/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.config;

import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.config.request.BiddingRequest;
import com.tradplus.ads.base.config.request.BiddingRequestInfo;
import com.tradplus.ads.base.config.response.BiddingResponse;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.network.Networking;
import com.tradplus.ads.volley.RequestQueue;
import com.tradplus.ads.volley.Response;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.toolbox.StringRequest;
import java.net.URLEncoder;

public class BiddingLoadManager {
    public static final String LC_WIN = "0";
    public static final String LC_NOFILL = "1";
    public static final String LC_PAYLOAD_TIMEOUT = "102";
    public static final String LC_NETWORK_TIMEOUT = "4902";
    private static BiddingLoadManager a = null;

    private BiddingLoadManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized BiddingLoadManager getInstance() {
        if (a != null) return a;
        Class<BiddingLoadManager> clazz = BiddingLoadManager.class;
        synchronized (BiddingLoadManager.class) {
            if (a != null) return a;
            a = new BiddingLoadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return a;
        }
    }

    public synchronized void loadBiddingRequest(BiddingRequestInfo object, final BiddingLoadListener biddingLoadListener) {
        Object object2 = new BiddingRequest.Listener(){

            @Override
            public final void onResponse(BiddingResponse biddingResponse) {
                if (biddingResponse == null) {
                    biddingLoadListener.onFailed(new VolleyError("response is null"));
                }
                biddingLoadListener.onSuccess(biddingResponse);
            }

            @Override
            public final void onErrorResponse(VolleyError volleyError) {
                biddingLoadListener.onFailed(volleyError);
            }
        };
        object = new BiddingRequest(TradPlus.isLocalDebugMode ? "https://test-bidder.tradplusad.com/api/v1/headbidding" : "https://bidder.tradplusad.com/api/v1/headbidding", JSON.toJSONString(object), (BiddingRequest.Listener)object2, ((BiddingRequestInfo)object).getTmax());
        object2 = Networking.getRequestQueue(GlobalTradPlus.getInstance().getContext());
        if (object2 != null) {
            ((RequestQueue)object2).add(object);
            return;
        }
        biddingLoadListener.onFailed(new VolleyError("requestQueue is null"));
    }

    public synchronized void biddingNotification(String object, String object2, String string, final BiddingNotificationListener biddingNotificationListener) {
        if (string == null || string.length() <= 0) {
            biddingNotificationListener.onFailed(new VolleyError("url is null"));
            return;
        }
        if (object2 == null || ((String)object2).length() <= 0) {
            object2 = LC_WIN;
        }
        try {
            string = string.replace(URLEncoder.encode("${AUCTION_LOSS}", "UTF-8"), (CharSequence)object);
        }
        catch (Exception exception) {}
        string = string.replace("${NOTIFY_VALUE}", (CharSequence)object2);
        LogUtil.ownShow("BiddingLoadManager biddingNotification send url:".concat(String.valueOf(string)));
        object = new StringRequest(0, string, new Response.Listener<String>(){

            @Override
            public final /* synthetic */ void onResponse(Object object) {
                String string = (String)object;
                object = this;
                if (string != null) {
                    object.biddingNotificationListener.onSuccess(string);
                    return;
                }
                object.biddingNotificationListener.onFailed(new VolleyError("response is null"));
            }
        }, new Response.ErrorListener(){

            @Override
            public final void onErrorResponse(VolleyError volleyError) {
                biddingNotificationListener.onFailed(volleyError);
            }
        });
        object2 = Networking.getRequestQueue(GlobalTradPlus.getInstance().getContext());
        if (object2 != null) {
            ((RequestQueue)object2).add(object);
            return;
        }
        biddingNotificationListener.onFailed(new VolleyError("requestQueue is null"));
    }

    public static interface BiddingNotificationListener {
        public void onSuccess(String var1);

        public void onFailed(VolleyError var1);
    }

    public static interface BiddingLoadListener {
        public void onSuccess(BiddingResponse var1);

        public void onFailed(VolleyError var1);
    }
}

