/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.UrlAction;
import com.tradplus.ads.common.UrlResolutionTask;
import com.tradplus.ads.common.event.BaseEvent;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.exceptions.IntentNotResolvableException;
import com.tradplus.ads.network.TrackingRequest;
import java.util.EnumSet;

public class UrlHandler {
    private static final ResultActions c = new ResultActions(){

        @Override
        public final void urlHandlingSucceeded(@NonNull String string, @NonNull UrlAction urlAction) {
        }

        @Override
        public final void urlHandlingFailed(@NonNull String string, @NonNull UrlAction urlAction) {
        }
    };
    private static final TPSchemeListener d = new TPSchemeListener(){

        @Override
        public final void onFinishLoad() {
        }

        @Override
        public final void onClose() {
        }

        @Override
        public final void onFailLoad() {
        }
    };
    @NonNull
    private EnumSet<UrlAction> e;
    @NonNull
    private ResultActions f;
    @NonNull
    TPSchemeListener a;
    @Nullable
    private String g;
    boolean b;
    private boolean h;
    private boolean i;

    private UrlHandler(@NonNull EnumSet<UrlAction> enumSet, @NonNull ResultActions resultActions, @NonNull TPSchemeListener tPSchemeListener, boolean bl, @Nullable String string) {
        this.e = EnumSet.copyOf(enumSet);
        this.f = resultActions;
        this.a = tPSchemeListener;
        this.b = bl;
        this.g = string;
        this.h = false;
        this.i = false;
    }

    public void handleUrl(@NonNull Context context, @NonNull String string) {
        Preconditions.checkNotNull(context);
        this.handleUrl(context, string, true);
    }

    public void handleUrl(@NonNull Context context, @NonNull String string, boolean bl) {
        Preconditions.checkNotNull(context);
        this.handleUrl(context, string, bl, null);
    }

    public void handleUrl(@NonNull Context object, @NonNull String string, boolean bl, @Nullable Iterable<String> iterable) {
        Preconditions.checkNotNull(object);
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.a(string, null, "Attempted to handle empty url.", null);
            return;
        }
        object = new UrlResolutionTask.a((Context)object, bl, iterable, string){
            final /* synthetic */ Context a;
            final /* synthetic */ boolean b;
            final /* synthetic */ Iterable c;
            final /* synthetic */ String d;
            {
                this.a = context;
                this.b = bl;
                this.c = iterable;
                this.d = string;
            }

            @Override
            public final void onSuccess(@NonNull String string) {
                UrlHandler.a(UrlHandler.this);
                UrlHandler.this.handleResolvedUrl(this.a, string, this.b, this.c);
            }

            @Override
            public final void onFailure(@NonNull String string, @Nullable Throwable throwable) {
                UrlHandler.a(UrlHandler.this);
                UrlHandler.this.a(this.d, null, string, throwable);
            }
        };
        UrlResolutionTask.getResolvedUrl(string, (UrlResolutionTask.a)object);
        this.i = true;
    }

    public boolean handleResolvedUrl(@NonNull Context context, @NonNull String string, boolean bl, @Nullable Iterable<String> iterable) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.a(string, null, "Attempted to handle empty url.", null);
            return false;
        }
        Object object = UrlAction.NOOP;
        Uri uri = Uri.parse((String)string);
        for (UrlAction urlAction : this.e) {
            if (!urlAction.shouldTryHandlingUrl(uri)) continue;
            try {
                urlAction.handleUrl(this, context, uri, bl, this.g);
                if (!(this.h || this.i || UrlAction.IGNORE_ABOUT_SCHEME.equals((Object)urlAction) || UrlAction.HANDLE_TP_SCHEME.equals((Object)urlAction))) {
                    TrackingRequest.makeTrackingHttpRequest(iterable, context, BaseEvent.Name.CLICK_REQUEST);
                    this.f.urlHandlingSucceeded(uri.toString(), urlAction);
                    this.h = true;
                }
                return true;
            }
            catch (IntentNotResolvableException intentNotResolvableException) {
                object = intentNotResolvableException;
                LogUtil.show(intentNotResolvableException.getMessage(), object);
                object = urlAction;
            }
        }
        this.a(string, (UrlAction)((Object)object), "Link ignored. Unable to handle url: ".concat(String.valueOf(string)), null);
        return false;
    }

    private void a(@Nullable String string, @Nullable UrlAction urlAction, @NonNull String string2, @Nullable Throwable throwable) {
        Preconditions.checkNotNull(string2);
        if (urlAction == null) {
            urlAction = UrlAction.NOOP;
        }
        LogUtil.show(string2, throwable);
        this.f.urlHandlingFailed(string, urlAction);
    }

    static /* synthetic */ ResultActions a() {
        return c;
    }

    static /* synthetic */ TPSchemeListener b() {
        return d;
    }

    /* synthetic */ UrlHandler(EnumSet enumSet, ResultActions resultActions, TPSchemeListener tPSchemeListener, boolean bl, String string, byte by) {
        this(enumSet, resultActions, tPSchemeListener, bl, string);
    }

    static /* synthetic */ boolean a(UrlHandler urlHandler) {
        urlHandler.i = false;
        return false;
    }

    public static class Builder {
        @NonNull
        private EnumSet<UrlAction> a = EnumSet.of(UrlAction.NOOP);
        @NonNull
        private ResultActions b = UrlHandler.a();
        @NonNull
        private TPSchemeListener c = UrlHandler.b();
        private boolean d = false;
        @Nullable
        private String e;

        public Builder withSupportedUrlActions(@NonNull UrlAction urlAction, UrlAction ... urlActionArray) {
            this.a = EnumSet.of(urlAction, urlActionArray);
            return this;
        }

        public Builder withSupportedUrlActions(@NonNull EnumSet<UrlAction> enumSet) {
            this.a = EnumSet.copyOf(enumSet);
            return this;
        }

        public Builder withResultActions(@NonNull ResultActions resultActions) {
            this.b = resultActions;
            return this;
        }

        public Builder withTPSchemeListener(@NonNull TPSchemeListener tPSchemeListener) {
            this.c = tPSchemeListener;
            return this;
        }

        public Builder withoutTPBrowser() {
            this.d = true;
            return this;
        }

        public Builder withDspCreativeId(@Nullable String string) {
            this.e = string;
            return this;
        }

        public UrlHandler build() {
            return new UrlHandler(this.a, this.b, this.c, this.d, this.e, 0);
        }
    }

    public static interface TPSchemeListener {
        public void onFinishLoad();

        public void onClose();

        public void onFailLoad();
    }

    public static interface ResultActions {
        public void urlHandlingSucceeded(@NonNull String var1, @NonNull UrlAction var2);

        public void urlHandlingFailed(@NonNull String var1, @NonNull UrlAction var2);
    }
}

