/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.event;

import android.support.annotation.NonNull;
import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.event.BaseEvent;
import com.tradplus.ads.common.event.ErrorEvent;
import com.tradplus.ads.common.util.LogUtil;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventSerializer {
    @NonNull
    public JSONArray serializeAsJson(@NonNull List<BaseEvent> object) {
        Preconditions.checkNotNull(object);
        JSONArray jSONArray = new JSONArray();
        object = object.iterator();
        while (object.hasNext()) {
            BaseEvent baseEvent = (BaseEvent)object.next();
            try {
                jSONArray.put((Object)this.serializeAsJson(baseEvent));
            }
            catch (JSONException jSONException) {
                LogUtil.show("Failed to serialize event \"" + (Object)((Object)baseEvent.getName()) + "\" to JSON: ", (Object)jSONException);
            }
        }
        return jSONArray;
    }

    @NonNull
    public JSONObject serializeAsJson(@NonNull BaseEvent baseEvent) {
        Preconditions.checkNotNull(baseEvent);
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("_category_", (Object)baseEvent.getScribeCategory().getCategory());
        jSONObject.put("ts", (Object)baseEvent.getTimestampUtcMs());
        jSONObject.put("name", (Object)baseEvent.getName().getName());
        jSONObject.put("name_category", (Object)baseEvent.getCategory().getCategory());
        Enum enum_ = baseEvent.getSdkProduct();
        jSONObject.put("sdk_product", enum_ == null ? null : Integer.valueOf(((BaseEvent.SdkProduct)enum_).getType()));
        jSONObject.put("sdk_version", (Object)baseEvent.getSdkVersion());
        jSONObject.put("ad_unit_id", (Object)baseEvent.getAdUnitId());
        jSONObject.put("ad_creative_id", (Object)baseEvent.getAdCreativeId());
        jSONObject.put("ad_type", (Object)baseEvent.getAdType());
        jSONObject.put("ad_network_type", (Object)baseEvent.getAdNetworkType());
        jSONObject.put("ad_width_px", (Object)baseEvent.getAdWidthPx());
        jSONObject.put("ad_height_px", (Object)baseEvent.getAdHeightPx());
        jSONObject.put("dsp_creative_id", (Object)baseEvent.getDspCreativeId());
        enum_ = baseEvent.getAppPlatform();
        jSONObject.put("app_platform", enum_ == null ? null : Integer.valueOf(((BaseEvent.AppPlatform)enum_).getType()));
        jSONObject.put("app_name", (Object)baseEvent.getAppName());
        jSONObject.put("app_package_name", (Object)baseEvent.getAppPackageName());
        jSONObject.put("app_version", (Object)baseEvent.getAppVersion());
        jSONObject.put("client_advertising_id", (Object)baseEvent.getObfuscatedClientAdvertisingId());
        jSONObject.put("client_do_not_track", (Object)baseEvent.getClientDoNotTrack());
        jSONObject.put("device_manufacturer", (Object)baseEvent.getDeviceManufacturer());
        jSONObject.put("device_model", (Object)baseEvent.getDeviceModel());
        jSONObject.put("device_product", (Object)baseEvent.getDeviceProduct());
        jSONObject.put("device_os_version", (Object)baseEvent.getDeviceOsVersion());
        jSONObject.put("device_screen_width_px", (Object)baseEvent.getDeviceScreenWidthDip());
        jSONObject.put("device_screen_height_px", (Object)baseEvent.getDeviceScreenHeightDip());
        jSONObject.put("geo_lat", (Object)baseEvent.getGeoLat());
        jSONObject.put("geo_lon", (Object)baseEvent.getGeoLon());
        jSONObject.put("geo_accuracy_radius_meters", (Object)baseEvent.getGeoAccuracy());
        jSONObject.put("perf_duration_ms", (Object)baseEvent.getPerformanceDurationMs());
        enum_ = baseEvent.getNetworkType();
        jSONObject.put("network_type", enum_ == null ? null : Integer.valueOf(((ClientMetadata.TPNetworkType)enum_).getId()));
        jSONObject.put("network_operator_code", (Object)baseEvent.getNetworkOperatorCode());
        jSONObject.put("network_operator_name", (Object)baseEvent.getNetworkOperatorName());
        jSONObject.put("network_iso_country_code", (Object)baseEvent.getNetworkIsoCountryCode());
        jSONObject.put("network_sim_code", (Object)baseEvent.getNetworkSimCode());
        jSONObject.put("network_sim_operator_name", (Object)baseEvent.getNetworkSimOperatorName());
        jSONObject.put("network_sim_iso_country_code", (Object)baseEvent.getNetworkSimIsoCountryCode());
        jSONObject.put("req_id", (Object)baseEvent.getRequestId());
        jSONObject.put("req_status_code", (Object)baseEvent.getRequestStatusCode());
        jSONObject.put("req_uri", (Object)baseEvent.getRequestUri());
        jSONObject.put("req_retries", (Object)baseEvent.getRequestRetries());
        jSONObject.put("timestamp_client", (Object)baseEvent.getTimestampUtcMs());
        if (baseEvent instanceof ErrorEvent) {
            baseEvent = (ErrorEvent)baseEvent;
            jSONObject.put("error_exception_class_name", (Object)((ErrorEvent)baseEvent).getErrorExceptionClassName());
            jSONObject.put("error_message", (Object)((ErrorEvent)baseEvent).getErrorMessage());
            jSONObject.put("error_stack_trace", (Object)((ErrorEvent)baseEvent).getErrorStackTrace());
            jSONObject.put("error_file_name", (Object)((ErrorEvent)baseEvent).getErrorFileName());
            jSONObject.put("error_class_name", (Object)((ErrorEvent)baseEvent).getErrorClassName());
            jSONObject.put("error_method_name", (Object)((ErrorEvent)baseEvent).getErrorMethodName());
            jSONObject.put("error_line_number", (Object)((ErrorEvent)baseEvent).getErrorLineNumber());
        }
        return jSONObject;
    }
}

