/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.deserializer.ContextObjectDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.ObjectDeserializer;
import com.tradplus.ads.common.serialization.serializer.BeanContext;
import com.tradplus.ads.common.serialization.serializer.ContextObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.DateCodec;
import com.tradplus.ads.common.serialization.serializer.JSONSerializer;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.IOUtils;
import java.io.Writer;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public class CalendarCodec
extends ContextObjectDeserializer
implements ObjectDeserializer,
ContextObjectSerializer,
ObjectSerializer {
    public static final CalendarCodec instance = new CalendarCodec();
    private DatatypeFactory a;

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, BeanContext object2) {
        SerializeWriter serializeWriter = jSONSerializer.out;
        object2 = ((BeanContext)object2).getFormat();
        object = (Calendar)object;
        if (((String)object2).equals("unixtime")) {
            long l2 = ((Calendar)object).getTimeInMillis() / 1000L;
            serializeWriter.writeInt((int)l2);
            return;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat((String)object2);
        simpleDateFormat.setTimeZone(jSONSerializer.d);
        String string = simpleDateFormat.format(((Calendar)object).getTime());
        serializeWriter.writeString(string);
    }

    @Override
    public void write(JSONSerializer jSONSerializer, Object object, Object object2, Type object3, int n2) {
        object2 = jSONSerializer.out;
        if (object == null) {
            ((SerializeWriter)object2).writeNull();
            return;
        }
        object = object instanceof XMLGregorianCalendar ? ((XMLGregorianCalendar)object).toGregorianCalendar() : (Calendar)object;
        if (((SerializeWriter)object2).isEnabled(SerializerFeature.UseISO8601DateFormat)) {
            char[] cArray;
            char c2 = ((SerializeWriter)object2).isEnabled(SerializerFeature.UseSingleQuotes) ? (char)'\'' : '\"';
            ((SerializeWriter)object2).append(c2);
            int n3 = ((Calendar)object).get(1);
            n2 = ((Calendar)object).get(2) + 1;
            int n4 = ((Calendar)object).get(5);
            int n5 = ((Calendar)object).get(11);
            int n6 = ((Calendar)object).get(12);
            int n7 = ((Calendar)object).get(13);
            int n8 = ((Calendar)object).get(14);
            if (n8 != 0) {
                cArray = "0000-00-00T00:00:00.000".toCharArray();
                IOUtils.getChars(n8, 23, cArray);
                IOUtils.getChars(n7, 19, cArray);
                IOUtils.getChars(n6, 16, cArray);
                IOUtils.getChars(n5, 13, cArray);
                IOUtils.getChars(n4, 10, cArray);
                IOUtils.getChars(n2, 7, cArray);
                IOUtils.getChars(n3, 4, cArray);
            } else if (n7 == 0 && n6 == 0 && n5 == 0) {
                cArray = "0000-00-00".toCharArray();
                IOUtils.getChars(n4, 10, cArray);
                IOUtils.getChars(n2, 7, cArray);
                IOUtils.getChars(n3, 4, cArray);
            } else {
                cArray = "0000-00-00T00:00:00".toCharArray();
                IOUtils.getChars(n7, 19, cArray);
                IOUtils.getChars(n6, 16, cArray);
                IOUtils.getChars(n5, 13, cArray);
                IOUtils.getChars(n4, 10, cArray);
                IOUtils.getChars(n2, 7, cArray);
                IOUtils.getChars(n3, 4, cArray);
            }
            ((Writer)object2).write(cArray);
            float f2 = (float)((Calendar)object).getTimeZone().getOffset(((Calendar)object).getTimeInMillis()) / 3600000.0f;
            int n9 = (int)f2;
            if ((double)n9 == 0.0) {
                ((SerializeWriter)object2).write(90);
            } else {
                if (n9 > 9) {
                    ((SerializeWriter)object2).write(43);
                    ((SerializeWriter)object2).writeInt(n9);
                } else if (n9 > 0) {
                    ((SerializeWriter)object2).write(43);
                    ((SerializeWriter)object2).write(48);
                    ((SerializeWriter)object2).writeInt(n9);
                } else if (n9 < -9) {
                    ((SerializeWriter)object2).write(45);
                    ((SerializeWriter)object2).writeInt(n9);
                } else if (n9 < 0) {
                    ((SerializeWriter)object2).write(45);
                    ((SerializeWriter)object2).write(48);
                    ((SerializeWriter)object2).writeInt(-n9);
                }
                ((SerializeWriter)object2).write(58);
                int n10 = (int)((f2 - (float)n9) * 60.0f);
                ((SerializeWriter)object2).append(String.format("%02d", n10));
            }
            ((SerializeWriter)object2).append(c2);
            return;
        }
        object3 = ((Calendar)object).getTime();
        jSONSerializer.write(object3);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser defaultJSONParser, Type type, Object object) {
        return this.deserialze(defaultJSONParser, type, object, null, 0);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser object, Type type, Object object2, String string, int n2) {
        if ((object2 = DateCodec.instance.deserialze((DefaultJSONParser)object, type, object2, string, n2)) instanceof Calendar) {
            return (T)object2;
        }
        if ((object2 = (Date)object2) == null) {
            return null;
        }
        object = ((DefaultJSONParser)object).lexer;
        object = Calendar.getInstance(object.getTimeZone(), object.getLocale());
        ((Calendar)object).setTime((Date)object2);
        if (type == XMLGregorianCalendar.class) {
            return (T)this.createXMLGregorianCalendar((GregorianCalendar)object);
        }
        return (T)object;
    }

    public XMLGregorianCalendar createXMLGregorianCalendar(Calendar calendar) {
        if (this.a == null) {
            try {
                this.a = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                throw new IllegalStateException("Could not obtain an instance of DatatypeFactory.", datatypeConfigurationException);
            }
        }
        return this.a.newXMLGregorianCalendar((GregorianCalendar)calendar);
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

