/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.serializer;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.serializer.ObjectSerializer;
import com.tradplus.ads.common.serialization.serializer.SerialContext;
import com.tradplus.ads.common.serialization.serializer.SerializeConfig;
import com.tradplus.ads.common.serialization.serializer.SerializeFilterable;
import com.tradplus.ads.common.serialization.serializer.SerializeWriter;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.serializer.StringCodec;
import com.tradplus.ads.common.serialization.util.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.TimeZone;
import java.util.zip.GZIPOutputStream;

public class JSONSerializer
extends SerializeFilterable {
    protected final SerializeConfig a;
    public final SerializeWriter out;
    private int o = 0;
    private String p = "\t";
    private String q;
    private DateFormat r;
    private String s;
    protected IdentityHashMap<Object, SerialContext> b = null;
    protected SerialContext c;
    protected TimeZone d = JSON.defaultTimeZone;
    protected Locale e = JSON.defaultLocale;

    public JSONSerializer() {
        this(new SerializeWriter(), SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeWriter serializeWriter) {
        this(serializeWriter, SerializeConfig.getGlobalInstance());
    }

    public JSONSerializer(SerializeConfig serializeConfig) {
        this(new SerializeWriter(), serializeConfig);
    }

    public JSONSerializer(SerializeWriter serializeWriter, SerializeConfig serializeConfig) {
        this.out = serializeWriter;
        this.a = serializeConfig;
    }

    public String getDateFormatPattern() {
        if (this.r instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)this.r).toPattern();
        }
        return this.q;
    }

    public DateFormat getDateFormat() {
        if (this.r == null && this.q != null) {
            this.r = this.a(this.q);
        }
        return this.r;
    }

    private DateFormat a(String object) {
        object = new SimpleDateFormat((String)object, this.e);
        ((DateFormat)object).setTimeZone(this.d);
        return object;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.r = dateFormat;
        if (this.q != null) {
            this.q = null;
        }
    }

    public void setDateFormat(String string) {
        this.q = string;
        if (this.r != null) {
            this.r = null;
        }
    }

    public void setFastJsonConfigDateFormatPattern(String string) {
        this.s = string;
    }

    public String getFastJsonConfigDateFormatPattern() {
        return this.s;
    }

    public SerialContext getContext() {
        return this.c;
    }

    public void setContext(SerialContext serialContext) {
        this.c = serialContext;
    }

    public void setContext(SerialContext serialContext, Object object, Object object2, int n2) {
        this.setContext(serialContext, object, object2, n2, 0);
    }

    public void setContext(SerialContext serialContext, Object object, Object object2, int n2, int n3) {
        if (this.out.g) {
            return;
        }
        this.c = new SerialContext(serialContext, object, object2, n2, n3);
        if (this.b == null) {
            this.b = new IdentityHashMap();
        }
        this.b.put(object, this.c);
    }

    public void setContext(Object object, Object object2) {
        JSONSerializer jSONSerializer = this;
        jSONSerializer.setContext(jSONSerializer.c, object, object2, 0);
    }

    public void popContext() {
        if (this.c != null) {
            this.c = this.c.parent;
        }
    }

    public final boolean isWriteClassName(Type type, Object object) {
        return this.out.isEnabled(SerializerFeature.WriteClassName) && (type != null || !this.out.isEnabled(SerializerFeature.NotWriteRootClassName) || this.c != null && this.c.parent != null);
    }

    public boolean containsReference(Object object) {
        if (this.b == null) {
            return false;
        }
        SerialContext serialContext = this.b.get(object);
        if (serialContext == null) {
            return false;
        }
        if (object == Collections.emptyMap()) {
            return false;
        }
        object = serialContext.fieldName;
        return object == null || object instanceof Integer || object instanceof String;
    }

    public void writeReference(Object object) {
        SerialContext serialContext = this.c;
        Object object2 = serialContext.object;
        if (object == object2) {
            this.out.write("{\"$ref\":\"@\"}");
            return;
        }
        object2 = serialContext.parent;
        if (object2 != null && object == ((SerialContext)object2).object) {
            this.out.write("{\"$ref\":\"..\"}");
            return;
        }
        while (serialContext.parent != null) {
            serialContext = serialContext.parent;
        }
        if (object == serialContext.object) {
            this.out.write("{\"$ref\":\"$\"}");
            return;
        }
        this.out.write("{\"$ref\":\"");
        object = this.b.get(object).toString();
        this.out.write((String)object);
        this.out.write("\"}");
    }

    public boolean checkValue(SerializeFilterable serializeFilterable) {
        return this.i != null && this.i.size() > 0 || this.m != null && this.m.size() > 0 || serializeFilterable.i != null && serializeFilterable.i.size() > 0 || serializeFilterable.m != null && serializeFilterable.m.size() > 0 || this.out.i;
    }

    public boolean hasNameFilters(SerializeFilterable serializeFilterable) {
        return this.j != null && this.j.size() > 0 || serializeFilterable.j != null && serializeFilterable.j.size() > 0;
    }

    public boolean hasPropertyFilters(SerializeFilterable serializeFilterable) {
        return this.h != null && this.h.size() > 0 || serializeFilterable.h != null && serializeFilterable.h.size() > 0;
    }

    public int getIndentCount() {
        return this.o;
    }

    public void incrementIndent() {
        ++this.o;
    }

    public void decrementIdent() {
        --this.o;
    }

    public void println() {
        this.out.write(10);
        for (int i2 = 0; i2 < this.o; ++i2) {
            this.out.write(this.p);
        }
    }

    public SerializeWriter getWriter() {
        return this.out;
    }

    public String toString() {
        return this.out.toString();
    }

    public void config(SerializerFeature serializerFeature, boolean bl) {
        this.out.config(serializerFeature, bl);
    }

    public boolean isEnabled(SerializerFeature serializerFeature) {
        return this.out.isEnabled(serializerFeature);
    }

    public void writeNull() {
        this.out.writeNull();
    }

    public SerializeConfig getMapping() {
        return this.a;
    }

    public static void write(Writer writer, Object object) {
        try (SerializeWriter serializeWriter = new SerializeWriter();){
            new JSONSerializer(serializeWriter).write(object);
            serializeWriter.writeTo(writer);
            return;
        }
    }

    public static void write(SerializeWriter serializeWriter, Object object) {
        new JSONSerializer(serializeWriter).write(object);
    }

    public final void write(Object object) {
        if (object == null) {
            this.out.writeNull();
            return;
        }
        Object object2 = object.getClass();
        object2 = this.getObjectWriter((Class<?>)object2);
        try {
            object2.write(this, object, null, null, 0);
            return;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
    }

    public final void writeAs(Object object, Class object2) {
        if (object == null) {
            this.out.writeNull();
            return;
        }
        object2 = this.getObjectWriter((Class<?>)object2);
        try {
            object2.write(this, object, null, null, 0);
            return;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
    }

    public final void writeWithFieldName(Object object, Object object2) {
        this.writeWithFieldName(object, object2, null, 0);
    }

    public final void writeWithFieldName(Object object, Object object2, Type type, int n2) {
        try {
            if (object == null) {
                this.out.writeNull();
                return;
            }
            Class<?> clazz = object.getClass();
            this.getObjectWriter(clazz).write(this, object, object2, type, n2);
            return;
        }
        catch (IOException iOException) {
            throw new JSONException(iOException.getMessage(), iOException);
        }
    }

    public final void writeWithFormat(Object object, String string) {
        if (object instanceof Date) {
            if ("unixtime".equals(string)) {
                long l2 = ((Date)object).getTime() / 1000L;
                this.out.writeInt((int)l2);
                return;
            }
            if ("millis".equals(string)) {
                this.out.writeLong(((Date)object).getTime());
                return;
            }
            DateFormat dateFormat = this.getDateFormat();
            if (dateFormat == null) {
                if (string != null) {
                    try {
                        dateFormat = this.a(string);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        String string2 = string.replaceAll("T", "'T'");
                        dateFormat = this.a(string2);
                    }
                } else if (this.s != null) {
                    JSONSerializer jSONSerializer = this;
                    dateFormat = jSONSerializer.a(jSONSerializer.s);
                } else {
                    dateFormat = this.a(JSON.DEFFAULT_DATE_FORMAT);
                }
            }
            String string3 = dateFormat.format((Date)object);
            this.out.writeString(string3);
            return;
        }
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            if ("gzip".equals(string) || "gzip,base64".equals(string)) {
                GZIPOutputStream gZIPOutputStream = null;
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    gZIPOutputStream = byArray.length < 512 ? new GZIPOutputStream((OutputStream)byteArrayOutputStream, byArray.length) : new GZIPOutputStream(byteArrayOutputStream);
                    gZIPOutputStream.write(byArray);
                    gZIPOutputStream.finish();
                    this.out.writeByteArray(byteArrayOutputStream.toByteArray());
                }
                catch (IOException iOException) {
                    try {
                        throw new JSONException("write gzipBytes error", iOException);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(gZIPOutputStream);
                        throw throwable;
                    }
                }
                IOUtils.close(gZIPOutputStream);
                return;
            }
            if ("hex".equals(string)) {
                this.out.writeHex(byArray);
                return;
            }
            this.out.writeByteArray(byArray);
            return;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            Iterator iterator = collection.iterator();
            this.out.write(91);
            for (int i2 = 0; i2 < collection.size(); ++i2) {
                object = iterator.next();
                if (i2 != 0) {
                    this.out.write(44);
                }
                this.writeWithFormat(object, string);
            }
            this.out.write(93);
            return;
        }
        this.write(object);
    }

    public final void write(String string) {
        StringCodec.instance.write(this, string);
    }

    public ObjectSerializer getObjectWriter(Class<?> clazz) {
        return this.a.getObjectWriter(clazz);
    }

    public void close() {
        this.out.close();
    }
}

