/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.util;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.TPBrowser;
import com.tradplus.ads.common.UrlAction;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.exceptions.IntentNotResolvableException;
import com.tradplus.ads.exceptions.UrlParseException;

public class Intents {
    private Intents() {
    }

    public static void startActivity(@NonNull Context context, @NonNull Intent intent) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(intent);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        try {
            context.startActivity(intent);
            return;
        }
        catch (ActivityNotFoundException activityNotFoundException) {
            throw new IntentNotResolvableException(activityNotFoundException);
        }
    }

    public static Intent getStartActivityIntent(@NonNull Context context, @NonNull Class clazz, @Nullable Bundle bundle) {
        clazz = new Intent(context, clazz);
        if (!(context instanceof Activity)) {
            clazz.addFlags(0x10000000);
        }
        if (bundle != null) {
            clazz.putExtras(bundle);
        }
        return clazz;
    }

    public static boolean deviceCanHandleIntent(@NonNull Context context, @NonNull Intent intent) {
        try {
            return !context.getPackageManager().queryIntentActivities(intent, 0).isEmpty();
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public static Intent intentForNativeBrowserScheme(@NonNull Uri uri) {
        String string;
        Preconditions.checkNotNull(uri);
        if (!UrlAction.OPEN_NATIVE_BROWSER.shouldTryHandlingUrl(uri)) {
            throw new UrlParseException("URL does not have tpnativebrowser:// scheme.");
        }
        if (!"navigate".equals(uri.getHost())) {
            throw new UrlParseException("URL missing 'navigate' host parameter.");
        }
        try {
            string = uri.getQueryParameter("url");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LogUtil.show("Could not handle url: ".concat(String.valueOf(uri)));
            throw new UrlParseException("Passed-in URL did not create a hierarchical URI.");
        }
        if (string == null) {
            throw new UrlParseException("URL missing 'url' query parameter.");
        }
        uri = Uri.parse((String)string);
        return new Intent("android.intent.action.VIEW", uri);
    }

    public static Intent intentForShareTweet(@NonNull Uri object) {
        String string;
        String string2;
        if (!UrlAction.HANDLE_SHARE_TWEET.shouldTryHandlingUrl((Uri)object)) {
            throw new UrlParseException("URL does not have tpshare://tweet? format.");
        }
        try {
            string2 = object.getQueryParameter("screen_name");
            string = object.getQueryParameter("tweet_id");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            LogUtil.show("Could not handle url: ".concat(String.valueOf(object)));
            throw new UrlParseException("Passed-in URL did not create a hierarchical URI.");
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            throw new UrlParseException("URL missing non-empty 'screen_name' query parameter.");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new UrlParseException("URL missing non-empty 'tweet_id' query parameter.");
        }
        object = String.format("https://twitter.com/%s/status/%s", string2, string);
        object = String.format("Check out @%s's Tweet: %s", string2, object);
        string2 = new Intent("android.intent.action.SEND");
        string2.setType("text/plain");
        string2.putExtra("android.intent.extra.SUBJECT", (String)object);
        string2.putExtra("android.intent.extra.TEXT", (String)object);
        return string2;
    }

    public static void showTPBrowserForUrl(@NonNull Context context, @NonNull Uri object, @Nullable String string) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(object);
        LogUtil.show("Final URI to show in browser: ".concat(String.valueOf(object)));
        Bundle bundle = new Bundle();
        bundle.putString("URL", object.toString());
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putString("tp-dsp-creative-id", string);
        }
        string = Intents.getStartActivityIntent(context, TPBrowser.class, bundle);
        object = "Could not show TPBrowser for url: " + object + "\n\tPerhaps you forgot to declare TPBrowser in your Android manifest file.";
        Intents.launchIntentForUserClick(context, (Intent)string, (String)object);
    }

    public static void showAdExpressBrowserForUrl(@NonNull Context context, @NonNull Uri object, @Nullable String string) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(object);
        LogUtil.show("Final URI to show in browser: ".concat(String.valueOf(object)));
        string = new Intent();
        string.setAction("android.intent.action.VIEW");
        string.setData(object);
        object = "Could not show url: ".concat(String.valueOf(object));
        Intents.launchIntentForUserClick(context, (Intent)string, (String)object);
    }

    public static void launchIntentForUserClick(@NonNull Context context, @NonNull Intent intent, @Nullable String string) {
        Preconditions.NoThrow.checkNotNull(context);
        Preconditions.NoThrow.checkNotNull(intent);
        try {
            Intents.startActivity(context, intent);
            return;
        }
        catch (IntentNotResolvableException intentNotResolvableException) {
            throw new IntentNotResolvableException(string + "\n" + intentNotResolvableException.getMessage());
        }
    }

    public static void launchApplicationUrl(@NonNull Context context, @NonNull Uri uri) {
        Intent intent = new Intent("android.intent.action.VIEW", uri);
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(uri);
        if (Intents.deviceCanHandleIntent(context, intent)) {
            Intents.launchApplicationIntent(context, intent);
            return;
        }
        throw new IntentNotResolvableException("Could not handle application specific action: " + uri + "\n\tYou may be running in the emulator or another device which does not have the required application.");
    }

    public static void launchApplicationIntent(@NonNull Context context, @NonNull Intent intent) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(intent);
        if (Intents.deviceCanHandleIntent(context, intent)) {
            String string = "Unable to open intent: ".concat(String.valueOf(intent));
            if (!(context instanceof Activity)) {
                intent.addFlags(0x10000000);
            }
            Intents.launchIntentForUserClick(context, intent, string);
            return;
        }
        String string = intent.getStringExtra("browser_fallback_url");
        if (TextUtils.isEmpty((CharSequence)string)) {
            if (!"market".equalsIgnoreCase(intent.getScheme())) {
                Intents.launchApplicationUrl(context, Intents.getPlayStoreUri(intent));
                return;
            }
            throw new IntentNotResolvableException("Device could not handle neither intent nor market url.\nIntent: " + intent.toString());
        }
        intent = Uri.parse((String)string);
        if ("http".equalsIgnoreCase(string = intent.getScheme()) || "https".equalsIgnoreCase(string)) {
            Intents.showTPBrowserForUrl(context, (Uri)intent, null);
            return;
        }
        Intents.launchApplicationUrl(context, (Uri)intent);
    }

    @NonNull
    public static Uri getPlayStoreUri(@NonNull Intent intent) {
        Preconditions.checkNotNull(intent);
        return Uri.parse((String)("market://details?id=" + intent.getPackage()));
    }

    public static void launchActionViewIntent(@NonNull Context context, @NonNull Uri uri, @Nullable String string) {
        Preconditions.checkNotNull(context);
        Preconditions.checkNotNull(uri);
        uri = new Intent("android.intent.action.VIEW", uri);
        if (!(context instanceof Activity)) {
            uri.addFlags(0x10000000);
        }
        Intents.launchIntentForUserClick(context, (Intent)uri, string);
    }

    @Deprecated
    public static boolean canHandleApplicationUrl(Context context, Uri uri) {
        return false;
    }

    @Deprecated
    public static boolean canHandleApplicationUrl(Context context, Uri uri, boolean bl) {
        return false;
    }
}

