/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.volley.toolbox;

import com.tradplus.ads.volley.NetworkResponse;
import com.tradplus.ads.volley.ParseError;
import com.tradplus.ads.volley.Response;
import com.tradplus.ads.volley.toolbox.HttpHeaderParser;
import com.tradplus.ads.volley.toolbox.JsonRequest;
import java.io.UnsupportedEncodingException;
import org.json.JSONArray;
import org.json.JSONException;

public class JsonArrayRequest
extends JsonRequest<JSONArray> {
    public JsonArrayRequest(String string, Response.Listener<JSONArray> listener, Response.ErrorListener errorListener) {
        super(0, string, null, listener, errorListener);
    }

    @Override
    public Response<JSONArray> parseNetworkResponse(NetworkResponse networkResponse) {
        try {
            String string = new String(networkResponse.data, HttpHeaderParser.parseCharset(networkResponse.headers));
            return Response.success(new JSONArray(string), HttpHeaderParser.parseCacheHeaders(networkResponse));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return Response.error(new ParseError(unsupportedEncodingException));
        }
        catch (JSONException jSONException) {
            return Response.error(new ParseError(jSONException));
        }
    }
}

