/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import com.tradplus.ads.common.AdvertisingIdClient;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.task.TPTaskManager;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.Dips;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.mobileads.gdpr.Const;
import com.tradplus.ads.mobileads.gdpr.SPUtil;
import com.tradplus.ads.mobileads.util.a;
import com.tradplus.ads.mobileads.util.oaid.AsusOaid;
import com.tradplus.ads.mobileads.util.oaid.HWOaidAidlUtil;
import com.tradplus.ads.mobileads.util.oaid.MeizuOaid;
import com.tradplus.ads.mobileads.util.oaid.NubiaOaid;
import com.tradplus.ads.mobileads.util.oaid.OaidCallback;
import com.tradplus.ads.mobileads.util.oaid.OppoOaid;
import com.tradplus.ads.mobileads.util.oaid.SamsungOaid;
import com.tradplus.ads.mobileads.util.oaid.VivoOaid;
import com.tradplus.ads.mobileads.util.oaid.ZuiOaid;
import com.tradplus.ads.pushcenter.event.utils.CPIds;
import com.tradplus.ads.pushcenter.event.utils.SegmentIds;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public class ClientMetadata {
    private String a;
    private String b;
    private final String c;
    private String d;
    private String e;
    private String f;
    private boolean g = false;
    private boolean h = false;
    private String i;
    public static String mAdvertisingId;
    public static boolean mAdvertisingLimited;
    private int j;
    private int k;
    private String l;
    private static String m;
    private static boolean n;
    private String o;
    private String p;
    private String q;
    private String r;
    private String s;
    private Map<String, CPIds> t = new HashMap<String, CPIds>();
    private Map<String, SegmentIds> u = new HashMap<String, SegmentIds>();
    private static volatile ClientMetadata v;
    private final String w;
    private final String x;
    private final String y;
    private final String z;
    private final String A;
    private final String B;
    private final String C;
    private String D;
    private final Context E;
    private final ConnectivityManager F;
    private final String G;
    private int H = 0;
    private final String I;
    private final String J;
    private final String K;
    private String L;
    private String M;
    private static DecimalFormat N;
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_HSPAP = 15;
    public static final int NETWORK_TYPE_NR = 20;

    public String getAdSourceId() {
        return this.q;
    }

    public void setAdSourceId(String string) {
        this.q = string;
    }

    public String getIso() {
        return this.p;
    }

    public void setIso(String string) {
        this.p = string;
    }

    public String getIp() {
        return this.o;
    }

    public void setIp(String string) {
        this.o = string;
    }

    public String getApp_ver() {
        return this.r;
    }

    public void setApp_ver(String string) {
        this.r = string;
    }

    public String getApp_instime() {
        return this.s;
    }

    public void setApp_instime(String string) {
        this.s = string;
    }

    public String getFirstInstallTime() {
        return this.L;
    }

    public Map<String, SegmentIds> getSegmentIdsMap() {
        return this.u;
    }

    public void setSegmentIdsMap(Map<String, SegmentIds> map) {
        this.u = map;
    }

    public String getTpGuid() {
        return this.M;
    }

    public void setTpGuid(String string) {
        this.M = string;
    }

    public String getUuId() {
        return this.i;
    }

    public void setUuId(String string) {
        this.i = string;
    }

    public String getScreenH() {
        return this.J;
    }

    public String getScreenW() {
        return this.K;
    }

    public String getScreenOrientation() {
        return this.I;
    }

    public String getDeviceType() {
        return this.G;
    }

    public int getNetworkType() {
        return this.H;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientMetadata getInstance(Context context) {
        ClientMetadata clientMetadata = v;
        if (clientMetadata != null) return clientMetadata;
        Class<ClientMetadata> clazz = ClientMetadata.class;
        synchronized (ClientMetadata.class) {
            clientMetadata = v;
            if (clientMetadata != null) return clientMetadata;
            v = clientMetadata = new ClientMetadata(context);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return clientMetadata;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ClientMetadata getInstance() {
        ClientMetadata clientMetadata = v;
        if (clientMetadata != null) return clientMetadata;
        Class<ClientMetadata> clazz = ClientMetadata.class;
        synchronized (ClientMetadata.class) {
            return v;
        }
    }

    public ClientMetadata(Context object) {
        this.E = object.getApplicationContext();
        this.F = (ConnectivityManager)this.E.getSystemService("connectivity");
        this.w = Build.MANUFACTURER;
        this.x = Build.MODEL;
        this.y = Build.PRODUCT;
        this.z = Build.VERSION.RELEASE;
        this.A = "6.9.70";
        this.B = ClientMetadata.getAppVersionFromContext(this.E);
        this.G = ClientMetadata.getDeviceType(this.E);
        ClientMetadata clientMetadata = this;
        clientMetadata.getNetworkType(clientMetadata.E);
        Object object2 = this.E.getPackageManager();
        Object object3 = null;
        this.C = object.getPackageName();
        this.I = DeviceUtils.getScreenOrientation(this.E);
        this.J = String.valueOf(DeviceUtils.getScreenHeight(this.E));
        this.K = String.valueOf(DeviceUtils.getScreenWidth(this.E));
        try {
            object3 = object2.getApplicationInfo(this.C, 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        if (object3 != null) {
            this.D = (String)object2.getApplicationLabel((ApplicationInfo)object3);
        }
        this.c = this.E.getResources().getConfiguration().locale.getCountry();
        ClientMetadata clientMetadata2 = this;
        object2 = clientMetadata2.E;
        object = clientMetadata2;
        try {
            long l2 = object2.getPackageManager().getPackageInfo((String)object2.getPackageName(), (int)0).firstInstallTime / 1000L;
            ((ClientMetadata)object).L = String.valueOf(l2);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            nameNotFoundException.printStackTrace();
        }
        object = this.E;
        object2 = new DisplayMetrics();
        ((WindowManager)object.getApplicationContext().getSystemService("window")).getDefaultDisplay().getMetrics((DisplayMetrics)object2);
        this.j = object2.widthPixels;
        object = this.E;
        object2 = new DisplayMetrics();
        ((WindowManager)object.getApplicationContext().getSystemService("window")).getDefaultDisplay().getMetrics((DisplayMetrics)object2);
        this.k = object2.heightPixels;
        object = this.E;
        object2 = Locale.getDefault().getLanguage();
        object3 = object.getResources().getConfiguration().locale;
        if (object3 != null && !((Locale)object3).getLanguage().trim().isEmpty()) {
            object2 = ((Locale)object3).getLanguage().trim();
        }
        this.l = object2;
        if (!TextUtils.isEmpty((CharSequence)SPUtil.getString(this.E, Const.SPU_NAME, "uid", ""))) {
            this.i = SPUtil.getString(this.E, Const.SPU_NAME, "uid", "");
            return;
        }
        object = UUID.randomUUID();
        this.i = "UID-" + ((UUID)object).toString();
        SPUtil.putString(this.E, Const.SPU_NAME, "uid", this.i);
    }

    public void putIds(String string) {
        this.t.put(string, new CPIds());
    }

    public CPIds getIds(String string) {
        return this.t.get(string);
    }

    public void putSegmentIds(String string, String string2, String string3) {
        this.u.put(string, new SegmentIds(string2, string3));
    }

    public SegmentIds getSegmentIds(String string) {
        return this.u.get(string);
    }

    public static String getAppVersionFromContext(Context context) {
        try {
            String string = context.getPackageName();
            return context.getPackageManager().getPackageInfo((String)string, (int)0).versionName;
        }
        catch (Exception exception) {
            LogUtil.show("Failed to retrieve PackageInfo#versionName.");
            return null;
        }
    }

    public static String getAppPackageNameFromContext(Context context) {
        try {
            String string = context.getPackageName();
            return context.getPackageManager().getPackageInfo((String)string, (int)0).packageName;
        }
        catch (Exception exception) {
            LogUtil.show("Failed to retrieve PackageInfo#versionName.");
            return null;
        }
    }

    public static void getOaid(Context context) {
        OaidCallback oaidCallback = new OaidCallback(){

            @Override
            public final void onSuccuss(String string, boolean bl) {
                Log.i((String)"tradplus", (String)("oaid = " + string + " isOaidTrackLimited = " + bl));
                m = string;
                n = bl;
            }

            @Override
            public final void onFail(String string) {
                Log.i((String)"tradplus", (String)"oaid errMsg = ".concat(String.valueOf(string)));
            }
        };
        String string = "";
        try {
            string = com.tradplus.ads.mobileads.util.a.a(context);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                oaidCallback.onSuccuss(string, false);
                return;
            }
            String string2 = Build.MANUFACTURER;
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                string2 = string2.toUpperCase();
                if (Arrays.asList("ASUS", "HUAWEI", "OPPO", "ONEPLUS", "ZTE", "FERRMEOS", "SSUI", "SAMSUNG", "MEIZU", "MOTOLORA", "LENOVO").contains(string2)) {
                    OaidCallback oaidCallback2 = oaidCallback;
                    TPTaskManager.getInstance().run_proxy(new Runnable(oaidCallback2, string2, context){
                        final /* synthetic */ OaidCallback a;
                        final /* synthetic */ String b;
                        final /* synthetic */ Context c;
                        {
                            this.a = oaidCallback;
                            this.b = string;
                            this.c = context;
                        }

                        @Override
                        public final void run() {
                            OaidCallback oaidCallback = new OaidCallback(){

                                @Override
                                public final void onSuccuss(String string, boolean bl) {
                                    if (a != null) {
                                        a.onSuccuss(string, bl);
                                    }
                                }

                                @Override
                                public final void onFail(String string) {
                                    a.onFail("no oaid");
                                }
                            };
                            try {
                                switch (this.b) {
                                    case "ASUS": {
                                        new AsusOaid(this.c).getOaid(oaidCallback);
                                        return;
                                    }
                                    case "OPPO": 
                                    case "ONEPLUS": {
                                        new OppoOaid(this.c).getOaid(oaidCallback);
                                        return;
                                    }
                                    case "HUAWEI": {
                                        new HWOaidAidlUtil(this.c).getOaid(oaidCallback);
                                        return;
                                    }
                                    case "SAMSUNG": {
                                        new SamsungOaid(this.c).getOaid(oaidCallback);
                                        return;
                                    }
                                    case "LENOVO": 
                                    case "MOTOLORA": {
                                        new ZuiOaid(this.c).getOaid(oaidCallback);
                                        return;
                                    }
                                    case "MEIZU": {
                                        new MeizuOaid(this.c).getOaid(oaidCallback);
                                        return;
                                    }
                                }
                                this.a.onFail("no oaid");
                                return;
                            }
                            catch (Throwable throwable) {
                                if (this.a != null) {
                                    this.a.onFail(throwable.getMessage());
                                }
                                return;
                            }
                        }
                    });
                } else if ("VIVO".equals(string2)) {
                    string = new VivoOaid(context).getOaid();
                } else if ("NUBIA".equals(string2)) {
                    string = new NubiaOaid(context).getOaid();
                }
            }
        }
        catch (Throwable throwable) {}
        if (!TextUtils.isEmpty((CharSequence)string)) {
            oaidCallback.onSuccuss(string, false);
        }
    }

    public static void getAdvertisingInfo(final Context context) {
        if (TextUtils.isEmpty((CharSequence)mAdvertisingId)) {
            if (TradPlus.isEUTraffic(context) && TradPlus.getGDPRDataCollection(context) != 0) {
                mAdvertisingId = "";
                return;
            }
            new Thread(new Runnable(){

                @Override
                public final void run() {
                    try {
                        AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(context);
                        mAdvertisingId = adInfo.getId();
                        mAdvertisingLimited = adInfo.isLimitAdTrackingEnabled();
                        LogUtil.ownShow("mAdvertisingId = " + mAdvertisingId);
                        LogUtil.ownShow("mAdvertisingLimited = " + mAdvertisingLimited);
                        if (mAdvertisingLimited) {
                            mAdvertisingId = "";
                        }
                        if (TradPlus.isEUTraffic(context) && (TradPlus.getGDPRDataCollection(context) == 1 || TradPlus.getGDPRDataCollection(context) == 2)) {
                            mAdvertisingId = "";
                        }
                        if (!TradPlus.invoker().isAllowTracking()) {
                            mAdvertisingId = "";
                        }
                        return;
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            }).start();
        }
    }

    public String getOrientationString() {
        int n2 = this.E.getResources().getConfiguration().orientation;
        String string = "u";
        if (n2 == 1) {
            string = "p";
        } else if (n2 == 2) {
            string = "l";
        } else if (n2 == 3) {
            string = "s";
        }
        return string;
    }

    public int getOrientationInt(Context context) {
        return context.getResources().getConfiguration().orientation;
    }

    public TPNetworkType getActiveNetworkType() {
        NetworkInfo networkInfo = this.F.getActiveNetworkInfo();
        return TPNetworkType.a(networkInfo != null ? networkInfo.getType() : -1);
    }

    public int getNetworkClassByType() {
        switch (this.getNetworkType()) {
            case -1: {
                return -1;
            }
            case -101: {
                return 1;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 2;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 3;
            }
            case 13: {
                return 4;
            }
            case 20: {
                return 5;
            }
        }
        return 5;
    }

    public int getDeviceCounByType() {
        switch (this.getNetworkType()) {
            case 0: {
                return 0;
            }
            case -1: {
                return -1;
            }
            case -101: {
                return 2;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 4;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 5;
            }
            case 13: {
                return 6;
            }
            case 20: {
                return 7;
            }
        }
        return 5;
    }

    public void getNetworkType(Context context) {
        new Thread(new Runnable(){

            @Override
            public final void run() {
                try {
                    NetworkInfo networkInfo = ClientMetadata.this.F.getActiveNetworkInfo();
                    if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
                        int n2 = networkInfo.getType();
                        if (n2 == 1) {
                            ClientMetadata.this.H = -101;
                            return;
                        }
                        if (n2 == 0) {
                            TelephonyManager telephonyManager = (TelephonyManager)ClientMetadata.this.E.getSystemService("phone");
                            ClientMetadata.this.H = telephonyManager.getNetworkType();
                        }
                        return;
                    }
                    ClientMetadata.this.H = -1;
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
        }).start();
    }

    public float getDensity() {
        return this.E.getResources().getDisplayMetrics().density;
    }

    public float getScreenSizeOfPPI() {
        DisplayMetrics displayMetrics = this.E.getResources().getDisplayMetrics();
        double d2 = Math.pow((float)this.getWidthPixels() / displayMetrics.xdpi, 2.0);
        double d3 = Math.pow((float)this.getHeightPixels() / displayMetrics.ydpi, 2.0);
        return (float)Math.sqrt(d2 + d3);
    }

    public String getNetworkOperatorForUrl() {
        return this.a;
    }

    public String getNetworkOperator() {
        return "";
    }

    public Locale getDeviceLocale() {
        return this.E.getResources().getConfiguration().locale;
    }

    public String getSimOperator() {
        return this.b;
    }

    public String getIsoCountryCode() {
        return this.c;
    }

    public String getSimIsoCountryCode() {
        return "";
    }

    public String getNetworkOperatorName() {
        return this.d;
    }

    public String getSimOperatorName() {
        return this.e;
    }

    public synchronized String getDId() {
        return this.f;
    }

    public String getAdvertisingId() {
        if (!TextUtils.isEmpty((CharSequence)(mAdvertisingId == null ? "" : mAdvertisingId))) {
            return mAdvertisingId;
        }
        return this.getOaid();
    }

    public String getDefultAdvertisingId() {
        if (TextUtils.isEmpty((CharSequence)mAdvertisingId)) {
            return "";
        }
        return mAdvertisingId;
    }

    public String getOaid() {
        if (m == null) {
            return "";
        }
        return m;
    }

    public String getGaid() {
        if (mAdvertisingId == null) {
            return "";
        }
        return mAdvertisingId;
    }

    public int getWidthPixels() {
        return this.j;
    }

    public int getHeightPixels() {
        return this.k;
    }

    public int getAdvertisingLimited() {
        LogUtil.ownShow("lmt = " + TradPlus.invoker().isDevAllowTracking() + " mAdvertisingLimited = " + mAdvertisingLimited);
        if (mAdvertisingLimited) {
            return 1;
        }
        return 0;
    }

    public String getLanguageCode() {
        return this.l;
    }

    public synchronized boolean isDoNotTrackSet() {
        return this.g;
    }

    public synchronized void setAdvertisingInfo(String string, boolean bl) {
        this.f = "ifa:".concat(String.valueOf(string));
        this.g = bl;
        this.h = true;
    }

    public synchronized boolean isAdvertisingInfoSet() {
        return this.h;
    }

    public String getDeviceManufacturer() {
        return this.w;
    }

    public String getDeviceModel() {
        return this.x;
    }

    public String getDeviceProduct() {
        return this.y;
    }

    public String getDeviceOsVersion() {
        return this.z;
    }

    public int getDeviceScreenWidthDip() {
        return Dips.screenWidthAsIntDips(this.E);
    }

    public int getDeviceScreenHeightDip() {
        return Dips.screenHeightAsIntDips(this.E);
    }

    public Point getDeviceDimensions() {
        if (Preconditions.NoThrow.checkNotNull(this.E)) {
            return DeviceUtils.getDeviceDimensions(this.E);
        }
        return new Point(0, 0);
    }

    public String getSdkVersion() {
        return this.A;
    }

    public String getAppVersion() {
        return this.B;
    }

    public String getAppPackageName() {
        return this.C;
    }

    public String getAppName() {
        return this.D;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @VisibleForTesting
    public static void setInstance(ClientMetadata clientMetadata) {
        Class<ClientMetadata> clazz = ClientMetadata.class;
        synchronized (ClientMetadata.class) {
            v = clientMetadata;
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    @VisibleForTesting
    public static void clearForTesting() {
        v = null;
    }

    public static String getDeviceType(Context context) {
        if ((context.getResources().getConfiguration().screenLayout & 0xF) >= 3) {
            return "2";
        }
        return "1";
    }

    static {
        N = new DecimalFormat("#.##");
    }

    public static enum TPNetworkType {
        UNKNOWN(0),
        ETHERNET(1),
        WIFI(2),
        MOBILE(3);

        private final int a;

        private TPNetworkType(int n3) {
            this.a = n3;
        }

        public final String toString() {
            return Integer.toString(this.a);
        }

        public final int getId() {
            return this.a;
        }

        static /* synthetic */ TPNetworkType a(int n2) {
            switch (n2) {
                case 9: {
                    return ETHERNET;
                }
                case 1: {
                    return WIFI;
                }
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return MOBILE;
                }
            }
            return UNKNOWN;
        }
    }
}

