/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.parser;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONLexer;
import com.tradplus.ads.common.serialization.parser.JSONScanner;
import com.tradplus.ads.common.serialization.parser.JSONToken;
import com.tradplus.ads.common.serialization.parser.SymbolTable;
import com.tradplus.ads.common.serialization.util.IOUtils;
import java.io.Closeable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;

public abstract class JSONLexerBase
implements JSONLexer,
Closeable {
    protected int a;
    protected int b;
    protected int c;
    protected char d;
    protected int e;
    protected int f;
    protected char[] g;
    protected int h;
    protected int i;
    protected boolean j;
    protected Calendar k = null;
    protected TimeZone l = JSON.defaultTimeZone;
    protected Locale m = JSON.defaultLocale;
    public int matchStat = 0;
    private static final ThreadLocal<char[]> r = new ThreadLocal();
    protected String n = null;
    protected int o = 0;
    protected static final char[] p = ("\"" + JSON.DEFAULT_TYPE_KEY + "\":\"").toCharArray();
    protected static final int[] q = new int[103];

    public JSONLexerBase(int n2) {
        this.c = n2;
        if ((n2 & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.n = "";
        }
        this.g = r.get();
        if (this.g == null) {
            this.g = new char[512];
        }
    }

    public final int matchStat() {
        return this.matchStat;
    }

    public void setToken(int n2) {
        this.a = n2;
    }

    @Override
    public final void nextToken() {
        this.h = 0;
        block41: while (true) {
            this.b = this.e;
            if (this.d == '/') {
                this.a();
                continue;
            }
            if (this.d == '\"') {
                this.scanString();
                return;
            }
            if (this.d == ',') {
                this.next();
                this.a = 16;
                return;
            }
            if (this.d >= '0' && this.d <= '9') {
                this.scanNumber();
                return;
            }
            if (this.d == '-') {
                this.scanNumber();
                return;
            }
            switch (this.d) {
                case '\'': {
                    char c2;
                    if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                        throw new JSONException("Feature.AllowSingleQuotes is false");
                    }
                    JSONLexerBase jSONLexerBase = this;
                    jSONLexerBase.i = jSONLexerBase.e;
                    jSONLexerBase.j = false;
                    block42: while ((c2 = jSONLexerBase.next()) != '\'') {
                        if (c2 == '\u001a') {
                            if (!jSONLexerBase.isEOF()) {
                                jSONLexerBase.a('\u001a');
                                continue;
                            }
                            throw new JSONException("unclosed single-quote string");
                        }
                        if (c2 == '\\') {
                            if (!jSONLexerBase.j) {
                                jSONLexerBase.j = true;
                                if (jSONLexerBase.h > jSONLexerBase.g.length) {
                                    char[] cArray = new char[jSONLexerBase.h * 2];
                                    System.arraycopy(jSONLexerBase.g, 0, cArray, 0, jSONLexerBase.g.length);
                                    jSONLexerBase.g = cArray;
                                }
                                JSONLexerBase jSONLexerBase2 = jSONLexerBase;
                                jSONLexerBase2.a(jSONLexerBase2.i + 1, jSONLexerBase.h, jSONLexerBase.g);
                            }
                            c2 = jSONLexerBase.next();
                            switch (c2) {
                                case '0': {
                                    jSONLexerBase.a('\u0000');
                                    continue block42;
                                }
                                case '1': {
                                    jSONLexerBase.a('\u0001');
                                    continue block42;
                                }
                                case '2': {
                                    jSONLexerBase.a('\u0002');
                                    continue block42;
                                }
                                case '3': {
                                    jSONLexerBase.a('\u0003');
                                    continue block42;
                                }
                                case '4': {
                                    jSONLexerBase.a('\u0004');
                                    continue block42;
                                }
                                case '5': {
                                    jSONLexerBase.a('\u0005');
                                    continue block42;
                                }
                                case '6': {
                                    jSONLexerBase.a('\u0006');
                                    continue block42;
                                }
                                case '7': {
                                    jSONLexerBase.a('\u0007');
                                    continue block42;
                                }
                                case 'b': {
                                    jSONLexerBase.a('\b');
                                    continue block42;
                                }
                                case 't': {
                                    jSONLexerBase.a('\t');
                                    continue block42;
                                }
                                case 'n': {
                                    jSONLexerBase.a('\n');
                                    continue block42;
                                }
                                case 'v': {
                                    jSONLexerBase.a('\u000b');
                                    continue block42;
                                }
                                case 'F': 
                                case 'f': {
                                    jSONLexerBase.a('\f');
                                    continue block42;
                                }
                                case 'r': {
                                    jSONLexerBase.a('\r');
                                    continue block42;
                                }
                                case '\"': {
                                    jSONLexerBase.a('\"');
                                    continue block42;
                                }
                                case '\'': {
                                    jSONLexerBase.a('\'');
                                    continue block42;
                                }
                                case '/': {
                                    jSONLexerBase.a('/');
                                    continue block42;
                                }
                                case '\\': {
                                    jSONLexerBase.a('\\');
                                    continue block42;
                                }
                                case 'x': {
                                    boolean bl;
                                    c2 = jSONLexerBase.next();
                                    char c3 = jSONLexerBase.next();
                                    boolean bl2 = c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F';
                                    boolean bl3 = bl = c3 >= '0' && c3 <= '9' || c3 >= 'a' && c3 <= 'f' || c3 >= 'A' && c3 <= 'F';
                                    if (!bl2 || !bl) {
                                        throw new JSONException("invalid escape character \\x" + c2 + c3);
                                    }
                                    jSONLexerBase.a((char)(q[c2] * 16 + q[c3]));
                                    continue block42;
                                }
                                case 'u': {
                                    jSONLexerBase.a((char)Integer.parseInt(new String(new char[]{jSONLexerBase.next(), jSONLexerBase.next(), jSONLexerBase.next(), jSONLexerBase.next()}), 16));
                                    continue block42;
                                }
                            }
                            jSONLexerBase.d = c2;
                            throw new JSONException("unclosed single-quote string");
                        }
                        if (!jSONLexerBase.j) {
                            ++jSONLexerBase.h;
                            continue;
                        }
                        if (jSONLexerBase.h == jSONLexerBase.g.length) {
                            jSONLexerBase.a(c2);
                            continue;
                        }
                        jSONLexerBase.g[jSONLexerBase.h++] = c2;
                    }
                    jSONLexerBase.a = 4;
                    jSONLexerBase.next();
                    return;
                }
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    this.next();
                    continue block41;
                }
                case 't': {
                    this.scanTrue();
                    return;
                }
                case 'f': {
                    this.scanFalse();
                    return;
                }
                case 'n': {
                    this.scanNullOrNew();
                    return;
                }
                case 'N': 
                case 'S': 
                case 'T': 
                case 'u': {
                    this.scanIdent();
                    return;
                }
                case '(': {
                    this.next();
                    this.a = 10;
                    return;
                }
                case ')': {
                    this.next();
                    this.a = 11;
                    return;
                }
                case '[': {
                    this.next();
                    this.a = 14;
                    return;
                }
                case ']': {
                    this.next();
                    this.a = 15;
                    return;
                }
                case '{': {
                    this.next();
                    this.a = 12;
                    return;
                }
                case '}': {
                    this.next();
                    this.a = 13;
                    return;
                }
                case ':': {
                    this.next();
                    this.a = 17;
                    return;
                }
                case ';': {
                    this.next();
                    this.a = 24;
                    return;
                }
                case '.': {
                    this.next();
                    this.a = 25;
                    return;
                }
                case '+': {
                    this.next();
                    this.scanNumber();
                    return;
                }
                case 'x': {
                    this.scanHex();
                    return;
                }
            }
            if (this.isEOF()) {
                if (this.a == 20) {
                    throw new JSONException("EOF error");
                }
                this.a = 20;
                JSONLexerBase jSONLexerBase = this;
                jSONLexerBase.f = jSONLexerBase.b = this.e;
                return;
            }
            if (this.d > '\u001f' && this.d != '\u007f') break;
            this.next();
        }
        (new Object[1])[0] = String.valueOf((int)this.d);
        this.a = 1;
        this.next();
    }

    @Override
    public final void nextToken(int n2) {
        this.h = 0;
        while (true) {
            switch (n2) {
                case 12: {
                    if (this.d == '{') {
                        this.a = 12;
                        this.next();
                        return;
                    }
                    if (this.d != '[') break;
                    this.a = 14;
                    this.next();
                    return;
                }
                case 16: {
                    if (this.d == ',') {
                        this.a = 16;
                        this.next();
                        return;
                    }
                    if (this.d == '}') {
                        this.a = 13;
                        this.next();
                        return;
                    }
                    if (this.d == ']') {
                        this.a = 15;
                        this.next();
                        return;
                    }
                    if (this.d == '\u001a') {
                        this.a = 20;
                        return;
                    }
                    if (this.d != 'n') break;
                    this.scanNullOrNew(false);
                    return;
                }
                case 2: {
                    if (this.d >= '0' && this.d <= '9') {
                        this.b = this.e;
                        this.scanNumber();
                        return;
                    }
                    if (this.d == '\"') {
                        this.b = this.e;
                        this.scanString();
                        return;
                    }
                    if (this.d == '[') {
                        this.a = 14;
                        this.next();
                        return;
                    }
                    if (this.d != '{') break;
                    this.a = 12;
                    this.next();
                    return;
                }
                case 4: {
                    if (this.d == '\"') {
                        this.b = this.e;
                        this.scanString();
                        return;
                    }
                    if (this.d >= '0' && this.d <= '9') {
                        this.b = this.e;
                        this.scanNumber();
                        return;
                    }
                    if (this.d == '[') {
                        this.a = 14;
                        this.next();
                        return;
                    }
                    if (this.d != '{') break;
                    this.a = 12;
                    this.next();
                    return;
                }
                case 14: {
                    if (this.d == '[') {
                        this.a = 14;
                        this.next();
                        return;
                    }
                    if (this.d != '{') break;
                    this.a = 12;
                    this.next();
                    return;
                }
                case 15: {
                    if (this.d == ']') {
                        this.a = 15;
                        this.next();
                        return;
                    }
                }
                case 20: {
                    if (this.d != '\u001a') break;
                    this.a = 20;
                    return;
                }
                case 18: {
                    this.nextIdent();
                    return;
                }
            }
            if (this.d != ' ' && this.d != '\n' && this.d != '\r' && this.d != '\t' && this.d != '\f' && this.d != '\b') break;
            this.next();
        }
        this.nextToken();
    }

    public final void nextIdent() {
        while (JSONLexerBase.isWhitespace(this.d)) {
            this.next();
        }
        if (this.d == '_' || this.d == '$' || Character.isLetter(this.d)) {
            this.scanIdent();
            return;
        }
        this.nextToken();
    }

    @Override
    public final void nextTokenWithColon() {
        this.nextTokenWithChar(':');
    }

    public final void nextTokenWithChar(char c2) {
        this.h = 0;
        while (true) {
            if (this.d == c2) {
                this.next();
                this.nextToken();
                return;
            }
            if (this.d != ' ' && this.d != '\n' && this.d != '\r' && this.d != '\t' && this.d != '\f' && this.d != '\b') break;
            this.next();
        }
        throw new JSONException("not match " + c2 + " - " + this.d + ", info : " + this.info());
    }

    @Override
    public final int token() {
        return this.a;
    }

    @Override
    public final String tokenName() {
        return JSONToken.name(this.a);
    }

    @Override
    public final int pos() {
        return this.b;
    }

    public final String stringDefaultValue() {
        return this.n;
    }

    @Override
    public final Number integerValue() {
        long l2;
        long l3 = 0L;
        boolean bl = false;
        if (this.i == -1) {
            this.i = 0;
        }
        int n2 = this.i;
        int n3 = this.i + this.h;
        int n4 = 32;
        switch (this.charAt(n3 - 1)) {
            case 'L': {
                --n3;
                n4 = 76;
                break;
            }
            case 'S': {
                --n3;
                n4 = 83;
                break;
            }
            case 'B': {
                --n3;
                n4 = 66;
            }
        }
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.i) == '-') {
            bl = true;
            l2 = Long.MIN_VALUE;
            ++n2;
        } else {
            l2 = -9223372036854775807L;
        }
        if (n2 < n3) {
            l3 = -(this.charAt(n2++) - 48);
        }
        while (n2 < n3) {
            int n5 = this.charAt(n2++) - 48;
            if (l3 < -922337203685477580L) {
                return new BigInteger(this.numberString(), 10);
            }
            if ((l3 *= 10L) < l2 + (long)n5) {
                return new BigInteger(this.numberString(), 10);
            }
            l3 -= (long)n5;
        }
        if (bl) {
            if (n2 > this.i + 1) {
                if (l3 >= Integer.MIN_VALUE && n4 != 76) {
                    if (n4 == 83) {
                        return (short)l3;
                    }
                    if (n4 == 66) {
                        return (byte)l3;
                    }
                    return (int)l3;
                }
                return l3;
            }
            throw new NumberFormatException(this.numberString());
        }
        if ((l3 = -l3) <= Integer.MAX_VALUE && n4 != 76) {
            if (n4 == 83) {
                return (short)l3;
            }
            if (n4 == 66) {
                return (byte)l3;
            }
            return (int)l3;
        }
        return l3;
    }

    @Override
    public final void nextTokenWithColon(int n2) {
        this.nextTokenWithChar(':');
    }

    @Override
    public float floatValue() {
        char c2;
        String string = this.numberString();
        float f2 = Float.parseFloat(string);
        if ((f2 == 0.0f || f2 == Float.POSITIVE_INFINITY) && (c2 = string.charAt(0)) > '0' && c2 <= '9') {
            throw new JSONException("float overflow : ".concat(String.valueOf(string)));
        }
        return f2;
    }

    public double doubleValue() {
        return Double.parseDouble(this.numberString());
    }

    @Override
    public void config(Feature feature, boolean bl) {
        this.c = Feature.config(this.c, feature, bl);
        if ((this.c & Feature.InitStringFieldAsEmpty.mask) != 0) {
            this.n = "";
        }
    }

    @Override
    public final boolean isEnabled(Feature feature) {
        return this.isEnabled(feature.mask);
    }

    @Override
    public final boolean isEnabled(int n2) {
        return (this.c & n2) != 0;
    }

    public final boolean isEnabled(int n2, int n3) {
        return (this.c & n3) != 0 || (n2 & n3) != 0;
    }

    @Override
    public abstract String numberString();

    public abstract boolean isEOF();

    @Override
    public final char getCurrent() {
        return this.d;
    }

    public abstract char charAt(int var1);

    @Override
    public abstract char next();

    private void a() {
        this.next();
        if (this.d == '/') {
            do {
                this.next();
                if (this.d != '\n') continue;
                this.next();
                return;
            } while (this.d != '\u001a');
            return;
        }
        if (this.d == '*') {
            this.next();
            while (this.d != '\u001a') {
                if (this.d == '*') {
                    this.next();
                    if (this.d != '/') continue;
                    this.next();
                    return;
                }
                this.next();
            }
        } else {
            throw new JSONException("invalid comment");
        }
    }

    @Override
    public final String scanSymbol(SymbolTable symbolTable) {
        this.skipWhitespace();
        if (this.d == '\"') {
            return this.scanSymbol(symbolTable, '\"');
        }
        if (this.d == '\'') {
            if (!this.isEnabled(Feature.AllowSingleQuotes)) {
                throw new JSONException("syntax error");
            }
            return this.scanSymbol(symbolTable, '\'');
        }
        if (this.d == '}') {
            this.next();
            this.a = 13;
            return null;
        }
        if (this.d == ',') {
            this.next();
            this.a = 16;
            return null;
        }
        if (this.d == '\u001a') {
            this.a = 20;
            return null;
        }
        if (!this.isEnabled(Feature.AllowUnQuotedFieldNames)) {
            throw new JSONException("syntax error");
        }
        return this.scanSymbolUnQuoted(symbolTable);
    }

    protected abstract void a(int var1, char[] var2, int var3);

    /*
     * WARNING - void declaration
     */
    @Override
    public final String scanSymbol(SymbolTable symbolTable, char c2) {
        void var5_8;
        char c3;
        int n2 = 0;
        this.i = this.e;
        this.h = 0;
        boolean bl = false;
        block22: while ((c3 = this.next()) != c2) {
            if (c3 == '\u001a') {
                throw new JSONException("unclosed.str");
            }
            if (c3 == '\\') {
                if (!bl) {
                    bl = true;
                    if (this.h >= this.g.length) {
                        c3 = this.g.length * 2;
                        if (this.h > c3) {
                            c3 = this.h;
                        }
                        char[] c5 = new char[c3];
                        System.arraycopy(this.g, 0, c5, 0, this.g.length);
                        this.g = c5;
                    }
                    JSONLexerBase jSONLexerBase = this;
                    jSONLexerBase.a(jSONLexerBase.i + 1, this.g, this.h);
                }
                c3 = this.next();
                switch (c3) {
                    case '0': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0000');
                        continue block22;
                    }
                    case '1': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0001');
                        continue block22;
                    }
                    case '2': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0002');
                        continue block22;
                    }
                    case '3': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0003');
                        continue block22;
                    }
                    case '4': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0004');
                        continue block22;
                    }
                    case '5': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0005');
                        continue block22;
                    }
                    case '6': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0006');
                        continue block22;
                    }
                    case '7': {
                        n2 = 31 * n2 + c3;
                        this.a('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        n2 = 31 * n2 + 8;
                        this.a('\b');
                        continue block22;
                    }
                    case 't': {
                        n2 = 31 * n2 + 9;
                        this.a('\t');
                        continue block22;
                    }
                    case 'n': {
                        n2 = 31 * n2 + 10;
                        this.a('\n');
                        continue block22;
                    }
                    case 'v': {
                        n2 = 31 * n2 + 11;
                        this.a('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        n2 = 31 * n2 + 12;
                        this.a('\f');
                        continue block22;
                    }
                    case 'r': {
                        n2 = 31 * n2 + 13;
                        this.a('\r');
                        continue block22;
                    }
                    case '\"': {
                        n2 = 31 * n2 + 34;
                        this.a('\"');
                        continue block22;
                    }
                    case '\'': {
                        n2 = 31 * n2 + 39;
                        this.a('\'');
                        continue block22;
                    }
                    case '/': {
                        n2 = 31 * n2 + 47;
                        this.a('/');
                        continue block22;
                    }
                    case '\\': {
                        n2 = 31 * n2 + 92;
                        this.a('\\');
                        continue block22;
                    }
                    case 'x': {
                        c3 = this.d = this.next();
                        char n3 = this.d = this.next();
                        c3 = (char)(q[c3] * 16 + q[n3]);
                        n2 = 31 * n2 + c3;
                        this.a(c3);
                        continue block22;
                    }
                    case 'u': {
                        c3 = this.next();
                        char c4 = this.next();
                        char c5 = this.next();
                        char c6 = this.next();
                        c3 = Integer.parseInt(new String(new char[]{c3, c4, c5, c6}), 16);
                        n2 = 31 * n2 + c3;
                        this.a(c3);
                        continue block22;
                    }
                }
                this.d = c3;
                throw new JSONException("unclosed.str.lit");
            }
            n2 = 31 * n2 + c3;
            if (!bl) {
                ++this.h;
                continue;
            }
            if (this.h == this.g.length) {
                this.a(c3);
                continue;
            }
            this.g[this.h++] = c3;
        }
        this.a = 4;
        if (!bl) {
            int n3 = this.i == -1 ? 0 : this.i + 1;
            String string = this.addSymbol(n3, this.h, n2, symbolTable);
        } else {
            String string = symbolTable.addSymbol(this.g, 0, this.h, n2);
        }
        this.h = 0;
        this.next();
        return var5_8;
    }

    @Override
    public final void resetStringPosition() {
        this.h = 0;
    }

    @Override
    public String info() {
        return "";
    }

    @Override
    public final String scanSymbolUnQuoted(SymbolTable symbolTable) {
        char c2;
        if (this.a == 1 && this.b == 0 && this.e == 1) {
            this.e = 0;
        }
        boolean[] blArray = IOUtils.firstIdentifierFlags;
        int n2 = this.d;
        if (!(this.d >= blArray.length || blArray[n2])) {
            throw new JSONException("illegal identifier : " + this.d + this.info());
        }
        blArray = IOUtils.identifierFlags;
        this.i = this.e;
        this.h = 1;
        while ((c2 = this.next()) >= blArray.length || blArray[c2]) {
            n2 = 31 * n2 + c2;
            ++this.h;
        }
        this.d = this.charAt(this.e);
        this.a = 18;
        if (this.h == 4 && n2 == 3392903) {
            JSONLexerBase jSONLexerBase = this;
            if (jSONLexerBase.charAt(jSONLexerBase.i) == 'n') {
                JSONLexerBase jSONLexerBase2 = this;
                if (jSONLexerBase2.charAt(jSONLexerBase2.i + 1) == 'u') {
                    JSONLexerBase jSONLexerBase3 = this;
                    if (jSONLexerBase3.charAt(jSONLexerBase3.i + 2) == 'l') {
                        JSONLexerBase jSONLexerBase4 = this;
                        if (jSONLexerBase4.charAt(jSONLexerBase4.i + 3) == 'l') {
                            return null;
                        }
                    }
                }
            }
        }
        if (symbolTable == null) {
            JSONLexerBase jSONLexerBase = this;
            return jSONLexerBase.subString(jSONLexerBase.i, this.h);
        }
        JSONLexerBase jSONLexerBase = this;
        return jSONLexerBase.addSymbol(jSONLexerBase.i, this.h, n2, symbolTable);
    }

    protected abstract void a(int var1, int var2, char[] var3);

    @Override
    public final void scanString() {
        char c2;
        this.i = this.e;
        this.j = false;
        block22: while ((c2 = this.next()) != '\"') {
            if (c2 == '\u001a') {
                if (!this.isEOF()) {
                    this.a('\u001a');
                    continue;
                }
                throw new JSONException("unclosed string : ".concat(String.valueOf(c2)));
            }
            if (c2 == '\\') {
                if (!this.j) {
                    this.j = true;
                    if (this.h >= this.g.length) {
                        c2 = this.g.length * 2;
                        if (this.h > c2) {
                            c2 = this.h;
                        }
                        char[] cArray = new char[c2];
                        System.arraycopy(this.g, 0, cArray, 0, this.g.length);
                        this.g = cArray;
                    }
                    JSONLexerBase jSONLexerBase = this;
                    jSONLexerBase.a(jSONLexerBase.i + 1, this.h, this.g);
                }
                c2 = this.next();
                switch (c2) {
                    case '0': {
                        this.a('\u0000');
                        continue block22;
                    }
                    case '1': {
                        this.a('\u0001');
                        continue block22;
                    }
                    case '2': {
                        this.a('\u0002');
                        continue block22;
                    }
                    case '3': {
                        this.a('\u0003');
                        continue block22;
                    }
                    case '4': {
                        this.a('\u0004');
                        continue block22;
                    }
                    case '5': {
                        this.a('\u0005');
                        continue block22;
                    }
                    case '6': {
                        this.a('\u0006');
                        continue block22;
                    }
                    case '7': {
                        this.a('\u0007');
                        continue block22;
                    }
                    case 'b': {
                        this.a('\b');
                        continue block22;
                    }
                    case 't': {
                        this.a('\t');
                        continue block22;
                    }
                    case 'n': {
                        this.a('\n');
                        continue block22;
                    }
                    case 'v': {
                        this.a('\u000b');
                        continue block22;
                    }
                    case 'F': 
                    case 'f': {
                        this.a('\f');
                        continue block22;
                    }
                    case 'r': {
                        this.a('\r');
                        continue block22;
                    }
                    case '\"': {
                        this.a('\"');
                        continue block22;
                    }
                    case '\'': {
                        this.a('\'');
                        continue block22;
                    }
                    case '/': {
                        this.a('/');
                        continue block22;
                    }
                    case '\\': {
                        this.a('\\');
                        continue block22;
                    }
                    case 'x': {
                        char c3;
                        c2 = this.next();
                        char c4 = this.next();
                        char c5 = c2 >= '0' && c2 <= '9' || c2 >= 'a' && c2 <= 'f' || c2 >= 'A' && c2 <= 'F' ? (char)'\u0001' : '\u0000';
                        char c6 = c3 = c4 >= '0' && c4 <= '9' || c4 >= 'a' && c4 <= 'f' || c4 >= 'A' && c4 <= 'F' ? (char)'\u0001' : '\u0000';
                        if (c5 == '\u0000' || c3 == '\u0000') {
                            throw new JSONException("invalid escape character \\x" + c2 + c4);
                        }
                        c2 = (char)(q[c2] * 16 + q[c4]);
                        this.a(c2);
                        continue block22;
                    }
                    case 'u': {
                        c2 = this.next();
                        char c7 = this.next();
                        char c5 = this.next();
                        char c3 = this.next();
                        c2 = Integer.parseInt(new String(new char[]{c2, c7, c5, c3}), 16);
                        this.a(c2);
                        continue block22;
                    }
                }
                this.d = c2;
                throw new JSONException("unclosed string : ".concat(String.valueOf(c2)));
            }
            if (!this.j) {
                ++this.h;
                continue;
            }
            if (this.h == this.g.length) {
                this.a(c2);
                continue;
            }
            this.g[this.h++] = c2;
        }
        this.a = 4;
        this.d = this.next();
    }

    public Calendar getCalendar() {
        return this.k;
    }

    @Override
    public TimeZone getTimeZone() {
        return this.l;
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.l = timeZone;
    }

    @Override
    public Locale getLocale() {
        return this.m;
    }

    @Override
    public void setLocale(Locale locale) {
        this.m = locale;
    }

    @Override
    public final int intValue() {
        int n2;
        int n3;
        if (this.i == -1) {
            this.i = 0;
        }
        int n4 = 0;
        boolean bl = false;
        int n5 = this.i;
        int n6 = this.i + this.h;
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.i) == '-') {
            bl = true;
            n3 = Integer.MIN_VALUE;
            ++n5;
        } else {
            n3 = -2147483647;
        }
        if (n5 < n6) {
            n4 = -(this.charAt(n5++) - 48);
        }
        while (n5 < n6 && (n2 = this.charAt(n5++)) != 76 && n2 != 83 && n2 != 66) {
            n2 -= 48;
            if ((long)n4 < -214748364L) {
                throw new NumberFormatException(this.numberString());
            }
            if ((n4 *= 10) < n3 + n2) {
                throw new NumberFormatException(this.numberString());
            }
            n4 -= n2;
        }
        if (bl) {
            if (n5 > this.i + 1) {
                return n4;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -n4;
    }

    @Override
    public abstract byte[] bytesValue();

    @Override
    public void close() {
        if (this.g.length <= 8192) {
            r.set(this.g);
        }
        this.g = null;
    }

    @Override
    public final boolean isRef() {
        if (this.h != 4) {
            return false;
        }
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.i + 1) == '$') {
            JSONLexerBase jSONLexerBase2 = this;
            if (jSONLexerBase2.charAt(jSONLexerBase2.i + 2) == 'r') {
                JSONLexerBase jSONLexerBase3 = this;
                if (jSONLexerBase3.charAt(jSONLexerBase3.i + 3) == 'e') {
                    JSONLexerBase jSONLexerBase4 = this;
                    if (jSONLexerBase4.charAt(jSONLexerBase4.i + 4) == 'f') {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public String scanTypeName(SymbolTable symbolTable) {
        return null;
    }

    public final int scanType(String string) {
        this.matchStat = 0;
        if (!this.charArrayCompare(p)) {
            return -2;
        }
        int n2 = this.e + p.length;
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            if (string.charAt(i2) == this.charAt(n2 + i2)) continue;
            return -1;
        }
        if (this.charAt(n2 += n3) != '\"') {
            return -1;
        }
        this.d = this.charAt(++n2);
        if (this.d == ',') {
            this.d = this.charAt(++n2);
            this.e = n2;
            this.a = 16;
            return 3;
        }
        if (this.d == '}') {
            this.d = this.charAt(++n2);
            if (this.d == ',') {
                this.a = 16;
                this.d = this.charAt(++n2);
            } else if (this.d == ']') {
                this.a = 15;
                this.d = this.charAt(++n2);
            } else if (this.d == '}') {
                this.a = 13;
                this.d = this.charAt(++n2);
            } else if (this.d == '\u001a') {
                this.a = 20;
            } else {
                return -1;
            }
            this.matchStat = 4;
        }
        this.e = n2;
        return this.matchStat;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final boolean matchField(char[] cArray) {
        while (!this.charArrayCompare(cArray)) {
            if (!JSONLexerBase.isWhitespace(this.d)) return false;
            this.next();
        }
        this.e += cArray.length;
        this.d = this.charAt(this.e);
        if (this.d == '{') {
            this.next();
            this.a = 12;
            return true;
        }
        if (this.d == '[') {
            this.next();
            this.a = 14;
            return true;
        }
        if (this.d == 'S') {
            JSONLexerBase jSONLexerBase = this;
            if (jSONLexerBase.charAt(jSONLexerBase.e + 1) == 'e') {
                JSONLexerBase jSONLexerBase2 = this;
                if (jSONLexerBase2.charAt(jSONLexerBase2.e + 2) == 't') {
                    JSONLexerBase jSONLexerBase3 = this;
                    if (jSONLexerBase3.charAt(jSONLexerBase3.e + 3) == '[') {
                        this.e += 3;
                        this.d = this.charAt(this.e);
                        this.a = 21;
                        return true;
                    }
                }
            }
        }
        this.nextToken();
        return true;
    }

    public int matchField(long l2) {
        throw new UnsupportedOperationException();
    }

    public boolean seekArrayToItem(int n2) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToField(long l2, boolean bl) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToField(long[] lArray) {
        throw new UnsupportedOperationException();
    }

    public int seekObjectToFieldDeepScan(long l2) {
        throw new UnsupportedOperationException();
    }

    public void skipObject() {
        throw new UnsupportedOperationException();
    }

    public void skipObject(boolean bl) {
        throw new UnsupportedOperationException();
    }

    public void skipArray() {
        throw new UnsupportedOperationException();
    }

    public abstract int indexOf(char var1, int var2);

    public abstract String addSymbol(int var1, int var2, int var3, SymbolTable var4);

    /*
     * Enabled aggressive block sorting
     */
    public String scanFieldString(char[] object) {
        this.matchStat = 0;
        if (!this.charArrayCompare((char[])object)) {
            this.matchStat = -2;
            return this.stringDefaultValue();
        }
        int n2 = ((char[])object).length;
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.e + n2++) != '\"') {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        int n3 = this.e + ((char[])object).length + 1;
        if ((n3 = this.indexOf('\"', n3)) == -1) {
            throw new JSONException("unclosed str");
        }
        int n4 = this.e + ((char[])object).length + 1;
        String string = this.subString(n4, n3 - n4);
        if (string.indexOf(92) != -1) {
            int n5;
            while (true) {
                n5 = 0;
                for (int i2 = n3 - 1; i2 >= 0 && this.charAt(i2) == '\\'; ++n5, --i2) {
                }
                if (n5 % 2 == 0) break;
                n3 = this.indexOf('\"', n3 + 1);
            }
            n5 = n3 - (this.e + ((char[])object).length + 1);
            JSONLexerBase jSONLexerBase2 = this;
            string = JSONLexerBase.readString(jSONLexerBase2.sub_chars(jSONLexerBase2.e + ((char[])object).length + 1, n5), n5);
        }
        n2 += n3 - (this.e + ((char[])object).length + 1) + 1;
        JSONLexerBase jSONLexerBase3 = this;
        n3 = jSONLexerBase3.charAt(jSONLexerBase3.e + n2++);
        String string2 = string;
        if (n3 == 44) {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return string2;
        }
        if (n3 != 125) {
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        JSONLexerBase jSONLexerBase4 = this;
        char c2 = jSONLexerBase4.charAt(jSONLexerBase4.e + n2++);
        n3 = c2;
        if (c2 == ',') {
            this.a = 16;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (n3 == 93) {
            this.a = 15;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (n3 == 125) {
            this.a = 13;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else {
            if (n3 != 26) {
                this.matchStat = -1;
                return this.stringDefaultValue();
            }
            this.a = 20;
            this.e += n2 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return string2;
    }

    @Override
    public String scanString(char c2) {
        String string;
        char c3;
        int n2;
        block14: {
            block15: {
                block17: {
                    block16: {
                        this.matchStat = 0;
                        n2 = 0;
                        JSONLexerBase jSONLexerBase = this;
                        ++n2;
                        c3 = jSONLexerBase.charAt(jSONLexerBase.e + 0);
                        if (c3 != 'n') break block15;
                        JSONLexerBase jSONLexerBase2 = this;
                        if (jSONLexerBase2.charAt(jSONLexerBase2.e + 1) != 'u') break block16;
                        JSONLexerBase jSONLexerBase3 = this;
                        if (jSONLexerBase3.charAt(jSONLexerBase3.e + 1 + 1) != 'l') break block16;
                        JSONLexerBase jSONLexerBase4 = this;
                        if (jSONLexerBase4.charAt(jSONLexerBase4.e + 1 + 2) == 'l') break block17;
                    }
                    this.matchStat = -1;
                    return null;
                }
                JSONLexerBase jSONLexerBase = this;
                c3 = jSONLexerBase.charAt(jSONLexerBase.e + 4);
                if (c3 == c2) {
                    this.e += 5;
                    this.d = this.charAt(this.e);
                    this.matchStat = 3;
                    return null;
                }
                this.matchStat = -1;
                return null;
            }
            while (true) {
                if (c3 == '\"') {
                    c3 = this.e + n2;
                    int n3 = this.indexOf('\"', c3);
                    if (n3 == -1) {
                        throw new JSONException("unclosed str");
                    }
                    JSONLexerBase jSONLexerBase = this;
                    string = jSONLexerBase.subString(jSONLexerBase.e + n2, n3 - c3);
                    if (string.indexOf(92) != -1) {
                        int n4;
                        while (true) {
                            n4 = 0;
                            for (int i2 = n3 - 1; i2 >= 0 && this.charAt(i2) == '\\'; --i2) {
                                ++n4;
                            }
                            if (n4 % 2 == 0) break;
                            n3 = this.indexOf('\"', n3 + 1);
                        }
                        n4 = n3 - c3;
                        JSONLexerBase jSONLexerBase5 = this;
                        string = JSONLexerBase.readString(jSONLexerBase5.sub_chars(jSONLexerBase5.e + 1, n4), n4);
                    }
                    n2 += n3 - c3 + 1;
                    break block14;
                }
                if (!JSONLexerBase.isWhitespace(c3)) break;
                JSONLexerBase jSONLexerBase = this;
                c3 = jSONLexerBase.charAt(jSONLexerBase.e + n2++);
            }
            this.matchStat = -1;
            return this.stringDefaultValue();
        }
        JSONLexerBase jSONLexerBase = this;
        c3 = jSONLexerBase.charAt(jSONLexerBase.e + n2++);
        String string2 = string;
        while (true) {
            if (c3 == c2) {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                this.a = 16;
                return string2;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            JSONLexerBase jSONLexerBase6 = this;
            c3 = jSONLexerBase6.charAt(jSONLexerBase6.e + n2++);
        }
        if (c3 == ']') {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = -1;
        }
        return string2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldSymbol(char[] cArray) {
        char c2;
        long l2;
        int n2;
        block12: {
            block13: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return 0L;
                }
                n2 = cArray.length;
                JSONLexerBase jSONLexerBase = this;
                if (jSONLexerBase.charAt(jSONLexerBase.e + n2++) != '\"') {
                    this.matchStat = -1;
                    return 0L;
                }
                l2 = -3750763034362895579L;
                do {
                    JSONLexerBase jSONLexerBase2 = this;
                    if ((c2 = jSONLexerBase2.charAt(jSONLexerBase2.e + n2++)) == '\"') {
                        JSONLexerBase jSONLexerBase3 = this;
                        if ((c2 = jSONLexerBase3.charAt(jSONLexerBase3.e + n2++)) != ',') break block12;
                        break block13;
                    }
                    l2 = (l2 ^ (long)c2) * 1099511628211L;
                } while (c2 != '\\');
                this.matchStat = -1;
                return 0L;
            }
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return l2;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return 0L;
        }
        JSONLexerBase jSONLexerBase = this;
        if ((c2 = jSONLexerBase.charAt(jSONLexerBase.e + n2++)) == ',') {
            this.a = 16;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.a = 20;
            this.e += n2 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return l2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanEnumSymbol(char[] cArray) {
        int n2;
        long l2;
        int n3;
        block12: {
            block13: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return 0L;
                }
                n3 = cArray.length;
                JSONLexerBase jSONLexerBase = this;
                if (jSONLexerBase.charAt(jSONLexerBase.e + n3++) != '\"') {
                    this.matchStat = -1;
                    return 0L;
                }
                l2 = -3750763034362895579L;
                do {
                    JSONLexerBase jSONLexerBase2 = this;
                    if ((n2 = jSONLexerBase2.charAt(jSONLexerBase2.e + n3++)) == 34) {
                        JSONLexerBase jSONLexerBase3 = this;
                        if ((n2 = jSONLexerBase3.charAt(jSONLexerBase3.e + n3++)) != 44) break block12;
                        break block13;
                    }
                    l2 = (l2 ^ (long)(n2 >= 65 && n2 <= 90 ? n2 + 32 : n2)) * 1099511628211L;
                } while (n2 != 92);
                this.matchStat = -1;
                return 0L;
            }
            this.e += n3;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return l2;
        }
        if (n2 != 125) {
            this.matchStat = -1;
            return 0L;
        }
        JSONLexerBase jSONLexerBase = this;
        char c2 = jSONLexerBase.charAt(jSONLexerBase.e + n3++);
        n2 = c2;
        if (c2 == ',') {
            this.a = 16;
            this.e += n3;
            this.d = this.charAt(this.e);
        } else if (n2 == 93) {
            this.a = 15;
            this.e += n3;
            this.d = this.charAt(this.e);
        } else if (n2 == 125) {
            this.a = 13;
            this.e += n3;
            this.d = this.charAt(this.e);
        } else {
            if (n2 != 26) {
                this.matchStat = -1;
                return 0L;
            }
            this.a = 20;
            this.e += n3 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return l2;
    }

    @Override
    public Enum<?> scanEnum(Class<?> clazz, SymbolTable object, char c2) {
        if ((object = this.scanSymbolWithSeperator((SymbolTable)object, c2)) == null) {
            return null;
        }
        return Enum.valueOf(clazz, (String)object);
    }

    @Override
    public String scanSymbolWithSeperator(SymbolTable object, char c2) {
        int n2;
        char c3;
        int n3;
        block8: {
            block9: {
                block11: {
                    block10: {
                        this.matchStat = 0;
                        n3 = 0;
                        JSONLexerBase jSONLexerBase = this;
                        ++n3;
                        c3 = jSONLexerBase.charAt(jSONLexerBase.e + 0);
                        if (c3 != 'n') break block9;
                        JSONLexerBase jSONLexerBase2 = this;
                        if (jSONLexerBase2.charAt(jSONLexerBase2.e + 1) != 'u') break block10;
                        JSONLexerBase jSONLexerBase3 = this;
                        if (jSONLexerBase3.charAt(jSONLexerBase3.e + 1 + 1) != 'l') break block10;
                        JSONLexerBase jSONLexerBase4 = this;
                        if (jSONLexerBase4.charAt(jSONLexerBase4.e + 1 + 2) == 'l') break block11;
                    }
                    this.matchStat = -1;
                    return null;
                }
                JSONLexerBase jSONLexerBase = this;
                c3 = jSONLexerBase.charAt(jSONLexerBase.e + 4);
                if (c3 == c2) {
                    this.e += 5;
                    this.d = this.charAt(this.e);
                    this.matchStat = 3;
                    return null;
                }
                this.matchStat = -1;
                return null;
            }
            if (c3 != '\"') {
                this.matchStat = -1;
                return null;
            }
            n2 = 0;
            do {
                JSONLexerBase jSONLexerBase = this;
                if ((c3 = jSONLexerBase.charAt(jSONLexerBase.e + n3++)) == '\"') break block8;
                n2 = 31 * n2 + c3;
            } while (c3 != '\\');
            this.matchStat = -1;
            return null;
        }
        c3 = this.e + 0 + 1;
        int n4 = this.e + n3 - c3 - 1;
        object = this.addSymbol(c3, n4, n2, (SymbolTable)object);
        JSONLexerBase jSONLexerBase = this;
        c3 = jSONLexerBase.charAt(jSONLexerBase.e + n3++);
        while (true) {
            if (c3 == c2) {
                this.e += n3;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                return object;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            JSONLexerBase jSONLexerBase5 = this;
            c3 = jSONLexerBase5.charAt(jSONLexerBase5.e + n3++);
        }
        this.matchStat = -1;
        return object;
    }

    public Collection<String> newCollectionByType(Class<?> clazz) {
        if (clazz.isAssignableFrom(HashSet.class)) {
            return new HashSet<String>();
        }
        if (clazz.isAssignableFrom(ArrayList.class)) {
            return new ArrayList<String>();
        }
        if (clazz.isAssignableFrom(LinkedList.class)) {
            return new LinkedList<String>();
        }
        try {
            return (Collection)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new JSONException(exception.getMessage(), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public Collection<String> scanFieldStringArray(char[] cArray, Class<?> collection) {
        int n2;
        int n3;
        block20: {
            this.matchStat = 0;
            if (!this.charArrayCompare(cArray)) {
                this.matchStat = -2;
                return null;
            }
            collection = this.newCollectionByType((Class<?>)((Object)collection));
            n3 = cArray.length;
            JSONLexerBase jSONLexerBase = this;
            if (jSONLexerBase.charAt(jSONLexerBase.e + n3++) != '[') {
                this.matchStat = -1;
                return null;
            }
            do {
                String string;
                block22: {
                    int n4;
                    block23: {
                        block21: {
                            JSONLexerBase jSONLexerBase2 = this;
                            if ((n2 = jSONLexerBase2.charAt(jSONLexerBase2.e + n3++)) != 34) break block21;
                            n2 = this.e + n3;
                            if ((n2 = this.indexOf('\"', n2)) == -1) {
                                throw new JSONException("unclosed str");
                            }
                            int n5 = this.e + n3;
                            string = this.subString(n5, n2 - n5);
                            if (string.indexOf(92) == -1) break block22;
                            break block23;
                        }
                        if (n2 == 110) {
                            JSONLexerBase jSONLexerBase3 = this;
                            if (jSONLexerBase3.charAt(jSONLexerBase3.e + n3) == 'u') {
                                JSONLexerBase jSONLexerBase4 = this;
                                if (jSONLexerBase4.charAt(jSONLexerBase4.e + n3 + 1) == 'l') {
                                    JSONLexerBase jSONLexerBase5 = this;
                                    if (jSONLexerBase5.charAt(jSONLexerBase5.e + n3 + 2) == 'l') {
                                        n3 += 3;
                                        JSONLexerBase jSONLexerBase6 = this;
                                        n2 = jSONLexerBase6.charAt(jSONLexerBase6.e + n3++);
                                        collection.add(null);
                                        continue;
                                    }
                                }
                            }
                        }
                        if (n2 != 93) throw new JSONException("illega str");
                        if (collection.size() != 0) throw new JSONException("illega str");
                        JSONLexerBase jSONLexerBase7 = this;
                        n2 = jSONLexerBase7.charAt(jSONLexerBase7.e + n3++);
                        break block20;
                    }
                    while (true) {
                        n4 = 0;
                        for (int i2 = n2 - 1; i2 >= 0 && this.charAt(i2) == '\\'; ++n4, --i2) {
                        }
                        if (n4 % 2 == 0) break;
                        n2 = this.indexOf('\"', n2 + 1);
                    }
                    n4 = n2 - (this.e + n3);
                    JSONLexerBase jSONLexerBase8 = this;
                    string = JSONLexerBase.readString(jSONLexerBase8.sub_chars(jSONLexerBase8.e + n3, n4), n4);
                }
                n3 += n2 - (this.e + n3) + 1;
                JSONLexerBase jSONLexerBase9 = this;
                n2 = jSONLexerBase9.charAt(jSONLexerBase9.e + n3++);
                collection.add(string);
            } while (n2 == 44);
            if (n2 != 93) {
                this.matchStat = -1;
                return null;
            }
            JSONLexerBase jSONLexerBase10 = this;
            n2 = jSONLexerBase10.charAt(jSONLexerBase10.e + n3++);
        }
        if (n2 == 44) {
            this.e += n3;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return collection;
        }
        if (n2 != 125) {
            this.matchStat = -1;
            return null;
        }
        JSONLexerBase jSONLexerBase = this;
        char c2 = jSONLexerBase.charAt(jSONLexerBase.e + n3++);
        n2 = c2;
        if (c2 == ',') {
            this.a = 16;
            this.e += n3;
            this.d = this.charAt(this.e);
        } else if (n2 == 93) {
            this.a = 15;
            this.e += n3;
            this.d = this.charAt(this.e);
        } else if (n2 == 125) {
            this.a = 13;
            this.e += n3;
            this.d = this.charAt(this.e);
        } else {
            if (n2 != 26) {
                this.matchStat = -1;
                return null;
            }
            this.e += n3 - 1;
            this.a = 20;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return collection;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void scanStringArray(Collection<String> var1_1, char var2_2) {
        block18: {
            this.matchStat = 0;
            var3_3 = 0;
            v0 = this;
            ++var3_3;
            var4_4 = v0.charAt(v0.e + 0);
            if (var4_4 == 110) {
                v1 = this;
                if (v1.charAt(v1.e + 1) == 'u') {
                    v2 = this;
                    if (v2.charAt(v2.e + 1 + 1) == 'l') {
                        v3 = this;
                        if (v3.charAt(v3.e + 1 + 2) == 'l') {
                            v4 = this;
                            if (v4.charAt(v4.e + 1 + 3) == var2_2) {
                                this.e += 5;
                                this.d = this.charAt(this.e);
                                this.matchStat = 5;
                                return;
                            }
                        }
                    }
                }
            }
            if (var4_4 != 91) {
                this.matchStat = -1;
                return;
            }
            v5 = this;
            ++var3_3;
            var4_4 = v5.charAt(v5.e + 1);
            while (true) {
                if (var4_4 != 110) ** GOTO lbl-1000
                v6 = this;
                if (v6.charAt(v6.e + var3_3) != 'u') ** GOTO lbl-1000
                v7 = this;
                if (v7.charAt(v7.e + var3_3 + 1) != 'l') ** GOTO lbl-1000
                v8 = this;
                if (v8.charAt(v8.e + var3_3 + 2) == 'l') {
                    var3_3 += 3;
                    v9 = this;
                    var4_4 = v9.charAt(v9.e + var3_3++);
                    var1_1.add(null);
                } else lbl-1000:
                // 4 sources

                {
                    if (var4_4 == 93 && var1_1.size() == 0) {
                        v10 = this;
                        var4_4 = v10.charAt(v10.e + var3_3++);
                        break block18;
                    }
                    if (var4_4 != 34) {
                        this.matchStat = -1;
                        return;
                    }
                    var4_4 = this.e + var3_3;
                    var5_5 = this.indexOf('\"', var4_4);
                    if (var5_5 == -1) {
                        throw new JSONException("unclosed str");
                    }
                    v11 = this;
                    var6_6 = v11.subString(v11.e + var3_3, var5_5 - var4_4);
                    if (var6_6.indexOf(92) != -1) {
                        while (true) {
                            var6_8 = 0;
                            for (var7_9 = var5_5 - 1; var7_9 >= 0 && this.charAt(var7_9) == '\\'; --var7_9) {
                                ++var6_8;
                            }
                            if (var6_8 % 2 == 0) break;
                            var5_5 = this.indexOf('\"', var5_5 + 1);
                        }
                        var6_8 = var5_5 - var4_4;
                        v12 = this;
                        var6_6 = JSONLexerBase.readString(v12.sub_chars(v12.e + var3_3, var6_8), var6_8);
                    }
                    var3_3 += var5_5 - (this.e + var3_3) + 1;
                    v13 = this;
                    var4_4 = v13.charAt(v13.e + var3_3++);
                    var1_1.add(var6_6);
                }
                if (var4_4 != 44) break;
                v14 = this;
                var4_4 = v14.charAt(v14.e + var3_3++);
            }
            if (var4_4 == 93) {
                v15 = this;
                var4_4 = v15.charAt(v15.e + var3_3++);
            } else {
                this.matchStat = -1;
                return;
            }
        }
        if (var4_4 == var2_2) {
            this.e += var3_3;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return;
        }
        this.matchStat = -1;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int scanFieldInt(char[] cArray) {
        int n2;
        char c2;
        boolean bl;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0;
        }
        int n3 = cArray.length;
        JSONLexerBase jSONLexerBase = this;
        if (bl = (c2 = jSONLexerBase.charAt(jSONLexerBase.e + n3++)) == '-') {
            JSONLexerBase jSONLexerBase2 = this;
            c2 = jSONLexerBase2.charAt(jSONLexerBase2.e + n3++);
        }
        if (c2 >= '0' && c2 <= '9') {
            n2 = c2 - 48;
            while (true) {
                JSONLexerBase jSONLexerBase3 = this;
                if ((c2 = jSONLexerBase3.charAt(jSONLexerBase3.e + n3++)) < '0' || c2 > '9') break;
                n2 = n2 * 10 + (c2 - 48);
            }
            if (c2 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (!(n2 >= 0 && n3 <= 14 + cArray.length || n2 == Integer.MIN_VALUE && n3 == 17 && bl)) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            this.matchStat = -1;
            return 0;
        }
        if (c2 == ',') {
            this.e += n3;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            if (bl) {
                return -n2;
            }
            return n2;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return 0;
        }
        JSONLexerBase jSONLexerBase4 = this;
        if ((c2 = jSONLexerBase4.charAt(jSONLexerBase4.e + n3++)) == ',') {
            this.a = 16;
            this.e += n3;
            this.d = this.charAt(this.e);
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n3;
            this.d = this.charAt(this.e);
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n3;
            this.d = this.charAt(this.e);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return 0;
            }
            this.a = 20;
            this.e += n3 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        if (!bl) {
            return n2;
        }
        return -n2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int[] scanFieldIntArray(char[] cArray) {
        int n2;
        int[] nArray;
        char c2;
        int n3;
        block20: {
            block19: {
                this.matchStat = 0;
                if (!this.charArrayCompare(cArray)) {
                    this.matchStat = -2;
                    return null;
                }
                n3 = cArray.length;
                JSONLexerBase jSONLexerBase = this;
                if (jSONLexerBase.charAt(jSONLexerBase.e + n3++) != '[') {
                    this.matchStat = -2;
                    return null;
                }
                JSONLexerBase jSONLexerBase2 = this;
                c2 = jSONLexerBase2.charAt(jSONLexerBase2.e + n3++);
                nArray = new int[16];
                n2 = 0;
                if (c2 == ']') {
                    JSONLexerBase jSONLexerBase3 = this;
                    c2 = jSONLexerBase3.charAt(jSONLexerBase3.e + n3++);
                } else {
                    while (true) {
                        boolean bl = false;
                        if (c2 == '-') {
                            JSONLexerBase jSONLexerBase4 = this;
                            c2 = jSONLexerBase4.charAt(jSONLexerBase4.e + n3++);
                            bl = true;
                        }
                        if (c2 < '0' || c2 > '9') break block19;
                        int n4 = c2 - 48;
                        while (true) {
                            JSONLexerBase jSONLexerBase5 = this;
                            if ((c2 = jSONLexerBase5.charAt(jSONLexerBase5.e + n3++)) < '0' || c2 > '9') break;
                            n4 = n4 * 10 + (c2 - 48);
                        }
                        if (n2 >= nArray.length) {
                            int[] nArray2 = new int[nArray.length * 3 / 2];
                            System.arraycopy(nArray, 0, nArray2, 0, n2);
                            nArray = nArray2;
                        }
                        int n5 = nArray[n2++] = bl ? -n4 : n4;
                        if (c2 == ',') {
                            JSONLexerBase jSONLexerBase6 = this;
                            c2 = jSONLexerBase6.charAt(jSONLexerBase6.e + n3++);
                            continue;
                        }
                        if (c2 == ']') break;
                    }
                    JSONLexerBase jSONLexerBase7 = this;
                    c2 = jSONLexerBase7.charAt(jSONLexerBase7.e + n3++);
                }
                break block20;
            }
            this.matchStat = -1;
            return null;
        }
        if (n2 != nArray.length) {
            int[] nArray3 = new int[n2];
            System.arraycopy(nArray, 0, nArray3, 0, n2);
            nArray = nArray3;
        }
        if (c2 == ',') {
            this.e += n3 - 1;
            this.next();
            this.matchStat = 3;
            this.a = 16;
            return nArray;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        JSONLexerBase jSONLexerBase = this;
        if ((c2 = jSONLexerBase.charAt(jSONLexerBase.e + n3++)) == ',') {
            this.a = 16;
            this.e += n3 - 1;
            this.next();
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n3 - 1;
            this.next();
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n3 - 1;
            this.next();
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.e += n3 - 1;
            this.a = 20;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return nArray;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean scanBoolean(char var1_1) {
        block9: {
            block7: {
                block8: {
                    this.matchStat = 0;
                    var2_2 = 0;
                    v0 = this;
                    ++var2_2;
                    var3_3 = v0.charAt(v0.e + 0);
                    var4_4 = false;
                    if (var3_3 != 't') break block7;
                    v1 = this;
                    if (v1.charAt(v1.e + 1) != 'r') break block8;
                    v2 = this;
                    if (v2.charAt(v2.e + 1 + 1) != 'u') break block8;
                    v3 = this;
                    if (v3.charAt(v3.e + 1 + 2) != 'e') break block8;
                    var2_2 += 3;
                    v4 = this;
                    ++var2_2;
                    var3_3 = v4.charAt(v4.e + 4);
                    var4_4 = true;
                    break block9;
                }
                this.matchStat = -1;
                return false;
            }
            if (var3_3 != 'f') ** GOTO lbl41
            v5 = this;
            if (v5.charAt(v5.e + 1) != 'a') ** GOTO lbl-1000
            v6 = this;
            if (v6.charAt(v6.e + 1 + 1) != 'l') ** GOTO lbl-1000
            v7 = this;
            if (v7.charAt(v7.e + 1 + 2) != 's') ** GOTO lbl-1000
            v8 = this;
            if (v8.charAt(v8.e + 1 + 3) == 'e') {
                var2_2 += 4;
                v9 = this;
                ++var2_2;
                var3_3 = v9.charAt(v9.e + 5);
                var4_4 = false;
            } else lbl-1000:
            // 4 sources

            {
                this.matchStat = -1;
                return false;
lbl41:
                // 1 sources

                if (var3_3 == '1') {
                    v10 = this;
                    ++var2_2;
                    var3_3 = v10.charAt(v10.e + 1);
                    var4_4 = true;
                } else if (var3_3 == '0') {
                    v11 = this;
                    ++var2_2;
                    var3_3 = v11.charAt(v11.e + 1);
                    var4_4 = false;
                }
            }
        }
        while (true) {
            if (var3_3 == var1_1) {
                this.e += var2_2;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                return var4_4;
            }
            if (!JSONLexerBase.isWhitespace(var3_3)) break;
            v12 = this;
            var3_3 = v12.charAt(v12.e + var2_2++);
        }
        this.matchStat = -1;
        return var4_4;
    }

    @Override
    public int scanInt(char c2) {
        boolean bl;
        this.matchStat = 0;
        int n2 = 0;
        JSONLexerBase jSONLexerBase = this;
        ++n2;
        char c3 = jSONLexerBase.charAt(jSONLexerBase.e + 0);
        int n3 = c3 == '\"' ? 1 : 0;
        if (n3 != 0) {
            JSONLexerBase jSONLexerBase2 = this;
            ++n2;
            c3 = jSONLexerBase2.charAt(jSONLexerBase2.e + 1);
        }
        if (bl = c3 == '-') {
            JSONLexerBase jSONLexerBase3 = this;
            c3 = jSONLexerBase3.charAt(jSONLexerBase3.e + n2++);
        }
        if (c3 >= '0' && c3 <= '9') {
            n3 = c3 - 48;
            while (true) {
                JSONLexerBase jSONLexerBase4 = this;
                if ((c3 = jSONLexerBase4.charAt(jSONLexerBase4.e + n2++)) < '0' || c3 > '9') break;
                n3 = n3 * 10 + (c3 - 48);
            }
            if (c3 == '.') {
                this.matchStat = -1;
                return 0;
            }
            if (n3 < 0) {
                this.matchStat = -1;
                return 0;
            }
        } else {
            if (c3 == 'n') {
                JSONLexerBase jSONLexerBase5 = this;
                if (jSONLexerBase5.charAt(jSONLexerBase5.e + n2) == 'u') {
                    JSONLexerBase jSONLexerBase6 = this;
                    if (jSONLexerBase6.charAt(jSONLexerBase6.e + n2 + 1) == 'l') {
                        JSONLexerBase jSONLexerBase7 = this;
                        if (jSONLexerBase7.charAt(jSONLexerBase7.e + n2 + 2) == 'l') {
                            this.matchStat = 5;
                            n2 += 3;
                            JSONLexerBase jSONLexerBase8 = this;
                            c3 = jSONLexerBase8.charAt(jSONLexerBase8.e + n2++);
                            if (n3 != 0 && c3 == '\"') {
                                JSONLexerBase jSONLexerBase9 = this;
                                c3 = jSONLexerBase9.charAt(jSONLexerBase9.e + n2++);
                            }
                            while (true) {
                                if (c3 == ',') {
                                    this.e += n2;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 16;
                                    return 0;
                                }
                                if (c3 == ']') {
                                    this.e += n2;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 15;
                                    return 0;
                                }
                                if (!JSONLexerBase.isWhitespace(c3)) break;
                                JSONLexerBase jSONLexerBase10 = this;
                                c3 = jSONLexerBase10.charAt(jSONLexerBase10.e + n2++);
                            }
                            this.matchStat = -1;
                            return 0;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0;
        }
        while (true) {
            if (c3 == c2) {
                this.e += n2;
                this.d = this.charAt(this.e);
                this.matchStat = 3;
                this.a = 16;
                if (bl) {
                    return -n3;
                }
                return n3;
            }
            if (!JSONLexerBase.isWhitespace(c3)) break;
            JSONLexerBase jSONLexerBase11 = this;
            c3 = jSONLexerBase11.charAt(jSONLexerBase11.e + n2++);
        }
        this.matchStat = -1;
        if (bl) {
            return -n3;
        }
        return n3;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean scanFieldBoolean(char[] cArray) {
        boolean bl;
        char c2;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return false;
        }
        int n2 = cArray.length;
        JSONLexerBase jSONLexerBase = this;
        if ((c2 = jSONLexerBase.charAt(jSONLexerBase.e + n2++)) == 't') {
            JSONLexerBase jSONLexerBase2 = this;
            if (jSONLexerBase2.charAt(jSONLexerBase2.e + n2++) != 'r') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase3 = this;
            if (jSONLexerBase3.charAt(jSONLexerBase3.e + n2++) != 'u') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase4 = this;
            if (jSONLexerBase4.charAt(jSONLexerBase4.e + n2++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            bl = true;
        } else {
            if (c2 != 'f') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase5 = this;
            if (jSONLexerBase5.charAt(jSONLexerBase5.e + n2++) != 'a') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase6 = this;
            if (jSONLexerBase6.charAt(jSONLexerBase6.e + n2++) != 'l') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase7 = this;
            if (jSONLexerBase7.charAt(jSONLexerBase7.e + n2++) != 's') {
                this.matchStat = -1;
                return false;
            }
            JSONLexerBase jSONLexerBase8 = this;
            if (jSONLexerBase8.charAt(jSONLexerBase8.e + n2++) != 'e') {
                this.matchStat = -1;
                return false;
            }
            bl = false;
        }
        JSONLexerBase jSONLexerBase9 = this;
        c2 = jSONLexerBase9.charAt(jSONLexerBase9.e + n2++);
        if (c2 == ',') {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            return bl;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return false;
        }
        JSONLexerBase jSONLexerBase10 = this;
        if ((c2 = jSONLexerBase10.charAt(jSONLexerBase10.e + n2++)) == ',') {
            this.a = 16;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return false;
            }
            this.a = 20;
            this.e += n2 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long scanFieldLong(char[] cArray) {
        long l2;
        this.matchStat = 0;
        if (!this.charArrayCompare(cArray)) {
            this.matchStat = -2;
            return 0L;
        }
        int n2 = cArray.length;
        JSONLexerBase jSONLexerBase = this;
        char c2 = jSONLexerBase.charAt(jSONLexerBase.e + n2++);
        boolean bl = false;
        if (c2 == '-') {
            JSONLexerBase jSONLexerBase2 = this;
            c2 = jSONLexerBase2.charAt(jSONLexerBase2.e + n2++);
            bl = true;
        }
        if (c2 >= '0' && c2 <= '9') {
            l2 = c2 - 48;
            while (true) {
                JSONLexerBase jSONLexerBase3 = this;
                if ((c2 = jSONLexerBase3.charAt(jSONLexerBase3.e + n2++)) < '0' || c2 > '9') break;
                l2 = l2 * 10L + (long)(c2 - 48);
            }
            if (c2 == '.') {
                this.matchStat = -1;
                return 0L;
            }
            if (!(n2 - cArray.length < 21 && (l2 >= 0L || l2 == Long.MIN_VALUE && bl))) {
                this.matchStat = -1;
                return 0L;
            }
        } else {
            this.matchStat = -1;
            return 0L;
        }
        if (c2 == ',') {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            if (bl) {
                return -l2;
            }
            return l2;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return 0L;
        }
        JSONLexerBase jSONLexerBase4 = this;
        if ((c2 = jSONLexerBase4.charAt(jSONLexerBase4.e + n2++)) == ',') {
            this.a = 16;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return 0L;
            }
            this.a = 20;
            this.e += n2 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        if (!bl) {
            return l2;
        }
        return -l2;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public long scanLong(char var1_1) {
        this.matchStat = 0;
        var2_3 = 0;
        v0 = this;
        ++var2_3;
        var3_4 = v0.charAt(v0.e + 0);
        var4_5 = var3_4 == '\"';
        if (var4_5) {
            v1 = this;
            ++var2_3;
            var3_4 = v1.charAt(v1.e + 1);
        }
        if (var5_6 = var3_4 == '-') {
            v2 = this;
            var3_4 = v2.charAt(v2.e + var2_3++);
        }
        if (var3_4 >= '0' && var3_4 <= '9') {
            var6_7 = var3_4 - 48;
            while (true) {
                v3 = this;
                if ((var3_4 = v3.charAt(v3.e + var2_3++)) < '0' || var3_4 > '9') break;
                var6_7 = var6_7 * 10L + (long)(var3_4 - 48);
            }
            if (var3_4 == '.') {
                this.matchStat = -1;
                return 0L;
            }
            if (!(var6_7 >= 0L || var6_7 == -9223372036854775808L && var5_6 != false)) {
                v4 = this;
                var1_2 = v4.subString(v4.e, var2_3 - 1);
                throw new NumberFormatException(var1_2);
            }
        } else {
            if (var3_4 == 'n') {
                v5 = this;
                if (v5.charAt(v5.e + var2_3) == 'u') {
                    v6 = this;
                    if (v6.charAt(v6.e + var2_3 + 1) == 'l') {
                        v7 = this;
                        if (v7.charAt(v7.e + var2_3 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_3 += 3;
                            v8 = this;
                            var3_4 = v8.charAt(v8.e + var2_3++);
                            if (var4_5 && var3_4 == '\"') {
                                v9 = this;
                                var3_4 = v9.charAt(v9.e + var2_3++);
                            }
                            while (true) {
                                if (var3_4 == ',') {
                                    this.e += var2_3;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 16;
                                    return 0L;
                                }
                                if (var3_4 == ']') {
                                    this.e += var2_3;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 15;
                                    return 0L;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_4)) break;
                                v10 = this;
                                var3_4 = v10.charAt(v10.e + var2_3++);
                            }
                            this.matchStat = -1;
                            return 0L;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0L;
        }
        if (!var4_5) ** GOTO lbl71
        if (var3_4 != '\"') {
            this.matchStat = -1;
            return 0L;
        }
        do {
            v11 = this;
            var3_4 = v11.charAt(v11.e + var2_3++);
lbl71:
            // 2 sources

            if (var3_4 != var1_1) continue;
            this.e += var2_3;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            if (var5_6) {
                return -var6_7;
            }
            return var6_7;
        } while (JSONLexerBase.isWhitespace(var3_4));
        this.matchStat = -1;
        return var6_7;
    }

    /*
     * Unable to fully structure code
     */
    public final float scanFieldFloat(char[] var1_1) {
        block35: {
            block33: {
                block34: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(var1_1)) {
                        this.matchStat = -2;
                        return 0.0f;
                    }
                    var2_4 = var1_1.length;
                    v0 = this;
                    if ((var4_6 = (var3_5 = v0.charAt(v0.e + var2_4++)) == '\"' ? 1 : 0) != 0) {
                        v1 = this;
                        var3_5 = v1.charAt(v1.e + var2_4++);
                    }
                    if (var5_7 = var3_5 == '-') {
                        v2 = this;
                        var3_5 = v2.charAt(v2.e + var2_4++);
                    }
                    if (var3_5 < '0' || var3_5 > '9') break block33;
                    var7_8 = var3_5 - 48;
                    while (true) {
                        v3 = this;
                        if ((var3_5 = v3.charAt(v3.e + var2_4++)) < '0' || var3_5 > '9') break;
                        var7_8 = var7_8 * 10L + (long)(var3_5 - 48);
                    }
                    var9_9 = 1L;
                    if (var3_5 == '.') {
                        v4 = this;
                        if ((var3_5 = v4.charAt(v4.e + var2_4++)) >= '0' && var3_5 <= '9') {
                            var7_8 = var7_8 * 10L + (long)(var3_5 - 48);
                            var9_9 = 10L;
                            while (true) {
                                v5 = this;
                                if ((var3_5 = v5.charAt(v5.e + var2_4++)) >= '0' && var3_5 <= '9') {
                                    var7_8 = var7_8 * 10L + (long)(var3_5 - 48);
                                    var9_9 *= 10L;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                    if (!(var6_10 = var3_5 == 'e' || var3_5 == 'E')) break block34;
                    v6 = this;
                    if ((var3_5 = v6.charAt(v6.e + var2_4++)) != '+' && var3_5 != '-') ** GOTO lbl41
                    do {
                        v7 = this;
                        var3_5 = v7.charAt(v7.e + var2_4++);
lbl41:
                        // 2 sources

                    } while (var3_5 >= '0' && var3_5 <= '9');
                }
                if (var4_6 != 0) {
                    if (var3_5 != '\"') {
                        this.matchStat = -1;
                        return 0.0f;
                    }
                    v8 = this;
                    var3_5 = v8.charAt(v8.e + var2_4++);
                    var1_2 = this.e + var1_1.length + 1;
                    var4_6 = this.e + var2_4 - var1_2 - 2;
                } else {
                    var1_2 = this.e + var1_1.length;
                    var4_6 = this.e + var2_4 - var1_2 - 1;
                }
                if (!var6_10 && var4_6 < 17) {
                    var1_3 = (float)((double)var7_8 / (double)var9_9);
                    if (var5_7) {
                        var1_3 = -var1_3;
                    }
                } else {
                    var1_3 = Float.parseFloat(this.subString(var1_2, var4_6));
                }
                break block35;
            }
            if (var3_5 == 'n') {
                v9 = this;
                if (v9.charAt(v9.e + var2_4) == 'u') {
                    v10 = this;
                    if (v10.charAt(v10.e + var2_4 + 1) == 'l') {
                        v11 = this;
                        if (v11.charAt(v11.e + var2_4 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_4 += 3;
                            v12 = this;
                            var3_5 = v12.charAt(v12.e + var2_4++);
                            if (var4_6 != 0 && var3_5 == '\"') {
                                v13 = this;
                                var3_5 = v13.charAt(v13.e + var2_4++);
                            }
                            while (true) {
                                if (var3_5 == ',') {
                                    this.e += var2_4;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 16;
                                    return 0.0f;
                                }
                                if (var3_5 == '}') {
                                    this.e += var2_4;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 13;
                                    return 0.0f;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_5)) break;
                                v14 = this;
                                var3_5 = v14.charAt(v14.e + var2_4++);
                            }
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0.0f;
        }
        if (var3_5 == ',') {
            this.e += var2_4;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            return var1_3;
        }
        if (var3_5 != '}') ** GOTO lbl128
        v15 = this;
        if ((var3_5 = v15.charAt(v15.e + var2_4++)) == ',') {
            this.a = 16;
            this.e += var2_4;
            this.d = this.charAt(this.e);
        } else if (var3_5 == ']') {
            this.a = 15;
            this.e += var2_4;
            this.d = this.charAt(this.e);
        } else if (var3_5 == '}') {
            this.a = 13;
            this.e += var2_4;
            this.d = this.charAt(this.e);
        } else if (var3_5 == '\u001a') {
            this.e += var2_4 - 1;
            this.a = 20;
            this.d = (char)26;
        } else {
            this.matchStat = -1;
            return 0.0f;
lbl128:
            // 1 sources

            this.matchStat = -1;
            return 0.0f;
        }
        this.matchStat = 4;
        return var1_3;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final float scanFloat(char var1_1) {
        block26: {
            block24: {
                block25: {
                    this.matchStat = 0;
                    var2_2 = 0;
                    v0 = this;
                    ++var2_2;
                    var3_3 = v0.charAt(v0.e + 0);
                    var4_4 = var3_3 == '\"' ? 1 : 0;
                    if (var4_4 != 0) {
                        v1 = this;
                        ++var2_2;
                        var3_3 = v1.charAt(v1.e + 1);
                    }
                    if (var5_6 = var3_3 == '-') {
                        v2 = this;
                        var3_3 = v2.charAt(v2.e + var2_2++);
                    }
                    if (var3_3 < '0' || var3_3 > '9') break block24;
                    var7_7 = var3_3 - 48;
                    while (true) {
                        v3 = this;
                        if ((var3_3 = v3.charAt(v3.e + var2_2++)) < '0' || var3_3 > '9') break;
                        var7_7 = var7_7 * 10L + (long)(var3_3 - 48);
                    }
                    var9_8 = 1L;
                    if (var3_3 == '.') {
                        v4 = this;
                        if ((var3_3 = v4.charAt(v4.e + var2_2++)) >= '0' && var3_3 <= '9') {
                            var7_7 = var7_7 * 10L + (long)(var3_3 - 48);
                            var9_8 = 10L;
                            while (true) {
                                v5 = this;
                                if ((var3_3 = v5.charAt(v5.e + var2_2++)) >= '0' && var3_3 <= '9') {
                                    var7_7 = var7_7 * 10L + (long)(var3_3 - 48);
                                    var9_8 *= 10L;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                    if (!(var6_9 = var3_3 == 'e' || var3_3 == 'E')) break block25;
                    v6 = this;
                    if ((var3_3 = v6.charAt(v6.e + var2_2++)) != '+' && var3_3 != '-') ** GOTO lbl42
                    do {
                        v7 = this;
                        var3_3 = v7.charAt(v7.e + var2_2++);
lbl42:
                        // 2 sources

                    } while (var3_3 >= '0' && var3_3 <= '9');
                }
                if (var4_4 != 0) {
                    if (var3_3 != '\"') {
                        this.matchStat = -1;
                        return 0.0f;
                    }
                    v8 = this;
                    var3_3 = v8.charAt(v8.e + var2_2++);
                    var4_4 = this.e + 1;
                    var11_10 = this.e + var2_2 - var4_4 - 2;
                } else {
                    var4_4 = this.e;
                    var11_10 = this.e + var2_2 - var4_4 - 1;
                }
                if (!var6_9 && var11_10 < 17) {
                    var4_5 = (float)((double)var7_7 / (double)var9_8);
                    if (var5_6) {
                        var4_5 = -var4_5;
                    }
                } else {
                    var4_5 = Float.parseFloat(this.subString(var4_4, var11_10));
                }
                break block26;
            }
            if (var3_3 == 'n') {
                v9 = this;
                if (v9.charAt(v9.e + var2_2) == 'u') {
                    v10 = this;
                    if (v10.charAt(v10.e + var2_2 + 1) == 'l') {
                        v11 = this;
                        if (v11.charAt(v11.e + var2_2 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_2 += 3;
                            v12 = this;
                            var3_3 = v12.charAt(v12.e + var2_2++);
                            if (var4_4 != 0 && var3_3 == '\"') {
                                v13 = this;
                                var3_3 = v13.charAt(v13.e + var2_2++);
                            }
                            while (true) {
                                if (var3_3 == ',') {
                                    this.e += var2_2;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 16;
                                    return 0.0f;
                                }
                                if (var3_3 == ']') {
                                    this.e += var2_2;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 15;
                                    return 0.0f;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_3)) break;
                                v14 = this;
                                var3_3 = v14.charAt(v14.e + var2_2++);
                            }
                            this.matchStat = -1;
                            return 0.0f;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0.0f;
        }
        if (var3_3 == var1_1) {
            this.e += var2_2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            return var4_5;
        }
        this.matchStat = -1;
        return var4_5;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public double scanDouble(char var1_1) {
        block26: {
            block24: {
                block25: {
                    this.matchStat = 0;
                    var2_2 = 0;
                    v0 = this;
                    ++var2_2;
                    var3_3 = v0.charAt(v0.e + 0);
                    var4_4 = var3_3 == '\"' ? 1 : 0;
                    if (var4_4 != 0) {
                        v1 = this;
                        ++var2_2;
                        var3_3 = v1.charAt(v1.e + 1);
                    }
                    if (var5_5 = var3_3 == '-') {
                        v2 = this;
                        var3_3 = v2.charAt(v2.e + var2_2++);
                    }
                    if (var3_3 < '0' || var3_3 > '9') break block24;
                    var8_6 = var3_3 - 48;
                    while (true) {
                        v3 = this;
                        if ((var3_3 = v3.charAt(v3.e + var2_2++)) < '0' || var3_3 > '9') break;
                        var8_6 = var8_6 * 10L + (long)(var3_3 - 48);
                    }
                    var10_7 = 1L;
                    if (var3_3 == '.') {
                        v4 = this;
                        if ((var3_3 = v4.charAt(v4.e + var2_2++)) >= '0' && var3_3 <= '9') {
                            var8_6 = var8_6 * 10L + (long)(var3_3 - 48);
                            var10_7 = 10L;
                            while (true) {
                                v5 = this;
                                if ((var3_3 = v5.charAt(v5.e + var2_2++)) >= '0' && var3_3 <= '9') {
                                    var8_6 = var8_6 * 10L + (long)(var3_3 - 48);
                                    var10_7 *= 10L;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    if (!(var6_8 = var3_3 == 'e' || var3_3 == 'E')) break block25;
                    v6 = this;
                    if ((var3_3 = v6.charAt(v6.e + var2_2++)) != '+' && var3_3 != '-') ** GOTO lbl42
                    do {
                        v7 = this;
                        var3_3 = v7.charAt(v7.e + var2_2++);
lbl42:
                        // 2 sources

                    } while (var3_3 >= '0' && var3_3 <= '9');
                }
                if (var4_4 != 0) {
                    if (var3_3 != '\"') {
                        this.matchStat = -1;
                        return 0.0;
                    }
                    v8 = this;
                    var3_3 = v8.charAt(v8.e + var2_2++);
                    var4_4 = this.e + 1;
                    var7_10 = this.e + var2_2 - var4_4 - 2;
                } else {
                    var4_4 = this.e;
                    var7_10 = this.e + var2_2 - var4_4 - 1;
                }
                if (!var6_8 && var7_10 < 17) {
                    var6_9 = (double)var8_6 / (double)var10_7;
                    if (var5_5) {
                        var6_9 = -var6_9;
                    }
                } else {
                    var6_9 = Double.parseDouble(this.subString(var4_4, var7_10));
                }
                break block26;
            }
            if (var3_3 == 'n') {
                v9 = this;
                if (v9.charAt(v9.e + var2_2) == 'u') {
                    v10 = this;
                    if (v10.charAt(v10.e + var2_2 + 1) == 'l') {
                        v11 = this;
                        if (v11.charAt(v11.e + var2_2 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_2 += 3;
                            v12 = this;
                            var3_3 = v12.charAt(v12.e + var2_2++);
                            if (var4_4 != 0 && var3_3 == '\"') {
                                v13 = this;
                                var3_3 = v13.charAt(v13.e + var2_2++);
                            }
                            while (true) {
                                if (var3_3 == ',') {
                                    this.e += var2_2;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 16;
                                    return 0.0;
                                }
                                if (var3_3 == ']') {
                                    this.e += var2_2;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 15;
                                    return 0.0;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_3)) break;
                                v14 = this;
                                var3_3 = v14.charAt(v14.e + var2_2++);
                            }
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0.0;
        }
        if (var3_3 == var1_1) {
            this.e += var2_2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            return var6_9;
        }
        this.matchStat = -1;
        return var6_9;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public BigDecimal scanDecimal(char var1_1) {
        block32: {
            block30: {
                block31: {
                    this.matchStat = 0;
                    var1_1 = '\u0000';
                    v0 = this;
                    var1_1 = (char)(var1_1 + 1);
                    var2_2 = v0.charAt(v0.e + 0);
                    var3_3 = var2_2 == '\"' ? 1 : 0;
                    if (var3_3 != 0) {
                        v1 = this;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v1.charAt(v1.e + 1);
                    }
                    if (var2_2 == '-') {
                        v2 = this;
                        v3 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v2.charAt(v2.e + v3);
                    }
                    if (var2_2 < '0' || var2_2 > '9') break block30;
                    do {
                        v4 = this;
                        v5 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                    } while ((var2_2 = v4.charAt(v4.e + v5)) >= '0' && var2_2 <= '9');
                    if (var2_2 == '.') {
                        v6 = this;
                        v7 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v6.charAt(v6.e + v7);
                        if (var2_2 >= '0' && var2_2 <= '9') {
                            while (true) {
                                v8 = this;
                                v9 = var1_1;
                                var1_1 = (char)(var1_1 + 1);
                                var2_2 = v8.charAt(v8.e + v9);
                                if (var2_2 >= '0' && var2_2 <= '9') {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return null;
                        }
                    }
                    if (!(var2_2 == 'e' || var2_2 == 'E')) break block31;
                    v10 = this;
                    v11 = var1_1;
                    var1_1 = (char)(var1_1 + 1);
                    var2_2 = v10.charAt(v10.e + v11);
                    if (var2_2 != '+' && var2_2 != '-') ** GOTO lbl49
                    do {
                        v12 = this;
                        v13 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v12.charAt(v12.e + v13);
lbl49:
                        // 2 sources

                    } while (var2_2 >= '0' && var2_2 <= '9');
                }
                if (var3_3 != 0) {
                    if (var2_2 != '\"') {
                        this.matchStat = -1;
                        return null;
                    }
                    v14 = this;
                    v15 = var1_1;
                    var1_1 = (char)(var1_1 + 1);
                    var2_2 = v14.charAt(v14.e + v15);
                    var3_3 = this.e + 1;
                    var4_5 = this.e + var1_1 - var3_3 - 2;
                } else {
                    var3_3 = this.e;
                    var4_5 = this.e + var1_1 - var3_3 - 1;
                }
                if (var4_5 > 65535) {
                    throw new JSONException("decimal overflow");
                }
                break block32;
            }
            if (var2_2 == 'n') {
                v16 = this;
                if (v16.charAt(v16.e + var1_1) == 'u') {
                    v17 = this;
                    if (v17.charAt(v17.e + var1_1 + 1) == 'l') {
                        v18 = this;
                        if (v18.charAt(v18.e + var1_1 + 2) == 'l') {
                            this.matchStat = 5;
                            var1_1 = (char)(var1_1 + 3);
                            v19 = this;
                            v20 = var1_1;
                            var1_1 = (char)(var1_1 + 1);
                            var2_2 = v19.charAt(v19.e + v20);
                            if (var3_3 != 0 && var2_2 == '\"') {
                                v21 = this;
                                v22 = var1_1;
                                var1_1 = (char)(var1_1 + 1);
                                var2_2 = v21.charAt(v21.e + v22);
                            }
                            while (true) {
                                if (var2_2 == ',') {
                                    this.e += var1_1;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 16;
                                    return null;
                                }
                                if (var2_2 == '}') {
                                    this.e += var1_1;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 13;
                                    return null;
                                }
                                if (!JSONLexerBase.isWhitespace(var2_2)) break;
                                v23 = this;
                                v24 = var1_1;
                                var1_1 = (char)(var1_1 + 1);
                                var2_2 = v23.charAt(v23.e + v24);
                            }
                            this.matchStat = -1;
                            return null;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return null;
        }
        var3_4 /* !! */  = this.sub_chars(var3_3, var4_5);
        var3_4 /* !! */  = (char[])new BigDecimal(var3_4 /* !! */ , 0, var3_4 /* !! */ .length, MathContext.UNLIMITED);
        if (var2_2 == ',') {
            this.e += var1_1;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            return var3_4 /* !! */ ;
        }
        if (var2_2 != ']') ** GOTO lbl145
        v25 = this;
        v26 = var1_1;
        var1_1 = (char)(var1_1 + 1);
        var2_2 = v25.charAt(v25.e + v26);
        if (var2_2 == ',') {
            this.a = 16;
            this.e += var1_1;
            this.d = this.charAt(this.e);
        } else if (var2_2 == ']') {
            this.a = 15;
            this.e += var1_1;
            this.d = this.charAt(this.e);
        } else if (var2_2 == '}') {
            this.a = 13;
            this.e += var1_1;
            this.d = this.charAt(this.e);
        } else if (var2_2 == '\u001a') {
            this.a = 20;
            this.e += var1_1 - '\u0001';
            this.d = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl145:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var3_4 /* !! */ ;
    }

    /*
     * Unable to fully structure code
     */
    public final float[] scanFieldFloatArray(char[] var1_1) {
        block28: {
            block26: {
                this.matchStat = 0;
                if (!this.charArrayCompare(var1_1)) {
                    this.matchStat = -2;
                    return null;
                }
                var1_2 = var1_1.length;
                v0 = this;
                if (v0.charAt(v0.e + var1_2++) != '[') {
                    this.matchStat = -2;
                    return null;
                }
                v1 = this;
                var2_3 = v1.charAt(v1.e + var1_2++);
                var3_4 = new float[16];
                var4_5 = 0;
                while (true) {
                    block27: {
                        var5_7 = this.e + var1_2 - 1;
                        var6_9 = var2_3 == '-';
                        if (var6_9) {
                            v2 = this;
                            var2_3 = v2.charAt(v2.e + var1_2++);
                        }
                        if (var2_3 < '0' || var2_3 > '9') break block26;
                        var7_11 = var2_3 - 48;
                        while (true) {
                            v3 = this;
                            if ((var2_3 = v3.charAt(v3.e + var1_2++)) < '0' || var2_3 > '9') break;
                            var7_11 = var7_11 * 10 + (var2_3 - 48);
                        }
                        var8_12 = 1;
                        if (var2_3 == '.') {
                            v4 = this;
                            var2_3 = v4.charAt(v4.e + var1_2++);
                            var8_12 = 10;
                            if (var2_3 >= '0' && var2_3 <= '9') {
                                var7_11 = var7_11 * 10 + (var2_3 - 48);
                                while (true) {
                                    v5 = this;
                                    if ((var2_3 = v5.charAt(v5.e + var1_2++)) >= '0' && var2_3 <= '9') {
                                        var7_11 = var7_11 * 10 + (var2_3 - 48);
                                        var8_12 *= 10;
                                        continue;
                                    }
                                    break;
                                }
                            } else {
                                this.matchStat = -1;
                                return null;
                            }
                        }
                        if (!(var9_13 = var2_3 == 'e' || var2_3 == 'E')) break block27;
                        v6 = this;
                        if ((var2_3 = v6.charAt(v6.e + var1_2++)) != '+' && var2_3 != '-') ** GOTO lbl49
                        do {
                            v7 = this;
                            var2_3 = v7.charAt(v7.e + var1_2++);
lbl49:
                            // 2 sources

                        } while (var2_3 >= '0' && var2_3 <= '9');
                    }
                    var10_14 = this.e + var1_2 - var5_7 - 1;
                    if (!var9_13 && var10_14 < 10) {
                        var5_6 = (float)var7_11 / (float)var8_12;
                        if (var6_9) {
                            var5_6 = -var5_6;
                        }
                    } else {
                        var5_6 = Float.parseFloat(this.subString(var5_7, var10_14));
                    }
                    if (var4_5 >= var3_4.length) {
                        var6_10 = new float[var3_4.length * 3 / 2];
                        System.arraycopy(var3_4, 0, var6_10, 0, var4_5);
                        var3_4 = var6_10;
                    }
                    var3_4[var4_5++] = var5_6;
                    if (var2_3 == ',') {
                        v8 = this;
                        var2_3 = v8.charAt(v8.e + var1_2++);
                        continue;
                    }
                    if (var2_3 == ']') break;
                }
                break block28;
            }
            this.matchStat = -1;
            return null;
        }
        v9 = this;
        var2_3 = v9.charAt(v9.e + var1_2++);
        if (var4_5 != var3_4.length) {
            var5_8 = new float[var4_5];
            System.arraycopy(var3_4, 0, var5_8, 0, var4_5);
            var3_4 = var5_8;
        }
        if (var2_3 == ',') {
            this.e += var1_2 - 1;
            this.next();
            this.matchStat = 3;
            this.a = 16;
            return var3_4;
        }
        if (var2_3 != '}') ** GOTO lbl114
        v10 = this;
        if ((var2_3 = v10.charAt(v10.e + var1_2++)) == ',') {
            this.a = 16;
            this.e += var1_2 - 1;
            this.next();
        } else if (var2_3 == ']') {
            this.a = 15;
            this.e += var1_2 - 1;
            this.next();
        } else if (var2_3 == '}') {
            this.a = 13;
            this.e += var1_2 - 1;
            this.next();
        } else if (var2_3 == '\u001a') {
            this.e += var1_2 - 1;
            this.a = 20;
            this.d = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl114:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var3_4;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final float[][] scanFieldFloatArray2(char[] var1_1) {
        this.matchStat = 0;
        if (!this.charArrayCompare(var1_1)) {
            this.matchStat = -2;
            return null;
        }
        var1_2 = var1_1.length;
        v0 = this;
        if (v0.charAt(v0.e + var1_2++) != '[') {
            this.matchStat = -2;
            return null;
        }
        v1 = this;
        var2_3 = v1.charAt(v1.e + var1_2++);
        var3_4 = new float[16][];
        var4_5 = 0;
        while (var2_3 == '[') {
            block32: {
                block30: {
                    v2 = this;
                    var2_3 = v2.charAt(v2.e + var1_2++);
                    var5_6 /* !! */  = (float[][])new float[16];
                    var6_7 = 0;
                    while (true) {
                        block31: {
                            var7_8 = this.e + var1_2 - 1;
                            var8_12 = var2_3 == '-';
                            if (var8_12) {
                                v3 = this;
                                var2_3 = v3.charAt(v3.e + var1_2++);
                            }
                            if (var2_3 < '0' || var2_3 > '9') break block30;
                            var9_14 = var2_3 - 48;
                            while (true) {
                                v4 = this;
                                if ((var2_3 = v4.charAt(v4.e + var1_2++)) < '0' || var2_3 > '9') break;
                                var9_14 = var9_14 * 10 + (var2_3 - 48);
                            }
                            var10_15 = 1;
                            if (var2_3 == '.') {
                                v5 = this;
                                if ((var2_3 = v5.charAt(v5.e + var1_2++)) >= '0' && var2_3 <= '9') {
                                    var9_14 = var9_14 * 10 + (var2_3 - 48);
                                    var10_15 = 10;
                                    while (true) {
                                        v6 = this;
                                        if ((var2_3 = v6.charAt(v6.e + var1_2++)) >= '0' && var2_3 <= '9') {
                                            var9_14 = var9_14 * 10 + (var2_3 - 48);
                                            var10_15 *= 10;
                                            continue;
                                        }
                                        break;
                                    }
                                } else {
                                    this.matchStat = -1;
                                    return null;
                                }
                            }
                            if (!(var11_16 = var2_3 == 'e' || var2_3 == 'E')) break block31;
                            v7 = this;
                            if ((var2_3 = v7.charAt(v7.e + var1_2++)) != '+' && var2_3 != '-') ** GOTO lbl53
                            do {
                                v8 = this;
                                var2_3 = v8.charAt(v8.e + var1_2++);
lbl53:
                                // 2 sources

                            } while (var2_3 >= '0' && var2_3 <= '9');
                        }
                        var12_17 = this.e + var1_2 - var7_8 - 1;
                        if (!var11_16 && var12_17 < 10) {
                            var7_9 = (float)var9_14 / (float)var10_15;
                            if (var8_12) {
                                var7_9 = -var7_9;
                            }
                        } else {
                            var7_9 = Float.parseFloat(this.subString(var7_8, var12_17));
                        }
                        if (var6_7 >= var5_6 /* !! */ .length) {
                            var8_13 = new float[var5_6 /* !! */ .length * 3 / 2];
                            System.arraycopy(var5_6 /* !! */ , 0, var8_13, 0, var6_7);
                            var5_6 /* !! */  = (float[][])var8_13;
                        }
                        var5_6 /* !! */ [var6_7++] = (float[])var7_9;
                        if (var2_3 == ',') {
                            v9 = this;
                            var2_3 = v9.charAt(v9.e + var1_2++);
                            continue;
                        }
                        if (var2_3 == ']') break;
                    }
                    break block32;
                }
                this.matchStat = -1;
                return null;
            }
            v10 = this;
            var2_3 = v10.charAt(v10.e + var1_2++);
            if (var6_7 != var5_6 /* !! */ .length) {
                var7_10 = new float[var6_7];
                System.arraycopy(var5_6 /* !! */ , 0, var7_10, 0, var6_7);
                var5_6 /* !! */  = (float[][])var7_10;
            }
            if (var4_5 >= var3_4.length) {
                var7_11 = new float[var3_4.length * 3 / 2][];
                System.arraycopy(var5_6 /* !! */ , 0, var7_11, 0, var6_7);
                var3_4 = var7_11;
            }
            var3_4[var4_5++] = (float[])var5_6 /* !! */ ;
            if (var2_3 == ',') {
                v11 = this;
                var2_3 = v11.charAt(v11.e + var1_2++);
                continue;
            }
            if (var2_3 != ']') continue;
            v12 = this;
            var2_3 = v12.charAt(v12.e + var1_2++);
            break;
        }
        if (var4_5 != var3_4.length) {
            var5_6 /* !! */  = new float[var4_5][];
            System.arraycopy(var3_4, 0, var5_6 /* !! */ , 0, var4_5);
            var3_4 = var5_6 /* !! */ ;
        }
        if (var2_3 == ',') {
            this.e += var1_2 - 1;
            this.next();
            this.matchStat = 3;
            this.a = 16;
            return var3_4;
        }
        if (var2_3 != '}') ** GOTO lbl135
        v13 = this;
        if ((var2_3 = v13.charAt(v13.e + var1_2++)) == ',') {
            this.a = 16;
            this.e += var1_2 - 1;
            this.next();
        } else if (var2_3 == ']') {
            this.a = 15;
            this.e += var1_2 - 1;
            this.next();
        } else if (var2_3 == '}') {
            this.a = 13;
            this.e += var1_2 - 1;
            this.next();
        } else if (var2_3 == '\u001a') {
            this.e += var1_2 - 1;
            this.a = 20;
            this.d = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl135:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var3_4;
    }

    /*
     * Unable to fully structure code
     */
    public final double scanFieldDouble(char[] var1_1) {
        block35: {
            block33: {
                block34: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(var1_1)) {
                        this.matchStat = -2;
                        return 0.0;
                    }
                    var2_3 = var1_1.length;
                    v0 = this;
                    if ((var4_5 = (var3_4 = v0.charAt(v0.e + var2_3++)) == '\"' ? 1 : 0) != 0) {
                        v1 = this;
                        var3_4 = v1.charAt(v1.e + var2_3++);
                    }
                    if (var5_6 = var3_4 == '-') {
                        v2 = this;
                        var3_4 = v2.charAt(v2.e + var2_3++);
                    }
                    if (var3_4 < '0' || var3_4 > '9') break block33;
                    var8_7 = var3_4 - 48;
                    while (true) {
                        v3 = this;
                        if ((var3_4 = v3.charAt(v3.e + var2_3++)) < '0' || var3_4 > '9') break;
                        var8_7 = var8_7 * 10L + (long)(var3_4 - 48);
                    }
                    var10_8 = 1L;
                    if (var3_4 == '.') {
                        v4 = this;
                        if ((var3_4 = v4.charAt(v4.e + var2_3++)) >= '0' && var3_4 <= '9') {
                            var8_7 = var8_7 * 10L + (long)(var3_4 - 48);
                            var10_8 = 10L;
                            while (true) {
                                v5 = this;
                                if ((var3_4 = v5.charAt(v5.e + var2_3++)) >= '0' && var3_4 <= '9') {
                                    var8_7 = var8_7 * 10L + (long)(var3_4 - 48);
                                    var10_8 *= 10L;
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                    if (!(var6_9 = var3_4 == 'e' || var3_4 == 'E')) break block34;
                    v6 = this;
                    if ((var3_4 = v6.charAt(v6.e + var2_3++)) != '+' && var3_4 != '-') ** GOTO lbl41
                    do {
                        v7 = this;
                        var3_4 = v7.charAt(v7.e + var2_3++);
lbl41:
                        // 2 sources

                    } while (var3_4 >= '0' && var3_4 <= '9');
                }
                if (var4_5 != 0) {
                    if (var3_4 != '\"') {
                        this.matchStat = -1;
                        return 0.0;
                    }
                    v8 = this;
                    var3_4 = v8.charAt(v8.e + var2_3++);
                    var1_2 = this.e + var1_1.length + 1;
                    var4_5 = this.e + var2_3 - var1_2 - 2;
                } else {
                    var1_2 = this.e + var1_1.length;
                    var4_5 = this.e + var2_3 - var1_2 - 1;
                }
                if (!var6_9 && var4_5 < 17) {
                    var6_10 = (double)var8_7 / (double)var10_8;
                    if (var5_6) {
                        var6_10 = -var6_10;
                    }
                } else {
                    var6_10 = Double.parseDouble(this.subString(var1_2, var4_5));
                }
                break block35;
            }
            if (var3_4 == 'n') {
                v9 = this;
                if (v9.charAt(v9.e + var2_3) == 'u') {
                    v10 = this;
                    if (v10.charAt(v10.e + var2_3 + 1) == 'l') {
                        v11 = this;
                        if (v11.charAt(v11.e + var2_3 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_3 += 3;
                            v12 = this;
                            var3_4 = v12.charAt(v12.e + var2_3++);
                            if (var4_5 != 0 && var3_4 == '\"') {
                                v13 = this;
                                var3_4 = v13.charAt(v13.e + var2_3++);
                            }
                            while (true) {
                                if (var3_4 == ',') {
                                    this.e += var2_3;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 16;
                                    return 0.0;
                                }
                                if (var3_4 == '}') {
                                    this.e += var2_3;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 13;
                                    return 0.0;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_4)) break;
                                v14 = this;
                                var3_4 = v14.charAt(v14.e + var2_3++);
                            }
                            this.matchStat = -1;
                            return 0.0;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return 0.0;
        }
        if (var3_4 == ',') {
            this.e += var2_3;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            return var6_10;
        }
        if (var3_4 != '}') ** GOTO lbl128
        v15 = this;
        if ((var3_4 = v15.charAt(v15.e + var2_3++)) == ',') {
            this.a = 16;
            this.e += var2_3;
            this.d = this.charAt(this.e);
        } else if (var3_4 == ']') {
            this.a = 15;
            this.e += var2_3;
            this.d = this.charAt(this.e);
        } else if (var3_4 == '}') {
            this.a = 13;
            this.e += var2_3;
            this.d = this.charAt(this.e);
        } else if (var3_4 == '\u001a') {
            this.a = 20;
            this.e += var2_3 - 1;
            this.d = (char)26;
        } else {
            this.matchStat = -1;
            return 0.0;
lbl128:
            // 1 sources

            this.matchStat = -1;
            return 0.0;
        }
        this.matchStat = 4;
        return var6_10;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public BigDecimal scanFieldDecimal(char[] var1_1) {
        block33: {
            block31: {
                block32: {
                    this.matchStat = 0;
                    if (!this.charArrayCompare(var1_1)) {
                        this.matchStat = -2;
                        return null;
                    }
                    var2_4 = var1_1.length;
                    v0 = this;
                    if ((var4_6 = (var3_5 = v0.charAt(v0.e + var2_4++)) == '\"' ? 1 : 0) != 0) {
                        v1 = this;
                        var3_5 = v1.charAt(v1.e + var2_4++);
                    }
                    if (var3_5 == '-') {
                        v2 = this;
                        var3_5 = v2.charAt(v2.e + var2_4++);
                    }
                    if (var3_5 < '0' || var3_5 > '9') break block31;
                    do {
                        v3 = this;
                    } while ((var3_5 = v3.charAt(v3.e + var2_4++)) >= '0' && var3_5 <= '9');
                    if (var3_5 == '.') {
                        v4 = this;
                        if ((var3_5 = v4.charAt(v4.e + var2_4++)) >= '0' && var3_5 <= '9') {
                            while (true) {
                                v5 = this;
                                if ((var3_5 = v5.charAt(v5.e + var2_4++)) >= '0' && var3_5 <= '9') {
                                    continue;
                                }
                                break;
                            }
                        } else {
                            this.matchStat = -1;
                            return null;
                        }
                    }
                    if (!(var3_5 == 'e' || var3_5 == 'E')) break block32;
                    v6 = this;
                    if ((var3_5 = v6.charAt(v6.e + var2_4++)) != '+' && var3_5 != '-') ** GOTO lbl33
                    do {
                        v7 = this;
                        var3_5 = v7.charAt(v7.e + var2_4++);
lbl33:
                        // 2 sources

                    } while (var3_5 >= '0' && var3_5 <= '9');
                }
                if (var4_6 != 0) {
                    if (var3_5 != '\"') {
                        this.matchStat = -1;
                        return null;
                    }
                    v8 = this;
                    var3_5 = v8.charAt(v8.e + var2_4++);
                    var1_2 = this.e + var1_1.length + 1;
                    var4_6 = this.e + var2_4 - var1_2 - 2;
                } else {
                    var1_2 = this.e + var1_1.length;
                    var4_6 = this.e + var2_4 - var1_2 - 1;
                }
                if (var4_6 > 65535) {
                    throw new JSONException("scan decimal overflow");
                }
                break block33;
            }
            if (var3_5 == 'n') {
                v9 = this;
                if (v9.charAt(v9.e + var2_4) == 'u') {
                    v10 = this;
                    if (v10.charAt(v10.e + var2_4 + 1) == 'l') {
                        v11 = this;
                        if (v11.charAt(v11.e + var2_4 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_4 += 3;
                            v12 = this;
                            var3_5 = v12.charAt(v12.e + var2_4++);
                            if (var4_6 != 0 && var3_5 == '\"') {
                                v13 = this;
                                var3_5 = v13.charAt(v13.e + var2_4++);
                            }
                            while (true) {
                                if (var3_5 == ',') {
                                    this.e += var2_4;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 16;
                                    return null;
                                }
                                if (var3_5 == '}') {
                                    this.e += var2_4;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 13;
                                    return null;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_5)) break;
                                v14 = this;
                                var3_5 = v14.charAt(v14.e + var2_4++);
                            }
                            this.matchStat = -1;
                            return null;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return null;
        }
        var1_3 /* !! */  = this.sub_chars(var1_2, var4_6);
        var1_3 /* !! */  = (char[])new BigDecimal(var1_3 /* !! */ , 0, var1_3 /* !! */ .length, MathContext.UNLIMITED);
        if (var3_5 == ',') {
            this.e += var2_4;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            return var1_3 /* !! */ ;
        }
        if (var3_5 != '}') ** GOTO lbl118
        v15 = this;
        if ((var3_5 = v15.charAt(v15.e + var2_4++)) == ',') {
            this.a = 16;
            this.e += var2_4;
            this.d = this.charAt(this.e);
        } else if (var3_5 == ']') {
            this.a = 15;
            this.e += var2_4;
            this.d = this.charAt(this.e);
        } else if (var3_5 == '}') {
            this.a = 13;
            this.e += var2_4;
            this.d = this.charAt(this.e);
        } else if (var3_5 == '\u001a') {
            this.a = 20;
            this.e += var2_4 - 1;
            this.d = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl118:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var1_3 /* !! */ ;
    }

    /*
     * Unable to fully structure code
     */
    public BigInteger scanFieldBigInteger(char[] var1_1) {
        this.matchStat = 0;
        if (!this.charArrayCompare(var1_1)) {
            this.matchStat = -2;
            return null;
        }
        var2_4 = var1_1.length;
        v0 = this;
        if ((var4_6 = (var3_5 = v0.charAt(v0.e + var2_4++)) == '\"' ? 1 : 0) != 0) {
            v1 = this;
            var3_5 = v1.charAt(v1.e + var2_4++);
        }
        if (var5_7 = var3_5 == '-') {
            v2 = this;
            var3_5 = v2.charAt(v2.e + var2_4++);
        }
        if (var3_5 >= '0' && var3_5 <= '9') {
            var7_8 = var3_5 - 48;
            var6_9 = false;
            while (true) {
                v3 = this;
                if ((var3_5 = v3.charAt(v3.e + var2_4++)) < '0' || var3_5 > '9') break;
                var9_10 = var7_8 * 10L + (long)(var3_5 - 48);
                if (var9_10 < var7_8) {
                    var6_9 = true;
                    break;
                }
                var7_8 = var9_10;
            }
            if (var4_6 != 0) {
                if (var3_5 != '\"') {
                    this.matchStat = -1;
                    return null;
                }
                v4 = this;
                var3_5 = v4.charAt(v4.e + var2_4++);
                var1_2 = this.e + var1_1.length + 1;
                var4_6 = this.e + var2_4 - var1_2 - 2;
            } else {
                var1_2 = this.e + var1_1.length;
                var4_6 = this.e + var2_4 - var1_2 - 1;
            }
            if (!var6_9 && (var4_6 < 20 || var5_7 && var4_6 < 21)) {
                var1_3 = BigInteger.valueOf(var5_7 != false ? -var7_8 : var7_8);
            } else {
                if (var4_6 > 65535) {
                    throw new JSONException("scanInteger overflow");
                }
                var1_3 = this.subString(var1_2, var4_6);
                var1_3 = new BigInteger((String)var1_3, 10);
            }
        } else {
            if (var3_5 == 'n') {
                v5 = this;
                if (v5.charAt(v5.e + var2_4) == 'u') {
                    v6 = this;
                    if (v6.charAt(v6.e + var2_4 + 1) == 'l') {
                        v7 = this;
                        if (v7.charAt(v7.e + var2_4 + 2) == 'l') {
                            this.matchStat = 5;
                            var2_4 += 3;
                            v8 = this;
                            var3_5 = v8.charAt(v8.e + var2_4++);
                            if (var4_6 != 0 && var3_5 == '\"') {
                                v9 = this;
                                var3_5 = v9.charAt(v9.e + var2_4++);
                            }
                            while (true) {
                                if (var3_5 == ',') {
                                    this.e += var2_4;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 16;
                                    return null;
                                }
                                if (var3_5 == '}') {
                                    this.e += var2_4;
                                    this.d = this.charAt(this.e);
                                    this.matchStat = 5;
                                    this.a = 13;
                                    return null;
                                }
                                if (!JSONLexerBase.isWhitespace(var3_5)) break;
                                v10 = this;
                                var3_5 = v10.charAt(v10.e + var2_4++);
                            }
                            this.matchStat = -1;
                            return null;
                        }
                    }
                }
            }
            this.matchStat = -1;
            return null;
        }
        if (var3_5 == ',') {
            this.e += var2_4;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            return var1_3;
        }
        if (var3_5 != '}') ** GOTO lbl109
        v11 = this;
        if ((var3_5 = v11.charAt(v11.e + var2_4++)) == ',') {
            this.a = 16;
            this.e += var2_4;
            this.d = this.charAt(this.e);
        } else if (var3_5 == ']') {
            this.a = 15;
            this.e += var2_4;
            this.d = this.charAt(this.e);
        } else if (var3_5 == '}') {
            this.a = 13;
            this.e += var2_4;
            this.d = this.charAt(this.e);
        } else if (var3_5 == '\u001a') {
            this.a = 20;
            this.e += var2_4 - 1;
            this.d = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl109:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var1_3;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Date scanFieldDate(char[] object) {
        void var1_5;
        char c2;
        int n2;
        block24: {
            Object object2;
            int n3;
            block26: {
                int n4;
                int n5;
                block27: {
                    block25: {
                        this.matchStat = 0;
                        if (!this.charArrayCompare((char[])object)) {
                            this.matchStat = -2;
                            return null;
                        }
                        n2 = ((char[])object).length;
                        JSONLexerBase jSONLexerBase = this;
                        if ((c2 = jSONLexerBase.charAt(jSONLexerBase.e + n2++)) != '\"') break block25;
                        n5 = this.e + ((char[])object).length + 1;
                        n3 = this.indexOf('\"', n5);
                        if (n3 == -1) {
                            throw new JSONException("unclosed str");
                        }
                        int n6 = this.e + ((char[])object).length + 1;
                        object2 = this.subString(n6, n3 - n6);
                        if (((String)object2).indexOf(92) == -1) break block26;
                        break block27;
                    }
                    if (c2 == '-' || c2 >= '0' && c2 <= '9') {
                        long l2 = 0L;
                        boolean bl = false;
                        if (c2 == '-') {
                            JSONLexerBase jSONLexerBase = this;
                            c2 = jSONLexerBase.charAt(jSONLexerBase.e + n2++);
                            bl = true;
                        }
                        if (c2 >= '0' && c2 <= '9') {
                            l2 = c2 - 48;
                            while (true) {
                                JSONLexerBase jSONLexerBase = this;
                                if ((c2 = jSONLexerBase.charAt(jSONLexerBase.e + n2++)) < '0' || c2 > '9') break;
                                l2 = l2 * 10L + (long)(c2 - 48);
                            }
                        }
                        if (l2 < 0L) {
                            this.matchStat = -1;
                            return null;
                        }
                        if (bl) {
                            l2 = -l2;
                        }
                        Date date = new Date(l2);
                        break block24;
                    } else {
                        this.matchStat = -1;
                        return null;
                    }
                }
                while (true) {
                    n4 = 0;
                    for (n5 = n3 - 1; n5 >= 0 && this.charAt(n5) == '\\'; ++n4, --n5) {
                    }
                    if (n4 % 2 == 0) break;
                    n3 = this.indexOf('\"', n3 + 1);
                }
                n4 = n3 - (this.e + ((char[])object).length + 1);
                JSONLexerBase jSONLexerBase = this;
                object2 = JSONLexerBase.readString(jSONLexerBase.sub_chars(jSONLexerBase.e + ((char[])object).length + 1, n4), n4);
            }
            n2 += n3 - (this.e + ((char[])object).length + 1) + 1;
            JSONLexerBase jSONLexerBase = this;
            c2 = jSONLexerBase.charAt(jSONLexerBase.e + n2++);
            object2 = new JSONScanner((String)object2);
            try {
                if (!((JSONScanner)object2).scanISO8601DateIfMatch(false)) {
                    this.matchStat = -1;
                    return null;
                }
                Date date = ((JSONLexerBase)object2).getCalendar().getTime();
            }
            finally {
                ((JSONLexerBase)object2).close();
            }
        }
        if (c2 == ',') {
            this.e += n2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return var1_5;
        }
        if (c2 != '}') {
            this.matchStat = -1;
            return null;
        }
        JSONLexerBase jSONLexerBase = this;
        if ((c2 = jSONLexerBase.charAt(jSONLexerBase.e + n2++)) == ',') {
            this.a = 16;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == ']') {
            this.a = 15;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else if (c2 == '}') {
            this.a = 13;
            this.e += n2;
            this.d = this.charAt(this.e);
        } else {
            if (c2 != '\u001a') {
                this.matchStat = -1;
                return null;
            }
            this.a = 20;
            this.e += n2 - 1;
            this.d = (char)26;
        }
        this.matchStat = 4;
        return var1_5;
    }

    /*
     * Unable to fully structure code
     */
    public Date scanDate(char var1_1) {
        block25: {
            block26: {
                this.matchStat = 0;
                var1_1 = '\u0000';
                v0 = this;
                var1_1 = (char)(var1_1 + 1);
                var2_3 = v0.charAt(v0.e + 0);
                if (var2_3 == '\"') {
                    var5_4 = this.e + 1;
                    var6_6 = this.indexOf('\"', var5_4);
                    if (var6_6 == -1) {
                        throw new JSONException("unclosed str");
                    }
                    var3_7 = this.e + 1;
                    var3_8 = this.subString(var3_7, var6_6 - var3_7);
                    if (var3_8.indexOf(92) != -1) {
                        while (true) {
                            var4_11 = 0;
                            for (var3_9 = var6_6 - 1; var3_9 >= 0 && this.charAt(var3_9) == '\\'; --var3_9) {
                                ++var4_11;
                            }
                            if (var4_11 % 2 == 0) break;
                            var6_6 = this.indexOf('\"', var6_6 + 1);
                        }
                        var4_11 = var6_6 - (this.e + 1);
                        v1 = this;
                        var3_8 = JSONLexerBase.readString(v1.sub_chars(v1.e + 1, var4_11), var4_11);
                    }
                    var1_1 = (char)(1 + (var6_6 - (this.e + 1) + 1));
                    v2 = this;
                    v3 = var1_1;
                    var1_1 = (char)(var1_1 + 1);
                    var2_3 = v2.charAt(v2.e + v3);
                    var4_12 = new JSONScanner((String)var3_8);
                    try {
                        if (var4_12.scanISO8601DateIfMatch(false)) {
                            var3_8 = var4_12.getCalendar().getTime();
                            break block25;
                        }
                        this.matchStat = -1;
                        return null;
                    }
                    finally {
                        var4_12.close();
                    }
                }
                if (var2_3 != '-' && (var2_3 < '0' || var2_3 > '9')) break block26;
                var5_5 = 0L;
                var3_10 = false;
                if (var2_3 == '-') {
                    v4 = this;
                    var1_1 = (char)(var1_1 + 1);
                    var2_3 = v4.charAt(v4.e + 1);
                    var3_10 = true;
                }
                if (var2_3 >= '0' && var2_3 <= '9') {
                    var5_5 = var2_3 - 48;
                    while (true) {
                        v5 = this;
                        v6 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                        var2_3 = v5.charAt(v5.e + v6);
                        if (var2_3 < '0' || var2_3 > '9') break;
                        var5_5 = var5_5 * 10L + (long)(var2_3 - 48);
                    }
                }
                if (var5_5 < 0L) {
                    this.matchStat = -1;
                    return null;
                }
                if (var3_10) {
                    var5_5 = -var5_5;
                }
                var3_8 = new Date(var5_5);
                break block25;
            }
            if (var2_3 != 'n') ** GOTO lbl-1000
            v7 = this;
            if (v7.charAt(v7.e + 1) != 'u') ** GOTO lbl-1000
            v8 = this;
            if (v8.charAt(v8.e + 1 + 1) != 'l') ** GOTO lbl-1000
            v9 = this;
            if (v9.charAt(v9.e + 1 + 2) == 'l') {
                this.matchStat = 5;
                var3_8 = null;
                var1_1 = (char)(var1_1 + 3);
                v10 = this;
                var1_1 = (char)(var1_1 + 1);
                var2_3 = v10.charAt(v10.e + 4);
            } else lbl-1000:
            // 4 sources

            {
                this.matchStat = -1;
                return null;
            }
        }
        if (var2_3 == ',') {
            this.e += var1_1;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            this.a = 16;
            return var3_8;
        }
        if (var2_3 != ']') ** GOTO lbl116
        v11 = this;
        v12 = var1_1;
        var1_1 = (char)(var1_1 + 1);
        var2_3 = v11.charAt(v11.e + v12);
        if (var2_3 == ',') {
            this.a = 16;
            this.e += var1_1;
            this.d = this.charAt(this.e);
        } else if (var2_3 == ']') {
            this.a = 15;
            this.e += var1_1;
            this.d = this.charAt(this.e);
        } else if (var2_3 == '}') {
            this.a = 13;
            this.e += var1_1;
            this.d = this.charAt(this.e);
        } else if (var2_3 == '\u001a') {
            this.a = 20;
            this.e += var1_1 - '\u0001';
            this.d = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl116:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var3_8;
    }

    /*
     * Unable to fully structure code
     */
    public UUID scanFieldUUID(char[] var1_1) {
        block64: {
            block62: {
                block65: {
                    block63: {
                        this.matchStat = 0;
                        if (!this.charArrayCompare(var1_1)) {
                            this.matchStat = -2;
                            return null;
                        }
                        var2_2 = var1_1.length;
                        v0 = this;
                        if ((var3_3 = v0.charAt(v0.e + var2_2++)) != 34) break block62;
                        var3_3 = this.e + var1_1.length + 1;
                        if ((var3_3 = this.indexOf('\"', var3_3)) == -1) {
                            throw new JSONException("unclosed str");
                        }
                        var4_4 = this.e + var1_1.length + 1;
                        var5_6 = var3_3 - var4_4;
                        if (var5_6 != 36) break block63;
                        var7_7 = 0L;
                        var9_9 = 0L;
                        for (var5_6 = 0; var5_6 < 8; ++var5_6) {
                            var6_11 = this.charAt(var4_4 + var5_6);
                            if (var6_11 >= 48 && var6_11 <= 57) {
                                var6_11 -= 48;
                            } else if (var6_11 >= 97 && var6_11 <= 102) {
                                var6_11 = 10 + (var6_11 - 97);
                            } else if (var6_11 >= 65 && var6_11 <= 70) {
                                var6_11 = 10 + (var6_11 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var7_7 = var7_7 << 4 | (long)var6_11;
                        }
                        for (var5_6 = 9; var5_6 < 13; ++var5_6) {
                            var6_11 = this.charAt(var4_4 + var5_6);
                            if (var6_11 >= 48 && var6_11 <= 57) {
                                var6_11 -= 48;
                            } else if (var6_11 >= 97 && var6_11 <= 102) {
                                var6_11 = 10 + (var6_11 - 97);
                            } else if (var6_11 >= 65 && var6_11 <= 70) {
                                var6_11 = 10 + (var6_11 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var7_7 = var7_7 << 4 | (long)var6_11;
                        }
                        for (var5_6 = 14; var5_6 < 18; ++var5_6) {
                            v1 = this.charAt(var4_4 + var5_6);
                            var6_11 = v1;
                            if (v1 >= '0' && var6_11 <= 57) {
                                var6_11 -= 48;
                            } else if (var6_11 >= 97 && var6_11 <= 102) {
                                var6_11 = 10 + (var6_11 - 97);
                            } else if (var6_11 >= 65 && var6_11 <= 70) {
                                var6_11 = 10 + (var6_11 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var7_7 = var7_7 << 4 | (long)var6_11;
                        }
                        for (var5_6 = 19; var5_6 < 23; ++var5_6) {
                            v2 = this.charAt(var4_4 + var5_6);
                            var6_11 = v2;
                            if (v2 >= '0' && var6_11 <= 57) {
                                var6_11 -= 48;
                            } else if (var6_11 >= 97 && var6_11 <= 102) {
                                var6_11 = 10 + (var6_11 - 97);
                            } else if (var6_11 >= 65 && var6_11 <= 70) {
                                var6_11 = 10 + (var6_11 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var9_9 = var9_9 << 4 | (long)var6_11;
                        }
                        for (var5_6 = 24; var5_6 < 36; ++var5_6) {
                            v3 = this.charAt(var4_4 + var5_6);
                            var6_11 = v3;
                            if (v3 >= '0' && var6_11 <= 57) {
                                var6_11 -= 48;
                            } else if (var6_11 >= 97 && var6_11 <= 102) {
                                var6_11 = 10 + (var6_11 - 97);
                            } else if (var6_11 >= 65 && var6_11 <= 70) {
                                var6_11 = 10 + (var6_11 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var9_9 = var9_9 << 4 | (long)var6_11;
                        }
                        var4_5 = new UUID(var7_7, var9_9);
                        var2_2 += var3_3 - (this.e + var1_1.length + 1) + 1;
                        v4 = this;
                        var3_3 = v4.charAt(v4.e + var2_2++);
                        break block64;
                    }
                    if (var5_6 != 32) break block65;
                    var7_8 = 0L;
                    var9_10 = 0L;
                    for (var5_6 = 0; var5_6 < 16; ++var5_6) {
                        var6_12 = this.charAt(var4_4 + var5_6);
                        if (var6_12 >= 48 && var6_12 <= 57) {
                            var6_12 -= 48;
                        } else if (var6_12 >= 97 && var6_12 <= 102) {
                            var6_12 = 10 + (var6_12 - 97);
                        } else if (var6_12 >= 65 && var6_12 <= 70) {
                            var6_12 = 10 + (var6_12 - 65);
                        } else {
                            this.matchStat = -2;
                            return null;
                        }
                        var7_8 = var7_8 << 4 | (long)var6_12;
                    }
                    for (var5_6 = 16; var5_6 < 32; ++var5_6) {
                        var6_12 = this.charAt(var4_4 + var5_6);
                        if (var6_12 >= 48 && var6_12 <= 57) {
                            var6_12 -= 48;
                        } else if (var6_12 >= 97 && var6_12 <= 102) {
                            var6_12 = 10 + (var6_12 - 97);
                        } else if (var6_12 >= 65 && var6_12 <= 70) {
                            var6_12 = 10 + (var6_12 - 65);
                        } else {
                            this.matchStat = -2;
                            return null;
                        }
                        var9_10 = var9_10 << 4 | (long)var6_12;
                    }
                    var4_5 = new UUID(var7_8, var9_10);
                    var2_2 += var3_3 - (this.e + var1_1.length + 1) + 1;
                    v5 = this;
                    var3_3 = v5.charAt(v5.e + var2_2++);
                    break block64;
                }
                this.matchStat = -1;
                return null;
            }
            if (var3_3 != 110) ** GOTO lbl-1000
            v6 = this;
            if (v6.charAt(v6.e + var2_2++) != 'u') ** GOTO lbl-1000
            v7 = this;
            if (v7.charAt(v7.e + var2_2++) != 'l') ** GOTO lbl-1000
            v8 = this;
            if (v8.charAt(v8.e + var2_2++) == 'l') {
                var4_5 = null;
                v9 = this;
                var3_3 = v9.charAt(v9.e + var2_2++);
            } else lbl-1000:
            // 4 sources

            {
                this.matchStat = -1;
                return null;
            }
        }
        if (var3_3 == 44) {
            this.e += var2_2;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return var4_5;
        }
        if (var3_3 != 125) ** GOTO lbl187
        v10 = this;
        v11 = v10.charAt(v10.e + var2_2++);
        var3_3 = v11;
        if (v11 == ',') {
            this.a = 16;
            this.e += var2_2;
            this.d = this.charAt(this.e);
        } else if (var3_3 == 93) {
            this.a = 15;
            this.e += var2_2;
            this.d = this.charAt(this.e);
        } else if (var3_3 == 125) {
            this.a = 13;
            this.e += var2_2;
            this.d = this.charAt(this.e);
        } else if (var3_3 == 26) {
            this.a = 20;
            this.e += var2_2 - 1;
            this.d = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl187:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var4_5;
    }

    /*
     * Unable to fully structure code
     */
    public UUID scanUUID(char var1_1) {
        block63: {
            block61: {
                block64: {
                    block62: {
                        this.matchStat = 0;
                        var1_1 = '\u0000';
                        v0 = this;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v0.charAt(v0.e + 0);
                        if (var2_2 != 34) break block61;
                        var1_1 = (char)(this.e + 1);
                        v1 = this.indexOf('\"', var1_1);
                        var1_1 = (char)v1;
                        if (v1 == -1) {
                            throw new JSONException("unclosed str");
                        }
                        var2_2 = this.e + 1;
                        var3_3 = var1_1 - var2_2;
                        if (var3_3 != 36) break block62;
                        var5_5 = 0L;
                        var7_7 = 0L;
                        for (var3_3 = 0; var3_3 < 8; ++var3_3) {
                            var4_9 = this.charAt(var2_2 + var3_3);
                            if (var4_9 >= 48 && var4_9 <= 57) {
                                var4_9 -= 48;
                            } else if (var4_9 >= 97 && var4_9 <= 102) {
                                var4_9 = 10 + (var4_9 - 97);
                            } else if (var4_9 >= 65 && var4_9 <= 70) {
                                var4_9 = 10 + (var4_9 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var5_5 = var5_5 << 4 | (long)var4_9;
                        }
                        for (var3_3 = 9; var3_3 < 13; ++var3_3) {
                            var4_9 = this.charAt(var2_2 + var3_3);
                            if (var4_9 >= 48 && var4_9 <= 57) {
                                var4_9 -= 48;
                            } else if (var4_9 >= 97 && var4_9 <= 102) {
                                var4_9 = 10 + (var4_9 - 97);
                            } else if (var4_9 >= 65 && var4_9 <= 70) {
                                var4_9 = 10 + (var4_9 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var5_5 = var5_5 << 4 | (long)var4_9;
                        }
                        for (var3_3 = 14; var3_3 < 18; ++var3_3) {
                            v2 = this.charAt(var2_2 + var3_3);
                            var4_9 = v2;
                            if (v2 >= '0' && var4_9 <= 57) {
                                var4_9 -= 48;
                            } else if (var4_9 >= 97 && var4_9 <= 102) {
                                var4_9 = 10 + (var4_9 - 97);
                            } else if (var4_9 >= 65 && var4_9 <= 70) {
                                var4_9 = 10 + (var4_9 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var5_5 = var5_5 << 4 | (long)var4_9;
                        }
                        for (var3_3 = 19; var3_3 < 23; ++var3_3) {
                            v3 = this.charAt(var2_2 + var3_3);
                            var4_9 = v3;
                            if (v3 >= '0' && var4_9 <= 57) {
                                var4_9 -= 48;
                            } else if (var4_9 >= 97 && var4_9 <= 102) {
                                var4_9 = 10 + (var4_9 - 97);
                            } else if (var4_9 >= 65 && var4_9 <= 70) {
                                var4_9 = 10 + (var4_9 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var7_7 = var7_7 << 4 | (long)var4_9;
                        }
                        for (var3_3 = 24; var3_3 < 36; ++var3_3) {
                            v4 = this.charAt(var2_2 + var3_3);
                            var4_9 = v4;
                            if (v4 >= '0' && var4_9 <= 57) {
                                var4_9 -= 48;
                            } else if (var4_9 >= 97 && var4_9 <= 102) {
                                var4_9 = 10 + (var4_9 - 97);
                            } else if (var4_9 >= 65 && var4_9 <= 70) {
                                var4_9 = 10 + (var4_9 - 65);
                            } else {
                                this.matchStat = -2;
                                return null;
                            }
                            var7_7 = var7_7 << 4 | (long)var4_9;
                        }
                        var3_4 = new UUID(var5_5, var7_7);
                        var1_1 = (char)(1 + (var1_1 - (this.e + 1) + 1));
                        v5 = this;
                        v6 = var1_1;
                        var1_1 = (char)(var1_1 + 1);
                        var2_2 = v5.charAt(v5.e + v6);
                        break block63;
                    }
                    if (var3_3 != 32) break block64;
                    var5_6 = 0L;
                    var7_8 = 0L;
                    for (var3_3 = 0; var3_3 < 16; ++var3_3) {
                        var4_10 = this.charAt(var2_2 + var3_3);
                        if (var4_10 >= 48 && var4_10 <= 57) {
                            var4_10 -= 48;
                        } else if (var4_10 >= 97 && var4_10 <= 102) {
                            var4_10 = 10 + (var4_10 - 97);
                        } else if (var4_10 >= 65 && var4_10 <= 70) {
                            var4_10 = 10 + (var4_10 - 65);
                        } else {
                            this.matchStat = -2;
                            return null;
                        }
                        var5_6 = var5_6 << 4 | (long)var4_10;
                    }
                    for (var3_3 = 16; var3_3 < 32; ++var3_3) {
                        var4_10 = this.charAt(var2_2 + var3_3);
                        if (var4_10 >= 48 && var4_10 <= 57) {
                            var4_10 -= 48;
                        } else if (var4_10 >= 97 && var4_10 <= 102) {
                            var4_10 = 10 + (var4_10 - 97);
                        } else if (var4_10 >= 65 && var4_10 <= 70) {
                            var4_10 = 10 + (var4_10 - 65);
                        } else {
                            this.matchStat = -2;
                            return null;
                        }
                        var7_8 = var7_8 << 4 | (long)var4_10;
                    }
                    var3_4 = new UUID(var5_6, var7_8);
                    var1_1 = (char)(1 + (var1_1 - (this.e + 1) + 1));
                    v7 = this;
                    v8 = var1_1;
                    var1_1 = (char)(var1_1 + 1);
                    var2_2 = v7.charAt(v7.e + v8);
                    break block63;
                }
                this.matchStat = -1;
                return null;
            }
            if (var2_2 != 110) ** GOTO lbl-1000
            v9 = this;
            var1_1 = (char)(var1_1 + 1);
            if (v9.charAt(v9.e + 1) != 'u') ** GOTO lbl-1000
            v10 = this;
            var1_1 = (char)(var1_1 + 1);
            if (v10.charAt(v10.e + 2) != 'l') ** GOTO lbl-1000
            v11 = this;
            var1_1 = (char)(var1_1 + 1);
            if (v11.charAt(v11.e + 3) == 'l') {
                var3_4 = null;
                v12 = this;
                var1_1 = (char)(var1_1 + 1);
                var2_2 = v12.charAt(v12.e + 4);
            } else lbl-1000:
            // 4 sources

            {
                this.matchStat = -1;
                return null;
            }
        }
        if (var2_2 == 44) {
            this.e += var1_1;
            this.d = this.charAt(this.e);
            this.matchStat = 3;
            return var3_4;
        }
        if (var2_2 != 93) ** GOTO lbl198
        v13 = this;
        v14 = var1_1;
        var1_1 = (char)(var1_1 + 1);
        v15 = v13.charAt(v13.e + v14);
        var2_2 = v15;
        if (v15 == ',') {
            this.a = 16;
            this.e += var1_1;
            this.d = this.charAt(this.e);
        } else if (var2_2 == 93) {
            this.a = 15;
            this.e += var1_1;
            this.d = this.charAt(this.e);
        } else if (var2_2 == 125) {
            this.a = 13;
            this.e += var1_1;
            this.d = this.charAt(this.e);
        } else if (var2_2 == 26) {
            this.a = 20;
            this.e += var1_1 - '\u0001';
            this.d = (char)26;
        } else {
            this.matchStat = -1;
            return null;
lbl198:
            // 1 sources

            this.matchStat = -1;
            return null;
        }
        this.matchStat = 4;
        return var3_4;
    }

    public final void scanTrue() {
        if (this.d != 't') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.d != 'r') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.d != 'u') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.d != 'e') {
            throw new JSONException("error parse true");
        }
        this.next();
        if (this.d == ' ' || this.d == ',' || this.d == '}' || this.d == ']' || this.d == '\n' || this.d == '\r' || this.d == '\t' || this.d == '\u001a' || this.d == '\f' || this.d == '\b' || this.d == ':' || this.d == '/') {
            this.a = 6;
            return;
        }
        throw new JSONException("scan true error");
    }

    public final void scanNullOrNew() {
        this.scanNullOrNew(true);
    }

    public final void scanNullOrNew(boolean bl) {
        if (this.d != 'n') {
            throw new JSONException("error parse null or new");
        }
        this.next();
        if (this.d == 'u') {
            this.next();
            if (this.d != 'l') {
                throw new JSONException("error parse null");
            }
            this.next();
            if (this.d != 'l') {
                throw new JSONException("error parse null");
            }
            this.next();
            if (this.d == ' ' || this.d == ',' || this.d == '}' || this.d == ']' || this.d == '\n' || this.d == '\r' || this.d == '\t' || this.d == '\u001a' || this.d == ':' && bl || this.d == '\f' || this.d == '\b') {
                this.a = 8;
                return;
            }
            throw new JSONException("scan null error");
        }
        if (this.d != 'e') {
            throw new JSONException("error parse new");
        }
        this.next();
        if (this.d != 'w') {
            throw new JSONException("error parse new");
        }
        this.next();
        if (this.d == ' ' || this.d == ',' || this.d == '}' || this.d == ']' || this.d == '\n' || this.d == '\r' || this.d == '\t' || this.d == '\u001a' || this.d == '\f' || this.d == '\b') {
            this.a = 9;
            return;
        }
        throw new JSONException("scan new error");
    }

    public final void scanFalse() {
        if (this.d != 'f') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.d != 'a') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.d != 'l') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.d != 's') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.d != 'e') {
            throw new JSONException("error parse false");
        }
        this.next();
        if (this.d == ' ' || this.d == ',' || this.d == '}' || this.d == ']' || this.d == '\n' || this.d == '\r' || this.d == '\t' || this.d == '\u001a' || this.d == '\f' || this.d == '\b' || this.d == ':' || this.d == '/') {
            this.a = 7;
            return;
        }
        throw new JSONException("scan false error");
    }

    public final void scanIdent() {
        this.i = this.e - 1;
        this.j = false;
        do {
            ++this.h;
            this.next();
        } while (Character.isLetterOrDigit(this.d));
        String string = this.stringVal();
        if ("null".equalsIgnoreCase(string)) {
            this.a = 8;
            return;
        }
        if ("new".equals(string)) {
            this.a = 9;
            return;
        }
        if ("true".equals(string)) {
            this.a = 6;
            return;
        }
        if ("false".equals(string)) {
            this.a = 7;
            return;
        }
        if ("undefined".equals(string)) {
            this.a = 23;
            return;
        }
        if ("Set".equals(string)) {
            this.a = 21;
            return;
        }
        if ("TreeSet".equals(string)) {
            this.a = 22;
            return;
        }
        this.a = 18;
    }

    @Override
    public abstract String stringVal();

    public abstract String subString(int var1, int var2);

    protected abstract char[] sub_chars(int var1, int var2);

    public static String readString(char[] cArray, int n2) {
        char[] cArray2 = new char[n2];
        int n3 = 0;
        block22: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            if (c2 != '\\') {
                cArray2[n3++] = c2;
                continue;
            }
            switch (cArray[++i2]) {
                case '0': {
                    cArray2[n3++] = '\u0000';
                    continue block22;
                }
                case '1': {
                    cArray2[n3++] = '\u0001';
                    continue block22;
                }
                case '2': {
                    cArray2[n3++] = 2;
                    continue block22;
                }
                case '3': {
                    cArray2[n3++] = 3;
                    continue block22;
                }
                case '4': {
                    cArray2[n3++] = 4;
                    continue block22;
                }
                case '5': {
                    cArray2[n3++] = 5;
                    continue block22;
                }
                case '6': {
                    cArray2[n3++] = 6;
                    continue block22;
                }
                case '7': {
                    cArray2[n3++] = 7;
                    continue block22;
                }
                case 'b': {
                    cArray2[n3++] = 8;
                    continue block22;
                }
                case 't': {
                    cArray2[n3++] = 9;
                    continue block22;
                }
                case 'n': {
                    cArray2[n3++] = 10;
                    continue block22;
                }
                case 'v': {
                    cArray2[n3++] = 11;
                    continue block22;
                }
                case 'F': 
                case 'f': {
                    cArray2[n3++] = 12;
                    continue block22;
                }
                case 'r': {
                    cArray2[n3++] = 13;
                    continue block22;
                }
                case '\"': {
                    cArray2[n3++] = 34;
                    continue block22;
                }
                case '\'': {
                    cArray2[n3++] = 39;
                    continue block22;
                }
                case '/': {
                    cArray2[n3++] = 47;
                    continue block22;
                }
                case '\\': {
                    cArray2[n3++] = 92;
                    continue block22;
                }
                case 'x': {
                    cArray2[n3++] = (char)(q[cArray[++i2]] * 16 + q[cArray[++i2]]);
                    continue block22;
                }
                case 'u': {
                    cArray2[n3++] = (char)Integer.parseInt(new String(new char[]{cArray[++i2], cArray[++i2], cArray[++i2], cArray[++i2]}), 16);
                    continue block22;
                }
                default: {
                    throw new JSONException("unclosed.str.lit");
                }
            }
        }
        return new String(cArray2, 0, n3);
    }

    protected abstract boolean charArrayCompare(char[] var1);

    @Override
    public boolean isBlankInput() {
        int n2 = 0;
        while (true) {
            char c2;
            if ((c2 = this.charAt(n2)) == '\u001a') break;
            if (!JSONLexerBase.isWhitespace(c2)) {
                return false;
            }
            ++n2;
        }
        this.a = 20;
        return true;
    }

    @Override
    public final void skipWhitespace() {
        while (this.d <= '/') {
            if (this.d == ' ' || this.d == '\r' || this.d == '\n' || this.d == '\t' || this.d == '\f' || this.d == '\b') {
                this.next();
                continue;
            }
            if (this.d != '/') break;
            this.a();
        }
    }

    private void a(char c2) {
        if (this.h == this.g.length) {
            char[] cArray = new char[this.g.length * 2];
            System.arraycopy(this.g, 0, cArray, 0, this.g.length);
            this.g = cArray;
        }
        this.g[this.h++] = c2;
    }

    public final void scanHex() {
        char c2;
        if (this.d != 'x') {
            throw new JSONException("illegal state. " + this.d);
        }
        this.next();
        if (this.d != '\'') {
            throw new JSONException("illegal state. " + this.d);
        }
        this.i = this.e;
        this.next();
        if (this.d == '\'') {
            this.next();
            this.a = 26;
            return;
        }
        while ((c2 = this.next()) >= '0' && c2 <= '9' || c2 >= 'A' && c2 <= 'F') {
            ++this.h;
        }
        if (c2 == '\'') {
            ++this.h;
        } else {
            throw new JSONException("illegal state. ".concat(String.valueOf(c2)));
        }
        this.next();
        this.a = 26;
    }

    @Override
    public final void scanNumber() {
        boolean bl;
        block13: {
            block17: {
                block18: {
                    block16: {
                        block15: {
                            block14: {
                                block12: {
                                    this.i = this.e;
                                    if (this.d == '-') {
                                        ++this.h;
                                        this.next();
                                    }
                                    while (this.d >= '0' && this.d <= '9') {
                                        ++this.h;
                                        this.next();
                                    }
                                    bl = false;
                                    if (this.d == '.') {
                                        ++this.h;
                                        this.next();
                                        bl = true;
                                        while (this.d >= '0' && this.d <= '9') {
                                            ++this.h;
                                            this.next();
                                        }
                                    }
                                    if (this.h > 65535) {
                                        throw new JSONException("scanNumber overflow");
                                    }
                                    if (this.d != 'L') break block12;
                                    ++this.h;
                                    this.next();
                                    break block13;
                                }
                                if (this.d != 'S') break block14;
                                ++this.h;
                                this.next();
                                break block13;
                            }
                            if (this.d != 'B') break block15;
                            ++this.h;
                            this.next();
                            break block13;
                        }
                        if (this.d != 'F') break block16;
                        ++this.h;
                        this.next();
                        break block17;
                    }
                    if (this.d != 'D') break block18;
                    ++this.h;
                    this.next();
                    break block17;
                }
                if (this.d != 'e' && this.d != 'E') break block13;
                ++this.h;
                this.next();
                if (this.d == '+' || this.d == '-') {
                    ++this.h;
                    this.next();
                }
                while (this.d >= '0' && this.d <= '9') {
                    ++this.h;
                    this.next();
                }
                if (this.d == 'D' || this.d == 'F') {
                    ++this.h;
                    this.next();
                }
            }
            bl = true;
        }
        if (bl) {
            this.a = 3;
            return;
        }
        this.a = 2;
    }

    @Override
    public final long longValue() {
        int n2;
        long l2;
        long l3 = 0L;
        boolean bl = false;
        if (this.i == -1) {
            this.i = 0;
        }
        int n3 = this.i;
        int n4 = this.i + this.h;
        JSONLexerBase jSONLexerBase = this;
        if (jSONLexerBase.charAt(jSONLexerBase.i) == '-') {
            bl = true;
            l2 = Long.MIN_VALUE;
            ++n3;
        } else {
            l2 = -9223372036854775807L;
        }
        if (n3 < n4) {
            l3 = -(this.charAt(n3++) - 48);
        }
        while (n3 < n4 && (n2 = this.charAt(n3++)) != 76 && n2 != 83 && n2 != 66) {
            n2 -= 48;
            if (l3 < -922337203685477580L) {
                throw new NumberFormatException(this.numberString());
            }
            if ((l3 *= 10L) < l2 + (long)n2) {
                throw new NumberFormatException(this.numberString());
            }
            l3 -= (long)n2;
        }
        if (bl) {
            if (n3 > this.i + 1) {
                return l3;
            }
            throw new NumberFormatException(this.numberString());
        }
        return -l3;
    }

    @Override
    public final Number decimalValue(boolean bl) {
        JSONLexerBase jSONLexerBase = this;
        char c2 = jSONLexerBase.charAt(jSONLexerBase.i + this.h - 1);
        try {
            if (c2 == 'F') {
                return Float.valueOf(Float.parseFloat(this.numberString()));
            }
            if (c2 == 'D') {
                return Double.parseDouble(this.numberString());
            }
            if (bl) {
                return this.decimalValue();
            }
            return this.doubleValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new JSONException(numberFormatException.getMessage() + ", " + this.info());
        }
    }

    @Override
    public abstract BigDecimal decimalValue();

    public static boolean isWhitespace(char c2) {
        return c2 <= ' ' && (c2 == ' ' || c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == '\f' || c2 == '\b');
    }

    public String[] scanFieldStringArray(char[] cArray, int n2, SymbolTable symbolTable) {
        throw new UnsupportedOperationException();
    }

    public boolean matchField2(char[] cArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFeatures() {
        return this.c;
    }

    @Override
    public void setFeatures(int n2) {
        this.c = n2;
    }

    static {
        int n2 = 48;
        while (n2 <= 57) {
            int n3 = n2++;
            JSONLexerBase.q[n3] = n3 - 48;
        }
        n2 = 97;
        while (n2 <= 102) {
            int n4 = n2++;
            JSONLexerBase.q[n4] = n4 - 97 + 10;
        }
        n2 = 65;
        while (n2 <= 70) {
            int n5 = n2++;
            JSONLexerBase.q[n5] = n5 - 65 + 10;
        }
    }
}

