/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.volley;

import android.net.Uri;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.text.TextUtils;
import com.tradplus.ads.volley.Cache;
import com.tradplus.ads.volley.DefaultRetryPolicy;
import com.tradplus.ads.volley.NetworkResponse;
import com.tradplus.ads.volley.RequestQueue;
import com.tradplus.ads.volley.Response;
import com.tradplus.ads.volley.RetryPolicy;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.VolleyLog;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.Map;

public abstract class Request<T>
implements Comparable<Request<T>> {
    private final VolleyLog.a a = VolleyLog.a.ENABLED ? new VolleyLog.a() : null;
    private final int b;
    private final String c;
    private final int d;
    private final Response.ErrorListener e;
    private Integer f;
    private RequestQueue g;
    private boolean h = true;
    private boolean i = false;
    private boolean j = false;
    private long k = 0L;
    private RetryPolicy l;
    private Cache.Entry m = null;
    private Object n;

    @Deprecated
    public Request(String string, Response.ErrorListener errorListener) {
        this(-1, string, errorListener);
    }

    public Request(int n2, String string, Response.ErrorListener errorListener) {
        this.b = n2;
        this.c = string;
        this.e = errorListener;
        this.setRetryPolicy(new DefaultRetryPolicy());
        String string2 = string;
        this.d = !TextUtils.isEmpty((CharSequence)string2) && (string2 = Uri.parse((String)string2)) != null && (string2 = string2.getHost()) != null ? string2.hashCode() : 0;
    }

    public int getMethod() {
        return this.b;
    }

    public Request<?> setTag(Object object) {
        this.n = object;
        return this;
    }

    public Object getTag() {
        return this.n;
    }

    public Response.ErrorListener getErrorListener() {
        return this.e;
    }

    public int getTrafficStatsTag() {
        return this.d;
    }

    public Request<?> setRetryPolicy(RetryPolicy retryPolicy) {
        this.l = retryPolicy;
        return this;
    }

    public void addMarker(String string) {
        if (VolleyLog.a.ENABLED) {
            this.a.add(string, Thread.currentThread().getId());
            return;
        }
        if (this.k == 0L) {
            this.k = SystemClock.elapsedRealtime();
        }
    }

    final void a(final String string) {
        if (this.g != null) {
            this.g.a(this);
        }
        if (VolleyLog.a.ENABLED) {
            final long l2 = Thread.currentThread().getId();
            if (Looper.myLooper() != Looper.getMainLooper()) {
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public final void run() {
                        Request.this.a.add(string, l2);
                        Request.this.a.finish(this.toString());
                    }
                });
                return;
            }
            this.a.add(string, l2);
            this.a.finish(this.toString());
            return;
        }
        long l3 = SystemClock.elapsedRealtime() - this.k;
        if (l3 >= 3000L) {
            VolleyLog.d("%d ms: %s", l3, this.toString());
        }
    }

    public Request<?> setRequestQueue(RequestQueue requestQueue) {
        this.g = requestQueue;
        return this;
    }

    public final Request<?> setSequence(int n2) {
        this.f = n2;
        return this;
    }

    public final int getSequence() {
        if (this.f == null) {
            throw new IllegalStateException("getSequence called before setSequence");
        }
        return this.f;
    }

    public String getUrl() {
        return this.c;
    }

    public String getCacheKey() {
        return this.getUrl();
    }

    public Request<?> setCacheEntry(Cache.Entry entry) {
        this.m = entry;
        return this;
    }

    public Cache.Entry getCacheEntry() {
        return this.m;
    }

    public void cancel() {
        this.i = true;
    }

    public boolean isCanceled() {
        return this.i;
    }

    public Map<String, String> getHeaders() {
        return Collections.emptyMap();
    }

    @Deprecated
    protected Map<String, String> getPostParams() {
        return this.getParams();
    }

    @Deprecated
    protected String getPostParamsEncoding() {
        return this.getParamsEncoding();
    }

    @Deprecated
    public String getPostBodyContentType() {
        return this.getBodyContentType();
    }

    @Deprecated
    public byte[] getPostBody() {
        Map<String, String> map = this.getPostParams();
        if (map != null && map.size() > 0) {
            return Request.a(map, this.getPostParamsEncoding());
        }
        return null;
    }

    protected Map<String, String> getParams() {
        return null;
    }

    protected String getParamsEncoding() {
        return "UTF-8";
    }

    public String getBodyContentType() {
        return "application/x-www-form-urlencoded; charset=" + this.getParamsEncoding();
    }

    public byte[] getBody() {
        Map<String, String> map = this.getParams();
        if (map != null && map.size() > 0) {
            return Request.a(map, this.getParamsEncoding());
        }
        return null;
    }

    private static byte[] a(Map<String, String> object, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            for (Map.Entry entry : object.entrySet()) {
                stringBuilder.append(URLEncoder.encode((String)entry.getKey(), string));
                stringBuilder.append('=');
                stringBuilder.append(URLEncoder.encode((String)entry.getValue(), string));
                stringBuilder.append('&');
            }
            return stringBuilder.toString().getBytes(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("Encoding not supported: ".concat(String.valueOf(string)), unsupportedEncodingException);
        }
    }

    public final Request<?> setShouldCache(boolean bl) {
        this.h = bl;
        return this;
    }

    public final boolean shouldCache() {
        return this.h;
    }

    public Priority getPriority() {
        return Priority.NORMAL;
    }

    public final int getTimeoutMs() {
        return this.l.getCurrentTimeout();
    }

    public RetryPolicy getRetryPolicy() {
        return this.l;
    }

    public void markDelivered() {
        this.j = true;
    }

    public boolean hasHadResponseDelivered() {
        return this.j;
    }

    protected abstract Response<T> parseNetworkResponse(NetworkResponse var1);

    protected VolleyError parseNetworkError(VolleyError volleyError) {
        return volleyError;
    }

    protected abstract void deliverResponse(T var1);

    public void deliverError(VolleyError volleyError) {
        if (this.e != null) {
            this.e.onErrorResponse(volleyError);
        }
    }

    @Override
    public int compareTo(Request<T> request) {
        Priority priority;
        Priority priority2 = this.getPriority();
        if (priority2 == (priority = request.getPriority())) {
            return this.f - request.f;
        }
        return priority.ordinal() - priority2.ordinal();
    }

    public String toString() {
        String string = "0x" + Integer.toHexString(this.getTrafficStatsTag());
        return (this.i ? "[X] " : "[ ] ") + this.getUrl() + " " + string + " " + (Object)((Object)this.getPriority()) + " " + this.f;
    }

    public static enum Priority {
        LOW,
        NORMAL,
        HIGH,
        IMMEDIATE;

    }

    public static interface Method {
        public static final int DEPRECATED_GET_OR_POST = -1;
        public static final int GET = 0;
        public static final int POST = 1;
        public static final int PUT = 2;
        public static final int DELETE = 3;
        public static final int HEAD = 4;
        public static final int OPTIONS = 5;
        public static final int TRACE = 6;
        public static final int PATCH = 7;
    }
}

