/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.adapter.offerwall;

import com.tradplus.ads.base.adapter.TPBalanceAdapterListener;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.adapter.TPShowAdapterListener;
import com.tradplus.ads.base.common.AdapterCheckTimeOut;
import com.tradplus.ads.network.response.ConfigResponse;

public abstract class TPOfferWallAdapter
extends TPBaseAdapter {
    private static final long TIME_DELTA = 30000L;
    public TPShowAdapterListener mShowListener;
    private AdapterCheckTimeOut mCheckTimeOut;
    public TPBalanceAdapterListener mBalanceListener;

    @Override
    public void init() {
        ConfigResponse.WaterfallBean waterfallBean = this.getWaterfallBean();
        if (waterfallBean == null) {
            return;
        }
        long l2 = waterfallBean.getAdValidTime();
        if (l2 <= 0L) {
            return;
        }
        this.mCheckTimeOut = new AdapterCheckTimeOut(30000L);
        this.mCheckTimeOut.setValidTime(l2 * 1000L);
    }

    public abstract void showAd();

    public void setShowListener(TPShowAdapterListener tPShowAdapterListener) {
        this.mShowListener = tPShowAdapterListener;
    }

    @Override
    public void clean() {
        this.mShowListener = null;
    }

    public void setFirstLoadedTime() {
        if (this.mCheckTimeOut != null) {
            this.mCheckTimeOut.setFirstLoadTime();
        }
    }

    public TPBalanceAdapterListener getBalanceListener() {
        return this.mBalanceListener;
    }

    public void setBalanceListener(TPBalanceAdapterListener tPBalanceAdapterListener) {
        this.mBalanceListener = tPBalanceAdapterListener;
    }

    public boolean isAdsTimeOut() {
        if (this.mCheckTimeOut != null) {
            return this.mCheckTimeOut.checkIsTimeOut();
        }
        return false;
    }

    public abstract void getCurrencyBalance();

    public abstract void spendCurrency(int var1);

    public abstract void awardCurrency(int var1);

    public abstract void setUserId(String var1);
}

