/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import com.tradplus.ads.base.common.TPImageLoader;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.toolbox.ImageLoader;
import java.util.ArrayList;

public class TPAllImageLoader {
    private int size;
    private int successCount;
    private int failedCount;
    private OnImageLoadedListener onImageLoadedListener;
    private ArrayList<String> urls = new ArrayList();

    public TPAllImageLoader(ArrayList<String> arrayList, OnImageLoadedListener onImageLoadedListener) {
        this.size = arrayList.size();
        this.onImageLoadedListener = onImageLoadedListener;
        this.urls.addAll(arrayList);
    }

    public void loadAllImage() {
        if (this.urls == null || this.urls.size() <= 0) {
            return;
        }
        for (int i2 = 0; i2 < this.urls.size(); ++i2) {
            TPImageLoader.getInstance().loadAllImage(null, this.urls.get(i2), new ImageLoader.ImageListener(){

                @Override
                public final void onErrorResponse(VolleyError volleyError) {
                    TPAllImageLoader.this.failedCount++;
                    TPAllImageLoader.this.checkSuccess();
                }

                @Override
                public final void onResponse(ImageLoader.ImageContainer imageContainer, boolean bl) {
                    if (imageContainer.getBitmap() != null) {
                        TPAllImageLoader.this.successCount++;
                        TPAllImageLoader.this.checkSuccess();
                    }
                }
            });
        }
    }

    public void checkSuccess() {
        LogUtil.ownShow("onErrorResponse = " + this.failedCount);
        LogUtil.ownShow("onResponse = " + this.successCount);
        if (this.failedCount > 0) {
            if (this.onImageLoadedListener != null) {
                this.onImageLoadedListener.onError();
                return;
            }
        } else if (this.successCount == this.size && this.onImageLoadedListener != null) {
            this.onImageLoadedListener.onImageLoaded();
        }
    }

    public static interface OnImageLoadedListener {
        public void onImageLoaded();

        public void onError();
    }
}

