/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.bean.TPAdInfo;
import com.tradplus.ads.base.bean.TPImpCallbackInfo;
import com.tradplus.ads.base.bean.TPRewardCallbackInfo;
import com.tradplus.ads.base.common.OnCallbackPrintListener;
import com.tradplus.ads.base.common.TPURLManager;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.network.BaseHttpRequest;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.TypeReference;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.network.response.ConfigResponse;
import java.net.URLEncoder;
import java.util.Map;

public class TPCallbackManager
extends BaseHttpRequest
implements BaseHttpRequest.OnHttpLoaderListener {
    private String url;
    private int restartCount;
    private TPAdInfo tpAdInfo;
    public static final int CALLBACK_REWARD = 0;
    public static final int CALLBACK_IMP = 1;
    private ConfigResponse.WaterfallBean waterfallBean;
    private String unitId;
    private static OnCallbackPrintListener onCallbackPrintListener;
    private int callbackType;
    private TPBaseAdapter baseAdapter;

    public TPCallbackManager(String string, int n2, TPBaseAdapter tPBaseAdapter, TPAdInfo tPAdInfo) {
        this.tpAdInfo = tPAdInfo;
        this.callbackType = n2;
        this.unitId = string;
        this.waterfallBean = tPBaseAdapter.getWaterfallBean();
        this.url = this.getCallbackUrl(string, tPBaseAdapter);
        this.baseAdapter = tPBaseAdapter;
    }

    public void startCallbackRequest() {
        ConfigResponse configResponse = ConfigLoadManager.getInstance().getLocalConfigResponse(this.unitId);
        if (configResponse == null) {
            return;
        }
        if (this.callbackType == 0) {
            if (configResponse.getIs_server_callback() == 0) {
                return;
            }
        } else if (this.callbackType == 1) {
            if (onCallbackPrintListener != null && this.baseAdapter != null) {
                onCallbackPrintListener.onPrint(this.baseAdapter);
            }
            if (configResponse.getIs_server_imp_callback() == 0) {
                return;
            }
        }
        TPCallbackManager tPCallbackManager = this;
        tPCallbackManager.request(tPCallbackManager);
    }

    public String getCallbackUrl(String charSequence, TPBaseAdapter tPBaseAdapter) {
        Map<String, String> map = null;
        Object object = "";
        if (this.callbackType == 0) {
            object = TPURLManager.getInstance().getRewardCallbackHost();
            map = JSON.parseObject(JSON.toJSONString(new TPRewardCallbackInfo((String)charSequence, tPBaseAdapter, this.tpAdInfo)), new TypeReference<Map<String, String>>(){}, new Feature[0]);
        } else if (this.callbackType == 1) {
            object = TPURLManager.getInstance().getImpCallbackHost();
            map = JSON.parseObject(JSON.toJSONString(new TPImpCallbackInfo((String)charSequence, tPBaseAdapter, this.tpAdInfo)), new TypeReference<Map<String, String>>(){}, new Feature[0]);
        }
        LogUtil.ownShow("callback url = ".concat(String.valueOf(object)));
        charSequence = new StringBuilder((String)object);
        try {
            boolean bl = true;
            if (map != null) {
                for (String string : map.keySet()) {
                    if (string == null || map.get(string) == null) continue;
                    if (bl) {
                        bl = false;
                        ((StringBuilder)charSequence).append("?");
                    } else {
                        ((StringBuilder)charSequence).append("&");
                    }
                    ((StringBuilder)charSequence).append(string).append("=").append(URLEncoder.encode(map.get(string), "UTF-8"));
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return ((StringBuilder)charSequence).toString();
    }

    @Override
    public void loadSuccess(Object object) {
    }

    @Override
    public void loadError(int n2, String string) {
        ++this.restartCount;
        if (this.restartCount <= 2) {
            this.startCallbackRequest();
        }
    }

    @Override
    public void loadCanceled() {
    }

    @Override
    public int requestType() {
        return 2;
    }

    @Override
    public String generateURL() {
        return this.url;
    }

    @Override
    public Map<String, String> addHeaders() {
        return null;
    }

    @Override
    public byte[] postContent() {
        return null;
    }

    @Override
    public Object parseResult(String string) {
        return string;
    }

    public static void setOnCallbackPrintListener(OnCallbackPrintListener onCallbackPrintListener) {
        TPCallbackManager.onCallbackPrintListener = onCallbackPrintListener;
    }
}

