/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.os.Environment;
import android.os.StatFs;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.db.StoreManager;
import com.tradplus.ads.base.event.TPPushCenter;
import java.io.File;

public class TPDiskManager {
    private final String TAG = "TPDiskManager";
    private static final long DB_PATH_MAX_SIZE = 0x1400000L;
    private static final long MIN_DISK_SIZE = 0xA00000L;
    private long maxDatabaseSize = 0x1400000L;
    private static TPDiskManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TPDiskManager getInstance() {
        if (instance != null) return instance;
        Class<TPDiskManager> clazz = TPDiskManager.class;
        synchronized (TPDiskManager.class) {
            if (instance != null) return instance;
            instance = new TPDiskManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public long getStorageAvailableSize() {
        long l2;
        long l3;
        try {
            StatFs statFs = new StatFs(Environment.getExternalStorageDirectory().getPath());
            l3 = statFs.getBlockSize();
            l2 = statFs.getAvailableBlocks();
        }
        catch (Throwable throwable) {
            return 0L;
        }
        return l3 * l2;
    }

    public boolean checkStorageSize() {
        long l2 = this.getStorageAvailableSize() / 5L;
        if (l2 <= this.maxDatabaseSize) {
            this.maxDatabaseSize = l2;
            if (0xA00000L >= l2) {
                TPPushCenter.getInstance().setEnable(false);
                return true;
            }
        }
        return false;
    }

    public int checkDatabaseSizeWillDelete(boolean bl) {
        if (this.checkStorageSize()) {
            try {
                if (bl) {
                    StoreManager.clearAll();
                } else {
                    this.deleteDBFile();
                }
            }
            catch (Throwable throwable) {}
            return 1;
        }
        if (this.getDBSize() > this.maxDatabaseSize) {
            try {
                StoreManager.clearAll();
            }
            catch (Throwable throwable) {}
            return 2;
        }
        return 0;
    }

    private void deleteDBFile() {
        Object object = GlobalTradPlus.getInstance().getContext();
        try {
            object = object.getDatabasePath("tradplus.db").getPath();
            object = new File((String)object);
            if (((File)object).exists() && ((File)object).isFile()) {
                ((File)object).delete();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public long getDBSize() {
        Object object = GlobalTradPlus.getInstance().getContext();
        try {
            object = object.getDatabasePath("tradplus.db").getPath();
            object = new File((String)object);
            if (((File)object).exists() && ((File)object).isFile()) {
                return ((File)object).length();
            }
        }
        catch (Throwable throwable) {}
        return 0L;
    }

    public long getMaxDatabaseSize() {
        return this.maxDatabaseSize;
    }

    public void setMaxDatabaseSize(long l2) {
        if (l2 > this.maxDatabaseSize) {
            return;
        }
        this.maxDatabaseSize = l2;
    }
}

