/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.graphics.Bitmap;
import android.util.LruCache;
import android.widget.ImageView;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Reflection;
import com.tradplus.ads.common.util.Utils;
import com.tradplus.ads.common.util.VersionCode;
import com.tradplus.ads.volley.RequestQueue;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.toolbox.ImageLoader;
import com.tradplus.ads.volley.toolbox.Volley;

public class TPImageLoader {
    private static final int MAX_MEMORY_CACHE_SIZE = 0x1E00000;
    private static TPImageLoader mInstance;
    private Context mContext;
    private ImageLoader mImageLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized TPImageLoader getInstance() {
        if (mInstance != null) return mInstance;
        Class<TPImageLoader> clazz = TPImageLoader.class;
        synchronized (TPImageLoader.class) {
            if (mInstance != null) return mInstance;
            mInstance = new TPImageLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private TPImageLoader() {
        this.init();
    }

    private void init() {
        this.mContext = GlobalTradPlus.getInstance().getContext();
        RequestQueue requestQueue = Volley.newRequestQueue(this.mContext);
        this.mImageLoader = new ImageLoader(requestQueue, new a());
    }

    public void loadImage(final ImageView imageView, final String string) {
        TPTaskManager.getInstance().runOnMainThread(new Runnable(){

            @Override
            public final void run() {
                Object object = imageView;
                if (object == null) {
                    object = new ImageView(TPImageLoader.this.mContext);
                }
                if (string == null || string.length() <= 0) {
                    return;
                }
                object = ImageLoader.getImageListener(object, 0, 0);
                TPImageLoader.this.mImageLoader.get(string, (ImageLoader.ImageListener)object);
            }
        });
    }

    public void loadAllImage(ImageView imageView, String string, ImageLoader.ImageListener imageListener) {
        if (imageView == null) {
            new ImageView(this.mContext);
        }
        if (string == null || string.length() <= 0) {
            imageListener.onErrorResponse(new VolleyError());
            return;
        }
        LogUtil.ownShow("url = ".concat(String.valueOf(string)));
        LogUtil.ownShow("listener = ".concat(String.valueOf(imageListener)));
        try {
            this.mImageLoader.getImageByUrl(string, imageListener, 0, 0);
            return;
        }
        catch (Exception exception) {
            imageListener.onErrorResponse(new VolleyError());
            return;
        }
    }

    private int memoryCacheSizeBytes(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        long l2 = activityManager.getMemoryClass();
        if (VersionCode.currentApiLevel().isAtLeast(VersionCode.HONEYCOMB)) {
            try {
                int n2 = ApplicationInfo.class.getDeclaredField("FLAG_LARGE_HEAP").getInt(null);
                if (Utils.bitMaskContainsFlag(context.getApplicationInfo().flags, n2)) {
                    l2 = ((Integer)new Reflection.MethodBuilder(activityManager, "getLargeMemoryClass").execute()).intValue();
                }
            }
            catch (Exception exception) {
                LogUtil.show("Unable to reflectively determine large heap size on Honeycomb and above.");
            }
        }
        return (int)Math.min(0x1E00000L, l2 / 8L * 1024L * 1024L);
    }

    final class a
    implements ImageLoader.ImageCache {
        private LruCache<String, Bitmap> b;

        public a() {
            TPImageLoader tPImageLoader2 = TPImageLoader.this;
            int n2 = tPImageLoader2.memoryCacheSizeBytes(tPImageLoader2.mContext);
            this.b = new LruCache<String, Bitmap>(n2){

                protected final /* synthetic */ int sizeOf(Object object, Object object2) {
                    object = (Bitmap)object2;
                    return object.getRowBytes() * object.getHeight();
                }
            };
        }

        @Override
        public final Bitmap getBitmap(String string) {
            return (Bitmap)this.b.get((Object)string);
        }

        @Override
        public final void putBitmap(String string, Bitmap bitmap) {
            this.b.put((Object)string, (Object)bitmap);
        }
    }
}

