/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.bean.TPAdInfo;
import com.tradplus.ads.base.common.TPAdInfoDialog;
import com.tradplus.ads.common.util.PxUtils;
import com.tradplus.ads.mobileads.gdpr.CommonUtil;

public class TPSensorManager {
    private SensorManager sensorManager;
    private Sensor sensor;
    private Activity showAdActivity;
    private a tpSensorEventListener;
    private WindowManager.LayoutParams wmParams;
    private WindowManager mWindowManager;
    private boolean isOpenSensor = true;
    private LinearLayout mFloatLayout;
    private static final String TAG = TPSensorManager.class.getSimpleName();
    private static final float MAX_ROTATE_COUNT = 18.0f;
    private static final float MAX_ROTATE_NUM = 4.0f;
    private static final float MAX_ROTATE_TIME = 2000.0f;
    private boolean isRegister;
    private float startPosition;
    private long startRotateTime;
    private int orientation = 0;
    private int rotateNum;
    private boolean isRotate;
    private TPAdInfo tpAdInfo;
    private boolean isAutoload;
    private static TPSensorManager instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TPSensorManager getInstance() {
        if (instance != null) return instance;
        Class<TPSensorManager> clazz = TPSensorManager.class;
        synchronized (TPSensorManager.class) {
            if (instance != null) return instance;
            instance = new TPSensorManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public TPSensorManager() {
        if (GlobalTradPlus.getInstance().getContext() != null) {
            this.sensorManager = (SensorManager)GlobalTradPlus.getInstance().getContext().getSystemService("sensor");
            this.tpSensorEventListener = new a(0);
        }
    }

    public void registerSensor(TPAdInfo tPAdInfo, boolean bl) {
        try {
            if (this.isOpenSensor) {
                this.unregisterSensor();
                if (!this.isRegister) {
                    Log.i((String)TAG, (String)"tpAdInfo isRegister create ".concat(String.valueOf(tPAdInfo)));
                    this.tpAdInfo = tPAdInfo;
                    this.isAutoload = bl;
                    if (this.sensorManager != null) {
                        this.isRegister = true;
                        this.sensor = this.sensorManager.getDefaultSensor(1);
                        this.sensorManager.registerListener((SensorEventListener)this.tpSensorEventListener, this.sensor, 2);
                    }
                }
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void unregisterSensor() {
        try {
            this.reset();
            if (this.isRegister) {
                this.isRegister = false;
                if (this.sensorManager != null) {
                    this.sensorManager.unregisterListener((SensorEventListener)this.tpSensorEventListener);
                }
                this.removeDragFloat();
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void setShowAdActivity(Activity activity) {
        this.showAdActivity = activity;
    }

    private void createFloatView() {
        if (this.showAdActivity != null) {
            this.wmParams = new WindowManager.LayoutParams();
            this.mWindowManager = this.showAdActivity.getWindowManager();
            this.wmParams.type = 1002;
            this.wmParams.format = 1;
            this.wmParams.flags = 8;
            this.wmParams.gravity = 51;
            BitmapFactory.Options options = new BitmapFactory.Options();
            new BitmapFactory.Options().inJustDecodeBounds = true;
            BitmapFactory.decodeResource((Resources)GlobalTradPlus.getInstance().getContext().getResources(), (int)CommonUtil.getResId((Context)this.showAdActivity, "tp_icon", "drawable"), (BitmapFactory.Options)options);
            int n2 = options.outWidth;
            this.wmParams.x = this.showAdActivity.getResources().getDisplayMetrics().widthPixels - PxUtils.dpToPx((Context)this.showAdActivity, n2);
            this.wmParams.y = this.showAdActivity.getResources().getDisplayMetrics().heightPixels / 2;
            Log.i((String)TAG, (String)("x = " + this.wmParams.x + " y = " + this.wmParams.y));
            this.wmParams.width = -2;
            this.wmParams.height = -2;
            LayoutInflater layoutInflater = this.showAdActivity.getLayoutInflater();
            this.mFloatLayout = (LinearLayout)layoutInflater.inflate(CommonUtil.getResId((Context)this.showAdActivity, "tp_layout_drap", "layout"), null);
            layoutInflater = (LinearLayout)this.mFloatLayout.findViewById(CommonUtil.getResId((Context)this.showAdActivity, "tp_drag_buttom", "id"));
            this.mWindowManager.addView((View)this.mFloatLayout, (ViewGroup.LayoutParams)this.wmParams);
            layoutInflater.setOnClickListener(new View.OnClickListener(){

                public final void onClick(View object) {
                    Log.i((String)TAG, (String)("tpAdInfo onClick showDialog " + TPSensorManager.this.tpAdInfo));
                    object = new TPAdInfoDialog((Context)TPSensorManager.this.showAdActivity, TPSensorManager.this.tpAdInfo, TPSensorManager.this.isAutoload);
                    object.setOnDismissListener(new DialogInterface.OnDismissListener(){

                        public final void onDismiss(DialogInterface dialogInterface) {
                            TPSensorManager.this.unregisterSensor();
                        }
                    });
                    object.show();
                }
            });
        }
    }

    public void setOpenSensor(boolean bl) {
        this.isOpenSensor = bl;
    }

    public boolean isRegister() {
        return this.isRegister;
    }

    private void reset() {
        this.startRotateTime = 0L;
        this.orientation = 0;
        this.startPosition = 0.0f;
        this.rotateNum = 0;
        this.isRotate = false;
    }

    public void removeDragFloat() {
        if (this.mWindowManager != null && this.mFloatLayout != null) {
            this.reset();
            Log.i((String)TAG, (String)"tpAdInfo removeDragFloat");
            this.tpAdInfo = null;
            this.showAdActivity = null;
            this.mWindowManager.removeView((View)this.mFloatLayout);
        }
    }

    final class a
    implements SensorEventListener {
        private a() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public final void onSensorChanged(SensorEvent sensorEvent) {
            try {
                float f2;
                if (TPSensorManager.this.isRotate || sensorEvent.sensor.getType() != 1 || sensorEvent.values.length <= 2) return;
                float f3 = sensorEvent.values[2];
                if (f2 > 9.0f && TPSensorManager.this.startPosition == 0.0f) {
                    TPSensorManager.this.startPosition = f3;
                }
                if (TPSensorManager.this.startPosition == 0.0f) return;
                if (TPSensorManager.this.orientation == 0) {
                    if (!(TPSensorManager.this.startPosition - f3 > 18.0f)) return;
                    TPSensorManager.this.rotateNum++;
                    TPSensorManager.this.startPosition = f3;
                    TPSensorManager.this.orientation = 1;
                    return;
                }
                if (!(TPSensorManager.this.startPosition + f3 > 0.0f)) return;
                TPSensorManager.this.rotateNum++;
                if ((float)TPSensorManager.this.rotateNum >= 4.0f) {
                    if (!((float)(System.currentTimeMillis() - TPSensorManager.this.startRotateTime) <= 2000.0f)) {
                        Log.i((String)TAG, (String)"NO");
                        TPSensorManager.this.reset();
                        return;
                    }
                    if (!TPSensorManager.this.isRotate) {
                        Log.i((String)TAG, (String)"YES");
                        TPSensorManager.this.isRotate = true;
                        TPSensorManager.this.createFloatView();
                    }
                } else if (TPSensorManager.this.startRotateTime == 0L) {
                    TPSensorManager.this.startRotateTime = System.currentTimeMillis();
                    Log.i((String)TAG, (String)("startRotateTime = " + TPSensorManager.this.startRotateTime));
                }
                TPSensorManager.this.startPosition = f3;
                TPSensorManager.this.orientation = 0;
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }

        public final void onAccuracyChanged(Sensor sensor, int n2) {
        }

        /* synthetic */ a(byte by) {
            this();
        }
    }
}

