/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.text.TextUtils;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.SPCacheUtil;
import com.tradplus.ads.base.common.TPURLManager;
import com.tradplus.ads.base.event.TPPushCenter;
import com.tradplus.ads.common.ClientMetadata;
import com.tradplus.ads.common.JSONHelper;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.Json;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.mobileads.gdpr.Const;
import com.tradplus.ads.pushcenter.event.request.SimplifyEvent;
import com.tradplus.ads.pushcenter.http.Listener;
import com.tradplus.ads.pushcenter.http.PushCenterHttpUtils;
import com.tradplus.ads.pushcenter.reqeust.UseTimeRequest;
import com.tradplus.ads.pushcenter.response.BaseResponse;
import com.tradplus.ads.pushcenter.utils.PushMessageUtils;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONObject;

public class TPUseTimeManager {
    private volatile long startTime;
    private HandlerThread handlerThread;
    private Handler handler;
    private ExecutorService mSinglePool;
    private static final int REFRESHTIME = 5000;
    private int refreshTime = 5000;
    private boolean isTrackUseTimeAllow = false;
    private static TPUseTimeManager instance;
    private Runnable timeRunnable = new Runnable(){

        @Override
        public final void run() {
            TPUseTimeManager.this.sendUseTimeRequest();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TPUseTimeManager getInstance() {
        if (instance != null) return instance;
        Class<TPUseTimeManager> clazz = TPUseTimeManager.class;
        synchronized (TPUseTimeManager.class) {
            if (instance != null) return instance;
            instance = new TPUseTimeManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public TPUseTimeManager() {
        TPUseTimeManager tPUseTimeManager = this;
        tPUseTimeManager.setRefreshTime(tPUseTimeManager.refreshTime);
        TPUseTimeManager tPUseTimeManager2 = this;
        tPUseTimeManager2.setTrackUseTimeAllow(tPUseTimeManager2.isTrackUseTimeAllow);
        this.handlerThread = new HandlerThread("tp-usetime-thread-" + System.currentTimeMillis());
        this.handlerThread.start();
        TPUseTimeManager tPUseTimeManager3 = this;
        this.handler = new Handler(tPUseTimeManager3.handlerThread.getLooper()){

            public final void handleMessage(Message message) {
                super.handleMessage(message);
                switch (message.what) {
                    case 0: {
                        TPUseTimeManager.this.handler.removeCallbacks(TPUseTimeManager.this.timeRunnable);
                        if (TPUseTimeManager.this.startTime != 0L) break;
                        TPUseTimeManager.this.startTime = System.currentTimeMillis();
                        long l2 = TPUseTimeManager.this.getAppUsedTime();
                        if (l2 > 0L) {
                            TPUseTimeManager.this.startTime -= l2;
                        }
                        return;
                    }
                    case 1: {
                        TPUseTimeManager.this.saveAppUsedStartTime(System.currentTimeMillis() - TPUseTimeManager.this.startTime);
                        TPUseTimeManager.this.startTime = 0L;
                        TPUseTimeManager.this.handler.postDelayed(TPUseTimeManager.this.timeRunnable, (long)TPUseTimeManager.this.refreshTime);
                    }
                }
            }
        };
        this.startTime = System.currentTimeMillis();
        this.mSinglePool = Executors.newSingleThreadExecutor();
    }

    public void onResume() {
        if (!this.isTrackUseTimeAllow) {
            return;
        }
        this.handler.sendEmptyMessage(0);
    }

    public void onPause() {
        if (!this.isTrackUseTimeAllow) {
            return;
        }
        this.handler.sendEmptyMessage(1);
    }

    public void saveUseTimeRequest() {
        long l2 = this.getAppUsedTime();
        if (l2 == 0L) {
            return;
        }
        if (TPPushCenter.getInstance().isSimplify()) {
            SimplifyEvent simplifyEvent = new SimplifyEvent(PushMessageUtils.PushStatus.EV_REQ_APP_USED_TIME.getValue());
            simplifyEvent.setUse_time(String.valueOf(l2));
            TPPushCenter.getInstance().saveEvent(simplifyEvent);
            return;
        }
        UseTimeRequest useTimeRequest = new UseTimeRequest(GlobalTradPlus.getInstance().getContext(), PushMessageUtils.PushStatus.EV_REQ_APP_USED_TIME.getValue(), l2);
        TPPushCenter.getInstance().saveEvent(useTimeRequest);
    }

    public void saveAppUsedStartTime(long l2) {
        SPCacheUtil.putLong(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "usetime", l2);
    }

    public long getAppUsedTime() {
        return SPCacheUtil.getLong(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "usetime", 0L);
    }

    public void sendUseTimeRequest() {
        if (!this.isTrackUseTimeAllow || !TPPushCenter.getInstance().isEnable()) {
            return;
        }
        long l2 = this.getAppUsedTime();
        if (l2 == 0L) {
            return;
        }
        if (TPPushCenter.getInstance().isSimplify()) {
            final SimplifyEvent simplifyEvent = new SimplifyEvent(PushMessageUtils.PushStatus.EV_REQ_APP_USED_TIME.getValue());
            simplifyEvent.setUse_time(String.valueOf(l2));
            this.mSinglePool.execute(new Runnable(){

                @Override
                public final void run() {
                    TPUseTimeManager.this.pushSingleEvent(simplifyEvent, true);
                }
            });
            return;
        }
        final UseTimeRequest useTimeRequest = new UseTimeRequest(GlobalTradPlus.getInstance().getContext(), PushMessageUtils.PushStatus.EV_REQ_APP_USED_TIME.getValue(), l2);
        this.mSinglePool.execute(new Runnable(){

            @Override
            public final void run() {
                TPUseTimeManager.this.pushSingleEvent(useTimeRequest, false);
            }
        });
    }

    public void pushSingleEvent(Object object, boolean bl) {
        String string;
        if (!this.isTrackUseTimeAllow) {
            return;
        }
        JSONObject jSONObject = this.putHeaderData();
        if (bl) {
            if (jSONObject == null) {
                return;
            }
            string = new JSONArray();
            try {
                string.put((Object)new JSONObject(JSON.toJSONString(object)));
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            try {
                jSONObject.putOpt("cb", (Object)string);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        string = this.getEventUrl();
        object = bl ? jSONObject.toString() : TPUseTimeManager.pushSingleMessage(object);
        LogUtil.ownShow("eid 20 data = " + (String)object + " url = " + string);
        PushCenterHttpUtils.push(string, (String)object, new Listener(){

            @Override
            public final void onSuccess(BaseResponse baseResponse) {
                TPUseTimeManager.this.saveAppUsedStartTime(0L);
            }

            @Override
            public final void oError(int n2, String string) {
            }
        });
    }

    public static String pushSingleMessage(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[");
        stringBuilder.append(JSONHelper.toJSON(object));
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public JSONObject putHeaderData() {
        ClientMetadata clientMetadata = ClientMetadata.getInstance(GlobalTradPlus.getInstance().getContext());
        JSONObject jSONObject = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("suuid", UUID.randomUUID().toString());
        hashMap.put("did", clientMetadata.getUuId());
        hashMap.put("iso", clientMetadata.getIsoCountryCode());
        hashMap.put("app_id", TradPlus.getAppId());
        hashMap.put("package", clientMetadata.getAppPackageName());
        hashMap.put("sdk_ver", clientMetadata.getSdkVersion());
        hashMap.put("os", "1");
        hashMap.put("app_ver", clientMetadata.getAppVersion());
        hashMap.put("device_gaid", clientMetadata.getGaid());
        hashMap.put("device_oaid", clientMetadata.getOaid());
        hashMap.put("device_osv", clientMetadata.getDeviceOsVersion());
        try {
            jSONObject = new JSONObject(Json.mapToJsonString(hashMap));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return jSONObject;
    }

    private String getEventUrl() {
        String string = TPURLManager.getInstance().getTPEventUrl();
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = TPURLManager.getInstance().getTPEventUrl();
        }
        return string;
    }

    public boolean isTrackUseTimeAllow() {
        return this.isTrackUseTimeAllow;
    }

    public void setTrackUseTimeAllow(boolean bl) {
        this.isTrackUseTimeAllow = bl;
    }

    public void setRefreshTime(int n2) {
        this.refreshTime = n2;
    }
}

