/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.config;

import android.content.Context;
import android.text.TextUtils;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.db.StoreManager;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.mobileads.TradPlus;
import com.tradplus.ads.mobileads.util.TestDeviceUtil;
import com.tradplus.ads.network.FSOpenResponse;
import com.tradplus.ads.network.response.ConfigResponse;

public class TradPlusConfigUtils {
    private static TradPlusConfigUtils instance;
    private static boolean isTestModeByConfig;

    public static TradPlusConfigUtils getInstance() {
        if (instance == null) {
            instance = new TradPlusConfigUtils();
        }
        return instance;
    }

    public static boolean isIsTestModeByConfig() {
        return isTestModeByConfig;
    }

    public static void setIsTestModeByConfig(boolean bl) {
        if (bl) {
            StoreManager.clearConfigResponse();
            ConfigLoadManager.getInstance().clearConfigResponse();
        }
        isTestModeByConfig = bl;
    }

    public ConfigResponse getConfigByUnitId(String object) {
        if ((object = StoreManager.getLocalConfigResponse((String)object, true)) == null) {
            return null;
        }
        if ((TradPlus.isLocalDebugMode || TradPlusConfigUtils.isIsTestModeByConfig()) && !TestDeviceUtil.getInstance().isTools()) {
            return null;
        }
        return object;
    }

    public void setConfigByUnitId(Context context, String string, ConfigResponse configResponse) {
        StoreManager.saveConfigResponse(string, configResponse);
    }

    public FSOpenResponse getOpenByUnitId(Context object, int n2) {
        object = StoreManager.getLocalFSOpenResponse(true);
        if (TradPlus.isLocalDebugMode) {
            return null;
        }
        return object;
    }

    public void setOpenByUnitId(Context context, FSOpenResponse fSOpenResponse, int n2) {
        StoreManager.saveFSOpenResponse(fSOpenResponse);
    }

    private boolean checkConfigValid(ConfigResponse configResponse) {
        ConfigResponse.WaterfallBean waterfallBean;
        int n2;
        if (configResponse == null) {
            return false;
        }
        boolean bl = true;
        if (configResponse.getWaterfall() != null) {
            for (n2 = 0; n2 < configResponse.getWaterfall().size(); ++n2) {
                waterfallBean = configResponse.getWaterfall().get(n2);
                if (TextUtils.isEmpty((CharSequence)waterfallBean.getAdsource_placement_id())) {
                    bl = false;
                    break;
                }
                if (TextUtils.isEmpty((CharSequence)waterfallBean.getCustomClassName())) {
                    bl = false;
                    break;
                }
                if (waterfallBean.checkConfigVaild()) continue;
                bl = false;
                break;
            }
        }
        if (configResponse.getBiddingwaterfall() != null) {
            for (n2 = 0; n2 < configResponse.getBiddingwaterfall().size(); ++n2) {
                waterfallBean = configResponse.getBiddingwaterfall().get(n2);
                if (TextUtils.isEmpty((CharSequence)waterfallBean.getAdsource_placement_id())) {
                    bl = false;
                    break;
                }
                if (TextUtils.isEmpty((CharSequence)waterfallBean.getCustomClassName())) {
                    bl = false;
                    break;
                }
                if (waterfallBean.checkConfigVaild()) continue;
                bl = false;
                break;
            }
        }
        LogUtil.ownShow("save config to local = ".concat(String.valueOf(bl)));
        return bl;
    }
}

