/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.db;

import android.text.TextUtils;
import com.tradplus.ads.base.db.TableUtils;
import com.tradplus.ads.base.db.annotation.Column;
import java.lang.reflect.Field;

public final class ColumnEntity {
    private static final String PRIMARY_KEY = " primary key";
    private static final String AUTOINCREMENT = " autoincrement";
    private final String name;
    private final boolean isId;
    private final boolean isAutoId;
    private final String sql;

    ColumnEntity(Field field, Column column) {
        String string = null;
        if (column == null) {
            this.name = field.getName();
            this.isId = false;
            this.isAutoId = false;
        } else {
            this.name = TextUtils.isEmpty((CharSequence)column.name()) ? field.getName() : column.name();
            this.isId = column.isId();
            this.isAutoId = this.isId && column.autoGen();
            string = column.property();
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\"");
        stringBuilder.append(this.name);
        stringBuilder.append("\"");
        stringBuilder.append(" ");
        stringBuilder.append(TableUtils.getTypeText(field.getType()));
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(" default ");
            stringBuilder.append(string);
        }
        if (this.isId) {
            stringBuilder.append(PRIMARY_KEY);
            if (column.autoGen()) {
                stringBuilder.append(AUTOINCREMENT);
            }
        }
        this.sql = stringBuilder.toString();
    }

    public final String getName() {
        return this.name;
    }

    public final boolean isId() {
        return this.isId;
    }

    public final boolean isAutoId() {
        return this.isAutoId;
    }

    public final String getSql() {
        return this.sql;
    }
}

