/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.db.dao;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import android.os.Build;
import android.text.TextUtils;
import com.tradplus.ads.base.db.TableEntity;
import com.tradplus.ads.base.db.TableUtils;
import com.tradplus.ads.base.db.api.cache.Store;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;

public abstract class BaseDao<T>
implements Store<String, T> {
    private SQLiteDatabase db;
    protected String id_name;
    protected String table_name;

    public BaseDao() {
        this.table_name = "null";
        this.id_name = "null";
    }

    public BaseDao(SQLiteDatabase sQLiteDatabase) {
        Object object = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        object = new TableEntity((Class)object);
        ((TableEntity)object).createTableIfNotExists(sQLiteDatabase);
        this.db = sQLiteDatabase;
        this.table_name = ((TableEntity)object).getName();
        this.id_name = ((TableEntity)object).getId().getName();
    }

    @Override
    public void save(T ... TArray) {
        if (TArray == null || TArray.length == 0) {
            return;
        }
        if (TArray.length == 1) {
            try {
                this.db.replace(this.table_name, null, this.convert(TArray[0]));
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        try {
            this.beginTransaction();
            SQLiteStatement sQLiteStatement = this.db.compileStatement(this.createInsertStateMentSql());
            int n2 = TArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.bindStateMent(sQLiteStatement, TArray[i2]);
                sQLiteStatement.executeInsert();
            }
            this.setTransactionSuccessful();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
        finally {
            this.endTransaction();
        }
    }

    public void update(T ... TArray) {
        if (TArray == null || TArray.length == 0) {
            return;
        }
        if (TArray.length == 1) {
            try {
                this.db.insertWithOnConflict(this.table_name, null, this.convert(TArray[0]), 5);
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        try {
            this.beginTransaction();
            SQLiteStatement sQLiteStatement = this.db.compileStatement(this.createUpdateStatementSql());
            int n2 = TArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                this.bindUpdateStatement(sQLiteStatement, TArray[i2]);
                sQLiteStatement.executeUpdateDelete();
            }
            this.setTransactionSuccessful();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public T get(String string) {
        T t2;
        Cursor cursor;
        block4: {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return null;
            }
            cursor = null;
            t2 = null;
            try {
                cursor = this.db.query(this.table_name, null, this.id_name + "=?", new String[]{string}, null, null, null, "1");
                if (!cursor.moveToNext()) break block4;
                t2 = this.parseCursor(cursor);
            }
            catch (Throwable throwable) {
                TableUtils.closeCursor(cursor);
            }
            catch (Throwable throwable) {
                TableUtils.closeCursor(cursor);
                throw throwable;
            }
        }
        TableUtils.closeCursor(cursor);
        return t2;
    }

    @Override
    public List<T> getList(int n2) {
        String string = null;
        if (n2 > 0) {
            string = String.valueOf(n2);
        }
        Cursor cursor = null;
        ArrayList<T> arrayList = new ArrayList<T>();
        try {
            cursor = this.db.query(this.table_name, null, null, null, null, null, null, string);
            while (cursor.moveToNext()) {
                arrayList.add(this.parseCursor(cursor));
            }
        }
        catch (Throwable throwable) {
            TableUtils.closeCursor(cursor);
        }
        catch (Throwable throwable) {
            TableUtils.closeCursor(cursor);
            throw throwable;
        }
        TableUtils.closeCursor(cursor);
        return arrayList;
    }

    @Override
    public int count() {
        Cursor cursor = null;
        int n2 = 0;
        try {
            cursor = this.db.query(this.table_name, new String[]{"count(*)"}, null, null, null, null, null, null);
            cursor.moveToNext();
            n2 = cursor.getInt(0);
        }
        catch (Throwable throwable) {
            TableUtils.closeCursor(cursor);
        }
        catch (Throwable throwable) {
            TableUtils.closeCursor(cursor);
            throw throwable;
        }
        TableUtils.closeCursor(cursor);
        return n2;
    }

    public void delete(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        if (stringArray.length == 1) {
            try {
                this.db.delete(this.table_name, this.id_name + "=?", new String[]{stringArray[0]});
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
        try {
            this.beginTransaction();
            SQLiteStatement sQLiteStatement = this.db.compileStatement("delete from " + this.table_name + " where " + this.id_name + "=?");
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                sQLiteStatement.bindString(1, stringArray[i2]);
                sQLiteStatement.execute();
            }
            this.setTransactionSuccessful();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
        finally {
            this.endTransaction();
        }
    }

    @Override
    public void clear() {
        try {
            this.db.execSQL("delete from " + this.table_name);
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private void beginTransaction() {
        try {
            if (Build.VERSION.SDK_INT >= 16 && this.db.isWriteAheadLoggingEnabled()) {
                this.db.beginTransactionNonExclusive();
                return;
            }
            this.db.beginTransaction();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private void setTransactionSuccessful() {
        try {
            this.db.setTransactionSuccessful();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    private void endTransaction() {
        try {
            this.db.endTransaction();
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    protected String safeText(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        return string;
    }

    protected abstract String getId(T var1);

    protected abstract T parseCursor(Cursor var1);

    protected abstract ContentValues convert(T var1);

    protected abstract String createInsertStateMentSql();

    protected abstract void bindStateMent(SQLiteStatement var1, T var2);

    protected abstract String createUpdateStatementSql();

    protected abstract void bindUpdateStatement(SQLiteStatement var1, T var2);
}

