/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.event.push;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.TPDiskManager;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.common.TPURLManager;
import com.tradplus.ads.base.event.timer.TPEventTimer;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.pushcenter.http.Listener;
import com.tradplus.ads.pushcenter.http.PushCenterHttpUtils;
import com.tradplus.ads.pushcenter.response.BaseResponse;

public abstract class EventBasePushUtil {
    public abstract String getPushUrl();

    public abstract void removeEvent(String ... var1);

    public abstract void saveEvent(Object var1);

    public abstract void setEventTime(Object var1);

    public abstract String getLogType();

    public abstract Pair<String[], String[]> getEvents(int var1);

    private String getEventUrl() {
        String string = this.getPushUrl();
        if (TextUtils.isEmpty((CharSequence)string)) {
            string = TPURLManager.getInstance().getTPEventUrl();
        }
        return string;
    }

    private boolean isNetworkAvailable() {
        Context context = GlobalTradPlus.getInstance().getContext();
        if (context == null) {
            return false;
        }
        return DeviceUtils.isNetworkAvailable(context);
    }

    public void pushEvent(int n2) {
        if (!this.isNetworkAvailable()) {
            TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
            return;
        }
        try {
            final Pair<String[], String[]> pair = this.getEvents(n2);
            if (pair == null || pair.first == null || pair.second == null) {
                return;
            }
            PushCenterHttpUtils.pushMessageArray(this.getEventUrl(), (String[])pair.second, new Listener(){

                @Override
                public final void onSuccess(BaseResponse baseResponse) {
                    LogUtil.ownShow("push Event success", EventBasePushUtil.this.getLogType());
                    TPTaskManager.getInstance().fastRun(new Runnable(){

                        @Override
                        public final void run() {
                            EventBasePushUtil.this.removeEvent((String[])pair.first);
                            TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
                        }
                    });
                    TPEventTimer.getInstance().initUploadEventFailedNum();
                }

                @Override
                public final void oError(int n2, String string) {
                    LogUtil.ownShow("push failed", EventBasePushUtil.this.getLogType());
                    TPEventTimer.getInstance().setUploadEventFailedNum();
                    TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
                }
            });
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void pushSingleEvent(final Object object) {
        if (!this.isNetworkAvailable()) {
            TPTaskManager.getInstance().fastRun(new Runnable(){

                @Override
                public final void run() {
                    TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
                    EventBasePushUtil.this.saveEvent(object);
                }
            });
            return;
        }
        this.setEventTime(object);
        PushCenterHttpUtils.pushSingleMessage(this.getEventUrl(), object, new Listener(){

            @Override
            public final void onSuccess(BaseResponse baseResponse) {
                TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
                LogUtil.ownShow("push Single Event success", EventBasePushUtil.this.getLogType());
                TPEventTimer.getInstance().initUploadEventFailedNum();
            }

            @Override
            public final void oError(int n2, String string) {
                LogUtil.ownShow("push single failed", EventBasePushUtil.this.getLogType());
                TPTaskManager.getInstance().fastRun(new Runnable(){

                    @Override
                    public final void run() {
                        TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
                        EventBasePushUtil.this.saveEvent(object);
                    }
                });
            }
        });
    }
}

