/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.event.push;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.TPError;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.event.TPMessageUtils;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.pushcenter.event.request.EventShowEndRequest;
import com.tradplus.ads.pushcenter.http.Listener;
import com.tradplus.ads.pushcenter.http.PushCenterHttpUtils;
import com.tradplus.ads.pushcenter.response.BaseResponse;

public class TrackPushUtil {
    public static void pushTrack(int n2) {
        if (!TrackPushUtil.isNetworkAvailable()) {
            return;
        }
        Context context = GlobalTradPlus.getInstance().getContext();
        if (context == null) {
            return;
        }
        Pair<String[], EventShowEndRequest[]> pair = TPMessageUtils.getTrackUrlAndMessage(context, n2);
        if (pair != null) {
            int n3 = ((String[])pair.first).length;
            for (int i2 = 0; i2 < n3; ++i2) {
                if (TextUtils.isEmpty((CharSequence)((String[])pair.first)[i2])) continue;
                if (((EventShowEndRequest[])pair.second)[i2] == null) {
                    TrackPushUtil.removeTrackAndMessage(((String[])pair.first)[i2]);
                    continue;
                }
                TrackPushUtil.pushTracks(((String[])pair.first)[i2].split("@")[0], ((EventShowEndRequest[])pair.second)[i2]);
            }
        }
    }

    public static void removeTrackAndMessage(final String string) {
        TPTaskManager.getInstance().fastRun(new Runnable(){

            @Override
            public final void run() {
                TPMessageUtils.removeTracks(string);
            }
        });
    }

    public static void pushTracks(final String string, final EventShowEndRequest eventShowEndRequest) {
        if (eventShowEndRequest == null || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        LogUtil.ownShow("pushTrackMessage url=".concat(String.valueOf(string)));
        final String string2 = string + "@" + eventShowEndRequest.getSuuid();
        LogUtil.ownShow("pushTrackMessage eventShowEndRequest event.getSuuid()=".concat(String.valueOf(string2)));
        PushCenterHttpUtils.pushGet(string, new Listener(){

            @Override
            public final void onSuccess(BaseResponse baseResponse) {
                LogUtil.ownShow("pushTrackMessage onSuccess url = " + string);
                LogUtil.ownShow("pushTrackMessage getStatusCode = " + baseResponse.getStatusCode());
                eventShowEndRequest.setError_code("1");
                TPTaskManager.getInstance().fastRun(new Runnable(){

                    @Override
                    public final void run() {
                        TPMessageUtils.saveCrossEvent(eventShowEndRequest);
                        TPMessageUtils.removeTracks(string2);
                    }
                });
            }

            @Override
            public final void oError(final int n2, String string3) {
                TPTaskManager.getInstance().fastRun(new Runnable(){

                    @Override
                    public final void run() {
                        EventShowEndRequest eventShowEndRequest = TPMessageUtils.getTrackMessage(string2);
                        if (eventShowEndRequest != null) {
                            if (eventShowEndRequest.getTrack_count() > 3) {
                                LogUtil.ownShow("pushTrackMessage getTrack_count = " + eventShowEndRequest.getTrack_count());
                                eventShowEndRequest.setError_code(TrackPushUtil.pareError(n2));
                                TPMessageUtils.saveCrossEvent(eventShowEndRequest);
                                TPMessageUtils.removeTracks(string2);
                                return;
                            }
                            EventShowEndRequest eventShowEndRequest2 = eventShowEndRequest;
                            eventShowEndRequest2.setTrack_count(eventShowEndRequest2.getTrack_count() + 1);
                            LogUtil.ownShow("pushTrackMessage getTrack_count = " + eventShowEndRequest.getTrack_count());
                            TPMessageUtils.saveTrackMessage(string2, eventShowEndRequest);
                            return;
                        }
                        TPMessageUtils.saveTrackMessage(string2, eventShowEndRequest);
                    }
                });
            }
        });
    }

    private static boolean isNetworkAvailable() {
        Context context = GlobalTradPlus.getInstance().getContext();
        if (context == null) {
            return false;
        }
        return DeviceUtils.isNetworkAvailable(context);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static String pareError(int n2) {
        if (n2 > 0) {
            if (!TrackPushUtil.isNetworkAvailable()) {
                ((TPError)null).setTpErrorCode("No internet connection detected.");
                return ((TPError)null).getTpErrorCode();
            }
        } else if (n2 >= 400) {
            ((TPError)null).setTpErrorCode("Unable to connect to TradPlus adserver.");
            return ((TPError)null).getTpErrorCode();
        }
        ((TPError)null).setTpErrorCode("Unspecified error.");
        return ((TPError)null).getTpErrorCode();
    }
}

