/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common;

import android.content.Context;
import android.os.AsyncTask;
import com.tradplus.ads.common.DiskLruCache;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.util.CMData;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Streams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CacheService {
    private static DiskLruCache a;

    public static boolean initializeDiskCache(Context object) {
        if (object == null) {
            return false;
        }
        if (a == null) {
            if ((object = CacheService.getDiskCacheDirectory(object)) == null) {
                return false;
            }
            long l2 = DeviceUtils.diskCacheSizeBytes((File)object);
            try {
                a = DiskLruCache.open((File)object, 1, 1, l2);
            }
            catch (IOException iOException) {
                LogUtil.show("Unable to create DiskLruCache", iOException);
                return false;
            }
        }
        return true;
    }

    public static void initialize(Context context) {
        CacheService.initializeDiskCache(context);
    }

    public static String createValidDiskCacheKey(String string) {
        return CMData.getS256(string);
    }

    public static File getDiskCacheDirectory(Context object) {
        if ((object = object.getCacheDir()) == null) {
            return null;
        }
        object = ((File)object).getPath();
        return new File((String)object + File.separator + "flute-cache");
    }

    public static boolean containsKeyDiskCache(String string) {
        if (a == null) {
            return false;
        }
        try {
            return a.get(CacheService.createValidDiskCacheKey(string)) != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String getFilePathDiskCache(String string) {
        if (a == null) {
            return null;
        }
        return a.getDirectory() + File.separator + CacheService.createValidDiskCacheKey(string) + ".0";
    }

    public static byte[] getFromDiskCache(String object) {
        byte[] byArray;
        block12: {
            if (a == null) {
                return null;
            }
            byArray = null;
            try (DiskLruCache.Snapshot snapshot = null;){
                snapshot = a.get(CacheService.createValidDiskCacheKey((String)object));
                if (snapshot == null) {
                    return null;
                }
                object = snapshot.getInputStream(0);
                if (object == null) break block12;
                byArray = new byte[(int)snapshot.getLength(0)];
                object = new BufferedInputStream((InputStream)object);
                try {
                    Streams.readStream((InputStream)object, byArray);
                }
                finally {
                    Streams.closeStream((Closeable)object);
                }
            }
        }
        return byArray;
    }

    public static void getFromDiskCacheAsync(String string, DiskLruCacheGetListener diskLruCacheGetListener) {
        new a(string, diskLruCacheGetListener).execute(new Void[0]);
    }

    public static boolean putToDiskCache(String string, byte[] byArray) {
        return CacheService.putToDiskCache(string, new ByteArrayInputStream(byArray));
    }

    public static boolean putToDiskCache(String object, InputStream inputStream) {
        if (a == null) {
            return false;
        }
        DiskLruCache.Editor editor = null;
        try {
            editor = a.edit(CacheService.createValidDiskCacheKey((String)object));
            if (editor == null) {
                return false;
            }
            object = new BufferedOutputStream(editor.newOutputStream(0));
            Streams.copyContent(inputStream, (OutputStream)object);
            ((OutputStream)object).flush();
            ((OutputStream)object).close();
            a.flush();
            editor.commit();
        }
        catch (Exception exception) {
            LogUtil.show("Unable to put to DiskLruCache", exception);
            try {
                if (editor != null) {
                    editor.abort();
                }
            }
            catch (IOException iOException) {}
            return false;
        }
        return true;
    }

    public static void putToDiskCacheAsync(String string, byte[] byArray) {
        new b(string, byArray).execute(new Void[0]);
    }

    @Deprecated
    @VisibleForTesting
    public static void clearAndNullCaches() {
        if (a != null) {
            try {
                a.delete();
                a = null;
                return;
            }
            catch (IOException iOException) {
                a = null;
            }
        }
    }

    @Deprecated
    @VisibleForTesting
    public static DiskLruCache getDiskLruCache() {
        return a;
    }

    static final class b
    extends AsyncTask<Void, Void, Void> {
        private final String a;
        private final byte[] b;

        b(String string, byte[] byArray) {
            this.a = string;
            this.b = byArray;
        }

        protected final /* synthetic */ Object doInBackground(Object[] object) {
            object = this;
            CacheService.putToDiskCache(object.a, object.b);
            return null;
        }
    }

    static final class a
    extends AsyncTask<Void, Void, byte[]> {
        private final DiskLruCacheGetListener a;
        private final String b;

        a(String string, DiskLruCacheGetListener diskLruCacheGetListener) {
            this.a = diskLruCacheGetListener;
            this.b = string;
        }

        protected final void onCancelled() {
            if (this.a != null) {
                this.a.onComplete(this.b, null);
            }
        }

        protected final /* synthetic */ void onPostExecute(Object object) {
            byte[] byArray = (byte[])object;
            object = this;
            if (object.isCancelled()) {
                ((a)((Object)object)).onCancelled();
                return;
            }
            if (((a)((Object)object)).a != null) {
                ((a)((Object)object)).a.onComplete(((a)((Object)object)).b, byArray);
            }
        }

        protected final /* synthetic */ Object doInBackground(Object[] objectArray) {
            return CacheService.getFromDiskCache(this.b);
        }
    }

    public static interface DiskLruCacheGetListener {
        public void onComplete(String var1, byte[] var2);
    }
}

