/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.common.serialization.util;

import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.JSONArray;
import com.tradplus.ads.common.serialization.JSONException;
import com.tradplus.ads.common.serialization.JSONObject;
import com.tradplus.ads.common.serialization.JSONPObject;
import com.tradplus.ads.common.serialization.PropertyNamingStrategy;
import com.tradplus.ads.common.serialization.annotation.JSONField;
import com.tradplus.ads.common.serialization.annotation.JSONType;
import com.tradplus.ads.common.serialization.parser.DefaultJSONParser;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.serialization.parser.JSONLexerBase;
import com.tradplus.ads.common.serialization.parser.JSONScanner;
import com.tradplus.ads.common.serialization.parser.ParserConfig;
import com.tradplus.ads.common.serialization.parser.deserializer.EnumDeserializer;
import com.tradplus.ads.common.serialization.parser.deserializer.JavaBeanDeserializer;
import com.tradplus.ads.common.serialization.serializer.CalendarCodec;
import com.tradplus.ads.common.serialization.serializer.SerializeBeanInfo;
import com.tradplus.ads.common.serialization.serializer.SerializerFeature;
import com.tradplus.ads.common.serialization.util.FieldInfo;
import com.tradplus.ads.common.serialization.util.GenericArrayTypeImpl;
import com.tradplus.ads.common.serialization.util.IOUtils;
import com.tradplus.ads.common.serialization.util.IdentityHashMap;
import com.tradplus.ads.common.serialization.util.ParameterizedTypeImpl;
import java.io.InputStream;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessControlException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TypeUtils {
    private static final Pattern a = Pattern.compile("\\.0*$");
    public static boolean compatibleWithJavaBean = false;
    public static boolean compatibleWithFieldName = false;
    private static boolean b = true;
    private static boolean c = false;
    private static Method d;
    private static boolean e;
    private static Method f;
    private static boolean g;
    private static Class<?> h;
    private static boolean i;
    private static Class<? extends Annotation> j;
    private static Class<? extends Annotation> k;
    private static boolean l;
    private static Class<? extends Annotation> m;
    private static boolean n;
    private static Method o;
    private static boolean p;
    private static volatile Class q;
    private static volatile boolean r;
    private static volatile boolean s;
    private static volatile Constructor t;
    private static volatile Method u;
    private static volatile Method v;
    private static volatile Method w;
    private static volatile boolean x;
    private static volatile Map<Class, String[]> y;
    private static volatile boolean z;
    private static ConcurrentMap<String, Class<?>> A;
    private static Class<?> B;
    private static boolean C;
    private static Class<? extends Annotation> D;
    private static boolean E;
    private static volatile Class F;
    private static volatile boolean G;
    private static volatile Class H;
    private static volatile Class I;
    private static volatile boolean J;
    private static volatile Method K;
    private static volatile Field L;
    private static volatile Object M;
    private static Class N;

    public static boolean isXmlField(Class clazz) {
        if (I == null && !J) {
            try {
                I = Class.forName("javax.xml.bind.annotation.XmlAccessorType");
            }
            catch (Throwable throwable) {
                J = true;
            }
        }
        if (I == null) {
            return false;
        }
        if ((clazz = TypeUtils.getAnnotation(clazz, I)) == null) {
            return false;
        }
        if (K == null && !J) {
            try {
                K = I.getMethod("value", new Class[0]);
            }
            catch (Throwable throwable) {
                J = true;
            }
        }
        if (K == null) {
            return false;
        }
        Object object = null;
        if (!J) {
            try {
                object = K.invoke((Object)clazz, new Object[0]);
            }
            catch (Throwable throwable) {
                J = true;
            }
        }
        if (object == null) {
            return false;
        }
        if (H == null && !J) {
            try {
                H = Class.forName("javax.xml.bind.annotation.XmlAccessType");
                L = H.getField("FIELD");
                M = L.get(null);
            }
            catch (Throwable throwable) {
                J = true;
            }
        }
        return object == M;
    }

    public static Annotation getXmlAccessorType(Class clazz) {
        if (I == null && !J) {
            try {
                I = Class.forName("javax.xml.bind.annotation.XmlAccessorType");
            }
            catch (Throwable throwable) {
                J = true;
            }
        }
        if (I == null) {
            return null;
        }
        return TypeUtils.getAnnotation(clazz, I);
    }

    public static boolean isClob(Class clazz) {
        if (F == null && !G) {
            try {
                F = Class.forName("java.sql.Clob");
            }
            catch (Throwable throwable) {
                G = true;
            }
        }
        if (F == null) {
            return false;
        }
        return F.isAssignableFrom(clazz);
    }

    public static String castToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static Byte castToByte(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return TypeUtils.byteValue((BigDecimal)object);
        }
        if (object instanceof Number) {
            return ((Number)object).byteValue();
        }
        if (object instanceof String) {
            if (((String)(object = (String)object)).length() == 0 || "null".equals(object) || "NULL".equals(object)) {
                return null;
            }
            return Byte.parseByte((String)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? (byte)1 : 0;
        }
        throw new JSONException("can not cast to byte, value : ".concat(String.valueOf(object)));
    }

    public static Character castToChar(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Character) {
            return (Character)object;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0) {
                return null;
            }
            if (string.length() != 1) {
                throw new JSONException("can not cast to char, value : ".concat(String.valueOf(object)));
            }
            return Character.valueOf(string.charAt(0));
        }
        throw new JSONException("can not cast to char, value : ".concat(String.valueOf(object)));
    }

    public static Short castToShort(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return TypeUtils.shortValue((BigDecimal)object);
        }
        if (object instanceof Number) {
            return ((Number)object).shortValue();
        }
        if (object instanceof String) {
            if (((String)(object = (String)object)).length() == 0 || "null".equals(object) || "NULL".equals(object)) {
                return null;
            }
            return Short.parseShort((String)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? (short)1 : 0;
        }
        throw new JSONException("can not cast to short, value : ".concat(String.valueOf(object)));
    }

    public static BigDecimal castToBigDecimal(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Float) {
            if (Float.isNaN(((Float)object).floatValue()) || Float.isInfinite(((Float)object).floatValue())) {
                return null;
            }
        } else if (object instanceof Double) {
            if (Double.isNaN((Double)object) || Double.isInfinite((Double)object)) {
                return null;
            }
        } else {
            if (object instanceof BigDecimal) {
                return (BigDecimal)object;
            }
            if (object instanceof BigInteger) {
                return new BigDecimal((BigInteger)object);
            }
            if (object instanceof Map && ((Map)object).size() == 0) {
                return null;
            }
        }
        if (((String)(object = object.toString())).length() == 0 || ((String)object).equalsIgnoreCase("null")) {
            return null;
        }
        if (((String)object).length() > 65535) {
            throw new JSONException("decimal overflow");
        }
        return new BigDecimal((String)object);
    }

    public static BigInteger castToBigInteger(Object object) {
        int n2;
        if (object == null) {
            return null;
        }
        if (object instanceof Float) {
            Float f2 = (Float)object;
            if (Float.isNaN(f2.floatValue()) || Float.isInfinite(f2.floatValue())) {
                return null;
            }
            return BigInteger.valueOf(f2.longValue());
        }
        if (object instanceof Double) {
            Double d2 = (Double)object;
            if (Double.isNaN(d2) || Double.isInfinite(d2)) {
                return null;
            }
            return BigInteger.valueOf(d2.longValue());
        }
        if (object instanceof BigInteger) {
            return (BigInteger)object;
        }
        if (object instanceof BigDecimal && (n2 = ((BigDecimal)object).scale()) > -1000 && n2 < 1000) {
            return ((BigDecimal)object).toBigInteger();
        }
        String string = object.toString();
        if (string.length() == 0 || string.equalsIgnoreCase("null")) {
            return null;
        }
        if (string.length() > 65535) {
            throw new JSONException("decimal overflow");
        }
        return new BigInteger(string);
    }

    public static Float castToFloat(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return Float.valueOf(((Number)object).floatValue());
        }
        if (object instanceof String) {
            if (((String)(object = object.toString())).length() == 0 || "null".equals(object) || "NULL".equals(object)) {
                return null;
            }
            if (((String)object).indexOf(44) != -1) {
                object = ((String)object).replaceAll(",", "");
            }
            return Float.valueOf(Float.parseFloat((String)object));
        }
        if (object instanceof Boolean) {
            return Float.valueOf((Boolean)object != false ? 1.0f : 0.0f);
        }
        throw new JSONException("can not cast to float, value : ".concat(String.valueOf(object)));
    }

    public static Double castToDouble(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Number) {
            return ((Number)object).doubleValue();
        }
        if (object instanceof String) {
            if (((String)(object = object.toString())).length() == 0 || "null".equals(object) || "NULL".equals(object)) {
                return null;
            }
            if (((String)object).indexOf(44) != -1) {
                object = ((String)object).replaceAll(",", "");
            }
            return Double.parseDouble((String)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1.0 : 0.0;
        }
        throw new JSONException("can not cast to double, value : ".concat(String.valueOf(object)));
    }

    public static Date castToDate(Object object) {
        return TypeUtils.castToDate(object, null);
    }

    public static Date castToDate(Object object, String string) {
        Object object2;
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Calendar) {
            return ((Calendar)object).getTime();
        }
        long l2 = -1L;
        if (object instanceof BigDecimal) {
            l2 = TypeUtils.longValue((BigDecimal)object);
            return new Date(l2);
        }
        if (object instanceof Number) {
            l2 = ((Number)object).longValue();
            if ("unixtime".equals(string)) {
                l2 *= 1000L;
            }
            return new Date(l2);
        }
        if (object instanceof String) {
            String string2 = (String)object;
            object2 = new JSONScanner(string2);
            try {
                if (((JSONScanner)object2).scanISO8601DateIfMatch(false)) {
                    object = ((JSONLexerBase)object2).getCalendar().getTime();
                    return object;
                }
            }
            finally {
                ((JSONLexerBase)object2).close();
            }
            if (string2.startsWith("/Date(") && string2.endsWith(")/")) {
                string2 = string2.substring(6, string2.length() - 2);
            }
            if (string2.indexOf(45) > 0 || string2.indexOf(43) > 0 || string != null) {
                if (string == null) {
                    string = string2.length() == JSON.DEFFAULT_DATE_FORMAT.length() || string2.length() == 22 && JSON.DEFFAULT_DATE_FORMAT.equals("yyyyMMddHHmmssSSSZ") ? JSON.DEFFAULT_DATE_FORMAT : (string2.length() == 10 ? "yyyy-MM-dd" : (string2.length() == 19 ? "yyyy-MM-dd HH:mm:ss" : (string2.length() == 29 && string2.charAt(26) == ':' && string2.charAt(28) == '0' ? "yyyy-MM-dd'T'HH:mm:ss.SSSXXX" : (string2.length() == 23 && string2.charAt(19) == ',' ? "yyyy-MM-dd HH:mm:ss,SSS" : "yyyy-MM-dd HH:mm:ss.SSS"))));
                }
                object = new SimpleDateFormat(string, JSON.defaultLocale);
                ((DateFormat)object).setTimeZone(JSON.defaultTimeZone);
                try {
                    return ((DateFormat)object).parse(string2);
                }
                catch (ParseException parseException) {
                    throw new JSONException("can not cast to Date, value : ".concat(String.valueOf(string2)));
                }
            }
            if (string2.length() == 0) {
                return null;
            }
            l2 = Long.parseLong(string2);
        }
        if (l2 == -1L) {
            Class<?> clazz = object.getClass();
            if ("oracle.sql.TIMESTAMP".equals(clazz.getName())) {
                if (d == null && !c) {
                    try {
                        d = clazz.getMethod("toJdbc", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    finally {
                        c = true;
                    }
                }
                try {
                    object2 = d.invoke(object, new Object[0]);
                }
                catch (Exception exception) {
                    throw new JSONException("can not cast oracle.sql.TIMESTAMP to Date", exception);
                }
                return (Date)object2;
            }
            if ("oracle.sql.DATE".equals(clazz.getName())) {
                if (f == null && !e) {
                    try {
                        f = clazz.getMethod("toJdbc", new Class[0]);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                    finally {
                        e = true;
                    }
                }
                try {
                    object2 = f.invoke(object, new Object[0]);
                }
                catch (Exception exception) {
                    throw new JSONException("can not cast oracle.sql.DATE to Date", exception);
                }
                return (Date)object2;
            }
            throw new JSONException("can not cast to Date, value : ".concat(String.valueOf(object)));
        }
        return new Date(l2);
    }

    public static java.sql.Date castToSqlDate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof java.sql.Date) {
            return (java.sql.Date)object;
        }
        if (object instanceof Date) {
            return new java.sql.Date(((Date)object).getTime());
        }
        if (object instanceof Calendar) {
            return new java.sql.Date(((Calendar)object).getTimeInMillis());
        }
        long l2 = 0L;
        if (object instanceof BigDecimal) {
            l2 = TypeUtils.longValue((BigDecimal)object);
        } else if (object instanceof Number) {
            l2 = ((Number)object).longValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0 || "null".equals(string) || "NULL".equals(string)) {
                return null;
            }
            if (TypeUtils.isNumber(string)) {
                l2 = Long.parseLong(string);
            } else {
                JSONScanner jSONScanner = new JSONScanner(string);
                if (jSONScanner.scanISO8601DateIfMatch(false)) {
                    l2 = jSONScanner.getCalendar().getTime().getTime();
                } else {
                    throw new JSONException("can not cast to Timestamp, value : ".concat(String.valueOf(string)));
                }
            }
        }
        if (l2 <= 0L) {
            throw new JSONException("can not cast to Date, value : ".concat(String.valueOf(object)));
        }
        return new java.sql.Date(l2);
    }

    public static long longExtractValue(Number number) {
        if (number instanceof BigDecimal) {
            return ((BigDecimal)number).longValueExact();
        }
        return number.longValue();
    }

    public static Time castToSqlTime(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof Date) {
            return new Time(((Date)object).getTime());
        }
        if (object instanceof Calendar) {
            return new Time(((Calendar)object).getTimeInMillis());
        }
        long l2 = 0L;
        if (object instanceof BigDecimal) {
            l2 = TypeUtils.longValue((BigDecimal)object);
        } else if (object instanceof Number) {
            l2 = ((Number)object).longValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0 || "null".equalsIgnoreCase(string)) {
                return null;
            }
            if (TypeUtils.isNumber(string)) {
                l2 = Long.parseLong(string);
            } else {
                JSONScanner jSONScanner = new JSONScanner(string);
                if (jSONScanner.scanISO8601DateIfMatch(false)) {
                    l2 = jSONScanner.getCalendar().getTime().getTime();
                } else {
                    throw new JSONException("can not cast to Timestamp, value : ".concat(String.valueOf(string)));
                }
            }
        }
        if (l2 <= 0L) {
            throw new JSONException("can not cast to Date, value : ".concat(String.valueOf(object)));
        }
        return new Time(l2);
    }

    public static Timestamp castToTimestamp(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Calendar) {
            return new Timestamp(((Calendar)object).getTimeInMillis());
        }
        if (object instanceof Timestamp) {
            return (Timestamp)object;
        }
        if (object instanceof Date) {
            return new Timestamp(((Date)object).getTime());
        }
        long l2 = 0L;
        if (object instanceof BigDecimal) {
            l2 = TypeUtils.longValue((BigDecimal)object);
        } else if (object instanceof Number) {
            l2 = ((Number)object).longValue();
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0 || "null".equals(string) || "NULL".equals(string)) {
                return null;
            }
            if (string.endsWith(".000000000")) {
                string = string.substring(0, string.length() - 10);
            } else if (string.endsWith(".000000")) {
                string = string.substring(0, string.length() - 7);
            }
            if (string.length() == 29 && string.charAt(4) == '-' && string.charAt(7) == '-' && string.charAt(10) == ' ' && string.charAt(13) == ':' && string.charAt(16) == ':' && string.charAt(19) == '.') {
                char c2 = string.charAt(3);
                char c3 = string.charAt(2);
                char c4 = string.charAt(1);
                char c5 = string.charAt(0);
                int n2 = c5 >= '0' && c5 <= '9' && c4 >= '0' && c4 <= '9' && c3 >= '0' && c3 <= '9' && c2 >= '0' && c2 <= '9' ? (c5 - 48) * 1000 + (c4 - 48) * 100 + (c3 - 48) * 10 + (c2 - 48) : -1;
                int n3 = TypeUtils.a(string.charAt(5), string.charAt(6));
                int n4 = TypeUtils.a(string.charAt(8), string.charAt(9));
                int n5 = TypeUtils.a(string.charAt(11), string.charAt(12));
                int n6 = TypeUtils.a(string.charAt(14), string.charAt(15));
                int n7 = TypeUtils.a(string.charAt(17), string.charAt(18));
                char c6 = string.charAt(28);
                char c7 = string.charAt(27);
                char c8 = string.charAt(26);
                char c9 = string.charAt(25);
                int n8 = string.charAt(24);
                c2 = string.charAt(23);
                c3 = string.charAt(22);
                c4 = string.charAt(21);
                c5 = string.charAt(20);
                n8 = c5 >= '0' && c5 <= '9' && c4 >= '0' && c4 <= '9' && c3 >= '0' && c3 <= '9' && c2 >= '0' && c2 <= '9' && n8 >= 48 && n8 <= 57 && c9 >= '0' && c9 <= '9' && c8 >= '0' && c8 <= '9' && c7 >= '0' && c7 <= '9' && c6 >= '0' && c6 <= '9' ? (c5 - 48) * 100000000 + (c4 - 48) * 10000000 + (c3 - 48) * 1000000 + (c2 - 48) * 100000 + (n8 - 48) * 10000 + (c9 - 48) * 1000 + (c8 - 48) * 100 + (c7 - 48) * 10 + (c6 - 48) : -1;
                return new Timestamp(n2 - 1900, n3 - 1, n4, n5, n6, n7, n8);
            }
            if (TypeUtils.isNumber(string)) {
                l2 = Long.parseLong(string);
            } else {
                JSONScanner jSONScanner = new JSONScanner(string);
                if (jSONScanner.scanISO8601DateIfMatch(false)) {
                    l2 = jSONScanner.getCalendar().getTime().getTime();
                } else {
                    throw new JSONException("can not cast to Timestamp, value : ".concat(String.valueOf(string)));
                }
            }
        }
        if (l2 < 0L) {
            throw new JSONException("can not cast to Timestamp, value : ".concat(String.valueOf(object)));
        }
        return new Timestamp(l2);
    }

    private static int a(char c2, char c3) {
        if (c2 >= '0' && c2 <= '9' && c3 >= '0' && c3 <= '9') {
            return (c2 - 48) * 10 + (c3 - 48);
        }
        return -1;
    }

    public static boolean isNumber(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!(c2 == '+' || c2 == '-' ? i2 != 0 : c2 < '0' || c2 > '9')) continue;
            return false;
        }
        return true;
    }

    public static Long castToLong(Object object) {
        while (true) {
            Object object2;
            block11: {
                if (object == null) {
                    return null;
                }
                if (object instanceof BigDecimal) {
                    return TypeUtils.longValue((BigDecimal)object);
                }
                if (object instanceof Number) {
                    return ((Number)object).longValue();
                }
                if (object instanceof String) {
                    object2 = (String)object;
                    if (((String)object2).length() == 0 || "null".equals(object2) || "NULL".equals(object2)) {
                        return null;
                    }
                    if (((String)object2).indexOf(44) != -1) {
                        object2 = ((String)object2).replaceAll(",", "");
                    }
                    try {
                        return Long.parseLong((String)object2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        object2 = new JSONScanner((String)object2);
                        Calendar calendar = null;
                        if (((JSONScanner)object2).scanISO8601DateIfMatch(false)) {
                            calendar = ((JSONLexerBase)object2).getCalendar();
                        }
                        ((JSONLexerBase)object2).close();
                        if (calendar == null) break block11;
                        return calendar.getTimeInMillis();
                    }
                }
            }
            if (!(object instanceof Map) || (object2 = (Map)object).size() != 2 || !object2.containsKey("andIncrement") || !object2.containsKey("andDecrement")) break;
            object2 = object2.values().iterator();
            object2.next();
            object = object2.next();
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? 1L : 0L;
        }
        throw new JSONException("can not cast to long, value : ".concat(String.valueOf(object)));
    }

    public static byte byteValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        int n2 = bigDecimal.scale();
        if (n2 >= -100 && n2 <= 100) {
            return bigDecimal.byteValue();
        }
        return bigDecimal.byteValueExact();
    }

    public static short shortValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        int n2 = bigDecimal.scale();
        if (n2 >= -100 && n2 <= 100) {
            return bigDecimal.shortValue();
        }
        return bigDecimal.shortValueExact();
    }

    public static int intValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0;
        }
        int n2 = bigDecimal.scale();
        if (n2 >= -100 && n2 <= 100) {
            return bigDecimal.intValue();
        }
        return bigDecimal.intValueExact();
    }

    public static long longValue(BigDecimal bigDecimal) {
        if (bigDecimal == null) {
            return 0L;
        }
        int n2 = bigDecimal.scale();
        if (n2 >= -100 && n2 <= 100) {
            return bigDecimal.longValue();
        }
        return bigDecimal.longValueExact();
    }

    public static Integer castToInt(Object iterator) {
        while (true) {
            Object object;
            if (iterator == null) {
                return null;
            }
            if (iterator instanceof Integer) {
                return (Integer)((Object)iterator);
            }
            if (iterator instanceof BigDecimal) {
                return TypeUtils.intValue((BigDecimal)((Object)iterator));
            }
            if (iterator instanceof Number) {
                return ((Number)((Object)iterator)).intValue();
            }
            if (iterator instanceof String) {
                object = (String)((Object)iterator);
                if (((String)object).length() == 0 || "null".equals(object) || "NULL".equals(object)) {
                    return null;
                }
                if (((String)object).indexOf(44) != -1) {
                    object = ((String)object).replaceAll(",", "");
                }
                if (((Matcher)((Object)(iterator = a.matcher((CharSequence)object)))).find()) {
                    object = ((Matcher)((Object)iterator)).replaceAll("");
                }
                return Integer.parseInt((String)object);
            }
            if (iterator instanceof Boolean) {
                return (Boolean)((Object)iterator) != false ? 1 : 0;
            }
            if (!(iterator instanceof Map) || (object = (Map)((Object)iterator)).size() != 2 || !object.containsKey("andIncrement") || !object.containsKey("andDecrement")) break;
            iterator = object.values().iterator();
            iterator.next();
            iterator = iterator.next();
        }
        throw new JSONException("can not cast to int, value : ".concat(String.valueOf(iterator)));
    }

    public static byte[] castToBytes(Object object) {
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        if (object instanceof String) {
            return IOUtils.ddb((String)object);
        }
        throw new JSONException("can not cast to byte[], value : ".concat(String.valueOf(object)));
    }

    public static Boolean castToBoolean(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof BigDecimal) {
            return TypeUtils.intValue((BigDecimal)object) == 1;
        }
        if (object instanceof Number) {
            return ((Number)object).intValue() == 1;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.length() == 0 || "null".equals(string) || "NULL".equals(string)) {
                return null;
            }
            if ("true".equalsIgnoreCase(string) || "1".equals(string)) {
                return Boolean.TRUE;
            }
            if ("false".equalsIgnoreCase(string) || "0".equals(string)) {
                return Boolean.FALSE;
            }
            if ("Y".equalsIgnoreCase(string) || "T".equals(string)) {
                return Boolean.TRUE;
            }
            if ("F".equalsIgnoreCase(string) || "N".equals(string)) {
                return Boolean.FALSE;
            }
        }
        throw new JSONException("can not cast to boolean, value : ".concat(String.valueOf(object)));
    }

    public static <T> T castToJavaBean(Object object, Class<T> clazz) {
        return TypeUtils.cast(object, clazz, ParserConfig.getGlobalInstance());
    }

    public static <T> T cast(Object object, Class<T> clazz, ParserConfig parserConfig) {
        if (object == null) {
            if (clazz == Integer.TYPE) {
                return (T)Integer.valueOf(0);
            }
            if (clazz == Long.TYPE) {
                return (T)Long.valueOf(0L);
            }
            if (clazz == Short.TYPE) {
                return (T)Short.valueOf((short)0);
            }
            if (clazz == Byte.TYPE) {
                return (T)Byte.valueOf((byte)0);
            }
            if (clazz == Float.TYPE) {
                return (T)Float.valueOf(0.0f);
            }
            if (clazz == Double.TYPE) {
                return (T)Double.valueOf(0.0);
            }
            if (clazz == Boolean.TYPE) {
                return (T)Boolean.FALSE;
            }
            return null;
        }
        if (clazz == null) {
            throw new IllegalArgumentException("clazz is null");
        }
        if (clazz == object.getClass()) {
            return (T)object;
        }
        if (object instanceof Map) {
            if (clazz == Map.class) {
                return (T)object;
            }
            Map map = (Map)object;
            if (clazz == Object.class && !map.containsKey(JSON.DEFAULT_TYPE_KEY)) {
                return (T)object;
            }
            return TypeUtils.castToJavaBean((Map)object, clazz, parserConfig);
        }
        if (clazz.isArray()) {
            if (object instanceof Collection) {
                Object object2 = (Collection)object;
                int n2 = 0;
                object = Array.newInstance(clazz.getComponentType(), object2.size());
                object2 = object2.iterator();
                while (object2.hasNext()) {
                    Object obj = TypeUtils.cast(object2.next(), clazz.getComponentType(), parserConfig);
                    Array.set(object, n2, obj);
                    ++n2;
                }
                return (T)object;
            }
            if (clazz == byte[].class) {
                return (T)TypeUtils.castToBytes(object);
            }
        }
        if (clazz.isAssignableFrom(object.getClass())) {
            return (T)object;
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return (T)TypeUtils.castToBoolean(object);
        }
        if (clazz == Byte.TYPE || clazz == Byte.class) {
            return (T)TypeUtils.castToByte(object);
        }
        if (clazz == Character.TYPE || clazz == Character.class) {
            return (T)TypeUtils.castToChar(object);
        }
        if (clazz == Short.TYPE || clazz == Short.class) {
            return (T)TypeUtils.castToShort(object);
        }
        if (clazz == Integer.TYPE || clazz == Integer.class) {
            return (T)TypeUtils.castToInt(object);
        }
        if (clazz == Long.TYPE || clazz == Long.class) {
            return (T)TypeUtils.castToLong(object);
        }
        if (clazz == Float.TYPE || clazz == Float.class) {
            return (T)TypeUtils.castToFloat(object);
        }
        if (clazz == Double.TYPE || clazz == Double.class) {
            return (T)TypeUtils.castToDouble(object);
        }
        if (clazz == String.class) {
            return (T)TypeUtils.castToString(object);
        }
        if (clazz == BigDecimal.class) {
            return (T)TypeUtils.castToBigDecimal(object);
        }
        if (clazz == BigInteger.class) {
            return (T)TypeUtils.castToBigInteger(object);
        }
        if (clazz == Date.class) {
            return (T)TypeUtils.castToDate(object);
        }
        if (clazz == java.sql.Date.class) {
            return (T)TypeUtils.castToSqlDate(object);
        }
        if (clazz == Time.class) {
            return (T)TypeUtils.castToSqlTime(object);
        }
        if (clazz == Timestamp.class) {
            return (T)TypeUtils.castToTimestamp(object);
        }
        if (clazz.isEnum()) {
            return TypeUtils.castToEnum(object, clazz, parserConfig);
        }
        if (Calendar.class.isAssignableFrom(clazz)) {
            Calendar calendar;
            Date date = TypeUtils.castToDate(object);
            if (clazz == Calendar.class) {
                calendar = Calendar.getInstance(JSON.defaultTimeZone, JSON.defaultLocale);
            } else {
                try {
                    calendar = (Calendar)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new JSONException("can not cast to : " + clazz.getName(), exception);
                }
            }
            calendar.setTime(date);
            return (T)calendar;
        }
        String string = clazz.getName();
        if (string.equals("javax.xml.datatype.XMLGregorianCalendar")) {
            Date date = TypeUtils.castToDate(object);
            object = Calendar.getInstance(JSON.defaultTimeZone, JSON.defaultLocale);
            ((Calendar)object).setTime(date);
            return (T)CalendarCodec.instance.createXMLGregorianCalendar((Calendar)object);
        }
        if (object instanceof String) {
            String string2 = (String)object;
            if (string2.length() == 0 || "null".equals(string2) || "NULL".equals(string2)) {
                return null;
            }
            if (clazz == Currency.class) {
                return (T)Currency.getInstance(string2);
            }
            if (clazz == Locale.class) {
                return (T)TypeUtils.toLocale(string2);
            }
            if (string.startsWith("java.time.")) {
                return JSON.parseObject(JSON.toJSONString(string2), clazz);
            }
        }
        if (parserConfig.get(clazz) != null) {
            return JSON.parseObject(JSON.toJSONString(object), clazz);
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    public static Locale toLocale(String stringArray) {
        if ((stringArray = stringArray.split("_")).length == 1) {
            return new Locale(stringArray[0]);
        }
        if (stringArray.length == 2) {
            return new Locale(stringArray[0], stringArray[1]);
        }
        return new Locale(stringArray[0], stringArray[1], stringArray[2]);
    }

    public static <T> T castToEnum(Object object, Class<T> clazz, ParserConfig object2) {
        try {
            int n2;
            if (object instanceof String) {
                String string = (String)object;
                if (string.length() == 0) {
                    return null;
                }
                if (object2 == null) {
                    object2 = ParserConfig.getGlobalInstance();
                }
                if ((object2 = object2.getDeserializer(clazz)) instanceof EnumDeserializer) {
                    return (T)((EnumDeserializer)object2).getEnumByHashCode(TypeUtils.fnv1a_64(string));
                }
                return Enum.valueOf(clazz, string);
            }
            if (object instanceof BigDecimal && (n2 = TypeUtils.intValue((BigDecimal)object)) < ((T[])(object2 = clazz.getEnumConstants())).length) {
                return object2[n2];
            }
            if (object instanceof Number && (n2 = ((Number)object).intValue()) < ((T[])(object2 = clazz.getEnumConstants())).length) {
                return object2[n2];
            }
        }
        catch (Exception exception) {
            throw new JSONException("can not cast to : " + clazz.getName(), exception);
        }
        throw new JSONException("can not cast to : " + clazz.getName());
    }

    public static <T> T cast(Object object, Type type, ParserConfig object2) {
        if (object == null) {
            return null;
        }
        if (type instanceof Class) {
            return TypeUtils.cast(object, (Class)type, (ParserConfig)object2);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.cast(object, (ParameterizedType)type, (ParserConfig)object2);
        }
        if (object instanceof String && (((String)(object2 = (String)object)).length() == 0 || "null".equals(object2) || "NULL".equals(object2))) {
            return null;
        }
        if (type instanceof TypeVariable) {
            return (T)object;
        }
        throw new JSONException("can not cast to : ".concat(String.valueOf(type)));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T cast(Object object42, ParameterizedType object22, ParserConfig parserConfig) {
        Map.Entry entry;
        ParserConfig parserConfig2;
        Type[] typeArray;
        Object object = object22.getRawType();
        if (object == List.class || object == ArrayList.class) {
            typeArray = object22.getActualTypeArguments()[0];
            if (object42 instanceof List) {
                List list = (List)object42;
                object = new ArrayList(list.size());
                for (int i2 = 0; i2 < list.size(); ++i2) {
                    Object e2 = list.get(i2);
                    T t2 = typeArray instanceof Class ? (e2 != null && e2.getClass() == JSONObject.class ? ((JSONObject)e2).toJavaObject((Class)typeArray, parserConfig2, 0) : TypeUtils.cast(e2, (Class)typeArray, parserConfig2)) : TypeUtils.cast(e2, (Type)typeArray, parserConfig2);
                    object.add(t2);
                }
                return (T)object;
            }
        }
        if (object == Set.class || object == HashSet.class || object == TreeSet.class || object == Collection.class || object == List.class || object == ArrayList.class) {
            typeArray = object22.getActualTypeArguments()[0];
            if (object42 instanceof Iterable) {
                AbstractCollection abstractCollection = object == Set.class || object == HashSet.class ? new HashSet() : (object == TreeSet.class ? new TreeSet() : new ArrayList());
                for (Object object42 : (Iterable)object42) {
                    void var1_9;
                    if (typeArray instanceof Class) {
                        if (object42 != null && object42.getClass() == JSONObject.class) {
                            Object t3 = ((JSONObject)object42).toJavaObject((Class)typeArray, parserConfig2, 0);
                        } else {
                            T t4 = TypeUtils.cast(object42, (Class)typeArray, parserConfig2);
                        }
                    } else {
                        T t5 = TypeUtils.cast(object42, (Type)typeArray, parserConfig2);
                    }
                    abstractCollection.add(var1_9);
                }
                return (T)abstractCollection;
            }
        }
        if (object == Map.class || object == HashMap.class) {
            typeArray = object22.getActualTypeArguments()[0];
            entry = object22.getActualTypeArguments()[1];
            if (object42 instanceof Map) {
                object = new HashMap();
                for (Map.Entry entry2 : ((Map)object42).entrySet()) {
                    T t6 = TypeUtils.cast(entry2.getKey(), (Type)typeArray, parserConfig2);
                    T t7 = TypeUtils.cast(entry2.getValue(), entry, parserConfig2);
                    object.put(t6, t7);
                }
                return (T)object;
            }
        }
        if (object42 instanceof String && ((String)object42).length() == 0) {
            return null;
        }
        typeArray = object22.getActualTypeArguments();
        if (typeArray.length == 1 && object22.getActualTypeArguments()[0] instanceof WildcardType) {
            return TypeUtils.cast(object42, (Type)object, parserConfig2);
        }
        if (object == Map.Entry.class && object42 instanceof Map && ((Map)object42).size() == 1) {
            entry = ((Map)object42).entrySet().iterator().next();
            object = entry.getValue();
            if (typeArray.length == 2 && object instanceof Map) {
                object42 = typeArray[1];
                entry.setValue(TypeUtils.cast(object, (Type)object42, parserConfig2));
            }
            return (T)entry;
        }
        if (object instanceof Class) {
            if (parserConfig2 == null) {
                parserConfig2 = ParserConfig.global;
            }
            if ((entry = parserConfig2.getDeserializer((Type)object)) != null) {
                object = JSON.toJSONString(object42);
                object42 = new DefaultJSONParser((String)object, parserConfig2);
                return entry.deserialze((DefaultJSONParser)object42, (Type)object22, null);
            }
        }
        throw new JSONException("can not cast to : ".concat(String.valueOf(object22)));
    }

    public static <T> T castToJavaBean(Map<String, Object> object, Class<T> clazz, ParserConfig parserConfig) {
        Object object2;
        Object object3;
        block23: {
            try {
                Object object4;
                if (clazz == StackTraceElement.class) {
                    String string = (String)object.get("className");
                    String string2 = (String)object.get("methodName");
                    String string3 = (String)object.get("fileName");
                    int n2 = (object = (Number)object.get("lineNumber")) == null ? 0 : (object instanceof BigDecimal ? ((BigDecimal)object).intValueExact() : ((Number)object).intValue());
                    return (T)new StackTraceElement(string, string2, string3, n2);
                }
                object3 = object.get(JSON.DEFAULT_TYPE_KEY);
                if (object3 instanceof String) {
                    object2 = (String)object3;
                    if (parserConfig == null) {
                        parserConfig = ParserConfig.global;
                    }
                    if ((object4 = parserConfig.checkAutoType((String)object2, null)) == null) {
                        throw new ClassNotFoundException((String)object2 + " not found");
                    }
                    if (!object4.equals(clazz)) {
                        return (T)TypeUtils.castToJavaBean((Map<String, Object>)object, object4, parserConfig);
                    }
                }
                if (clazz.isInterface()) {
                    object3 = object instanceof JSONObject ? (JSONObject)object : new JSONObject((Map<String, Object>)object);
                    if (parserConfig == null) {
                        parserConfig = ParserConfig.getGlobalInstance();
                    }
                    if (parserConfig.get(clazz) != null) {
                        return JSON.parseObject(JSON.toJSONString(object3), clazz);
                    }
                    return (T)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{clazz}, (InvocationHandler)object3);
                }
                if (clazz == Locale.class) {
                    object3 = object.get("language");
                    object2 = object.get("country");
                    if (object3 instanceof String) {
                        object4 = (String)object3;
                        if (object2 instanceof String) {
                            object = (String)object2;
                            return (T)new Locale((String)object4, (String)object);
                        }
                        if (object2 == null) {
                            return (T)new Locale((String)object4);
                        }
                    }
                }
                if (clazz != String.class || !(object instanceof JSONObject)) break block23;
                return (T)object.toString();
            }
            catch (Exception exception) {
                throw new JSONException(exception.getMessage(), exception);
            }
        }
        if (clazz == JSON.class && object instanceof JSONObject) {
            return (T)object;
        }
        if (clazz == LinkedHashMap.class && object instanceof JSONObject) {
            object2 = ((JSONObject)object).getInnerMap();
            if (object2 instanceof LinkedHashMap) {
                return (T)object2;
            }
            new LinkedHashMap<String, Object>().putAll((Map<String, Object>)object2);
        }
        if (clazz.isInstance(object)) {
            return (T)object;
        }
        if (clazz == JSONObject.class) {
            return (T)new JSONObject((Map<String, Object>)object);
        }
        if (parserConfig == null) {
            parserConfig = ParserConfig.getGlobalInstance();
        }
        object3 = null;
        object2 = parserConfig.getDeserializer(clazz);
        if (object2 instanceof JavaBeanDeserializer) {
            object3 = (JavaBeanDeserializer)object2;
        }
        if (object3 == null) {
            throw new JSONException("can not get javaBeanDeserializer. " + clazz.getName());
        }
        return (T)((JavaBeanDeserializer)object3).createInstance((Map<String, Object>)object, parserConfig);
    }

    private static void a() {
        A.put("byte", Byte.TYPE);
        A.put("short", Short.TYPE);
        A.put("int", Integer.TYPE);
        A.put("long", Long.TYPE);
        A.put("float", Float.TYPE);
        A.put("double", Double.TYPE);
        A.put("boolean", Boolean.TYPE);
        A.put("char", Character.TYPE);
        A.put("[byte", byte[].class);
        A.put("[short", short[].class);
        A.put("[int", int[].class);
        A.put("[long", long[].class);
        A.put("[float", float[].class);
        A.put("[double", double[].class);
        A.put("[boolean", boolean[].class);
        A.put("[char", char[].class);
        A.put("[B", byte[].class);
        A.put("[S", short[].class);
        A.put("[I", int[].class);
        A.put("[J", long[].class);
        A.put("[F", float[].class);
        A.put("[D", double[].class);
        A.put("[C", char[].class);
        A.put("[Z", boolean[].class);
        Class[] classArray = new Class[]{Object.class, Cloneable.class, TypeUtils.loadClass("java.lang.AutoCloseable"), Exception.class, RuntimeException.class, IllegalAccessError.class, IllegalAccessException.class, IllegalArgumentException.class, IllegalMonitorStateException.class, IllegalStateException.class, IllegalThreadStateException.class, IndexOutOfBoundsException.class, InstantiationError.class, InstantiationException.class, InternalError.class, InterruptedException.class, LinkageError.class, NegativeArraySizeException.class, NoClassDefFoundError.class, NoSuchFieldError.class, NoSuchFieldException.class, NoSuchMethodError.class, NoSuchMethodException.class, NullPointerException.class, NumberFormatException.class, OutOfMemoryError.class, SecurityException.class, StackOverflowError.class, StringIndexOutOfBoundsException.class, TypeNotPresentException.class, VerifyError.class, StackTraceElement.class, HashMap.class, Hashtable.class, TreeMap.class, IdentityHashMap.class, WeakHashMap.class, LinkedHashMap.class, HashSet.class, LinkedHashSet.class, TreeSet.class, ArrayList.class, TimeUnit.class, ConcurrentHashMap.class, AtomicInteger.class, AtomicLong.class, Collections.EMPTY_MAP.getClass(), Boolean.class, Character.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Number.class, String.class, BigDecimal.class, BigInteger.class, BitSet.class, Calendar.class, Date.class, Locale.class, UUID.class, Time.class, java.sql.Date.class, Timestamp.class, SimpleDateFormat.class, JSONObject.class, JSONPObject.class, JSONArray.class};
        for (int i2 = 0; i2 < 71; ++i2) {
            Class clazz = classArray[i2];
            if (clazz == null) continue;
            A.put(clazz.getName(), clazz);
        }
    }

    public static void clearClassMapping() {
        A.clear();
        TypeUtils.a();
    }

    public static void addMapping(String string, Class<?> clazz) {
        A.put(string, clazz);
    }

    public static Class<?> loadClass(String string) {
        return TypeUtils.loadClass(string, null);
    }

    public static boolean isPath(Class<?> clazz) {
        if (B == null && !C) {
            try {
                B = Class.forName("java.nio.file.Path");
            }
            catch (Throwable throwable) {
                C = true;
            }
        }
        if (B != null) {
            return B.isAssignableFrom(clazz);
        }
        return false;
    }

    public static Class<?> getClassFromMapping(String string) {
        return (Class)A.get(string);
    }

    public static Class<?> loadClass(String string, ClassLoader classLoader) {
        return TypeUtils.loadClass(string, classLoader, false);
    }

    public static Class<?> loadClass(String string, ClassLoader classLoader, boolean bl) {
        if (string == null || string.length() == 0 || string.length() > 128) {
            return null;
        }
        Class<?> clazz = (Class<?>)A.get(string);
        if (clazz != null) {
            return clazz;
        }
        if (string.charAt(0) == '[') {
            return Array.newInstance(TypeUtils.loadClass(string.substring(1), classLoader), 0).getClass();
        }
        if (string.startsWith("L") && string.endsWith(";")) {
            return TypeUtils.loadClass(string.substring(1, string.length() - 1), classLoader);
        }
        try {
            if (classLoader != null) {
                clazz = classLoader.loadClass(string);
                if (bl) {
                    A.put(string, clazz);
                }
                return clazz;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            ClassLoader classLoader2 = Thread.currentThread().getContextClassLoader();
            if (classLoader2 != null && classLoader2 != classLoader) {
                clazz = classLoader2.loadClass(string);
                if (bl) {
                    A.put(string, clazz);
                }
                return clazz;
            }
        }
        catch (Throwable throwable) {}
        try {
            clazz = Class.forName(string);
            if (bl) {
                A.put(string, clazz);
            }
            return clazz;
        }
        catch (Throwable throwable) {
            return clazz;
        }
    }

    public static SerializeBeanInfo buildBeanInfo(Class<?> clazz, Map<String, String> map, PropertyNamingStrategy propertyNamingStrategy) {
        return TypeUtils.buildBeanInfo(clazz, map, propertyNamingStrategy, false);
    }

    public static SerializeBeanInfo buildBeanInfo(Class<?> clazz, Map<String, String> map, PropertyNamingStrategy propertyNamingStrategy, boolean bl) {
        Object object;
        Object object2;
        int n2;
        JSONType jSONType = TypeUtils.getAnnotation(clazz, JSONType.class);
        String[] stringArray = null;
        String string = null;
        String string2 = null;
        if (jSONType != null) {
            JSONType jSONType2;
            PropertyNamingStrategy propertyNamingStrategy2;
            stringArray = jSONType.orders();
            string = jSONType.typeName();
            if (string.length() == 0) {
                string = null;
            }
            if ((propertyNamingStrategy2 = jSONType.naming()) != PropertyNamingStrategy.CamelCase) {
                propertyNamingStrategy = propertyNamingStrategy2;
            }
            n2 = SerializerFeature.of(jSONType.serialzeFeatures());
            for (object2 = clazz.getSuperclass(); object2 != null && object2 != Object.class && (jSONType2 = TypeUtils.getAnnotation(object2, JSONType.class)) != null && (string2 = jSONType2.typeKey()).length() == 0; object2 = object2.getSuperclass()) {
            }
            object2 = clazz.getInterfaces();
            int n3 = ((Class<?>[])object2).length;
            for (int i2 = 0; i2 < n3 && ((object = TypeUtils.getAnnotation(object2[i2], JSONType.class)) == null || (string2 = object.typeKey()).length() == 0); ++i2) {
            }
            if (string2 != null && string2.length() == 0) {
                string2 = null;
            }
        } else {
            n2 = 0;
        }
        Object[] objectArray = new HashMap();
        ParserConfig.parserAllFieldToCache(clazz, objectArray);
        object2 = bl ? TypeUtils.computeGettersWithFieldBase(clazz, map, false, propertyNamingStrategy) : TypeUtils.computeGetters(clazz, jSONType, map, objectArray, false, propertyNamingStrategy);
        Object[] objectArray2 = new FieldInfo[object2.size()];
        object2.toArray(objectArray2);
        if (stringArray != null && stringArray.length != 0) {
            object = bl ? TypeUtils.computeGettersWithFieldBase(clazz, map, true, propertyNamingStrategy) : TypeUtils.computeGetters(clazz, jSONType, map, (Map<String, Field>)objectArray, true, propertyNamingStrategy);
        } else {
            object = new ArrayList(object2);
            Collections.sort(object);
        }
        objectArray = new FieldInfo[object.size()];
        object.toArray(objectArray);
        if (Arrays.equals(objectArray, objectArray2)) {
            objectArray = objectArray2;
        }
        return new SerializeBeanInfo(clazz, jSONType, string, string2, n2, (FieldInfo[])objectArray2, (FieldInfo[])objectArray);
    }

    public static List<FieldInfo> computeGettersWithFieldBase(Class<?> clazz, Map<String, String> map, boolean bl, PropertyNamingStrategy propertyNamingStrategy) {
        LinkedHashMap<String, FieldInfo> linkedHashMap = new LinkedHashMap<String, FieldInfo>();
        for (Class<?> clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
            Field[] fieldArray = clazz2.getDeclaredFields();
            TypeUtils.a(clazz2, map, propertyNamingStrategy, linkedHashMap, fieldArray);
        }
        return TypeUtils.a(clazz, bl, linkedHashMap);
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, Map<String, String> map) {
        return TypeUtils.computeGetters(clazz, map, true);
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, Map<String, String> map, boolean bl) {
        JSONType jSONType = TypeUtils.getAnnotation(clazz, JSONType.class);
        HashMap<String, Field> hashMap = new HashMap<String, Field>();
        ParserConfig.parserAllFieldToCache(clazz, hashMap);
        return TypeUtils.computeGetters(clazz, jSONType, map, hashMap, bl, PropertyNamingStrategy.CamelCase);
    }

    public static List<FieldInfo> computeGetters(Class<?> clazz, JSONType object, Map<String, String> map, Map<String, Field> map2, boolean bl, PropertyNamingStrategy propertyNamingStrategy) {
        object = new LinkedHashMap();
        boolean bl2 = TypeUtils.isKotlin(clazz);
        Constructor[] constructorArray = null;
        Annotation[][] annotationArray = null;
        Object[] objectArray = null;
        short[] sArray = null;
        for (Method method : clazz.getMethods()) {
            Object object2;
            Object object3;
            Class<?> clazz2;
            String string = method.getName();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            String string2 = null;
            if (Modifier.isStatic(method.getModifiers()) || (clazz2 = method.getReturnType()).equals(Void.TYPE) || method.getParameterTypes().length != 0 || clazz2 == ClassLoader.class || clazz2 == InputStream.class || clazz2 == Reader.class || string.equals("getMetaClass") && clazz2.getName().equals("groovy.lang.MetaClass") || string.equals("getSuppressed") && method.getDeclaringClass() == Throwable.class || bl2 && TypeUtils.b(clazz, string)) continue;
            Boolean bl3 = Boolean.FALSE;
            JSONField jSONField = TypeUtils.getAnnotation(method, JSONField.class);
            if (jSONField == null) {
                jSONField = TypeUtils.getSuperMethodAnnotation(clazz, method);
            }
            if (jSONField == null && bl2) {
                int n5;
                if (constructorArray == null && (object3 = TypeUtils.getKotlinConstructor(constructorArray = clazz.getDeclaredConstructors())) != null) {
                    annotationArray = TypeUtils.getParameterAnnotations((Constructor)object3);
                    objectArray = TypeUtils.getKoltinConstructorParameters(clazz);
                    if (objectArray != null) {
                        object2 = new String[objectArray.length];
                        System.arraycopy(objectArray, 0, object2, 0, objectArray.length);
                        Arrays.sort((Object[])object2);
                        sArray = new short[objectArray.length];
                        for (n5 = 0; n5 < objectArray.length; n5 = (int)((short)(n5 + 1))) {
                            int n6 = Arrays.binarySearch((Object[])object2, objectArray[n5]);
                            sArray[n6] = n5;
                        }
                        objectArray = object2;
                    }
                }
                if (objectArray != null && sArray != null && string.startsWith("get")) {
                    object3 = TypeUtils.decapitalize(string.substring(3));
                    int n7 = Arrays.binarySearch(objectArray, object3);
                    if (n7 < 0) {
                        for (n5 = 0; n5 < objectArray.length; ++n5) {
                            if (!((String)object3).equalsIgnoreCase((String)objectArray[n5])) continue;
                            n7 = n5;
                            break;
                        }
                    }
                    if (n7 >= 0) {
                        n5 = sArray[n7];
                        Object object4 = annotationArray[n5];
                        if (object4 != null) {
                            n5 = ((Annotation[])object4).length;
                            for (n7 = 0; n7 < n5; ++n7) {
                                Annotation annotation = object4[n7];
                                if (!(annotation instanceof JSONField)) continue;
                                jSONField = (JSONField)annotation;
                                break;
                            }
                        }
                        if (jSONField == null && (object4 = ParserConfig.getFieldFromCache((String)object3, map2)) != null) {
                            jSONField = TypeUtils.getAnnotation((Field)object4, JSONField.class);
                        }
                    }
                }
            }
            if (jSONField != null) {
                if (!jSONField.serialize()) continue;
                n2 = jSONField.ordinal();
                n3 = SerializerFeature.of(jSONField.serialzeFeatures());
                n4 = Feature.of(jSONField.parseFeatures());
                if (jSONField.name().length() != 0) {
                    object3 = jSONField.name();
                    if (map != null && (object3 = map.get(object3)) == null) continue;
                    object2 = new FieldInfo((String)object3, method, null, clazz, null, n2, n3, n4, jSONField, null, null);
                    object.put(object3, object2);
                    continue;
                }
                if (jSONField.label().length() != 0) {
                    string2 = jSONField.label();
                }
            }
            if (string.startsWith("get")) {
                char c2;
                if (string.length() < 4 || string.equals("getClass") || string.equals("getDeclaringClass") && clazz.isEnum()) continue;
                char c3 = string.charAt(3);
                Object object5 = null;
                if (Character.isUpperCase(c3) || c3 > '\u0200') {
                    object2 = compatibleWithJavaBean ? TypeUtils.decapitalize(string.substring(3)) : TypeUtils.getPropertyNameByMethodName(string);
                    object2 = TypeUtils.a(map2, string, (String)object2, 3);
                } else if (c3 == '_') {
                    object2 = string.substring(3);
                    object5 = map2.get(object2);
                    if (object5 == null) {
                        Object[] objectArray2 = object2;
                        object2 = string.substring(4);
                        object5 = ParserConfig.getFieldFromCache((String)object2, map2);
                        if (object5 == null) {
                            object2 = objectArray2;
                        }
                    }
                } else if (c3 == 'f') {
                    object2 = string.substring(3);
                } else if (string.length() >= 5 && Character.isUpperCase(string.charAt(4))) {
                    object2 = TypeUtils.decapitalize(string.substring(3));
                } else {
                    object2 = string.substring(3);
                    object5 = ParserConfig.getFieldFromCache((String)object2, map2);
                    if (object5 == null) continue;
                }
                if (TypeUtils.a(clazz, (String)object2)) continue;
                if (object5 == null) {
                    object5 = ParserConfig.getFieldFromCache((String)object2, map2);
                }
                if (object5 == null && ((String)object2).length() > 1 && (c2 = ((String)object2).charAt(1)) >= 'A' && c2 <= 'Z') {
                    object5 = ParserConfig.getFieldFromCache(TypeUtils.decapitalize(string.substring(3)), map2);
                }
                JSONField jSONField2 = null;
                if (object5 != null && (jSONField2 = TypeUtils.getAnnotation((Field)object5, JSONField.class)) != null) {
                    if (!jSONField2.serialize()) continue;
                    n2 = jSONField2.ordinal();
                    n3 = SerializerFeature.of(jSONField2.serialzeFeatures());
                    n4 = Feature.of(jSONField2.parseFeatures());
                    if (jSONField2.name().length() != 0) {
                        bl3 = Boolean.TRUE;
                        object2 = jSONField2.name();
                        if (map != null && (object2 = map.get(object2)) == null) continue;
                    }
                    if (jSONField2.label().length() != 0) {
                        string2 = jSONField2.label();
                    }
                }
                if (map != null && (object2 = map.get(object2)) == null) continue;
                if (propertyNamingStrategy != null && !bl3.booleanValue()) {
                    object2 = propertyNamingStrategy.translate((String)object2);
                }
                object5 = new FieldInfo((String)object2, method, (Field)object5, clazz, null, n2, n3, n4, jSONField, jSONField2, string2);
                object.put(object2, object5);
            }
            if (!string.startsWith("is") || string.length() < 3 || clazz2 != Boolean.TYPE && clazz2 != Boolean.class) continue;
            char c4 = string.charAt(2);
            Object object6 = null;
            if (Character.isUpperCase(c4)) {
                object2 = compatibleWithJavaBean ? TypeUtils.decapitalize(string.substring(2)) : Character.toLowerCase(string.charAt(2)) + string.substring(3);
                object2 = TypeUtils.a(map2, string, (String)object2, 2);
            } else if (c4 == '_') {
                object2 = string.substring(3);
                object6 = map2.get(object2);
                if (object6 == null) {
                    Object object7 = object2;
                    object2 = string.substring(2);
                    object6 = ParserConfig.getFieldFromCache((String)object2, map2);
                    if (object6 == null) {
                        object2 = object7;
                    }
                }
            } else if (c4 == 'f') {
                object2 = string.substring(2);
            } else {
                object2 = string.substring(2);
                object6 = ParserConfig.getFieldFromCache((String)object2, map2);
                if (object6 == null) continue;
            }
            if (TypeUtils.a(clazz, (String)object2)) continue;
            if (object6 == null) {
                object6 = ParserConfig.getFieldFromCache((String)object2, map2);
            }
            if (object6 == null) {
                object6 = ParserConfig.getFieldFromCache(string, map2);
            }
            JSONField jSONField3 = null;
            if (object6 != null && (jSONField3 = TypeUtils.getAnnotation((Field)object6, JSONField.class)) != null) {
                if (!jSONField3.serialize()) continue;
                n2 = jSONField3.ordinal();
                n3 = SerializerFeature.of(jSONField3.serialzeFeatures());
                n4 = Feature.of(jSONField3.parseFeatures());
                if (jSONField3.name().length() != 0) {
                    object2 = jSONField3.name();
                    if (map != null && (object2 = map.get(object2)) == null) continue;
                }
                if (jSONField3.label().length() != 0) {
                    string2 = jSONField3.label();
                }
            }
            if (map != null && (object2 = map.get(object2)) == null) continue;
            if (propertyNamingStrategy != null) {
                object2 = propertyNamingStrategy.translate((String)object2);
            }
            if (object.containsKey(object2)) continue;
            object6 = new FieldInfo((String)object2, method, (Field)object6, clazz, null, n2, n3, n4, jSONField, jSONField3, string2);
            object.put(object2, object6);
        }
        AccessibleObject[] accessibleObjectArray = clazz.getFields();
        TypeUtils.a(clazz, map, propertyNamingStrategy, (Map<String, FieldInfo>)object, (Field[])accessibleObjectArray);
        return TypeUtils.a(clazz, bl, (Map<String, FieldInfo>)object);
    }

    private static List<FieldInfo> a(Class<?> object, boolean bl, Map<String, FieldInfo> iterator2) {
        ArrayList<FieldInfo> arrayList = new ArrayList<FieldInfo>();
        String[] stringArray = null;
        if ((object = TypeUtils.getAnnotation(object, JSONType.class)) != null) {
            stringArray = object.orders();
        }
        if (stringArray != null && stringArray.length > 0) {
            object = new LinkedHashMap(arrayList.size());
            for (FieldInfo fieldInfo : iterator2.values()) {
                ((HashMap)object).put(fieldInfo.name, fieldInfo);
            }
            String[] stringArray2 = stringArray;
            int fieldInfo = stringArray.length;
            for (int i2 = 0; i2 < fieldInfo; ++i2) {
                String string = stringArray2[i2];
                FieldInfo fieldInfo2 = (FieldInfo)((LinkedHashMap)object).get(string);
                if (fieldInfo2 == null) continue;
                arrayList.add(fieldInfo2);
                ((HashMap)object).remove(string);
            }
            for (FieldInfo fieldInfo3 : ((LinkedHashMap)object).values()) {
                arrayList.add(fieldInfo3);
            }
        } else {
            for (FieldInfo fieldInfo : iterator2.values()) {
                arrayList.add(fieldInfo);
            }
            if (bl) {
                Collections.sort(arrayList);
            }
        }
        return arrayList;
    }

    private static void a(Class<?> clazz, Map<String, String> map, PropertyNamingStrategy propertyNamingStrategy, Map<String, FieldInfo> map2, Field[] fieldArray) {
        for (Field field : fieldArray) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            JSONField jSONField = TypeUtils.getAnnotation(field, JSONField.class);
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            String string = field.getName();
            String string2 = null;
            if (jSONField != null) {
                if (!jSONField.serialize()) continue;
                n2 = jSONField.ordinal();
                n3 = SerializerFeature.of(jSONField.serialzeFeatures());
                n4 = Feature.of(jSONField.parseFeatures());
                if (jSONField.name().length() != 0) {
                    string = jSONField.name();
                }
                if (jSONField.label().length() != 0) {
                    string2 = jSONField.label();
                }
            }
            if (map != null && (string = map.get(string)) == null) continue;
            if (propertyNamingStrategy != null) {
                string = propertyNamingStrategy.translate(string);
            }
            if (map2.containsKey(string)) continue;
            FieldInfo fieldInfo = new FieldInfo(string, null, field, clazz, null, n2, n3, n4, null, jSONField, string2);
            map2.put(string, fieldInfo);
        }
    }

    private static String a(Map<String, Field> map, String string, String string2, int n2) {
        if (compatibleWithFieldName && !map.containsKey(string2)) {
            if (map.containsKey(string = string.substring(n2))) {
                return string;
            }
            return string2;
        }
        return string2;
    }

    public static JSONField getSuperMethodAnnotation(Class<?> clazz, Method method) {
        Object object;
        Class<?>[] classArray = clazz.getInterfaces();
        if (classArray.length > 0) {
            object = method.getParameterTypes();
            int n2 = classArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                for (Method method2 : classArray[i2].getMethods()) {
                    JSONField jSONField;
                    Class<?>[] classArray2 = method2.getParameterTypes();
                    if (classArray2.length != ((Object)object).length || !method2.getName().equals(method.getName())) continue;
                    boolean bl = true;
                    for (int i3 = 0; i3 < ((Object)object).length; ++i3) {
                        if (classArray2[i3].equals(object[i3])) continue;
                        bl = false;
                        break;
                    }
                    if (!bl || (jSONField = TypeUtils.getAnnotation(method2, JSONField.class)) == null) continue;
                    return jSONField;
                }
            }
        }
        if ((object = clazz.getSuperclass()) == null) {
            return null;
        }
        if (Modifier.isAbstract(((Class)object).getModifiers())) {
            classArray = method.getParameterTypes();
            for (Method method3 : ((Class)object).getMethods()) {
                JSONField jSONField;
                Class<?>[] classArray3 = method3.getParameterTypes();
                if (classArray3.length != classArray.length || !method3.getName().equals(method.getName())) continue;
                int n3 = 1;
                for (int i4 = 0; i4 < classArray.length; ++i4) {
                    if (classArray3[i4].equals(classArray[i4])) continue;
                    n3 = 0;
                    break;
                }
                if (n3 == 0 || (jSONField = TypeUtils.getAnnotation(method3, JSONField.class)) == null) continue;
                return jSONField;
            }
        }
        return null;
    }

    private static boolean a(Class<?> clazz, String string) {
        while (true) {
            JSONType jSONType;
            if ((jSONType = TypeUtils.getAnnotation(clazz, JSONType.class)) != null) {
                String[] stringArray = jSONType.includes();
                if (stringArray.length > 0) {
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        if (!string.equals(stringArray[i2])) continue;
                        return false;
                    }
                    return true;
                }
                stringArray = jSONType.ignores();
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    if (!string.equals(stringArray[i3])) continue;
                    return true;
                }
            }
            if (clazz.getSuperclass() == Object.class || clazz.getSuperclass() == null) break;
            clazz = clazz.getSuperclass();
        }
        return false;
    }

    public static boolean isGenericParamType(Type type) {
        if (type instanceof ParameterizedType) {
            return true;
        }
        if (type instanceof Class) {
            return (type = ((Class)type).getGenericSuperclass()) != Object.class && TypeUtils.isGenericParamType(type);
        }
        return false;
    }

    public static Type getGenericParamType(Type type) {
        while (true) {
            if (type instanceof ParameterizedType) {
                return type;
            }
            if (!(type instanceof Class)) break;
            type = ((Class)type).getGenericSuperclass();
        }
        return type;
    }

    public static Type unwrapOptional(Type type) {
        ParameterizedType parameterizedType;
        if (!g) {
            try {
                h = Class.forName("java.util.Optional");
            }
            catch (Exception exception) {
            }
            finally {
                g = true;
            }
        }
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() == h) {
            return parameterizedType.getActualTypeArguments()[0];
        }
        return type;
    }

    public static Class<?> getClass(Type object) {
        while (true) {
            if (object.getClass() == Class.class) {
                return (Class)object;
            }
            if (object instanceof ParameterizedType) {
                object = ((ParameterizedType)object).getRawType();
                continue;
            }
            if (object instanceof TypeVariable) {
                if (!((object = ((TypeVariable)object).getBounds()[0]) instanceof Class)) continue;
                return (Class)object;
            }
            if (!(object instanceof WildcardType) || ((Type[])(object = ((WildcardType)object).getUpperBounds())).length != 1) break;
            object = object[0];
        }
        return Object.class;
    }

    public static Field getField(Class<?> object, String string, Field[] object2) {
        while (true) {
            for (Field field : object2) {
                char c2;
                String string2 = field.getName();
                if (string.equals(string2)) {
                    return field;
                }
                if (string.length() <= 2 || (c2 = string.charAt(0)) < 'a' || c2 > 'z' || (c2 = string.charAt(1)) < 'A' || c2 > 'Z' || !string.equalsIgnoreCase(string2)) continue;
                return field;
            }
            object2 = ((Class)object).getSuperclass();
            if (object2 == null || object2 == Object.class) break;
            Object object3 = object2;
            object2 = ((Class)object2).getDeclaredFields();
            object = object3;
        }
        return null;
    }

    public static int getSerializeFeatures(Class<?> object) {
        if ((object = TypeUtils.getAnnotation(object, JSONType.class)) == null) {
            return 0;
        }
        return SerializerFeature.of(object.serialzeFeatures());
    }

    public static int getParserFeatures(Class<?> object) {
        if ((object = TypeUtils.getAnnotation(object, JSONType.class)) == null) {
            return 0;
        }
        return Feature.of(object.parseFeatures());
    }

    public static String decapitalize(String object) {
        if (object == null || ((String)object).length() == 0) {
            return object;
        }
        if (((String)object).length() > 1 && Character.isUpperCase(((String)object).charAt(1)) && Character.isUpperCase(((String)object).charAt(0))) {
            return object;
        }
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        cArray[0] = Character.toLowerCase((char)object[0]);
        return new String((char[])object);
    }

    public static String getPropertyNameByMethodName(String string) {
        return Character.toLowerCase(string.charAt(3)) + string.substring(4);
    }

    static void a(AccessibleObject accessibleObject) {
        if (!b) {
            return;
        }
        if (accessibleObject.isAccessible()) {
            return;
        }
        try {
            accessibleObject.setAccessible(true);
            return;
        }
        catch (AccessControlException accessControlException) {
            b = false;
            return;
        }
    }

    public static Type getCollectionItemType(Type object) {
        if (object instanceof ParameterizedType) {
            Type[] typeArray;
            block7: {
                Object object2;
                object = (ParameterizedType)object;
                while (true) {
                    typeArray = object.getRawType();
                    object = object.getActualTypeArguments();
                    if (typeArray == Collection.class) {
                        if ((object = object[0]) instanceof WildcardType) {
                            if (((Type[])(object = ((WildcardType)object).getUpperBounds())).length > 0) {
                                return object[0];
                            }
                            return Object.class;
                        }
                        return object;
                    }
                    typeArray = (Class)typeArray;
                    object2 = object;
                    object = typeArray.getTypeParameters();
                    int n2 = ((TypeVariable<Class<T>>[])object).length;
                    HashMap<Type, Type> hashMap = new HashMap<Type, Type>(n2);
                    for (int i2 = 0; i2 < n2; ++i2) {
                        hashMap.put(object[i2], object2[i2]);
                    }
                    object = hashMap;
                    if (!((typeArray = TypeUtils.b(typeArray)) instanceof ParameterizedType)) break block7;
                    object2 = TypeUtils.getRawClass((Type)typeArray);
                    if ((typeArray = ((ParameterizedType)typeArray).getActualTypeArguments()).length <= 0) break;
                    object = TypeUtils.a(object2, typeArray, (Map<TypeVariable, Type>)object);
                }
                return TypeUtils.a(object2);
            }
            return TypeUtils.a((Class)typeArray);
        }
        if (object instanceof Class) {
            return TypeUtils.a((Class)object);
        }
        return Object.class;
    }

    private static Type a(Class<?> clazz) {
        if (clazz.getName().startsWith("java.")) {
            return Object.class;
        }
        return TypeUtils.getCollectionItemType(TypeUtils.b(clazz));
    }

    private static Type b(Class<?> clazz) {
        Type type = null;
        for (Type type2 : clazz.getGenericInterfaces()) {
            Class<?> clazz2 = TypeUtils.getRawClass(type2);
            if (clazz2 == Collection.class) {
                return type2;
            }
            if (!Collection.class.isAssignableFrom(clazz2)) continue;
            type = type2;
        }
        if (type == null) {
            return clazz.getGenericSuperclass();
        }
        return type;
    }

    private static ParameterizedType a(Class<?> clazz, Type[] typeArray, Map<TypeVariable, Type> map) {
        int n2 = typeArray.length;
        Type[] typeArray2 = new Type[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            typeArray2[i2] = TypeUtils.a(typeArray[i2], map);
        }
        return new ParameterizedTypeImpl(typeArray2, null, clazz);
    }

    private static Type a(Type type, Map<TypeVariable, Type> map) {
        if (type instanceof TypeVariable) {
            return map.get(type);
        }
        if (type instanceof ParameterizedType) {
            return TypeUtils.a(TypeUtils.getRawClass(type), ((ParameterizedType)type).getActualTypeArguments(), map);
        }
        if (type instanceof GenericArrayType) {
            return new GenericArrayTypeImpl(TypeUtils.a(((GenericArrayType)type).getGenericComponentType(), map));
        }
        return type;
    }

    public static Class<?> getCollectionItemClass(Type type) {
        if (type instanceof ParameterizedType) {
            Type[] typeArray;
            if ((type = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof WildcardType && (typeArray = ((WildcardType)type).getUpperBounds()).length == 1) {
                type = typeArray[0];
            }
            if (type instanceof Class) {
                if (!Modifier.isPublic(((Class)(type = (Class)type)).getModifiers())) {
                    throw new JSONException("can not create ASMParser");
                }
            } else {
                throw new JSONException("can not create ASMParser");
            }
            return type;
        }
        return Object.class;
    }

    public static Type checkPrimitiveArray(GenericArrayType type) {
        Type type2 = type;
        type = type.getGenericComponentType();
        String string = "[";
        while (type instanceof GenericArrayType) {
            type = type.getGenericComponentType();
            string = string + string;
        }
        if (type instanceof Class && ((Class)(type = (Class)type)).isPrimitive()) {
            try {
                if (type == Boolean.TYPE) {
                    type2 = Class.forName(string + "Z");
                } else if (type == Character.TYPE) {
                    type2 = Class.forName(string + "C");
                } else if (type == Byte.TYPE) {
                    type2 = Class.forName(string + "B");
                } else if (type == Short.TYPE) {
                    type2 = Class.forName(string + "S");
                } else if (type == Integer.TYPE) {
                    type2 = Class.forName(string + "I");
                } else if (type == Long.TYPE) {
                    type2 = Class.forName(string + "J");
                } else if (type == Float.TYPE) {
                    type2 = Class.forName(string + "F");
                } else if (type == Double.TYPE) {
                    type2 = Class.forName(string + "D");
                }
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return type2;
    }

    public static Collection createCollection(Type object) {
        Class clazz = TypeUtils.getRawClass((Type)object);
        if (clazz == AbstractCollection.class || clazz == Collection.class) {
            object = new ArrayList();
        } else if (clazz.isAssignableFrom(HashSet.class)) {
            object = new HashSet();
        } else if (clazz.isAssignableFrom(LinkedHashSet.class)) {
            object = new LinkedHashSet();
        } else if (clazz.isAssignableFrom(TreeSet.class)) {
            object = new TreeSet();
        } else if (clazz.isAssignableFrom(ArrayList.class)) {
            object = new ArrayList();
        } else if (clazz.isAssignableFrom(EnumSet.class)) {
            object = object instanceof ParameterizedType ? ((ParameterizedType)object).getActualTypeArguments()[0] : Object.class;
            object = EnumSet.noneOf((Class)object);
        } else if (clazz.isAssignableFrom(Queue.class) || N != null && clazz.isAssignableFrom(N)) {
            object = new LinkedList();
        } else {
            try {
                object = (Collection)clazz.newInstance();
            }
            catch (Exception exception) {
                throw new JSONException("create instance error, class " + clazz.getName());
            }
        }
        return object;
    }

    public static Class<?> getRawClass(Type object) {
        block3: {
            while (true) {
                if (object instanceof Class) {
                    return (Class)object;
                }
                if (object instanceof ParameterizedType) {
                    object = ((ParameterizedType)object).getRawType();
                    continue;
                }
                if (!(object instanceof WildcardType)) break block3;
                if (((Type[])(object = ((WildcardType)object).getUpperBounds())).length != 1) break;
                object = object[0];
            }
            throw new JSONException("TODO");
        }
        throw new JSONException("TODO");
    }

    public static boolean isProxy(Class<?> classArray) {
        classArray = classArray.getInterfaces();
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = classArray[i2].getName();
            if (string.equals("net.sf.cglib.proxy.Factory") || string.equals("org.springframework.cglib.proxy.Factory")) {
                return true;
            }
            if (string.equals("javassist.util.proxy.ProxyObject") || string.equals("org.apache.ibatis.javassist.util.proxy.ProxyObject")) {
                return true;
            }
            if (!string.equals("org.hibernate.proxy.HibernateProxy")) continue;
            return true;
        }
        return false;
    }

    public static boolean isTransient(Method method) {
        if (method == null) {
            return false;
        }
        if (!i) {
            try {
                j = Class.forName("java.beans.Transient");
            }
            catch (Exception exception) {
            }
            finally {
                i = true;
            }
        }
        if (j != null) {
            return TypeUtils.getAnnotation(method, j) != null;
        }
        return false;
    }

    public static boolean isAnnotationPresentOneToMany(Method method) {
        if (method == null) {
            return false;
        }
        if (k == null && !l) {
            try {
                k = Class.forName("javax.persistence.OneToMany");
            }
            catch (Throwable throwable) {
                l = true;
            }
        }
        return k != null && method.isAnnotationPresent(k);
    }

    public static boolean isAnnotationPresentManyToMany(Method method) {
        if (method == null) {
            return false;
        }
        if (m == null && !n) {
            try {
                m = Class.forName("javax.persistence.ManyToMany");
            }
            catch (Throwable throwable) {
                n = true;
            }
        }
        return m != null && (method.isAnnotationPresent(k) || method.isAnnotationPresent(m));
    }

    public static boolean isHibernateInitialized(Object object) {
        if (object == null) {
            return false;
        }
        if (o == null && !p) {
            try {
                o = Class.forName("org.hibernate.Hibernate").getMethod("isInitialized", Object.class);
            }
            catch (Throwable throwable) {
                p = true;
            }
        }
        if (o != null) {
            try {
                return (Boolean)o.invoke(null, object);
            }
            catch (Throwable throwable) {}
        }
        return true;
    }

    public static double parseDouble(String string) {
        int n2 = string.length();
        if (n2 > 10) {
            return Double.parseDouble(string);
        }
        boolean bl = false;
        long l2 = 0L;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = string.charAt(i2);
            if (n4 == 45 && i2 == 0) {
                bl = true;
                continue;
            }
            if (n4 == 46) {
                if (n3 != 0) {
                    return Double.parseDouble(string);
                }
                n3 = n2 - i2 - 1;
                continue;
            }
            if (n4 >= 48 && n4 <= 57) {
                l2 = l2 * 10L + (long)(n4 -= 48);
                continue;
            }
            return Double.parseDouble(string);
        }
        if (bl) {
            l2 = -l2;
        }
        switch (n3) {
            case 0: {
                return l2;
            }
            case 1: {
                return (double)l2 / 10.0;
            }
            case 2: {
                return (double)l2 / 100.0;
            }
            case 3: {
                return (double)l2 / 1000.0;
            }
            case 4: {
                return (double)l2 / 10000.0;
            }
            case 5: {
                return (double)l2 / 100000.0;
            }
            case 6: {
                return (double)l2 / 1000000.0;
            }
            case 7: {
                return (double)l2 / 1.0E7;
            }
            case 8: {
                return (double)l2 / 1.0E8;
            }
            case 9: {
                return (double)l2 / 1.0E9;
            }
        }
        return Double.parseDouble(string);
    }

    public static float parseFloat(String string) {
        int n2 = string.length();
        if (n2 >= 10) {
            return Float.parseFloat(string);
        }
        boolean bl = false;
        long l2 = 0L;
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4 = string.charAt(i2);
            if (n4 == 45 && i2 == 0) {
                bl = true;
                continue;
            }
            if (n4 == 46) {
                if (n3 != 0) {
                    return Float.parseFloat(string);
                }
                n3 = n2 - i2 - 1;
                continue;
            }
            if (n4 >= 48 && n4 <= 57) {
                l2 = l2 * 10L + (long)(n4 -= 48);
                continue;
            }
            return Float.parseFloat(string);
        }
        if (bl) {
            l2 = -l2;
        }
        switch (n3) {
            case 0: {
                return l2;
            }
            case 1: {
                return (float)l2 / 10.0f;
            }
            case 2: {
                return (float)l2 / 100.0f;
            }
            case 3: {
                return (float)l2 / 1000.0f;
            }
            case 4: {
                return (float)l2 / 10000.0f;
            }
            case 5: {
                return (float)l2 / 100000.0f;
            }
            case 6: {
                return (float)l2 / 1000000.0f;
            }
            case 7: {
                return (float)l2 / 1.0E7f;
            }
            case 8: {
                return (float)l2 / 1.0E8f;
            }
            case 9: {
                return (float)l2 / 1.0E9f;
            }
        }
        return Float.parseFloat(string);
    }

    public static long fnv1a_64_extract(String string) {
        long l2 = -3750763034362895579L;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 == '_' || c2 == '-') continue;
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            l2 = (l2 ^ (long)c2) * 1099511628211L;
        }
        return l2;
    }

    public static long fnv1a_64_lower(String string) {
        long l2 = -3750763034362895579L;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (c2 >= 'A' && c2 <= 'Z') {
                c2 = (char)(c2 + 32);
            }
            l2 = (l2 ^ (long)c2) * 1099511628211L;
        }
        return l2;
    }

    public static long fnv1a_64(String string) {
        long l2 = -3750763034362895579L;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            l2 = (l2 ^ (long)c2) * 1099511628211L;
        }
        return l2;
    }

    public static boolean isKotlin(Class clazz) {
        if (q == null && !r) {
            try {
                q = Class.forName("kotlin.Metadata");
            }
            catch (Throwable throwable) {
                r = true;
            }
        }
        return q != null && clazz.isAnnotationPresent(q);
    }

    public static Constructor getKotlinConstructor(Constructor[] constructorArray) {
        return TypeUtils.getKotlinConstructor(constructorArray, null);
    }

    public static Constructor getKotlinConstructor(Constructor[] constructorArray, String[] stringArray) {
        Constructor constructor = null;
        for (Constructor constructor2 : constructorArray) {
            Class<?>[] classArray = constructor2.getParameterTypes();
            if (stringArray != null && classArray.length != stringArray.length || classArray.length > 0 && classArray[classArray.length - 1].getName().equals("kotlin.jvm.internal.DefaultConstructorMarker") || constructor != null && constructor.getParameterTypes().length >= classArray.length) continue;
            constructor = constructor2;
        }
        return constructor;
    }

    public static String[] getKoltinConstructorParameters(Class object) {
        if (t == null && !s) {
            try {
                t = Class.forName("kotlin.reflect.jvm.internal.KClassImpl").getConstructor(Class.class);
            }
            catch (Throwable throwable) {
                s = true;
            }
        }
        if (t == null) {
            return null;
        }
        if (u == null && !s) {
            try {
                u = Class.forName("kotlin.reflect.jvm.internal.KClassImpl").getMethod("getConstructors", new Class[0]);
            }
            catch (Throwable throwable) {
                s = true;
            }
        }
        if (v == null && !s) {
            try {
                v = Class.forName("kotlin.reflect.KFunction").getMethod("getParameters", new Class[0]);
            }
            catch (Throwable throwable) {
                s = true;
            }
        }
        if (w == null && !s) {
            try {
                w = Class.forName("kotlin.reflect.KParameter").getMethod("getName", new Class[0]);
            }
            catch (Throwable throwable) {
                s = true;
            }
        }
        if (x) {
            return null;
        }
        try {
            Object object2;
            Object var1_1 = null;
            object = t.newInstance(object);
            object = ((Iterable)u.invoke(object, new Object[0])).iterator();
            while (object.hasNext()) {
                object2 = object.next();
                List list = (List)v.invoke(object2, new Object[0]);
                if (var1_1 == null || list.size() != 0) {
                    var1_1 = object2;
                }
                object.hasNext();
            }
            if (var1_1 == null) {
                return null;
            }
            object = (List)v.invoke(var1_1, new Object[0]);
            object2 = new String[object.size()];
            for (int i2 = 0; i2 < object.size(); ++i2) {
                var1_1 = object.get(i2);
                object2[i2] = (String)w.invoke(var1_1, new Object[0]);
            }
            return object2;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            x = true;
            return null;
        }
    }

    private static boolean b(Class clazz, String string) {
        Object[] objectArray;
        if (y == null && !z) {
            try {
                objectArray = new HashMap();
                Class<?> clazz2 = Class.forName("kotlin.ranges.CharRange");
                objectArray.put(clazz2, new String[]{"getEndInclusive", "isEmpty"});
                clazz2 = Class.forName("kotlin.ranges.IntRange");
                objectArray.put(clazz2, new String[]{"getEndInclusive", "isEmpty"});
                clazz2 = Class.forName("kotlin.ranges.LongRange");
                objectArray.put(clazz2, new String[]{"getEndInclusive", "isEmpty"});
                clazz2 = Class.forName("kotlin.ranges.ClosedFloatRange");
                objectArray.put(clazz2, new String[]{"getEndInclusive", "isEmpty"});
                clazz2 = Class.forName("kotlin.ranges.ClosedDoubleRange");
                objectArray.put(clazz2, new String[]{"getEndInclusive", "isEmpty"});
                y = objectArray;
            }
            catch (Throwable throwable) {
                z = true;
            }
        }
        if (y == null) {
            return false;
        }
        objectArray = y.get(clazz);
        return objectArray != null && Arrays.binarySearch(objectArray, string) >= 0;
    }

    public static <A extends Annotation> A getAnnotation(Class<?> clazz, Class<A> clazz2) {
        int n2;
        A a2 = clazz.getAnnotation(clazz2);
        Annotation[] annotationArray = null;
        Object object = JSON.getMixInAnnotations(clazz);
        if (object instanceof Class) {
            annotationArray = object;
        }
        if (annotationArray != null) {
            object = annotationArray.getAnnotation(clazz2);
            annotationArray = annotationArray.getAnnotations();
            if (object == null && annotationArray.length > 0) {
                Annotation[] annotationArray2 = annotationArray;
                n2 = annotationArray.length;
                for (int i2 = 0; i2 < n2 && (object = annotationArray2[i2].annotationType().getAnnotation(clazz2)) == null; ++i2) {
                }
            }
            if (object != null) {
                return (A)object;
            }
        }
        object = clazz.getAnnotations();
        if (a2 == null && ((Annotation[])object).length > 0) {
            Object object2 = object;
            int n3 = ((Annotation[])object).length;
            for (n2 = 0; n2 < n3 && (a2 = object2[n2].annotationType().getAnnotation(clazz2)) == null; ++n2) {
            }
        }
        return a2;
    }

    public static <A extends Annotation> A getAnnotation(Field object, Class<A> clazz) {
        A a2 = ((Field)object).getAnnotation(clazz);
        Object object2 = ((Field)object).getDeclaringClass();
        Type type = null;
        if ((object2 = JSON.getMixInAnnotations(object2)) instanceof Class) {
            type = object2;
        }
        if (type != null) {
            object2 = null;
            object = ((Field)object).getName();
            while (type != null && type != Object.class) {
                try {
                    object2 = ((Class)type).getDeclaredField((String)object);
                    break;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    type = ((Class)type).getSuperclass();
                }
            }
            if (object2 == null) {
                return a2;
            }
            object = ((Field)object2).getAnnotation(clazz);
            if (object != null) {
                return (A)object;
            }
        }
        return a2;
    }

    public static <A extends Annotation> A getAnnotation(Method object, Class<A> clazz) {
        A a2 = object.getAnnotation(clazz);
        Object object2 = object.getDeclaringClass();
        Type type = null;
        if ((object2 = JSON.getMixInAnnotations(object2)) instanceof Class) {
            type = object2;
        }
        if (type != null) {
            object2 = null;
            String string = object.getName();
            object = object.getParameterTypes();
            while (type != null && type != Object.class) {
                try {
                    object2 = ((Class)type).getDeclaredMethod(string, (Class<?>)object);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    type = ((Class)type).getSuperclass();
                }
            }
            if (object2 == null) {
                return a2;
            }
            object = ((Method)object2).getAnnotation(clazz);
            if (object != null) {
                return (A)object;
            }
        }
        return a2;
    }

    public static Annotation[][] getParameterAnnotations(Method classArray) {
        Annotation[][] annotationArray = classArray.getParameterAnnotations();
        Object object = classArray.getDeclaringClass();
        Type type = null;
        if ((object = JSON.getMixInAnnotations(object)) instanceof Class) {
            type = object;
        }
        if (type != null) {
            object = null;
            String string = classArray.getName();
            classArray = classArray.getParameterTypes();
            while (type != null && type != Object.class) {
                try {
                    object = ((Class)type).getDeclaredMethod(string, classArray);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    type = ((Class)type).getSuperclass();
                }
            }
            if (object == null) {
                return annotationArray;
            }
            classArray = ((Method)object).getParameterAnnotations();
            if (classArray != null) {
                return classArray;
            }
        }
        return annotationArray;
    }

    public static Annotation[][] getParameterAnnotations(Constructor classArray) {
        Annotation[][] annotationArray = classArray.getParameterAnnotations();
        Constructor constructor = classArray.getDeclaringClass();
        Type type = null;
        if ((constructor = JSON.getMixInAnnotations(constructor)) instanceof Class) {
            type = constructor;
        }
        if (type != null) {
            constructor = null;
            classArray = classArray.getParameterTypes();
            ArrayList arrayList = new ArrayList(2);
            for (Class<?> clazz = ((Class)type).getEnclosingClass(); clazz != null; clazz = clazz.getEnclosingClass()) {
                arrayList.add(clazz);
            }
            int n2 = arrayList.size();
            for (Class clazz = type; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
                try {
                    if (n2 != 0) {
                        Class[] classArray2 = new Class[n2 + classArray.length];
                        System.arraycopy(classArray, 0, classArray2, n2, classArray.length);
                        for (int i2 = n2; i2 > 0; --i2) {
                            classArray2[i2 - 1] = (Class)arrayList.get(i2 - 1);
                        }
                        constructor = ((Class)type).getDeclaredConstructor(classArray2);
                        break;
                    }
                    constructor = ((Class)type).getDeclaredConstructor(classArray);
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    --n2;
                    continue;
                }
            }
            if (constructor == null) {
                return annotationArray;
            }
            classArray = constructor.getParameterAnnotations();
            if (classArray != null) {
                return classArray;
            }
        }
        return annotationArray;
    }

    public static boolean isJacksonCreator(Method method) {
        if (method == null) {
            return false;
        }
        if (D == null && !E) {
            try {
                D = Class.forName("com.fasterxml.jackson.annotation.JsonCreator");
            }
            catch (Throwable throwable) {
                E = true;
            }
        }
        return D != null && method.isAnnotationPresent(D);
    }

    static {
        e = false;
        g = false;
        i = false;
        k = null;
        l = false;
        m = null;
        n = false;
        o = null;
        p = false;
        A = new ConcurrentHashMap(256, 0.75f, 1);
        C = false;
        D = null;
        E = false;
        F = null;
        G = false;
        H = null;
        I = null;
        J = false;
        K = null;
        L = null;
        M = null;
        N = null;
        try {
            compatibleWithJavaBean = "true".equals(IOUtils.getStringProperty("fastjson.compatibleWithJavaBean"));
            compatibleWithFieldName = "true".equals(IOUtils.getStringProperty("fastjson.compatibleWithFieldName"));
        }
        catch (Throwable throwable) {}
        try {
            N = Class.forName("java.util.Deque");
        }
        catch (Throwable throwable) {}
        TypeUtils.a();
    }
}

