/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.network;

import android.content.Context;
import android.text.TextUtils;
import com.tradplus.ads.common.event.BaseEvent;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.network.Networking;
import com.tradplus.ads.network.TPNetworkError;
import com.tradplus.ads.volley.DefaultRetryPolicy;
import com.tradplus.ads.volley.NetworkResponse;
import com.tradplus.ads.volley.Request;
import com.tradplus.ads.volley.RequestQueue;
import com.tradplus.ads.volley.Response;
import com.tradplus.ads.volley.VolleyError;
import com.tradplus.ads.volley.toolbox.HttpHeaderParser;
import java.util.Arrays;

public class TrackingRequest
extends Request<Void> {
    private final Listener a;

    private TrackingRequest(String string, Listener listener) {
        super(0, string, listener);
        this.a = listener;
        this.setShouldCache(false);
        this.setRetryPolicy(new DefaultRetryPolicy(2500, 0, 1.0f));
    }

    @Override
    public Response<Void> parseNetworkResponse(NetworkResponse networkResponse) {
        if (networkResponse.statusCode != 200) {
            return Response.error(new TPNetworkError("Failed to log tracking request. Response code: " + networkResponse.statusCode + " for url: " + this.getUrl(), TPNetworkError.Reason.TRACKING_FAILURE));
        }
        return Response.success(null, HttpHeaderParser.parseCacheHeaders(networkResponse));
    }

    @Override
    public void deliverResponse(Void void_) {
        if (this.a != null) {
            this.a.onResponse(this.getUrl());
        }
    }

    public static void makeTrackingHttpRequest(Iterable<String> object, Context object2, final Listener listener, BaseEvent.Name object3) {
        if (object == null || object2 == null) {
            return;
        }
        object2 = Networking.getRequestQueue((Context)object2);
        object = object.iterator();
        while (object.hasNext()) {
            object3 = (String)object.next();
            if (TextUtils.isEmpty((CharSequence)object3)) continue;
            Listener listener2 = new Listener((String)object3){
                final /* synthetic */ String b;
                {
                    this.b = string;
                }

                @Override
                public final void onResponse(String string) {
                    LogUtil.show("Successfully hit tracking endpoint: ".concat(String.valueOf(string)));
                    if (listener != null) {
                        listener.onResponse(string);
                    }
                }

                @Override
                public final void onErrorResponse(VolleyError volleyError) {
                    LogUtil.show("Failed to hit tracking endpoint: " + this.b);
                    if (listener != null) {
                        listener.onErrorResponse(volleyError);
                    }
                }
            };
            object3 = new TrackingRequest((String)object3, listener2);
            if (object2 == null) continue;
            ((RequestQueue)object2).add(object3);
        }
    }

    public static void makeTrackingHttpRequest(String string, Context context) {
        TrackingRequest.makeTrackingHttpRequest(string, context, null, null);
    }

    public static void makeTrackingHttpRequest(String string, Context context, Listener listener) {
        TrackingRequest.makeTrackingHttpRequest(string, context, listener, null);
    }

    public static void makeTrackingHttpRequest(String string, Context context, BaseEvent.Name name) {
        TrackingRequest.makeTrackingHttpRequest(string, context, null, name);
    }

    public static void makeTrackingHttpRequest(String string, Context context, Listener listener, BaseEvent.Name name) {
        if (string != null) {
            TrackingRequest.makeTrackingHttpRequest(Arrays.asList(string), context, listener, name);
        }
    }

    public static void makeTrackingHttpRequest(Iterable<String> iterable, Context context) {
        TrackingRequest.makeTrackingHttpRequest(iterable, context, null, null);
    }

    public static void makeTrackingHttpRequest(Iterable<String> iterable, Context context, BaseEvent.Name name) {
        TrackingRequest.makeTrackingHttpRequest(iterable, context, null, name);
    }

    public static interface Listener
    extends Response.ErrorListener {
        public void onResponse(String var1);
    }
}

