/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.volley.toolbox;

import android.os.SystemClock;
import com.tradplus.ads.volley.Cache;
import com.tradplus.ads.volley.VolleyLog;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DiskBasedCache
implements Cache {
    private final Map<String, a> a = new LinkedHashMap<String, a>(16, 0.75f, true);
    private long b = 0L;
    private final File c;
    private final int d;

    public DiskBasedCache(File file, int n2) {
        this.c = file;
        this.d = n2;
    }

    public DiskBasedCache(File file) {
        this(file, 0x500000);
    }

    @Override
    public synchronized void clear() {
        File[] fileArray = this.c.listFiles();
        if (fileArray != null) {
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                fileArray[i2].delete();
            }
        }
        this.a.clear();
        this.b = 0L;
        VolleyLog.d("Cache cleared.", new Object[0]);
    }

    /*
     * Loose catch block
     */
    @Override
    public synchronized Cache.Entry get(String string) {
        Object object = this.a.get(string);
        if (object == null) {
            return null;
        }
        File file = this.getFileForKey(string);
        FilterInputStream filterInputStream = null;
        filterInputStream = new b(new FileInputStream(file), 0);
        com.tradplus.ads.volley.toolbox.DiskBasedCache$a.readHeader(filterInputStream);
        byte[] byArray = DiskBasedCache.a(filterInputStream, (int)(file.length() - (long)((b)filterInputStream).a));
        object = ((a)object).toCacheEntry(byArray);
        try {
            filterInputStream.close();
        }
        catch (IOException iOException) {
            return null;
        }
        return object;
        catch (IOException iOException) {
            block12: {
                try {
                    VolleyLog.d("%s: %s", file.getAbsolutePath(), iOException.toString());
                    this.remove(string);
                    if (filterInputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (filterInputStream != null) {
                        try {
                            filterInputStream.close();
                        }
                        catch (IOException iOException2) {
                            return null;
                        }
                    }
                    throw throwable;
                }
                try {
                    filterInputStream.close();
                }
                catch (IOException iOException3) {
                    return null;
                }
            }
            return null;
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public synchronized void initialize() {
        if (!this.c.exists()) {
            if (!this.c.mkdirs()) {
                VolleyLog.e("Unable to create cache dir %s", this.c.getAbsolutePath());
            }
            return;
        }
        File[] fileArray = this.c.listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            BufferedInputStream bufferedInputStream = null;
            bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            a a2 = com.tradplus.ads.volley.toolbox.DiskBasedCache$a.readHeader(bufferedInputStream);
            com.tradplus.ads.volley.toolbox.DiskBasedCache$a.readHeader(bufferedInputStream).size = file.length();
            this.a(a2.key, a2);
            try {
                bufferedInputStream.close();
            }
            catch (IOException iOException) {}
            continue;
            catch (IOException iOException) {
                block15: {
                    try {
                        if (file == null) break block15;
                        file.delete();
                    }
                    catch (Throwable throwable) {
                        try {
                            if (bufferedInputStream != null) {
                                bufferedInputStream.close();
                            }
                        }
                        catch (IOException iOException2) {}
                        throw throwable;
                    }
                }
                try {
                    if (bufferedInputStream == null) continue;
                    bufferedInputStream.close();
                }
                catch (IOException iOException3) {}
            }
        }
    }

    @Override
    public synchronized void invalidate(String string, boolean bl) {
        Cache.Entry entry = this.get(string);
        if (entry != null) {
            entry.softTtl = 0L;
            if (bl) {
                entry.ttl = 0L;
            }
            this.put(string, entry);
        }
    }

    @Override
    public synchronized void put(String string, Cache.Entry entry) {
        int n2 = entry.data.length;
        Object object = this;
        if (((DiskBasedCache)object).b + (long)n2 >= (long)((DiskBasedCache)object).d) {
            if (VolleyLog.DEBUG) {
                VolleyLog.v("Pruning old cache entries.", new Object[0]);
            }
            long l2 = ((DiskBasedCache)object).b;
            int n3 = 0;
            long l3 = SystemClock.elapsedRealtime();
            Iterator<Map.Entry<String, a>> iterator = ((DiskBasedCache)object).a.entrySet().iterator();
            while (iterator.hasNext()) {
                a a2 = iterator.next().getValue();
                if (((DiskBasedCache)object).getFileForKey(a2.key).delete()) {
                    ((DiskBasedCache)object).b -= a2.size;
                } else {
                    VolleyLog.d("Could not delete cache entry for key=%s, filename=%s", a2.key, DiskBasedCache.a(a2.key));
                }
                iterator.remove();
                ++n3;
                if (!((float)(((DiskBasedCache)object).b + (long)n2) < (float)((DiskBasedCache)object).d * 0.9f)) continue;
            }
            if (VolleyLog.DEBUG) {
                VolleyLog.v("pruned %d files, %d bytes, %d ms", n3, ((DiskBasedCache)object).b - l2, SystemClock.elapsedRealtime() - l3);
            }
        }
        object = this.getFileForKey(string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            a a3 = new a(string, entry);
            if (!a3.writeHeader(fileOutputStream)) {
                fileOutputStream.close();
                VolleyLog.d("Failed to write header for %s", ((File)object).getAbsolutePath());
                throw new IOException();
            }
            fileOutputStream.write(entry.data);
            fileOutputStream.close();
            this.a(string, a3);
            return;
        }
        catch (IOException iOException) {
            if (!((File)object).delete()) {
                VolleyLog.d("Could not clean up file %s", ((File)object).getAbsolutePath());
            }
            return;
        }
    }

    @Override
    public synchronized void remove(String string) {
        boolean bl = this.getFileForKey(string).delete();
        String string2 = string;
        DiskBasedCache diskBasedCache = this;
        a a2 = diskBasedCache.a.get(string2);
        if (a2 != null) {
            diskBasedCache.b -= a2.size;
            diskBasedCache.a.remove(string2);
        }
        if (!bl) {
            VolleyLog.d("Could not delete cache entry for key=%s, filename=%s", string, DiskBasedCache.a(string));
        }
    }

    private static String a(String string) {
        int n2 = string.length() / 2;
        String string2 = String.valueOf(string.substring(0, n2).hashCode());
        return string2 + String.valueOf(string.substring(n2).hashCode());
    }

    public File getFileForKey(String string) {
        return new File(this.c, DiskBasedCache.a(string));
    }

    private void a(String string, a a2) {
        if (!this.a.containsKey(string)) {
            this.b += a2.size;
        } else {
            a a3 = this.a.get(string);
            this.b += a2.size - a3.size;
        }
        this.a.put(string, a2);
    }

    private static byte[] a(InputStream inputStream, int n2) {
        int n3;
        int n4;
        byte[] byArray = new byte[n2];
        for (n3 = 0; n3 < n2 && (n4 = inputStream.read(byArray, n3, n2 - n3)) != -1; n3 += n4) {
        }
        if (n3 != n2) {
            throw new IOException("Expected " + n2 + " bytes, read " + n3 + " bytes");
        }
        return byArray;
    }

    private static int e(InputStream inputStream) {
        int n2 = inputStream.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return n2;
    }

    static void a(OutputStream outputStream, int n2) {
        outputStream.write(n2 >> 0 & 0xFF);
        outputStream.write(n2 >> 8 & 0xFF);
        outputStream.write(n2 >> 16 & 0xFF);
        outputStream.write(n2 >> 24 & 0xFF);
    }

    static int a(InputStream inputStream) {
        return 0 | DiskBasedCache.e(inputStream) << 0 | DiskBasedCache.e(inputStream) << 8 | DiskBasedCache.e(inputStream) << 16 | DiskBasedCache.e(inputStream) << 24;
    }

    static void a(OutputStream outputStream, long l2) {
        outputStream.write((byte)(l2 >>> 0));
        outputStream.write((byte)(l2 >>> 8));
        outputStream.write((byte)(l2 >>> 16));
        outputStream.write((byte)(l2 >>> 24));
        outputStream.write((byte)(l2 >>> 32));
        outputStream.write((byte)(l2 >>> 40));
        outputStream.write((byte)(l2 >>> 48));
        outputStream.write((byte)(l2 >>> 56));
    }

    static long b(InputStream inputStream) {
        return 0L | ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 0 | ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 8 | ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 16 | ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 24 | ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 32 | ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 40 | ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 48 | ((long)DiskBasedCache.e(inputStream) & 0xFFL) << 56;
    }

    static void a(OutputStream outputStream, String object) {
        object = ((String)object).getBytes("UTF-8");
        DiskBasedCache.a(outputStream, (long)((Object)object).length);
        outputStream.write((byte[])object, 0, ((Object)object).length);
    }

    static String c(InputStream object) {
        int n2 = (int)DiskBasedCache.b((InputStream)object);
        object = DiskBasedCache.a((InputStream)object, n2);
        return new String((byte[])object, "UTF-8");
    }

    static void a(Map<String, String> object, OutputStream outputStream) {
        if (object != null) {
            DiskBasedCache.a(outputStream, object.size());
            for (Map.Entry entry : object.entrySet()) {
                DiskBasedCache.a(outputStream, (String)entry.getKey());
                DiskBasedCache.a(outputStream, (String)entry.getValue());
            }
            return;
        }
        DiskBasedCache.a(outputStream, 0);
    }

    static Map<String, String> d(InputStream inputStream) {
        int n2 = DiskBasedCache.a(inputStream);
        HashMap<String, String> hashMap = n2 == 0 ? Collections.emptyMap() : new HashMap<String, String>(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = DiskBasedCache.c(inputStream).intern();
            String string2 = DiskBasedCache.c(inputStream).intern();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    static final class b
    extends FilterInputStream {
        private int a = 0;

        private b(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public final int read() {
            int n2 = super.read();
            if (n2 != -1) {
                ++this.a;
            }
            return n2;
        }

        @Override
        public final int read(byte[] byArray, int n2, int n3) {
            int n4 = super.read(byArray, n2, n3);
            if (n4 != -1) {
                this.a += n4;
            }
            return n4;
        }

        /* synthetic */ b(InputStream inputStream, byte by) {
            this(inputStream);
        }
    }

    static final class a {
        public long size;
        public String key;
        public String etag;
        public long serverDate;
        public long ttl;
        public long softTtl;
        public Map<String, String> responseHeaders;

        private a() {
        }

        public a(String string, Cache.Entry entry) {
            this.key = string;
            this.size = entry.data.length;
            this.etag = entry.etag;
            this.serverDate = entry.serverDate;
            this.ttl = entry.ttl;
            this.softTtl = entry.softTtl;
            this.responseHeaders = entry.responseHeaders;
        }

        public static a readHeader(InputStream inputStream) {
            a a2 = new a();
            if (DiskBasedCache.a(inputStream) != 538183203) {
                throw new IOException();
            }
            a2.key = DiskBasedCache.c(inputStream);
            a2.etag = DiskBasedCache.c(inputStream);
            if (a2.etag.equals("")) {
                a2.etag = null;
            }
            a2.serverDate = DiskBasedCache.b(inputStream);
            a2.ttl = DiskBasedCache.b(inputStream);
            a2.softTtl = DiskBasedCache.b(inputStream);
            a2.responseHeaders = DiskBasedCache.d(inputStream);
            return a2;
        }

        public final Cache.Entry toCacheEntry(byte[] byArray) {
            Cache.Entry entry = new Cache.Entry();
            new Cache.Entry().data = byArray;
            entry.etag = this.etag;
            entry.serverDate = this.serverDate;
            entry.ttl = this.ttl;
            entry.softTtl = this.softTtl;
            entry.responseHeaders = this.responseHeaders;
            return entry;
        }

        public final boolean writeHeader(OutputStream outputStream) {
            try {
                DiskBasedCache.a(outputStream, 538183203);
                DiskBasedCache.a(outputStream, this.key);
                DiskBasedCache.a(outputStream, this.etag == null ? "" : this.etag);
                DiskBasedCache.a(outputStream, this.serverDate);
                DiskBasedCache.a(outputStream, this.ttl);
                DiskBasedCache.a(outputStream, this.softTtl);
                DiskBasedCache.a(this.responseHeaders, outputStream);
                outputStream.flush();
                return true;
            }
            catch (IOException iOException) {
                VolleyLog.d("%s", iOException.toString());
                return false;
            }
        }
    }
}

