/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.volley.toolbox;

import com.tradplus.ads.volley.toolbox.ByteArrayPool;
import java.io.ByteArrayOutputStream;

public class PoolingByteArrayOutputStream
extends ByteArrayOutputStream {
    private final ByteArrayPool a;

    public PoolingByteArrayOutputStream(ByteArrayPool byteArrayPool) {
        this(byteArrayPool, 256);
    }

    public PoolingByteArrayOutputStream(ByteArrayPool byteArrayPool, int n2) {
        this.a = byteArrayPool;
        this.buf = this.a.getBuf(Math.max(n2, 256));
    }

    @Override
    public void close() {
        this.a.returnBuf(this.buf);
        this.buf = null;
        super.close();
    }

    public void finalize() {
        this.a.returnBuf(this.buf);
    }

    private void a(int n2) {
        if (this.count + n2 <= this.buf.length) {
            return;
        }
        byte[] byArray = this.a.getBuf((this.count + n2) * 2);
        System.arraycopy(this.buf, 0, byArray, 0, this.count);
        this.a.returnBuf(this.buf);
        this.buf = byArray;
    }

    @Override
    public synchronized void write(byte[] byArray, int n2, int n3) {
        this.a(n3);
        super.write(byArray, n2, n3);
    }

    @Override
    public synchronized void write(int n2) {
        this.a(1);
        super.write(n2);
    }
}

