/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base;

import android.content.Context;
import android.net.ConnectivityManager;
import android.util.Log;

public class CommonUtil {
    public static final String TAG = "CommonUtils";

    public static <T extends String> boolean isNullOrEmpty(T t) {
        return t == null || t.length() == 0;
    }

    public static <T extends String> boolean isNotNullOrEmpty(T t) {
        return t != null && t.length() > 0;
    }

    public static boolean isNetConnect(Context context) {
        try {
            context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo();
            return context != null && context.isAvailable();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static int dip2px(Context context, float f) {
        float f2 = context.getResources().getDisplayMetrics().density;
        return (int)(f * f2 + 0.5f);
    }

    public static boolean isGranted(String string, Context context) {
        boolean bl = false;
        try {
            if (context.getPackageManager().checkPermission(string, context.getPackageName()) == 0) {
                bl = true;
                Log.d((String)TAG, (String)("Permission " + string + " is granted"));
            } else {
                Log.d((String)TAG, (String)("Permission " + string + " is NOT granted"));
            }
        }
        catch (Exception exception) {
            return false;
        }
        return bl;
    }

    public static int getResId(Context context, String string, String string2) {
        if (context != null) {
            return context.getResources().getIdentifier(string, string2, context.getPackageName());
        }
        return -1;
    }
}

