/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base;

import android.app.Activity;
import android.content.Context;
import android.os.Looper;
import android.util.Log;
import com.tradplus.ads.base.GetApplication;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.common.util.Utils;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GlobalTradPlus {
    private static GlobalTradPlus mInstance;
    private Context mContext;
    private WeakReference<Activity> activityRef;
    private boolean mAllowTracking = true;
    private String mAppId;
    private ConcurrentHashMap<String, Map<String, Object>> mUserLoadParams = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Map<String, String>> mConfigParam = new ConcurrentHashMap();
    private Map<String, Object> mLocalParam = new HashMap<String, Object>();
    private Map<String, Boolean> mFirstLoadTraceMap = new HashMap<String, Boolean>();
    private String mAdxAppKeywards;
    private ArrayList<String> mAdxAppSectionCat;
    private ArrayList<String> mAdxAppPageCat;
    private boolean isOpenPersonalizedAd = true;
    private boolean isPrivacyUserAgree = true;
    private String mWxAppId;

    private GlobalTradPlus() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GlobalTradPlus getInstance() {
        if (mInstance != null) return mInstance;
        Class<GlobalTradPlus> clazz = GlobalTradPlus.class;
        synchronized (GlobalTradPlus.class) {
            if (mInstance != null) return mInstance;
            mInstance = new GlobalTradPlus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public synchronized void refreshContext(Context context) {
        if (context == null) {
            return;
        }
        this.mContext = context.getApplicationContext();
        if (context instanceof Activity) {
            this.activityRef = new WeakReference<Activity>((Activity)context);
        }
    }

    public Activity getActivity() {
        if (this.activityRef != null) {
            return (Activity)this.activityRef.get();
        }
        return null;
    }

    public Context getContext() {
        if (this.mContext == null && Looper.myLooper() == Looper.getMainLooper()) {
            this.mContext = GetApplication.getContext();
        }
        return this.mContext;
    }

    public String getAppId() {
        return this.mAppId;
    }

    public void initTradPlusSdk(Context context, String string) {
        this.mAppId = string;
        TradPlus.invoker().initSDK(context, string);
    }

    public void setUserLoadParam(String string, Map<String, Object> map) {
        Map<String, Object> map2 = this.getUserLoadParam(string);
        map2.putAll(map);
        this.mUserLoadParams.put(string, map2);
    }

    public Map<String, Object> getUserLoadParam(String object) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if ((object = this.mUserLoadParams.get(object)) != null) {
            hashMap.putAll((Map<String, Object>)object);
        }
        return hashMap;
    }

    public Map<String, Object> getLocalParam() {
        this.mLocalParam.put("broadcastIdentifier", Utils.generateUniqueId());
        int n = TradPlus.isCCPADoNotSell(this.mContext);
        int n2 = TradPlus.isCOPPAAgeRestrictedUser(this.mContext);
        int n3 = TradPlus.getLGPDConsent(this.mContext);
        Log.i((String)"privacy", (String)("GlobalTradPlus getLocalParam coppa: " + n2 + ":ccpa:" + n + ":lgpdConsent:" + n3));
        this.mLocalParam.put("isue", TradPlus.isEUTraffic(this.mContext));
        this.mLocalParam.put("gdpr_consent", TradPlus.getGDPRDataCollection(this.mContext));
        if (n3 != -1) {
            this.mLocalParam.put("LGPD", n3);
        }
        if (n2 != -1) {
            this.mLocalParam.put("COPPA", n2 == 1);
        }
        if (n != -1) {
            this.mLocalParam.put("CCPA", n == 1);
        }
        this.mLocalParam.put("gdpr_child", TradPlus.getGDPRChild(this.mContext));
        return this.mLocalParam;
    }

    public void setConfigParam(String string, ConfigResponse configResponse) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("sec_ad_type", String.valueOf(configResponse.getSecType()));
        this.mConfigParam.put(string, hashMap);
    }

    public Map<String, String> getConfigParam(String object) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if ((object = this.mConfigParam.get(object)) != null) {
            hashMap.putAll((Map<String, String>)object);
        }
        return hashMap;
    }

    public void removeAdUnitFirstLoadTrace(String string) {
        if (string == null) {
            return;
        }
        this.mFirstLoadTraceMap.remove(string);
    }

    public void setAdUnitFirstLoadTrace(String string) {
        if (string == null) {
            return;
        }
        this.mFirstLoadTraceMap.put(string, Boolean.TRUE);
    }

    public boolean getAdUnitFirstLoadTrace(String string) {
        if (string == null) {
            return false;
        }
        return this.mFirstLoadTraceMap.containsKey(string);
    }

    public void setDevAllowTracking(boolean bl) {
        this.mAllowTracking = bl;
        TradPlus.invoker().setDevAllowTracking(bl);
    }

    public boolean isDevAllowTracking() {
        return this.mAllowTracking;
    }

    public void setAdxAppKeywords(String string) {
        this.mAdxAppKeywards = string;
    }

    public String getAdxAppKeywards() {
        return this.mAdxAppKeywards;
    }

    public void setAdxAppSectionCat(ArrayList<String> arrayList) {
        this.mAdxAppSectionCat.addAll(arrayList);
    }

    public ArrayList<String> getAdxAppSectionCat() {
        return this.mAdxAppSectionCat;
    }

    public void setAdxAppPageCat(ArrayList<String> arrayList) {
        this.mAdxAppPageCat.addAll(arrayList);
    }

    public ArrayList<String> getAdxAppPageCat() {
        return this.mAdxAppPageCat;
    }

    public boolean isOpenPersonalizedAd() {
        LogUtil.ownShow("isOpenPersonalizedAd " + this.isOpenPersonalizedAd);
        return this.isOpenPersonalizedAd;
    }

    public void setWxAppId(String string) {
        this.mWxAppId = string;
    }

    public String getWxAppId() {
        return this.mWxAppId;
    }

    public void setOpenPersonalizedAd(boolean bl) {
        this.isOpenPersonalizedAd = bl;
    }

    public boolean isPrivacyUserAgree() {
        return this.isPrivacyUserAgree;
    }

    public void setPrivacyUserAgree(boolean bl) {
        LogUtil.ownShow("privacyUserAgree ".concat(String.valueOf(bl)));
        this.isPrivacyUserAgree = bl;
    }

    public long getInitSdkTime() {
        return TradPlus.invoker().getStartInitSdkTime();
    }
}

