/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.RotateAnimation;
import android.widget.ImageView;
import com.tradplus.ads.base.CommonUtil;

public class LoadingView
extends ImageView {
    public LoadingView(Context context) {
        super(context);
        this.init();
    }

    public LoadingView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.init();
    }

    public LoadingView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.init();
    }

    private void init() {
        LoadingView loadingView = this;
        loadingView.setImageDrawable(loadingView.getResources().getDrawable(CommonUtil.getResId(this.getContext(), "core_loading", "drawable")));
        try {
            if (Build.VERSION.SDK_INT >= 19) {
                this.setLayerType(2, null);
            } else {
                this.setLayerType(1, null);
            }
        }
        catch (Exception exception) {}
        LoadingView loadingView2 = this;
        loadingView2.startAnimation((View)loadingView2);
    }

    private void startAnimation(View view) {
        RotateAnimation rotateAnimation = new RotateAnimation(0.0f, 360.0f, 1, 0.5f, 1, 0.5f);
        LinearInterpolator linearInterpolator = new LinearInterpolator();
        rotateAnimation.setRepeatCount(-1);
        rotateAnimation.setInterpolator((Interpolator)linearInterpolator);
        rotateAnimation.setDuration(1000L);
        view.startAnimation((Animation)rotateAnimation);
    }

    public void startAnimation() {
        LoadingView loadingView = this;
        loadingView.startAnimation((View)loadingView);
    }
}

