/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base;

import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.net.Uri;
import android.text.Html;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.CheckBox;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.tradplus.ads.base.CommonUtil;
import com.tradplus.ads.base.LoadingView;
import com.tradplus.ads.base.TradPlus;

public class PrivacyPolicyView
extends RelativeLayout
implements View.OnClickListener {
    private static String TAG = PrivacyPolicyView.class.getSimpleName();
    ViewGroup mPolicyContentView;
    LinearLayout mLoadingView;
    LoadingView mLoadingImageView;
    TextView mLoadingTextView;
    FrameLayout mWebviewArea;
    WebView mPolicyWebView;
    CheckBox mRecommendCheckBox;
    View mAgreeView;
    TextView mRejectView;
    boolean mIsWebViewloadSuccess = true;
    boolean mIsLoading = false;
    String mUrl;
    View.OnClickListener mClickCallbackListener;

    public PrivacyPolicyView(Context context) {
        super(context);
        this.init();
    }

    private void init() {
        try {
            LayoutInflater.from((Context)this.getContext()).inflate(CommonUtil.getResId(this.getContext(), "tp_privace_policy_layout", "layout"), (ViewGroup)this);
            this.mPolicyContentView = (ViewGroup)this.findViewById(CommonUtil.getResId(this.getContext(), "tp_policy_content_view", "id"));
            this.mLoadingView = (LinearLayout)this.findViewById(CommonUtil.getResId(this.getContext(), "tp_policy_loading_view", "id"));
            this.mLoadingImageView = new LoadingView(this.getContext());
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(CommonUtil.dip2px(this.getContext(), 30.0f), CommonUtil.dip2px(this.getContext(), 30.0f));
            new LinearLayout.LayoutParams(CommonUtil.dip2px(this.getContext(), 30.0f), CommonUtil.dip2px(this.getContext(), 30.0f)).gravity = 1;
            this.mLoadingImageView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mLoadingTextView = new TextView(this.getContext());
            layoutParams = new LinearLayout.LayoutParams(-2, -2);
            new LinearLayout.LayoutParams(-2, -2).gravity = 1;
            layoutParams.topMargin = CommonUtil.dip2px(this.getContext(), 5.0f);
            this.mLoadingTextView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
            this.mLoadingTextView.setText((CharSequence)"Page failed to load, please try again later.");
            this.mLoadingTextView.setTextColor(-8947849);
            this.mLoadingTextView.setTextSize(1, 12.0f);
            this.mLoadingView.addView((View)this.mLoadingImageView);
            this.mLoadingView.addView((View)this.mLoadingTextView);
            this.mLoadingView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    try {
                        if (PrivacyPolicyView.this.mPolicyWebView != null && !PrivacyPolicyView.this.mIsLoading) {
                            PrivacyPolicyView.this.mIsWebViewloadSuccess = true;
                            Log.d((String)TAG, (String)"reload.......");
                            PrivacyPolicyView.this.loadPolicyUrl(PrivacyPolicyView.this.mUrl);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        return;
                    }
                }
            });
            this.mWebviewArea = (FrameLayout)this.findViewById(CommonUtil.getResId(this.getContext(), "tp_policy_webview_area", "id"));
            this.mPolicyWebView = new WebView(this.getContext());
            this.mPolicyWebView.removeJavascriptInterface("searchBoxJavaBridge_");
            this.mPolicyWebView.removeJavascriptInterface("accessibility");
            this.mPolicyWebView.removeJavascriptInterface("accessibilityTraversal");
            this.mWebviewArea.addView((View)this.mPolicyWebView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            this.initPolicyWebView();
            this.mRecommendCheckBox = (CheckBox)this.findViewById(CommonUtil.getResId(this.getContext(), "tp_policy_check_box", "id"));
            this.mAgreeView = this.findViewById(CommonUtil.getResId(this.getContext(), "tp_policy_agree_view", "id"));
            this.mRejectView = (TextView)this.findViewById(CommonUtil.getResId(this.getContext(), "tp_policy_reject_view", "id"));
            this.mAgreeView.setOnClickListener((View.OnClickListener)this);
            this.mRejectView.setOnClickListener((View.OnClickListener)this);
            int n = CommonUtil.dip2px(this.getContext(), 20.0f);
            GradientDrawable gradientDrawable = new GradientDrawable();
            gradientDrawable.setColor(-13472268);
            gradientDrawable.setCornerRadius((float)n);
            this.mAgreeView.setBackgroundDrawable((Drawable)gradientDrawable);
            this.mRejectView.setText((CharSequence)Html.fromHtml((String)"<u>No,Thanks</u>"));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void initPolicyWebView() {
        WebSettings webSettings = this.mPolicyWebView.getSettings();
        if (webSettings != null) {
            webSettings.setJavaScriptEnabled(false);
            webSettings.setAppCacheEnabled(true);
            webSettings.setBuiltInZoomControls(true);
            webSettings.setJavaScriptCanOpenWindowsAutomatically(true);
            webSettings.setDomStorageEnabled(true);
            webSettings.setSupportZoom(false);
            webSettings.setSavePassword(false);
            webSettings.setDatabaseEnabled(false);
            webSettings.setAllowFileAccessFromFileURLs(false);
            webSettings.setAllowFileAccess(false);
            webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
            webSettings.setPluginState(WebSettings.PluginState.ON);
            webSettings.setLayoutAlgorithm(WebSettings.LayoutAlgorithm.NORMAL);
            webSettings.setLoadWithOverviewMode(true);
            webSettings.setUseWideViewPort(true);
        }
        this.mPolicyWebView.setWebViewClient(new WebViewClient(){

            public void onPageStarted(WebView webView, String string, Bitmap bitmap) {
                Log.d((String)TAG, (String)"onPageStarted\uff1a".concat(String.valueOf(string)));
                super.onPageStarted(webView, string, bitmap);
            }

            public void onPageFinished(WebView webView, String string) {
                try {
                    Log.d((String)TAG, (String)("onPageFinished\uff1a" + string + "   mIsWebViewloadSuccess:" + PrivacyPolicyView.this.mIsWebViewloadSuccess));
                    if (PrivacyPolicyView.this.mUrl.equals(string)) {
                        if (PrivacyPolicyView.this.mIsWebViewloadSuccess) {
                            PrivacyPolicyView.this.mLoadingView.setVisibility(4);
                            PrivacyPolicyView.this.mPolicyContentView.setVisibility(0);
                            PrivacyPolicyView.this.mLoadingView.setVisibility(8);
                            PrivacyPolicyView.this.mLoadingImageView.clearAnimation();
                        } else {
                            PrivacyPolicyView.this.mLoadingView.setVisibility(0);
                            PrivacyPolicyView.this.mLoadingImageView.clearAnimation();
                            PrivacyPolicyView.this.mLoadingTextView.setVisibility(0);
                            PrivacyPolicyView.this.mPolicyContentView.setVisibility(8);
                        }
                        PrivacyPolicyView.this.mIsLoading = false;
                        super.onPageFinished(webView, string);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    return;
                }
            }

            public boolean shouldOverrideUrlLoading(WebView webView, String string) {
                Log.d((String)TAG, (String)"shouldOverrideUrlLoading\uff1a".concat(String.valueOf(string)));
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    PrivacyPolicyView.this.openBrowser(PrivacyPolicyView.this.getContext(), string);
                    return true;
                }
                return false;
            }

            public void onReceivedError(WebView webView, WebResourceRequest webResourceRequest, WebResourceError webResourceError) {
                try {
                    PrivacyPolicyView.this.mIsWebViewloadSuccess = false;
                    super.onReceivedError(webView, webResourceRequest, webResourceError);
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
        });
        this.mPolicyWebView.setWebChromeClient(new WebChromeClient(){

            public void onReceivedTitle(WebView webView, String string) {
                try {
                    if (!TextUtils.isEmpty((CharSequence)string) && string.toLowerCase().contains("error")) {
                        PrivacyPolicyView.this.mIsWebViewloadSuccess = false;
                    }
                    super.onReceivedTitle(webView, string);
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
        });
    }

    public void loadPolicyUrl(String string) {
        Log.i((String)TAG, (String)"loadPolicyUrl test: ".concat(String.valueOf(string)));
        if (this.mIsLoading) {
            return;
        }
        this.mUrl = string;
        Log.i((String)TAG, (String)("loadPolicyUrl: " + this.mUrl));
        this.mIsWebViewloadSuccess = true;
        this.mLoadingView.setVisibility(0);
        this.mLoadingImageView.clearAnimation();
        this.mLoadingImageView.startAnimation();
        this.mLoadingTextView.setVisibility(8);
        this.mIsLoading = true;
        if (this.mUrl.equals(this.mPolicyWebView.getUrl())) {
            this.mPolicyWebView.reload();
            return;
        }
        this.mPolicyWebView.loadUrl(this.mUrl);
    }

    private void openBrowser(Context context, String string) {
        string = new Intent("android.intent.action.VIEW", Uri.parse((String)string));
        string.addCategory("android.intent.category.BROWSABLE");
        context.startActivity((Intent)string);
    }

    public void destory() {
        try {
            this.removeAllViews();
            if (this.mPolicyContentView != null) {
                this.mPolicyContentView.removeAllViews();
            }
            if (this.mWebviewArea != null) {
                this.mWebviewArea.removeView((View)this.mPolicyWebView);
                this.mPolicyWebView.removeAllViews();
            }
            if (this.mPolicyWebView != null) {
                this.mPolicyWebView.clearHistory();
                this.mPolicyWebView.clearCache(true);
                this.mPolicyWebView.destroy();
                this.mPolicyWebView = null;
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void setClickCallbackListener(View.OnClickListener onClickListener) {
        this.mClickCallbackListener = onClickListener;
    }

    public void onClick(View view) {
        if (view == this.mAgreeView) {
            TradPlus.setGDPRDataCollection(this.getContext(), 0);
            view.setTag((Object)0);
        } else if (view == this.mRejectView) {
            TradPlus.setGDPRDataCollection(this.getContext(), 1);
            view.setTag((Object)1);
        }
        this.mClickCallbackListener.onClick(view);
    }
}

