/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.adapter;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.event.TPPushCenter;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.JSONHelper;
import com.tradplus.ads.pushcenter.reqeust.InitNetworkRequest;
import com.tradplus.ads.pushcenter.utils.PushMessageUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public abstract class TPInitMediation {
    public Map<String, ArrayList<InitCallback>> initCallbackMap = new HashMap<String, ArrayList<InitCallback>>();
    public static Map<String, Boolean> isInitMap = new HashMap<String, Boolean>();
    protected boolean isOpenPersonalizedAd = true;
    public static final String INIT_STATE_OPEN = "1";
    public static final String INIT_STATE_BIDDING = "2";
    public static final String INIT_STATE_LOADAD = "3";
    protected String initState = "3";
    protected long initStartTime = System.currentTimeMillis();
    protected String networkId;
    public Runnable checkResultRunnable = new Runnable(){

        @Override
        public void run() {
            for (String string : TPInitMediation.this.initCallbackMap.keySet()) {
                TPInitMediation.this.sendResult(string, false, "", "");
            }
        }
    };

    public void setInitState(String string) {
        this.initState = string;
    }

    public synchronized boolean hasInit(String string, InitCallback initCallback) {
        ArrayList<InitCallback> arrayList = this.initCallbackMap.get(string);
        int n = arrayList != null ? arrayList.size() : 0;
        this.putInitMap(string, initCallback);
        boolean bl = n != 0;
        if (!bl) {
            TPTaskManager.getInstance().getThreadHandler().postDelayed(this.checkResultRunnable, 60000L);
        }
        return bl;
    }

    public static synchronized boolean isInited(String string) {
        return isInitMap.get(string) != null;
    }

    public synchronized void putInited(String string) {
        isInitMap.put(string, Boolean.TRUE);
    }

    public synchronized void removeInited(String string) {
        if (this.isOpenPersonalizedAd != GlobalTradPlus.getInstance().isOpenPersonalizedAd()) {
            isInitMap.remove(string);
        }
        this.isOpenPersonalizedAd = GlobalTradPlus.getInstance().isOpenPersonalizedAd();
    }

    public synchronized void putInitMap(String string, InitCallback initCallback) {
        ArrayList<InitCallback> arrayList = this.initCallbackMap.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList();
        }
        arrayList.add(initCallback);
        this.initCallbackMap.put(string, arrayList);
    }

    public synchronized void sendResult(String object, boolean bl, String string, String string2) {
        Object object2 = this.printAdapterVersion();
        if (isInitMap.get(object) == null || Boolean.FALSE.equals(isInitMap.get(object))) {
            this.sendInitRequest(bl, this.initState, (String)object2);
        }
        if (bl) {
            this.putInited((String)object);
        }
        TPTaskManager.getInstance().getThreadHandler().removeCallbacks(this.checkResultRunnable);
        object = this.initCallbackMap.get(object);
        if (object == null) {
            return;
        }
        while (((ArrayList)object).size() != 0) {
            object2 = (InitCallback)((ArrayList)object).get(0);
            if (bl) {
                object2.onSuccess();
            } else {
                object2.onFailed(String.valueOf(string), string2);
            }
            ((ArrayList)object).remove(object2);
        }
    }

    public void sendInitRequest(boolean bl, String string, String string2) {
        InitNetworkRequest initNetworkRequest = new InitNetworkRequest(this.getValidContext(), PushMessageUtils.PushStatus.EV_REQ_INIT_RESULT.getValue());
        initNetworkRequest.setLt("" + (System.currentTimeMillis() - this.initStartTime));
        initNetworkRequest.setCf(string);
        initNetworkRequest.setAsn(this.getNetworkVersionName());
        initNetworkRequest.setEmsg("Compatible version:" + string2 + ",Current version:" + this.getNetworkVersionCode());
        initNetworkRequest.setEc(bl ? INIT_STATE_OPEN : INIT_STATE_BIDDING);
        TPPushCenter.getInstance().saveEvent(initNetworkRequest);
    }

    public final void initMediationSDK(int n, ConfigResponse.WaterfallBean.ConfigBean configBean) {
        this.networkId = String.valueOf(n);
        this.initState = INIT_STATE_OPEN;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        Map<String, Object> map = GlobalTradPlus.getInstance().getLocalParam();
        hashMap.putAll(map);
        TPInitMediation tPInitMediation = this;
        tPInitMediation.initSDK(tPInitMediation.getValidContext(), hashMap, JSONHelper.beanToMap(configBean), new InitCallback(){

            @Override
            public void onSuccess() {
            }

            @Override
            public void onFailed(String string, String string2) {
            }
        });
    }

    public final Context getValidContext() {
        Activity activity = GlobalTradPlus.getInstance().getActivity();
        Context context = GlobalTradPlus.getInstance().getContext();
        if (activity == null) {
            return context;
        }
        return activity;
    }

    public void sendResult(String string, boolean bl) {
        this.sendResult(string, bl, "", "");
    }

    public void postDelayResult(final String string, long l) {
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                try {
                    TPInitMediation.this.sendResult(string, true);
                    return;
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        }, l);
    }

    public String printAdapterVersion() {
        Object object = "";
        try {
            Object object2 = this.getClass().getPackage().getName();
            object2 = Class.forName((String)object2 + ".BuildConfig");
            Object object3 = ((Class)object2).getField("VERSION_NAME");
            object2 = ((Class)object2).getField("NETWORK_VERSION");
            ((Field)object3).setAccessible(true);
            ((Field)object2).setAccessible(true);
            object3 = (String)((Field)object3).get(this);
            object2 = (String)((Field)object2).get(this);
            String string = this.getNetworkVersionCode();
            Log.i((String)"TradPlusLog", (String)("\u5f53\u524d\u96c6\u6210\u7684\u6e90\u4e3a" + this.getNetworkVersionName() + "\uff0cadapter\u7248\u672c\u4e3a" + (String)object3 + "\uff0c\u9002\u914d\u4e09\u65b9\u7248\u672c\u4e3a" + (String)object2 + "\uff0c\u5f53\u524d\u96c6\u6210\u7684\u4e09\u65b9\u7248\u672c\u4e3a" + string));
            object = object2;
        }
        catch (Throwable throwable) {}
        return object;
    }

    public abstract void initSDK(Context var1, Map<String, Object> var2, Map<String, String> var3, InitCallback var4);

    public abstract void suportGDPR(Context var1, Map<String, Object> var2);

    public abstract String getNetworkVersionCode();

    public abstract String getNetworkVersionName();

    public String getAdapterVersionCode() {
        try {
            Object object = this.getClass().getPackage().getName();
            object = Class.forName((String)object + ".BuildConfig").getField("VERSION_NAME");
            ((Field)object).setAccessible(true);
            return (String)((Field)object).get(this);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static interface InitCallback {
        public void onSuccess();

        public void onFailed(String var1, String var2);
    }
}

