/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.adapter.banner;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.common.AdapterCheckTimeOut;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.LogUtil;
import java.util.Map;

public abstract class TPBannerAdapter
extends TPBaseAdapter {
    private static final long TIME_DELTA = 30000L;
    private AdapterCheckTimeOut mCheckTimeOut;
    public ViewGroup mAdContainerView;
    protected int mAdHeight;
    protected int mAdWidth;
    protected int mAdViewWidth;
    protected int mAdViewHeight;

    @Override
    public void init() {
        ConfigResponse.WaterfallBean waterfallBean = this.getWaterfallBean();
        if (waterfallBean == null) {
            return;
        }
        long l = waterfallBean.getAdValidTime();
        if (l <= 0L) {
            return;
        }
        this.mCheckTimeOut = new AdapterCheckTimeOut(30000L);
        this.mCheckTimeOut.setValidTime(l * 1000L);
    }

    public void setFirstLoadedTime() {
        if (this.mCheckTimeOut != null) {
            this.mCheckTimeOut.setFirstLoadTime();
        }
    }

    public boolean isAdsTimeOut() {
        if (this.mCheckTimeOut != null) {
            return this.mCheckTimeOut.checkIsTimeOut();
        }
        return false;
    }

    public int getmAdViewWidth() {
        return this.mAdViewWidth;
    }

    public void setmAdViewWidth(int n) {
        this.mAdViewWidth = n;
    }

    public int getmAdViewHeight() {
        return this.mAdViewHeight;
    }

    public void setmAdViewHeight(int n) {
        this.mAdViewHeight = n;
    }

    @Override
    public boolean isReady() {
        return false;
    }

    public void setAdContainerView(ViewGroup viewGroup) {
        this.mAdContainerView = viewGroup;
    }

    public void setAdHeightAndWidthByService(String string, Map<String, String> map) {
        try {
            this.mAdHeight = Integer.parseInt(map.get("ad_size_info_y".concat(String.valueOf(string))));
            this.mAdWidth = Integer.parseInt(map.get("ad_size_info_x".concat(String.valueOf(string))));
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void setDefaultAdSize(int n, int n2) {
        if (this.mAdWidth == 0 || this.mAdHeight == 0) {
            this.mAdWidth = n;
            this.mAdHeight = n2;
        }
    }

    public void setDefaultAdViewSize(int n, int n2) {
        if (this.mAdViewWidth == 0 || this.mAdViewHeight == 0) {
            this.mAdViewWidth = n;
            this.mAdViewHeight = n2;
        }
    }

    public void setAdHeightAndWidthByUser(Map<String, Object> map) {
        try {
            if (map != null && map.size() > 0) {
                if (map.containsKey("width")) {
                    this.mAdViewWidth = (Integer)map.get("width");
                }
                if (map.containsKey("height")) {
                    this.mAdViewHeight = (Integer)map.get("height");
                }
            }
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public void printSize() {
        LogUtil.ownShow("TradPlusLog mAdViewWidth = " + this.mAdViewWidth + " mAdViewHeight = " + this.mAdViewHeight + " mAdWidth = " + this.mAdWidth + " mAdHeight = " + this.mAdHeight);
    }

    public void setBannerLayoutParams(View view) {
        if (view == null) {
            return;
        }
        Context context = GlobalTradPlus.getInstance().getContext();
        if (this.mAdViewWidth > 0 && this.mAdViewHeight > 0) {
            view.setLayoutParams(new ViewGroup.LayoutParams(DeviceUtils.dip2px(context, this.mAdViewWidth), DeviceUtils.dip2px(context, this.mAdViewHeight)));
            return;
        }
        if (this.mAdWidth > 0 && this.mAdHeight > 0) {
            view.setLayoutParams(new ViewGroup.LayoutParams(DeviceUtils.dip2px(context, this.mAdWidth), DeviceUtils.dip2px(context, this.mAdHeight)));
        }
    }

    public ViewGroup.LayoutParams getBannerParams() {
        Context context = GlobalTradPlus.getInstance().getContext();
        if (this.mAdViewWidth > 0 && this.mAdViewHeight > 0) {
            return new ViewGroup.LayoutParams(DeviceUtils.dip2px(context, this.mAdViewWidth), DeviceUtils.dip2px(context, this.mAdViewHeight));
        }
        if (this.mAdWidth > 0 && this.mAdHeight > 0) {
            return new ViewGroup.LayoutParams(DeviceUtils.dip2px(context, this.mAdWidth), DeviceUtils.dip2px(context, this.mAdHeight));
        }
        return new ViewGroup.LayoutParams(-2, -2);
    }
}

