/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.View;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.tradplus.ads.base.CommonUtil;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.bean.TPAdInfo;
import com.tradplus.ads.common.util.ResourceUtils;

public class TPAdInfoDialog
extends Dialog {
    private Context context;
    private LinearLayout layout_info;
    private TPAdInfo tpAdInfo;
    private boolean isAutoload;
    private Button btn_close;

    public TPAdInfoDialog(Context context, TPAdInfo tPAdInfo, boolean bl) {
        super(context);
        this.context = context;
        this.tpAdInfo = tPAdInfo;
        this.isAutoload = bl;
    }

    protected void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.requestWindowFeature(1);
        TPAdInfoDialog tPAdInfoDialog = this;
        tPAdInfoDialog.setContentView(ResourceUtils.getLayoutIdByName(tPAdInfoDialog.context, "tp_layout_adinfo"));
        this.layout_info = (LinearLayout)this.findViewById(CommonUtil.getResId(this.context, "tp_layout_info", "id"));
        this.btn_close = (Button)this.findViewById(CommonUtil.getResId(this.context, "btn_close", "id"));
        this.btn_close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                TPAdInfoDialog.this.dismiss();
            }
        });
        this.setWindowSize();
        this.setInfoText();
    }

    private void setInfoText() {
        Log.i((String)"TPSensorManager", (String)("tpAdInfo setInfoText " + this.tpAdInfo));
        if (this.tpAdInfo == null) {
            return;
        }
        this.bindTextView("AdUnitId", this.tpAdInfo.tpAdUnitId);
        this.bindTextView("Format", this.tpAdInfo.format);
        this.bindTextView("Network", this.tpAdInfo.adSourceName);
        this.bindTextView("Network Placement", this.tpAdInfo.adSourceId);
        this.bindTextView("Ecpm($)", this.tpAdInfo.ecpm);
        this.bindTextView("Ecpmcny(\uffe5)", this.tpAdInfo.ecpmcny);
        this.bindTextView("EcpmPrecision", this.tpAdInfo.ecpmPrecision);
        this.bindTextView("EcpmLevel", this.tpAdInfo.ecpmLevel);
        this.bindTextView("Load Time(ms)", "" + this.tpAdInfo.loadTime);
        this.bindTextView("Reward Name", this.tpAdInfo.rewardName);
        this.bindTextView("Reward Number", "" + this.tpAdInfo.rewardNumber);
        this.bindTextView("ISO Code", this.tpAdInfo.isoCode);
        this.bindTextView("isBidding", "" + this.tpAdInfo.isBiddingNetwork);
        this.bindTextView("Waterfall Index", "" + this.tpAdInfo.waterfallIndex);
        this.bindTextView("RequestId", this.tpAdInfo.requestId);
        this.bindTextView("Channel", this.tpAdInfo.channel);
        this.bindTextView("SubChannel", this.tpAdInfo.subChannel);
        this.bindTextView("SceneId", this.tpAdInfo.sceneId);
        this.bindTextView("BucketId", this.tpAdInfo.bucketId);
        this.bindTextView("SegmentId", this.tpAdInfo.segmentId);
        this.bindTextView("is Autoload", "" + this.isAutoload);
    }

    private void bindTextView(String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        TextView textView = new TextView(this.context);
        textView.setTextSize(18.0f);
        textView.setTextColor(this.context.getResources().getColor(17170443));
        textView.setPadding(20, 10, 20, 10);
        textView.setText((CharSequence)(string + ":" + string2));
        this.layout_info.addView((View)textView);
    }

    private void setWindowSize() {
        int n;
        int n2;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        Activity activity = GlobalTradPlus.getInstance().getActivity();
        if (activity == null) {
            n2 = 1920;
            n = 1080;
        } else {
            activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            n2 = displayMetrics.heightPixels;
            n = displayMetrics.widthPixels;
        }
        WindowManager.LayoutParams layoutParams = this.getWindow().getAttributes();
        this.getWindow().getAttributes().height = (int)((double)n2 * 0.7);
        layoutParams.width = (int)((double)n * 0.85);
        layoutParams.alpha = 0.7f;
        layoutParams.dimAmount = 0.0f;
        this.getWindow().setAttributes(layoutParams);
    }
}

