/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.adapter.TPBaseAdapter;
import com.tradplus.ads.base.bean.TPAdInfo;
import com.tradplus.ads.base.bean.TPImpCallbackInfo;
import com.tradplus.ads.base.bean.TPRewardCallbackInfo;
import com.tradplus.ads.base.common.OnCallbackPrintListener;
import com.tradplus.ads.base.common.TPURLManager;
import com.tradplus.ads.base.config.ConfigLoadManager;
import com.tradplus.ads.base.network.BaseHttpRequest;
import com.tradplus.ads.base.network.TPRequestManager;
import com.tradplus.ads.base.network.TPUrlGenerator;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.serialization.TypeReference;
import com.tradplus.ads.common.serialization.parser.Feature;
import com.tradplus.ads.common.util.LogUtil;
import java.util.Map;

public class TPCallbackManager
implements BaseHttpRequest.OnHttpLoaderListener {
    private String url;
    private int restartCount;
    private TPAdInfo tpAdInfo;
    public static final int CALLBACK_REWARD = 0;
    public static final int CALLBACK_IMP = 1;
    private ConfigResponse.WaterfallBean waterfallBean;
    private String unitId;
    private static OnCallbackPrintListener onCallbackPrintListener;
    private int callbackType;
    private TPBaseAdapter baseAdapter;

    public TPCallbackManager(String string, int n, TPBaseAdapter tPBaseAdapter, TPAdInfo tPAdInfo) {
        this.tpAdInfo = tPAdInfo;
        this.callbackType = n;
        this.unitId = string;
        this.waterfallBean = tPBaseAdapter.getWaterfallBean();
        this.url = this.getCallbackUrl(string, tPBaseAdapter);
        this.baseAdapter = tPBaseAdapter;
    }

    public void startCallbackRequest() {
        Object object = ConfigLoadManager.getInstance().getLocalConfigResponse(this.unitId);
        if (object == null) {
            return;
        }
        if (this.callbackType == 0) {
            if (((ConfigResponse)object).getIs_server_callback() == 0) {
                return;
            }
        } else if (this.callbackType == 1) {
            if (onCallbackPrintListener != null && this.baseAdapter != null) {
                onCallbackPrintListener.onPrint(this.baseAdapter, this.tpAdInfo);
            }
            if (((ConfigResponse)object).getIs_server_imp_callback() == 0) {
                return;
            }
        }
        object = new TPUrlGenerator(GlobalTradPlus.getInstance().getContext());
        ((TPUrlGenerator)object).generateCallback(this.getCallbackParams());
        TPRequestManager.getInstance().requestCallback(this.url, (TPUrlGenerator)object, this);
    }

    public Map<String, String> getCallbackParams() {
        Map<String, String> map = null;
        if (this.callbackType == 0) {
            map = JSON.parseObject(JSON.toJSONString(new TPRewardCallbackInfo(this.unitId, this.baseAdapter, this.tpAdInfo)), new TypeReference<Map<String, String>>(){}, new Feature[0]);
        } else if (this.callbackType == 1) {
            map = JSON.parseObject(JSON.toJSONString(new TPImpCallbackInfo(this.unitId, this.baseAdapter, this.tpAdInfo)), new TypeReference<Map<String, String>>(){}, new Feature[0]);
        }
        return map;
    }

    public String getCallbackUrl(String string, TPBaseAdapter tPBaseAdapter) {
        string = "";
        if (this.callbackType == 0) {
            string = TPURLManager.getInstance().getRewardCallbackHost();
        } else if (this.callbackType == 1) {
            string = TPURLManager.getInstance().getImpCallbackHost();
        }
        LogUtil.ownShow("callback url = ".concat(String.valueOf(string)));
        return string;
    }

    public void loadSuccess(Object object) {
    }

    @Override
    public void loadError(int n, String string) {
        ++this.restartCount;
        if (this.restartCount <= 2) {
            this.startCallbackRequest();
        }
    }

    @Override
    public void loadCanceled() {
    }

    public static void setOnCallbackPrintListener(OnCallbackPrintListener onCallbackPrintListener) {
        TPCallbackManager.onCallbackPrintListener = onCallbackPrintListener;
    }
}

