/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.content.Context;
import android.os.Process;
import com.tradplus.ads.base.db.StoreManager;
import com.tradplus.ads.base.util.ACache;
import com.tradplus.ads.base.util.TradPlusDataConstants;
import java.io.PrintWriter;
import java.io.StringWriter;

public class TPCrashHandler
implements Thread.UncaughtExceptionHandler {
    public static final String TAG = "CrashHandler";
    private Thread.UncaughtExceptionHandler mDefaultHandler;
    private static TPCrashHandler INSTANCE = new TPCrashHandler();
    private Context mContext;
    private volatile boolean hasInit = false;
    public CrashHandlerCallback callback;

    private TPCrashHandler() {
    }

    public static TPCrashHandler getInstance() {
        return INSTANCE;
    }

    public void init(Context context) {
        if (this.hasInit) {
            return;
        }
        this.hasInit = true;
        this.mContext = context;
        this.mDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
    }

    @Override
    public void uncaughtException(Thread thread, Throwable throwable) {
        this.clearDB();
        this.sendEx(throwable);
        if (this.mDefaultHandler != null) {
            this.mDefaultHandler.uncaughtException(thread, throwable);
            return;
        }
        Process.killProcess((int)Process.myPid());
        System.exit(1);
    }

    private void clearDB() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    StoreManager.clearConfigResponse();
                    ACache.get(TPCrashHandler.this.mContext, TradPlusDataConstants.CACHETRADPLUSCONFIGTYPE).clear();
                    return;
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        }).start();
    }

    private void sendEx(final Throwable throwable) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TPCrashHandler.this.callback != null) {
                        StringWriter stringWriter = new StringWriter();
                        PrintWriter printWriter = new PrintWriter(stringWriter);
                        throwable.printStackTrace(printWriter);
                        TPCrashHandler.this.callback.crashMsg(((Object)stringWriter).toString());
                    }
                    return;
                }
                catch (Throwable throwable2) {
                    return;
                }
            }
        }).start();
    }

    public static interface CrashHandlerCallback {
        public void crashMsg(String var1);
    }
}

