/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.content.Context;
import android.graphics.Point;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import com.tradplus.ads.base.Const;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.common.SPCacheUtil;
import com.tradplus.ads.base.util.OaidUtil;
import com.tradplus.ads.base.util.oaid.OaidCallback;
import com.tradplus.ads.common.AdvertisingIdClient;
import com.tradplus.ads.common.Preconditions;
import com.tradplus.ads.common.VisibleForTesting;
import com.tradplus.ads.common.util.DeviceUtils;
import com.tradplus.ads.common.util.Dips;
import com.tradplus.ads.common.util.LogUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.Reader;
import java.util.Locale;

public class TPDataCenter {
    private static final int TYPE_ETHERNET = 9;
    private static final String DEVICE_ORIENTATION_PORTRAIT = "p";
    private static final String DEVICE_ORIENTATION_LANDSCAPE = "l";
    private static final String DEVICE_ORIENTATION_SQUARE = "s";
    private static final String DEVICE_ORIENTATION_UNKNOWN = "u";
    private static final String IFA_PREFIX = "ifa:";
    private static final String SHA_PREFIX = "sha:";
    private static final int UNKNOWN_NETWORK = -1;
    private static volatile TPDataCenter sInstance;
    private final Context mContext;
    private final ConnectivityManager mConnectivityManager;
    public static final int NETWORK_TYPE_UNAVAILABLE = -1;
    public static final int NETWORK_TYPE_WIFI = -101;
    public static final int NETWORK_CLASS_UNAVAILABLE = -1;
    public static final int NETWORK_CLASS_UNKNOWN = 0;
    public static final int NETWORK_CLASS_WIFI = 1;
    public static final int NETWORK_CLASS_2_G = 2;
    public static final int NETWORK_CLASS_3_G = 3;
    public static final int NETWORK_CLASS_4_G = 4;
    public static final int NETWORK_CLASS_5_G = 5;
    public static final int NETWORK_CLASS_CP_WIFI = 2;
    public static final int NETWORK_CLASS_CP_2_G = 4;
    public static final int NETWORK_CLASS_CP_3_G = 5;
    public static final int NETWORK_CLASS_CP_4_G = 6;
    public static final int NETWORK_CLASS_CP_5_G = 7;
    public static final int NETWORK_TYPE_UNKNOWN = 0;
    public static final int NETWORK_TYPE_GPRS = 1;
    public static final int NETWORK_TYPE_EDGE = 2;
    public static final int NETWORK_TYPE_UMTS = 3;
    public static final int NETWORK_TYPE_CDMA = 4;
    public static final int NETWORK_TYPE_EVDO_0 = 5;
    public static final int NETWORK_TYPE_EVDO_A = 6;
    public static final int NETWORK_TYPE_1xRTT = 7;
    public static final int NETWORK_TYPE_HSDPA = 8;
    public static final int NETWORK_TYPE_HSUPA = 9;
    public static final int NETWORK_TYPE_HSPA = 10;
    public static final int NETWORK_TYPE_IDEN = 11;
    public static final int NETWORK_TYPE_EVDO_B = 12;
    public static final int NETWORK_TYPE_LTE = 13;
    public static final int NETWORK_TYPE_EHRPD = 14;
    public static final int NETWORK_TYPE_HSPAP = 15;
    public static final int NETWORK_TYPE_NR = 20;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TPDataCenter getInstance(Context context) {
        TPDataCenter tPDataCenter = sInstance;
        if (tPDataCenter != null) return tPDataCenter;
        Class<TPDataCenter> clazz = TPDataCenter.class;
        synchronized (TPDataCenter.class) {
            tPDataCenter = sInstance;
            if (tPDataCenter != null) return tPDataCenter;
            sInstance = tPDataCenter = new TPDataCenter(context);
            // ** MonitorExit[var2_3] (shouldn't be in output)
            return tPDataCenter;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TPDataCenter getInstance() {
        TPDataCenter tPDataCenter = sInstance;
        if (tPDataCenter != null) return tPDataCenter;
        Class<TPDataCenter> clazz = TPDataCenter.class;
        synchronized (TPDataCenter.class) {
            return sInstance;
        }
    }

    public TPDataCenter(Context context) {
        this.mContext = context.getApplicationContext();
        this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
    }

    public String getInstallTime(Context context) {
        try {
            return String.valueOf(context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).firstInstallTime / 1000L);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return "";
        }
    }

    public String getAppVersionFromContext(Context context) {
        try {
            String string = context.getPackageName();
            return context.getPackageManager().getPackageInfo((String)string, (int)0).versionName;
        }
        catch (Throwable throwable) {
            LogUtil.show("Failed to retrieve PackageInfo#versionName.");
            return null;
        }
    }

    public String getAppPackageNameFromContext(Context context) {
        try {
            String string = context.getPackageName();
            return context.getPackageManager().getPackageInfo((String)string, (int)0).packageName;
        }
        catch (Throwable throwable) {
            LogUtil.show("Failed to retrieve PackageInfo#versionName.");
            return null;
        }
    }

    public void getOaid(Context context, final OnTPAdIdListener onTPAdIdListener) {
        OaidUtil.initOaidServerAndGetOaid(context, new OaidCallback(){

            @Override
            public void onSuccuss(String string, boolean bl) {
                Log.i((String)"tradplus", (String)("oaid = " + string + " isOaidTrackLimited = " + bl));
                if (onTPAdIdListener != null) {
                    onTPAdIdListener.onResult(string, bl);
                }
            }

            @Override
            public void onFail(String string) {
                Log.i((String)"tradplus", (String)"oaid errMsg = ".concat(String.valueOf(string)));
            }
        });
    }

    public void getAdvertisingInfo(Context context, OnTPAdIdListener onTPAdIdListener) {
        if (TradPlus.isEUTraffic(context) && TradPlus.getGDPRDataCollection(context) != 0) {
            if (onTPAdIdListener != null) {
                onTPAdIdListener.onResult("", false);
                return;
            }
        } else {
            this.getAdertisingId(context, onTPAdIdListener);
        }
    }

    public void getAdertisingId(final Context context, final OnTPAdIdListener onTPAdIdListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (TradPlus.isEUTraffic(context) && (TradPlus.getGDPRDataCollection(context) == 1 || TradPlus.getGDPRDataCollection(context) == 2)) {
                        return;
                    }
                    if (!TradPlus.invoker().isAllowTracking()) {
                        return;
                    }
                    AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(context);
                    String string = adInfo.getId();
                    boolean bl = adInfo.isLimitAdTrackingEnabled();
                    if (bl) {
                        string = "";
                    }
                    if (onTPAdIdListener != null) {
                        onTPAdIdListener.onResult(string, bl);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        }).start();
    }

    public void getAdertisingIdM(final Context context, final OnTPAdIdListener onTPAdIdListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!TradPlus.invoker().isDevAllowTracking()) {
                        return;
                    }
                    if (SPCacheUtil.getInt(context, Const.SPU_NAME, "UPLOAD_DATA_LEVEL", 2) == 1) {
                        return;
                    }
                    if (TradPlus.getGDPRChild(context)) {
                        return;
                    }
                    if (TradPlus.isCOPPAAgeRestrictedUser(context) == 1) {
                        return;
                    }
                    AdvertisingIdClient.AdInfo adInfo = AdvertisingIdClient.getAdvertisingIdInfo(context);
                    String string = adInfo.getId();
                    boolean bl = adInfo.isLimitAdTrackingEnabled();
                    LogUtil.ownShow("mAdvertisingIdm = ".concat(String.valueOf(string)));
                    LogUtil.ownShow("mAdvertisingLimitedm = ".concat(String.valueOf(bl)));
                    if (bl) {
                        string = "";
                    }
                    if (onTPAdIdListener != null) {
                        onTPAdIdListener.onResult(string, bl);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        }).start();
    }

    public String getTotalRam() {
        Object object = "/proc/meminfo";
        String string = null;
        int n = 0;
        try {
            object = new FileReader((String)object);
            object = new BufferedReader((Reader)object, 4096);
            string = ((BufferedReader)object).readLine().split("\\s+")[1];
            ((BufferedReader)object).close();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (string != null) {
            n = (int)Math.ceil(new Float(Float.valueOf(string).floatValue() / 1048576.0f).doubleValue());
        }
        return String.valueOf(n);
    }

    public int getScreenWidth(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getApplicationContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.widthPixels;
    }

    public int getScreenHeight(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getApplicationContext().getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.heightPixels;
    }

    public String getLanguageCode(Context object) {
        String string = Locale.getDefault().getLanguage();
        object = object.getResources().getConfiguration().locale;
        if (object != null && !((Locale)object).getLanguage().trim().isEmpty()) {
            string = ((Locale)object).getLanguage().trim();
        }
        return string;
    }

    public String getOrientationString() {
        int n = this.mContext.getResources().getConfiguration().orientation;
        String string = DEVICE_ORIENTATION_UNKNOWN;
        if (n == 1) {
            string = DEVICE_ORIENTATION_PORTRAIT;
        } else if (n == 2) {
            string = DEVICE_ORIENTATION_LANDSCAPE;
        } else if (n == 3) {
            string = DEVICE_ORIENTATION_SQUARE;
        }
        return string;
    }

    public int getOrientationInt(Context context) {
        return context.getResources().getConfiguration().orientation;
    }

    public TPNetworkType getActiveNetworkType() {
        NetworkInfo networkInfo = this.mConnectivityManager.getActiveNetworkInfo();
        return TPNetworkType.fromAndroidNetworkType(networkInfo != null ? networkInfo.getType() : -1);
    }

    public void getNetworkType(final OnTPNetworkTypeListener onTPNetworkTypeListener) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    int n = 0;
                    NetworkInfo networkInfo = TPDataCenter.this.mConnectivityManager.getActiveNetworkInfo();
                    if (networkInfo != null && networkInfo.isAvailable() && networkInfo.isConnected()) {
                        int n2 = networkInfo.getType();
                        if (n2 == 1) {
                            n = -101;
                        } else if (n2 == 0) {
                            n = ((TelephonyManager)TPDataCenter.this.mContext.getSystemService("phone")).getNetworkType();
                        }
                    } else {
                        n = -1;
                    }
                    if (onTPNetworkTypeListener != null) {
                        onTPNetworkTypeListener.onResult(n);
                    }
                    return;
                }
                catch (Throwable throwable) {
                    return;
                }
            }
        }).start();
    }

    public float getDensity() {
        return this.mContext.getResources().getDisplayMetrics().density;
    }

    public int getDpi() {
        return this.mContext.getResources().getDisplayMetrics().densityDpi;
    }

    public String getNetworkOperator() {
        return "";
    }

    public Locale getDeviceLocale() {
        return this.mContext.getResources().getConfiguration().locale;
    }

    public int getDeviceScreenWidthDip() {
        return Dips.screenWidthAsIntDips(this.mContext);
    }

    public int getDeviceScreenHeightDip() {
        return Dips.screenHeightAsIntDips(this.mContext);
    }

    public Point getDeviceDimensions() {
        if (Preconditions.NoThrow.checkNotNull(this.mContext)) {
            return DeviceUtils.getDeviceDimensions(this.mContext);
        }
        return new Point(0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @VisibleForTesting
    public static void setInstance(TPDataCenter tPDataCenter) {
        Class<TPDataCenter> clazz = TPDataCenter.class;
        synchronized (TPDataCenter.class) {
            sInstance = tPDataCenter;
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    @VisibleForTesting
    public static void clearForTesting() {
        sInstance = null;
    }

    public String getDeviceType(Context context) {
        if ((context.getResources().getConfiguration().screenLayout & 0xF) >= 3) {
            return "2";
        }
        return "1";
    }

    public static interface OnTPNetworkTypeListener {
        public void onResult(int var1);
    }

    public static interface OnTPAdIdListener {
        public void onResult(String var1, boolean var2);
    }

    public static enum TPNetworkType {
        UNKNOWN(0),
        ETHERNET(1),
        WIFI(2),
        MOBILE(3);

        private final int mId;

        private TPNetworkType(int n2) {
            this.mId = n2;
        }

        public final String toString() {
            return Integer.toString(this.mId);
        }

        private static TPNetworkType fromAndroidNetworkType(int n) {
            switch (n) {
                case 9: {
                    return ETHERNET;
                }
                case 1: {
                    return WIFI;
                }
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    return MOBILE;
                }
            }
            return UNKNOWN;
        }

        public final int getId() {
            return this.mId;
        }
    }
}

