/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import com.tradplus.ads.base.Const;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.common.SPCacheUtil;
import com.tradplus.ads.base.common.TPDataCenter;
import com.tradplus.ads.base.util.OaidUtil;
import com.tradplus.ads.base.util.TestDeviceUtil;
import com.tradplus.ads.base.util.oaid.OaidCallback;
import com.tradplus.ads.common.util.CMData;
import com.tradplus.ads.pushcenter.event.utils.CPIds;
import com.tradplus.ads.pushcenter.event.utils.SegmentIds;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class TPDataManager {
    private static TPDataManager instance;
    private TPDataCenter tpDataCenter;
    private Context context = GlobalTradPlus.getInstance().getContext();
    private String uuId;
    private String tpGuid;
    private boolean testModeFile;
    private boolean debugModeFile;
    private boolean chinaPluginFile;
    private String mIsoCountryCode;
    private int mWidthPixels;
    private int mHeightPixels;
    private String mLanguageCode;
    private int discardconf;
    private Map<String, CPIds> cpIdsMap;
    private Map<String, SegmentIds> segmentIdsMap;
    private String mDeviceOsVersion;
    private String mSdkVersion;
    private String mAppVersion;
    private String mAppPackageName;
    private String mAppName;
    private String mDeviceType;
    private String firstInstallTime;
    private String mRam;
    private String ip;
    private String iso;
    public String mAdvertisingId;
    public boolean mAdvertisingLimited;
    private String mOaid;
    private boolean mOaidLimited;
    private int mNetworkType = 0;
    private static final String DEBUG_MODE = "tp_debug_mode.flag";
    private static final String TEST_MODE = "tp_test_env.flag";
    private static final String CHECK_CHINA_PLUGIN = "check_china_plugin.flag";

    public TPDataManager() {
        this.tpDataCenter = TPDataCenter.getInstance(this.context);
        this.cpIdsMap = new HashMap<String, CPIds>();
        this.segmentIdsMap = new HashMap<String, SegmentIds>();
        this.testModeFile = this.checkTestMode();
        this.debugModeFile = this.checkDebugMode();
        this.chinaPluginFile = this.checkChinaPlugin();
        this.mIsoCountryCode = this.context.getResources().getConfiguration().locale.getCountry();
        this.mWidthPixels = this.tpDataCenter.getScreenWidth(this.context);
        this.mHeightPixels = this.tpDataCenter.getScreenHeight(this.context);
        this.mDeviceOsVersion = Build.VERSION.RELEASE;
        this.mSdkVersion = "9.4.30.1";
        this.mAppPackageName = this.context.getPackageName();
        Object object = null;
        PackageManager packageManager = this.context.getPackageManager();
        try {
            object = packageManager.getApplicationInfo(this.mAppPackageName, 0);
        }
        catch (Throwable throwable) {}
        if (object != null) {
            this.mAppName = (String)packageManager.getApplicationLabel((ApplicationInfo)object);
        }
        this.mDeviceType = this.tpDataCenter.getDeviceType(this.context);
        this.mAppVersion = this.tpDataCenter.getAppVersionFromContext(this.context);
        this.mLanguageCode = this.tpDataCenter.getLanguageCode(this.context);
        this.firstInstallTime = this.tpDataCenter.getInstallTime(this.context);
        this.mRam = this.tpDataCenter.getTotalRam();
        this.tpDataCenter.getNetworkType(new TPDataCenter.OnTPNetworkTypeListener(){

            @Override
            public void onResult(int n) {
                TPDataManager.this.mNetworkType = n;
            }
        });
        this.discardconf = SPCacheUtil.getInt(this.context, Const.SPU_NAME, "discardconf", 0);
        object = SPCacheUtil.getString(this.context, Const.SPU_NAME, "uid", "");
        if (!TextUtils.isEmpty((CharSequence)object)) {
            this.uuId = object;
            return;
        }
        object = UUID.randomUUID();
        this.uuId = "UID-" + ((UUID)object).toString();
        SPCacheUtil.putString(this.context, Const.SPU_NAME, "uid", this.uuId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TPDataManager getInstance() {
        TPDataManager tPDataManager = instance;
        if (tPDataManager != null) return tPDataManager;
        Class<TPDataManager> clazz = TPDataManager.class;
        synchronized (TPDataManager.class) {
            tPDataManager = instance;
            if (tPDataManager != null) return tPDataManager;
            instance = tPDataManager = new TPDataManager();
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return tPDataManager;
        }
    }

    public boolean checkChinaPlugin() {
        return TPDataManager.getDiskCacheDir(this.context, CHECK_CHINA_PLUGIN).exists();
    }

    public boolean checkDebugMode() {
        return TPDataManager.getDiskCacheDir(this.context, DEBUG_MODE).exists();
    }

    public boolean checkTestMode() {
        return TPDataManager.getDiskCacheDir(this.context, TEST_MODE).exists();
    }

    public String getIsoCountryCode() {
        return this.mIsoCountryCode;
    }

    public String getUuId() {
        return this.uuId;
    }

    public void setUuId(String string) {
        this.uuId = string;
    }

    public String getGaidValue() {
        return this.getAdvertisingId();
    }

    public void setAdvertisingId(String string) {
        this.mAdvertisingId = string;
    }

    public String getGaidInfo() {
        if (TextUtils.isEmpty((CharSequence)this.mAdvertisingId)) {
            this.tpDataCenter.getAdvertisingInfo(this.context, new TPDataCenter.OnTPAdIdListener(){

                @Override
                public void onResult(String string, boolean bl) {
                    TPDataManager.this.putGaid(string);
                    TPDataManager.this.mAdvertisingLimited = bl;
                }
            });
        }
        return "";
    }

    public String getAdvertisingId() {
        String string = this.getOaidValue();
        String string2 = TestDeviceUtil.getInstance().getTestModeId();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        if (!TradPlus.invoker().isAllowTracking()) {
            this.putEmptyGaid();
            return "";
        }
        string2 = this.getGaidBySP();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return string2;
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return "";
    }

    public void getGaidM() {
        if (!TextUtils.isEmpty((CharSequence)this.getGaidMBySP())) {
            return;
        }
        try {
            this.tpDataCenter.getAdertisingIdM(this.context, new TPDataCenter.OnTPAdIdListener(){

                @Override
                public void onResult(String string, boolean bl) {
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        string = CMData.getHexM(string);
                        TPDataManager.this.putGaidM(string);
                        return;
                    }
                    TPDataManager.this.putGaidM("");
                }
            });
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
    }

    public void getOaidInfo() {
        if (TradPlus.invoker().getAuthUID(this.context)) {
            this.tpDataCenter.getOaid(this.context, new TPDataCenter.OnTPAdIdListener(){

                @Override
                public void onResult(String string, boolean bl) {
                    TPDataManager.this.mOaid = string;
                    TPDataManager.this.mOaidLimited = bl;
                }
            });
        }
    }

    public String getOaidValue() {
        if (!this.isOaidLimited()) {
            return this.mOaid;
        }
        return "";
    }

    public boolean isOaidLimited() {
        return this.mOaidLimited;
    }

    public void getOaidM(OaidCallback oaidCallback) {
        String string;
        if (!TestDeviceUtil.getInstance().isNeedTPAdId()) {
            oaidCallback.onFail("");
        }
        if (!TextUtils.isEmpty((CharSequence)(string = this.getOaidMBySP()))) {
            oaidCallback.onSuccuss(string, true);
        }
        OaidUtil.initOaidServerAndGetOaid(GlobalTradPlus.getInstance().getContext(), oaidCallback);
    }

    public int getAdvertisingLimited() {
        if (this.mAdvertisingLimited) {
            return 1;
        }
        return 0;
    }

    public int getWidthPixels() {
        return this.mWidthPixels;
    }

    public int getHeightPixels() {
        return this.mHeightPixels;
    }

    public int getDiscardconf() {
        return this.discardconf;
    }

    public void setDiscardconf(int n) {
        this.discardconf = n;
    }

    public int getNetworkType() {
        return this.mNetworkType;
    }

    public String getLanguageCode() {
        return this.mLanguageCode;
    }

    public String getDeviceOsVersion() {
        return this.mDeviceOsVersion;
    }

    public String getSdkVersion() {
        return this.mSdkVersion;
    }

    public String getAppVersion() {
        return this.mAppVersion;
    }

    public String getAppPackageName() {
        return this.mAppPackageName;
    }

    public String getAppName() {
        return this.mAppName;
    }

    public String getDeviceType() {
        return this.mDeviceType;
    }

    public String getRam() {
        return this.mRam;
    }

    public void setRam(String string) {
        this.mRam = string;
    }

    public String getTpGuid() {
        return this.tpGuid;
    }

    public void setTpGuid(String string) {
        this.tpGuid = string;
    }

    public String getTpAdId() {
        if (!TestDeviceUtil.getInstance().isNeedTPAdId()) {
            return "";
        }
        String string = this.getGaidMBySP();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return "";
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String string) {
        this.ip = string;
    }

    public int getNetworkClassByType() {
        switch (this.mNetworkType) {
            case -1: {
                return -1;
            }
            case -101: {
                return 1;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 2;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 3;
            }
            case 13: {
                return 4;
            }
            case 20: {
                return 5;
            }
        }
        return 5;
    }

    public int getDeviceCounByType() {
        switch (this.mNetworkType) {
            case 0: {
                return 0;
            }
            case -1: {
                return -1;
            }
            case -101: {
                return 2;
            }
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: {
                return 4;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: {
                return 5;
            }
            case 13: {
                return 6;
            }
            case 20: {
                return 7;
            }
        }
        return 5;
    }

    public int getOrientationInt() {
        return this.tpDataCenter.getOrientationInt(this.context);
    }

    public float getScreenSizeOfPPI() {
        DisplayMetrics displayMetrics = this.context.getResources().getDisplayMetrics();
        double d = Math.pow((float)this.getWidthPixels() / displayMetrics.xdpi, 2.0);
        double d2 = Math.pow((float)this.getHeightPixels() / displayMetrics.ydpi, 2.0);
        return (float)Math.sqrt(d + d2);
    }

    public float getDensity() {
        return this.tpDataCenter.getDensity();
    }

    public int getDpi() {
        return this.tpDataCenter.getDpi();
    }

    public String getIso() {
        return this.iso;
    }

    public void setIso(String string) {
        this.iso = string;
    }

    public void putIds(String string) {
        this.cpIdsMap.put(string, new CPIds());
    }

    public CPIds getIds(String string) {
        return this.cpIdsMap.get(string);
    }

    public void putSegmentIds(String string, String string2, String string3) {
        this.segmentIdsMap.put(string, new SegmentIds(string2, string3));
    }

    public SegmentIds getSegmentIds(String string) {
        return this.segmentIdsMap.get(string);
    }

    public void putEmptyGaid() {
        this.mAdvertisingId = "";
        this.putGaidM("");
        SPCacheUtil.putString(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "gaid", "");
    }

    public String getFirstInstallTime() {
        return this.firstInstallTime;
    }

    public void putGaid(String string) {
        SPCacheUtil.putString(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "gaid", string);
    }

    public String getGaidBySP() {
        if (!TradPlus.invoker().isAllowTracking()) {
            return "";
        }
        return SPCacheUtil.getString(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "gaid", "");
    }

    public void putGaidM(String string) {
        SPCacheUtil.putString(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "gaidM", string);
    }

    public String getGaidMBySP() {
        return SPCacheUtil.getString(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "gaidM", "");
    }

    public void putOaidM(String string) {
        SPCacheUtil.putString(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "oaidM", string);
    }

    public String getOaidMBySP() {
        return SPCacheUtil.getString(GlobalTradPlus.getInstance().getContext(), Const.SPU_NAME, "oaidM", "");
    }

    private static File getDiskCacheDir(Context object, String string) {
        object = "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable() ? Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS).getPath() : object.getCacheDir().getPath();
        return new File((String)object + File.separator + string);
    }

    public void setDebugMode(boolean bl) {
        this.debugModeFile = bl;
    }

    public boolean isTestMode() {
        return this.testModeFile;
    }

    public boolean isDebugMode() {
        return this.debugModeFile;
    }

    public boolean isChinaPluginFile() {
        return this.chinaPluginFile;
    }
}

