/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.content.Context;
import android.graphics.Bitmap;
import android.widget.ImageView;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.network.util.ImageLoader;
import com.tradplus.ads.base.network.util.ResourceEntry;
import com.tradplus.ads.common.util.LogUtil;

public class TPImageLoader {
    private static final int MAX_MEMORY_CACHE_SIZE = 0x1E00000;
    private static TPImageLoader mInstance;
    private Context mContext;
    private ImageLoader mImageLoader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized TPImageLoader getInstance() {
        if (mInstance != null) return mInstance;
        Class<TPImageLoader> clazz = TPImageLoader.class;
        synchronized (TPImageLoader.class) {
            if (mInstance != null) return mInstance;
            mInstance = new TPImageLoader();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    private TPImageLoader() {
        this.init();
    }

    private void init() {
        this.mContext = GlobalTradPlus.getInstance().getContext();
        this.mImageLoader = ImageLoader.getInstance(this.mContext);
    }

    public void loadImage(final ImageView imageView, final String string) {
        TPTaskManager.getInstance().runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (string == null || string.length() <= 0) {
                    return;
                }
                ImageLoader.ImageLoaderListener imageLoaderListener = new ImageLoader.ImageLoaderListener(){

                    @Override
                    public void onSuccess(String string, Bitmap bitmap) {
                        if (imageView != null && bitmap != null) {
                            imageView.setImageBitmap(bitmap);
                        }
                    }

                    @Override
                    public void onFail(String string, String string2) {
                    }
                };
                TPImageLoader.this.mImageLoader.load(new ResourceEntry(1, string), 0, 0, imageLoaderListener);
            }
        });
    }

    public void loadAllImage(ImageView imageView, String string, ImageLoader.ImageLoaderListener imageLoaderListener) {
        if (imageView == null) {
            new ImageView(this.mContext);
        }
        if (string == null || string.length() <= 0) {
            imageLoaderListener.onFail(string, "");
            return;
        }
        LogUtil.ownShow("url = ".concat(String.valueOf(string)));
        LogUtil.ownShow("listener = ".concat(String.valueOf(imageLoaderListener)));
        try {
            this.mImageLoader.load(new ResourceEntry(1, string), 0, 0, imageLoaderListener);
            return;
        }
        catch (Exception exception) {
            imageLoaderListener.onFail(string, "");
            return;
        }
    }
}

