/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.common;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import com.tradplus.ads.common.util.TaskUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TPTaskManager {
    private static TPTaskManager mInstance = null;
    private ExecutorService mNormalPool;
    private ExecutorService mSinglePool = Executors.newSingleThreadExecutor();
    private ExecutorService mDyCorePool;
    private ExecutorService mHttpPool;
    private HandlerThread mHandlerThread;
    private Handler mThreadHandler;
    private HandlerThread volleyHandlerThread;
    private Handler volleyThreadHandler;
    private HandlerThread thresholdHandlerThread;
    private Handler thresholdThreadHandler;
    private HandlerThread loadHandlerThread;
    private Handler loadThreadHandler;
    private HandlerThread refreshAdHandlerThread;
    private Handler refreshThreadHandler;
    private HandlerThread autoAdHandlerThread;
    private Handler autoThreadHandler;
    private Handler mMainHandler;

    protected TPTaskManager() {
        this.mNormalPool = Executors.newCachedThreadPool();
        this.mDyCorePool = Executors.newFixedThreadPool(TaskUtil.getCPUProcessors(8));
        this.mHttpPool = Executors.newFixedThreadPool(4);
        this.mMainHandler = new Handler(Looper.getMainLooper());
        this.mHandlerThread = new HandlerThread("tp-thread-" + System.currentTimeMillis());
        this.mHandlerThread.start();
        this.mThreadHandler = new Handler(this.mHandlerThread.getLooper());
        this.volleyHandlerThread = new HandlerThread("tp-thread-" + System.currentTimeMillis());
        this.volleyHandlerThread.start();
        this.volleyThreadHandler = new Handler(this.volleyHandlerThread.getLooper());
        this.thresholdHandlerThread = new HandlerThread("tp-thread-" + System.currentTimeMillis());
        this.thresholdHandlerThread.start();
        this.thresholdThreadHandler = new Handler(this.thresholdHandlerThread.getLooper());
        this.loadHandlerThread = new HandlerThread("tp-thread-" + System.currentTimeMillis());
        this.loadHandlerThread.start();
        this.loadThreadHandler = new Handler(this.loadHandlerThread.getLooper());
        this.refreshAdHandlerThread = new HandlerThread("tp-thread-" + System.currentTimeMillis());
        this.refreshAdHandlerThread.start();
        this.refreshThreadHandler = new Handler(this.refreshAdHandlerThread.getLooper());
        this.autoAdHandlerThread = new HandlerThread("tp-thread-" + System.currentTimeMillis());
        this.autoAdHandlerThread.start();
        this.autoThreadHandler = new Handler(this.autoAdHandlerThread.getLooper());
    }

    public static synchronized TPTaskManager getInstance() {
        if (mInstance == null) {
            mInstance = new TPTaskManager();
        }
        return mInstance;
    }

    public void fastRun(Runnable runnable) {
        this.mSinglePool.execute(runnable);
    }

    public void runNormalTask(Runnable runnable) {
        this.mNormalPool.execute(runnable);
    }

    public void runDyCorePool(Runnable runnable) {
        this.mDyCorePool.execute(runnable);
    }

    public void runHttpPool(Runnable runnable) {
        this.mHttpPool.execute(runnable);
    }

    public Handler getThresholdThreadHandler() {
        return this.thresholdThreadHandler;
    }

    public Handler getThreadHandler() {
        return this.mThreadHandler;
    }

    public Handler getVolleyThreadHandler() {
        return this.volleyThreadHandler;
    }

    public Handler getLoadThreadHandler() {
        return this.loadThreadHandler;
    }

    public Handler getRefreshThreadHandler() {
        return this.refreshThreadHandler;
    }

    public Handler getAutoThreadHandler() {
        return this.autoThreadHandler;
    }

    public void runOnMainThread(Runnable runnable) {
        this.mMainHandler.post(runnable);
    }

    public void runOnMainThreadDelayed(Runnable runnable, long l) {
        this.mMainHandler.postDelayed(runnable, l);
    }
}

