/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.config;

import android.content.Context;
import android.util.Base64;
import android.util.Log;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.annotation.Nullable;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.base.config.TradPlusConfigUtils;
import com.tradplus.ads.base.filter.FrequencyUtils;
import com.tradplus.ads.base.network.OnConfigListener;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.base.network.util.TradPlusConfigLoadUtils;
import com.tradplus.ads.base.util.TestDeviceUtil;
import com.tradplus.ads.common.serialization.JSON;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigLoadManager {
    private static final String CONFIG_AES_KEY = "tradplus";
    private static ConfigLoadManager mInstance = null;
    private ConcurrentHashMap<String, ConfigResponse> mConfigResponses = new ConcurrentHashMap();

    private ConfigLoadManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized ConfigLoadManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<ConfigLoadManager> clazz = ConfigLoadManager.class;
        synchronized (ConfigLoadManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ConfigLoadManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public void clearConfigResponse() {
        this.mConfigResponses.clear();
    }

    public ConfigResponse getLocalConfigResponse(String string) {
        ConfigResponse configResponse = this.mConfigResponses.get(string);
        if (configResponse != null) {
            return configResponse;
        }
        GlobalTradPlus.getInstance().getContext();
        configResponse = TradPlusConfigUtils.getInstance().getConfigByUnitId(string);
        if (configResponse != null) {
            this.mConfigResponses.put(string, configResponse);
        }
        return configResponse;
    }

    public void loadConfig(final String string, final @Nullable ConfigLoadListener configLoadListener) {
        final Context context = GlobalTradPlus.getInstance().getContext();
        Object object = this.mConfigResponses.get(string);
        if (object != null && !TradPlusConfigUtils.isIsTestModeByConfig()) {
            configLoadListener.onSuccess((ConfigResponse)object);
            this.checkConfigTimeout(context, string, (ConfigResponse)object);
            return;
        }
        object = new TradPlusConfigLoadUtils(context, string, "", 0L);
        ((TradPlusConfigLoadUtils)object).setOnConfigListener(new OnConfigListener(){

            @Override
            public void onSuccess(ConfigResponse configResponse) {
                ConfigLoadManager.this.checkConfigTimeout(context, string, configResponse);
                if (configResponse != null) {
                    FrequencyUtils.getInstance().saveFrequency(configResponse.getFrequency(), string);
                    if (configResponse.getIs_nothing() != 1) {
                        ConfigLoadManager.this.mConfigResponses.put(string, configResponse);
                        configLoadListener.onSuccess(configResponse);
                        return;
                    }
                    configLoadListener.onFailed(10, "nothing response");
                    return;
                }
                configLoadListener.onFailed(10, "response is null");
            }

            @Override
            public void onFailed(int n, String string2) {
                configLoadListener.onFailed(n, string2);
            }
        });
        ((TradPlusConfigLoadUtils)object).load(true);
    }

    public void setDefaultConfig(String string, String object) {
        if (object == null || ((String)object).length() <= 0) {
            return;
        }
        Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig getLocalConfig start---------");
        ConfigResponse configResponse = this.getLocalConfigResponse(string);
        Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig getLocalConfig end---------");
        if (configResponse != null) {
            return;
        }
        if (((String)object).contains("\n")) {
            object = ((String)object).replaceAll("\n", "").replaceAll("\r", "").replaceAll(" ", "");
        }
        try {
            object = Base64.decode((byte[])((String)object).getBytes(), (int)0);
            object = new String((byte[])object, "utf-8");
            Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig setDefaultConfig decode ========");
            object = JSON.parseObject((String)object, ConfigResponse.class);
            if (object != null) {
                Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig setDefaultConfig success ========");
                this.mConfigResponses.put(string, (ConfigResponse)object);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Log.v((String)"ConfigLoadManager", (String)"setDefaultConfig setDefaultConfig error ==========");
            return;
        }
    }

    public String getCurrentConfig(String object) {
        object = TradPlusConfigUtils.getInstance().getConfigByUnitId((String)object);
        if (object == null) {
            return "";
        }
        String string = "";
        try {
            string = Base64.encodeToString((byte[])JSON.toJSONString(object).getBytes(), (int)0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private boolean checkConfigTimeout(Context object, final String string, ConfigResponse configResponse) {
        if (configResponse == null) {
            return true;
        }
        if (TradPlusConfigLoadUtils.isConfigExpires(configResponse.getCreateTime(), configResponse.getExpires()) && !TestDeviceUtil.getInstance().isTools()) {
            object = new TradPlusConfigLoadUtils((Context)object, string, configResponse.getResp_uid(), configResponse.getResp_time());
            object.setOnConfigListener(new OnConfigListener(){

                @Override
                public void onSuccess(ConfigResponse configResponse) {
                    if (configResponse != null) {
                        ConfigResponse configResponse2 = (ConfigResponse)ConfigLoadManager.this.mConfigResponses.get(string);
                        if (configResponse.getResp_uid() != null && configResponse2 != null && configResponse.getResp_uid().equals(configResponse2.getResp_uid())) {
                            configResponse2.setCreateTime(configResponse.getCreateTime());
                            return;
                        }
                        ConfigLoadManager.this.mConfigResponses.put(string, configResponse);
                    }
                }

                @Override
                public void onFailed(int n, String string2) {
                }
            });
            TPTaskManager.getInstance().runDyCorePool(new Runnable((TradPlusConfigLoadUtils)object){
                final /* synthetic */ TradPlusConfigLoadUtils val$tradPlusConfigLoadUtils;
                {
                    this.val$tradPlusConfigLoadUtils = tradPlusConfigLoadUtils;
                }

                @Override
                public void run() {
                    TPDataManager.getInstance().getGaidM();
                    this.val$tradPlusConfigLoadUtils.stillLoadConfig();
                }
            });
            return true;
        }
        return false;
    }

    public static interface ConfigLoadListener {
        public void onSuccess(ConfigResponse var1);

        public void onFailed(int var1, String var2);
    }
}

