/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.db;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import com.tradplus.ads.base.db.TradPlusDB;
import com.tradplus.ads.base.db.api.cache.Store;
import com.tradplus.ads.base.db.api.cache.StoreProvider;
import com.tradplus.ads.base.db.dao.AdSourceFrenquencyDao;
import com.tradplus.ads.base.db.dao.AdUnitConfigDao;
import com.tradplus.ads.base.db.dao.AdUnitFrenquencyDao;
import com.tradplus.ads.base.db.dao.BaseDao;
import com.tradplus.ads.base.db.dao.EventAdxDao;
import com.tradplus.ads.base.db.dao.EventCrossDao;
import com.tradplus.ads.base.db.dao.EventDao;
import com.tradplus.ads.base.db.dao.KVEntityDao;
import com.tradplus.ads.base.db.dao.SimplifyEventDao;
import com.tradplus.ads.base.db.dao.TrackDao;
import com.tradplus.ads.base.db.entity.AdSourceFrenquency;
import com.tradplus.ads.base.db.entity.AdUnitConfig;
import com.tradplus.ads.base.db.entity.AdUnitFrenquency;
import com.tradplus.ads.base.db.entity.Event;
import com.tradplus.ads.base.db.entity.EventAdx;
import com.tradplus.ads.base.db.entity.EventCross;
import com.tradplus.ads.base.db.entity.EventSimplify;
import com.tradplus.ads.base.db.entity.KVEntity;
import com.tradplus.ads.base.db.entity.Tracks;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class DBStoreProvider
implements StoreProvider<String> {
    private static HashMap<Class<?>, DaoOwner> daosMap = new HashMap();
    private static volatile SQLiteDatabase database;

    public static DBStoreProvider create(Context context) {
        return new DBStoreProvider(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DBStoreProvider(Context context) {
        if (database == null) {
            Class<DBStoreProvider> clazz = DBStoreProvider.class;
            synchronized (DBStoreProvider.class) {
                if (database == null) {
                    try {
                        database = new TradPlusDB(context.getApplicationContext()).getDatabase();
                    }
                    catch (Throwable throwable) {}
                }
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return;
            }
        }
    }

    @Override
    public <V> Store<String, V> getStore(Class<V> clazz) {
        return DBStoreProvider.daosMap.get(clazz).getBaseDao(DBStoreProvider.database);
    }

    static {
        daosMap.put(AdSourceFrenquency.class, new DaoOwner(AdSourceFrenquencyDao.class));
        daosMap.put(AdUnitConfig.class, new DaoOwner(AdUnitConfigDao.class));
        daosMap.put(AdUnitFrenquency.class, new DaoOwner(AdUnitFrenquencyDao.class));
        daosMap.put(Event.class, new DaoOwner(EventDao.class));
        daosMap.put(EventSimplify.class, new DaoOwner(SimplifyEventDao.class));
        daosMap.put(EventCross.class, new DaoOwner(EventCrossDao.class));
        daosMap.put(EventAdx.class, new DaoOwner(EventAdxDao.class));
        daosMap.put(KVEntity.class, new DaoOwner(KVEntityDao.class));
        daosMap.put(Tracks.class, new DaoOwner(TrackDao.class));
    }

    static class DaoOwner<T extends BaseDao> {
        private final Class<? extends BaseDao> daoClass;
        private volatile BaseDao<T> baseDao;

        private DaoOwner(Class<T> clazz) {
            this.daoClass = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BaseDao<T> getBaseDao(SQLiteDatabase sQLiteDatabase) {
            if (this.baseDao == null) {
                DaoOwner daoOwner = this;
                synchronized (daoOwner) {
                    if (this.baseDao == null) {
                        try {
                            if (sQLiteDatabase == null) {
                                this.baseDao = this.daoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                                return this.baseDao;
                            }
                            Constructor<? extends BaseDao> constructor = this.daoClass.getDeclaredConstructor(SQLiteDatabase.class);
                            this.baseDao = constructor.newInstance(sQLiteDatabase);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        if (this.baseDao == null) {
                            try {
                                this.baseDao = this.daoClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                    }
                }
            }
            return this.baseDao;
        }
    }
}

