/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.db;

import android.content.Context;
import android.text.TextUtils;
import android.util.Pair;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.db.DBStoreProvider;
import com.tradplus.ads.base.db.api.cache.Store;
import com.tradplus.ads.base.db.api.cache.StoreProvider;
import com.tradplus.ads.base.db.entity.AdSourceFrenquency;
import com.tradplus.ads.base.db.entity.AdUnitConfig;
import com.tradplus.ads.base.db.entity.AdUnitFrenquency;
import com.tradplus.ads.base.db.entity.Event;
import com.tradplus.ads.base.db.entity.EventAdx;
import com.tradplus.ads.base.db.entity.EventCross;
import com.tradplus.ads.base.db.entity.EventSimplify;
import com.tradplus.ads.base.db.entity.KVEntity;
import com.tradplus.ads.base.db.entity.Tracks;
import com.tradplus.ads.base.filter.NetWorkFrequencyUtils;
import com.tradplus.ads.base.network.TPOpenResponse;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.JSONHelper;
import com.tradplus.ads.pushcenter.event.EventBaseRequest;
import com.tradplus.ads.pushcenter.event.request.SimplifyEvent;
import com.tradplus.ads.pushcenter.reqeust.BaseRequest;
import java.util.List;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONObject;

public class StoreManager {
    private static StoreProvider<String> storeProvider;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(Context context) {
        if (storeProvider == null) {
            Class<StoreManager> clazz = StoreManager.class;
            synchronized (StoreManager.class) {
                if (storeProvider == null) {
                    storeProvider = DBStoreProvider.create(context);
                }
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return;
            }
        }
    }

    private static <T> Store<String, T> getStore(Class<T> clazz) {
        if (storeProvider == null) {
            StoreManager.init(GlobalTradPlus.getInstance().getContext());
        }
        return storeProvider.getStore(clazz);
    }

    public static String getVersionName() {
        return "9.4.30.1";
    }

    public static boolean checkVersion(String string) {
        return StoreManager.getVersionName().compareTo(string) != 0;
    }

    private static String toJson(Object object) {
        if (object instanceof JSONObject) {
            return object.toString();
        }
        return JSONHelper.toJSON(object);
    }

    private static <T> T fromJson(String string, Class<T> clazz) {
        return JSONHelper.fromJson(string, clazz);
    }

    public static void saveFrequency(String string, ConfigResponse.FrequencyBean frequencyBean) {
        if (frequencyBean == null) {
            return;
        }
        AdUnitFrenquency adUnitFrenquency = StoreManager.getStore(AdUnitFrenquency.class).get(string);
        long l = System.currentTimeMillis();
        if (adUnitFrenquency == null) {
            adUnitFrenquency = new AdUnitFrenquency();
            adUnitFrenquency.setId(string);
            adUnitFrenquency.setLoad_time(l);
            adUnitFrenquency.setShow_time(l);
        } else if ((l - adUnitFrenquency.getShow_time()) / 60000L >= (long)adUnitFrenquency.getTime()) {
            adUnitFrenquency.setShow_time(l);
            adUnitFrenquency.setShow_count(0);
        }
        adUnitFrenquency.setTime_limit(frequencyBean.getLimit());
        adUnitFrenquency.setTime(frequencyBean.getTime());
        adUnitFrenquency.setVersion_name(StoreManager.getVersionName());
        StoreManager.getStore(AdUnitFrenquency.class).save((AdUnitFrenquency[])new AdUnitFrenquency[]{adUnitFrenquency});
    }

    public static ConfigResponse.FrequencyBean getFrequency(String object, boolean bl) {
        object = StoreManager.getStore(AdUnitFrenquency.class).get((String)object);
        if (object == null || bl && StoreManager.checkVersion(((AdUnitFrenquency)object).getVersion_name())) {
            return null;
        }
        ConfigResponse.FrequencyBean frequencyBean = new ConfigResponse.FrequencyBean();
        frequencyBean.setLimit(((AdUnitFrenquency)object).getTime_limit());
        frequencyBean.setTime(((AdUnitFrenquency)object).getTime());
        return frequencyBean;
    }

    public static void addFrequencyShowCount(String object) {
        Store<String, AdUnitFrenquency> store = StoreManager.getStore(AdUnitFrenquency.class);
        object = store.get((String)object);
        if (object == null) {
            return;
        }
        Object object2 = object;
        ((AdUnitFrenquency)object2).setShow_count(((AdUnitFrenquency)object2).getShow_count() + 1);
        ((AdUnitFrenquency)object).setShow_time(System.currentTimeMillis());
        store.save((AdUnitFrenquency[])new AdUnitFrenquency[]{object});
    }

    public static boolean needShowAd(String object) {
        Store<String, AdUnitFrenquency> store = StoreManager.getStore(AdUnitFrenquency.class);
        object = store.get((String)object);
        if (object == null || ((AdUnitFrenquency)object).getTime_limit() == -1 || ((AdUnitFrenquency)object).getTime() == -1) {
            return true;
        }
        long l = System.currentTimeMillis();
        if ((l - ((AdUnitFrenquency)object).getShow_time()) / 60000L >= (long)((AdUnitFrenquency)object).getTime()) {
            ((AdUnitFrenquency)object).setLoad_time(l);
            ((AdUnitFrenquency)object).setShow_count(0);
            store.save((AdUnitFrenquency[])new AdUnitFrenquency[]{object});
            return true;
        }
        return ((AdUnitFrenquency)object).getTime_limit() > ((AdUnitFrenquency)object).getShow_count();
    }

    public static NetWorkFrequencyUtils.NetworkFrequencyBean getNetworkFrequency(String object, boolean bl) {
        object = StoreManager.getStore(AdSourceFrenquency.class).get((String)object);
        if (object == null || bl && StoreManager.checkVersion(((AdSourceFrenquency)object).getVersion_name())) {
            return null;
        }
        NetWorkFrequencyUtils.NetworkFrequencyBean networkFrequencyBean = new NetWorkFrequencyUtils.NetworkFrequencyBean();
        networkFrequencyBean.setHourTime(((AdSourceFrenquency)object).getHourTime());
        networkFrequencyBean.setDayTime(((AdSourceFrenquency)object).getDayTime());
        networkFrequencyBean.setDayCount(((AdSourceFrenquency)object).getDayCount());
        networkFrequencyBean.setHourCount(((AdSourceFrenquency)object).getHourCount());
        networkFrequencyBean.setShowTime(((AdSourceFrenquency)object).getShowTime());
        networkFrequencyBean.setCapping_day(((AdSourceFrenquency)object).getCapping_day());
        networkFrequencyBean.setCapping_hour(((AdSourceFrenquency)object).getCapping_hour());
        networkFrequencyBean.setPacing_min(((AdSourceFrenquency)object).getPacing_min());
        return networkFrequencyBean;
    }

    public static void saveNetworkFrequency(String string, NetWorkFrequencyUtils.NetworkFrequencyBean networkFrequencyBean) {
        AdSourceFrenquency adSourceFrenquency = new AdSourceFrenquency();
        adSourceFrenquency.setId(string);
        adSourceFrenquency.setVersion_name(StoreManager.getVersionName());
        adSourceFrenquency.setDayTime(networkFrequencyBean.getDayTime());
        adSourceFrenquency.setHourTime(networkFrequencyBean.getHourTime());
        adSourceFrenquency.setHourCount(networkFrequencyBean.getHourCount());
        adSourceFrenquency.setDayCount(networkFrequencyBean.getDayCount());
        adSourceFrenquency.setShowTime(networkFrequencyBean.getShowTime());
        adSourceFrenquency.setCapping_day(networkFrequencyBean.getCapping_day());
        adSourceFrenquency.setCapping_hour(networkFrequencyBean.getCapping_hour());
        adSourceFrenquency.setPacing_min(networkFrequencyBean.getPacing_min());
        StoreManager.getStore(AdSourceFrenquency.class).save((AdSourceFrenquency[])new AdSourceFrenquency[]{adSourceFrenquency});
    }

    public static void saveConfigResponse(String string, ConfigResponse configResponse) {
        AdUnitConfig adUnitConfig = new AdUnitConfig();
        adUnitConfig.setId(string);
        adUnitConfig.setVersion_name(StoreManager.getVersionName());
        adUnitConfig.setBean(StoreManager.toJson(configResponse));
        StoreManager.getStore(AdUnitConfig.class).save((AdUnitConfig[])new AdUnitConfig[]{adUnitConfig});
    }

    public static ConfigResponse getLocalConfigResponse(String object, boolean bl) {
        object = StoreManager.getStore(AdUnitConfig.class).get((String)object);
        if (object == null || bl && StoreManager.checkVersion(((AdUnitConfig)object).getVersion_name())) {
            return null;
        }
        return StoreManager.fromJson(((AdUnitConfig)object).getBean(), ConfigResponse.class);
    }

    public static void clearConfigResponse() {
        StoreManager.getStore(AdUnitConfig.class).clear();
    }

    public static void saveTPOpenResponse(TPOpenResponse tPOpenResponse) {
        tPOpenResponse.setCreate_time(System.currentTimeMillis());
        tPOpenResponse.setVersion_name(StoreManager.getVersionName());
        KVEntity kVEntity = new KVEntity();
        kVEntity.setKey(tPOpenResponse.getClass().getName());
        kVEntity.setValue(StoreManager.toJson(tPOpenResponse));
        kVEntity.setType(tPOpenResponse.getClass().getName());
        StoreManager.getStore(KVEntity.class).save((KVEntity[])new KVEntity[]{kVEntity});
    }

    public static TPOpenResponse getLocalTPOpenResponse(boolean bl) {
        Object object = StoreManager.getStore(KVEntity.class).get(TPOpenResponse.class.getName());
        object = object == null ? null : StoreManager.fromJson(((KVEntity)object).getValue(), TPOpenResponse.class);
        if (object == null || bl && StoreManager.checkVersion(((TPOpenResponse)object).getVersion_name())) {
            return null;
        }
        return object;
    }

    public static Pair<String[], String[]> getEvent(int n) {
        List<Event> list = StoreManager.getStore(Event.class).getList(n);
        if (list == null || list.size() == 0) {
            return null;
        }
        int n2 = list.size();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        Pair pair = new Pair((Object)stringArray, (Object)stringArray2);
        for (int i = 0; i < n2; ++i) {
            Event event = list.get(i);
            stringArray[i] = event.getId();
            stringArray2[i] = event.getContent();
        }
        return pair;
    }

    public static Pair<String[], String[]> getSimplifyEvent(int n) {
        List<EventSimplify> list = StoreManager.getStore(EventSimplify.class).getList(n);
        if (list == null || list.size() == 0) {
            return null;
        }
        int n2 = list.size();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        Pair pair = new Pair((Object)stringArray, (Object)stringArray2);
        for (int i = 0; i < n2; ++i) {
            EventSimplify eventSimplify = list.get(i);
            stringArray[i] = eventSimplify.getId();
            stringArray2[i] = eventSimplify.getContent();
        }
        return pair;
    }

    public static int getEventCount() {
        return StoreManager.getStore(Event.class).count();
    }

    public static int getSimplifyEventCount() {
        return StoreManager.getStore(EventSimplify.class).count();
    }

    public static void clearEvent() {
        StoreManager.getStore(Event.class).clear();
    }

    public static void clearSimplifyEvent() {
        StoreManager.getStore(EventSimplify.class).clear();
    }

    public static void removeEvent(String[] stringArray) {
        StoreManager.getStore(Event.class).delete((String[])stringArray);
    }

    public static void removeSimplifyEvent(String[] stringArray) {
        StoreManager.getStore(EventSimplify.class).delete((String[])stringArray);
    }

    public static void clearAll() {
        StoreManager.clearEvent();
        StoreManager.clearCrossEvent();
        StoreManager.clearAdxEvent();
        StoreManager.clearSimplifyEvent();
    }

    public static void saveEvent(BaseRequest baseRequest) {
        if (baseRequest == null) {
            return;
        }
        Event event = new Event();
        event.setId(UUID.randomUUID().toString());
        event.setContent(StoreManager.toJson(baseRequest));
        StoreManager.getStore(Event.class).save((Event[])new Event[]{event});
    }

    public static void saveSimplifyEvent(SimplifyEvent simplifyEvent) {
        if (simplifyEvent == null) {
            return;
        }
        EventSimplify eventSimplify = new EventSimplify();
        eventSimplify.setId(UUID.randomUUID().toString());
        eventSimplify.setContent(StoreManager.toJson(simplifyEvent));
        StoreManager.getStore(EventSimplify.class).save((EventSimplify[])new EventSimplify[]{eventSimplify});
    }

    public static Pair<String[], String[]> saveEventJSONArray(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        int n = jSONArray.length();
        Event[] eventArray = new Event[n];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            Event event = new Event();
            event.setId(UUID.randomUUID().toString());
            stringArray[i] = event.getId();
            try {
                event.setContent(StoreManager.toJson(jSONArray.get(i)));
            }
            catch (Exception exception) {}
            stringArray2[i] = event.getContent();
            eventArray[i] = event;
        }
        StoreManager.getStore(Event.class).save((Event[])eventArray);
        return new Pair((Object)stringArray, (Object)stringArray2);
    }

    public static Pair<String[], String[]> saveSimplifyEventJSONArray(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        int n = jSONArray.length();
        EventSimplify[] eventSimplifyArray = new EventSimplify[n];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            EventSimplify eventSimplify = new EventSimplify();
            eventSimplify.setId(UUID.randomUUID().toString());
            stringArray[i] = eventSimplify.getId();
            try {
                eventSimplify.setContent(StoreManager.toJson(jSONArray.get(i)));
            }
            catch (Exception exception) {}
            stringArray2[i] = eventSimplify.getContent();
            eventSimplifyArray[i] = eventSimplify;
        }
        StoreManager.getStore(EventSimplify.class).save((EventSimplify[])eventSimplifyArray);
        return new Pair((Object)stringArray, (Object)stringArray2);
    }

    public static Pair<String[], String[]> getEventCross(int n) {
        List<EventCross> list = StoreManager.getStore(EventCross.class).getList(n);
        if (list == null || list.size() == 0) {
            return null;
        }
        int n2 = list.size();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        Pair pair = new Pair((Object)stringArray, (Object)stringArray2);
        for (int i = 0; i < n2; ++i) {
            EventCross eventCross = list.get(i);
            stringArray[i] = eventCross.getId();
            stringArray2[i] = eventCross.getContent();
        }
        return pair;
    }

    public static int getEventCountCross() {
        return StoreManager.getStore(EventCross.class).count();
    }

    public static void saveCrossEvent(EventBaseRequest eventBaseRequest) {
        if (eventBaseRequest == null) {
            return;
        }
        EventCross eventCross = new EventCross();
        eventCross.setId(UUID.randomUUID().toString());
        eventCross.setContent(StoreManager.toJson(eventBaseRequest));
        StoreManager.getStore(EventCross.class).save((EventCross[])new EventCross[]{eventCross});
    }

    public static void clearCrossEvent() {
        StoreManager.getStore(EventCross.class).clear();
    }

    public static Pair<String[], String[]> saveCrossEventJSONArray(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        int n = jSONArray.length();
        EventCross[] eventCrossArray = new EventCross[jSONArray.length()];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int n2 = jSONArray.length();
        for (int i = 0; i < n2; ++i) {
            EventCross eventCross = new EventCross();
            eventCross.setId(UUID.randomUUID().toString());
            stringArray[i] = eventCross.getId();
            try {
                eventCross.setContent(StoreManager.toJson(jSONArray.get(i)));
            }
            catch (Exception exception) {}
            stringArray2[i] = eventCross.getContent();
            eventCrossArray[i] = eventCross;
        }
        StoreManager.getStore(EventCross.class).save((EventCross[])eventCrossArray);
        return new Pair((Object)stringArray, (Object)stringArray2);
    }

    public static void removeCrossEvent(String[] stringArray) {
        StoreManager.getStore(EventCross.class).delete((String[])stringArray);
    }

    public static Pair<String[], String[]> getEventAdx(int n) {
        List<EventAdx> list = StoreManager.getStore(EventAdx.class).getList(n);
        if (list == null || list.size() == 0) {
            return null;
        }
        int n2 = list.size();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        Pair pair = new Pair((Object)stringArray, (Object)stringArray2);
        for (int i = 0; i < n2; ++i) {
            EventAdx eventAdx = list.get(i);
            stringArray[i] = eventAdx.getId();
            stringArray2[i] = eventAdx.getContent();
        }
        return pair;
    }

    public static int getEventCountAdx() {
        return StoreManager.getStore(EventAdx.class).count();
    }

    public static void saveAdxEvent(Object object) {
        if (object == null) {
            return;
        }
        EventAdx eventAdx = new EventAdx();
        eventAdx.setId(UUID.randomUUID().toString());
        eventAdx.setContent(StoreManager.toJson(object));
        StoreManager.getStore(EventAdx.class).save((EventAdx[])new EventAdx[]{eventAdx});
    }

    public static void clearAdxEvent() {
        StoreManager.getStore(EventAdx.class).clear();
    }

    public static Pair<String[], String[]> saveAdxEventJSONArray(JSONArray jSONArray) {
        if (jSONArray == null || jSONArray.length() == 0) {
            return null;
        }
        int n = jSONArray.length();
        EventAdx[] eventAdxArray = new EventAdx[jSONArray.length()];
        String[] stringArray = new String[n];
        String[] stringArray2 = new String[n];
        int n2 = jSONArray.length();
        for (int i = 0; i < n2; ++i) {
            EventAdx eventAdx = new EventAdx();
            eventAdx.setId(UUID.randomUUID().toString());
            stringArray[i] = eventAdx.getId();
            try {
                eventAdx.setContent(StoreManager.toJson(jSONArray.get(i)));
            }
            catch (Exception exception) {}
            stringArray2[i] = eventAdx.getContent();
            eventAdxArray[i] = eventAdx;
        }
        StoreManager.getStore(EventAdx.class).save((EventAdx[])eventAdxArray);
        return new Pair((Object)stringArray, (Object)stringArray2);
    }

    public static void removeAdxEvent(String[] stringArray) {
        StoreManager.getStore(EventAdx.class).delete((String[])stringArray);
    }

    public static void saveTrack(Pair<String[], String[]> pair) {
        int n = ((String[])pair.first).length;
        Tracks[] tracksArray = new Tracks[n];
        for (int i = 0; i < n; ++i) {
            Tracks tracks = new Tracks();
            tracks.setId(((String[])pair.first)[i]);
            tracks.setUrl(((String[])pair.first)[i]);
            if (pair.second != null) {
                tracks.setContent(((String[])pair.second)[i]);
            }
            tracksArray[i] = tracks;
        }
        StoreManager.getStore(Tracks.class).save((Tracks[])tracksArray);
    }

    public static void removeTracks(String string) {
        StoreManager.getStore(Tracks.class).delete((String[])new String[]{string});
    }

    public static String getTracksContent(String object) {
        object = StoreManager.getStore(Tracks.class).get((String)object);
        if (object == null || TextUtils.isEmpty((CharSequence)((Tracks)object).getContent())) {
            return null;
        }
        return ((Tracks)object).getContent();
    }

    public static Pair<String[], String[]> getTracksContent(int n) {
        List<Tracks> list = StoreManager.getStore(Tracks.class).getList(n);
        if (list == null || list.size() == 0) {
            return null;
        }
        int n2 = list.size();
        String[] stringArray = new String[n2];
        String[] stringArray2 = new String[n2];
        for (int i = 0; i < n2; ++i) {
            Tracks tracks = list.get(i);
            stringArray[i] = tracks.getId();
            stringArray2[i] = tracks.getContent();
        }
        return new Pair((Object)stringArray, (Object)stringArray2);
    }
}

