/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.db;

import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.tradplus.ads.base.db.ColumnEntity;
import com.tradplus.ads.base.db.annotation.Column;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.LinkedHashMap;

public final class TableUtils {
    private TableUtils() {
        throw new RuntimeException("you can't instantiation me \u3002\u3002\u3002");
    }

    static LinkedHashMap<String, ColumnEntity> findColumns(Class<?> clazz) {
        LinkedHashMap<String, ColumnEntity> linkedHashMap = new LinkedHashMap<String, ColumnEntity>();
        TableUtils.addColumns2Map(clazz, linkedHashMap);
        return linkedHashMap;
    }

    private static void addColumns2Map(Class<?> clazz, HashMap<String, ColumnEntity> hashMap) {
        if (Object.class.equals(clazz)) {
            return;
        }
        try {
            for (Field field : clazz.getDeclaredFields()) {
                Column column;
                int n = field.getModifiers();
                if (Modifier.isStatic(n) || Modifier.isTransient(n) || (column = field.getAnnotation(Column.class)) != null && column.ignore()) continue;
                ColumnEntity columnEntity = new ColumnEntity(field, column);
                hashMap.put(columnEntity.getName(), columnEntity);
            }
            TableUtils.addColumns2Map(clazz.getSuperclass(), hashMap);
            return;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    static String getTypeText(Class<?> clazz) {
        if (clazz == String.class) {
            return "TEXT";
        }
        if (clazz == Long.TYPE || clazz == Long.class || clazz == Integer.class || clazz == Integer.TYPE || clazz == Byte.TYPE || clazz == Byte.class || clazz == Character.TYPE || clazz == Character.class || clazz == Short.TYPE || clazz == Short.class) {
            return "INTEGER";
        }
        if (clazz == Boolean.TYPE || clazz == Boolean.class) {
            return "INTEGER";
        }
        if (clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class) {
            return "REAL";
        }
        throw new RuntimeException("unsupport type: " + clazz.getSimpleName());
    }

    public static void closeCursor(Cursor cursor) {
        if (cursor != null) {
            try {
                cursor.close();
                return;
            }
            catch (Throwable throwable) {}
        }
    }

    public static boolean tableExists(SQLiteDatabase sQLiteDatabase, String string) {
        if ((sQLiteDatabase = sQLiteDatabase.rawQuery("SELECT COUNT(*) FROM sqlite_master WHERE type='table' AND name='" + string + "'", null)) != null) {
            try {
                if (sQLiteDatabase.moveToNext() && sQLiteDatabase.getInt(0) > 0) {
                    return true;
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                TableUtils.closeCursor((Cursor)sQLiteDatabase);
            }
        }
        return false;
    }

    public static String[] getColumnNames(SQLiteDatabase sQLiteDatabase, String string) {
        String[] stringArray;
        Cursor cursor;
        block3: {
            cursor = null;
            stringArray = null;
            try {
                cursor = sQLiteDatabase.rawQuery("SELECT * FROM " + string + " limit 1 ", null);
                if (cursor == null) break block3;
                stringArray = cursor.getColumnNames();
            }
            catch (Throwable throwable) {
                TableUtils.closeCursor(cursor);
            }
            catch (Throwable throwable) {
                TableUtils.closeCursor(cursor);
                throw throwable;
            }
        }
        TableUtils.closeCursor(cursor);
        return stringArray;
    }
}

