/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.event.push;

import android.util.Pair;
import com.tradplus.ads.base.TradPlus;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.common.TPDiskManager;
import com.tradplus.ads.base.common.TPURLManager;
import com.tradplus.ads.base.db.StoreManager;
import com.tradplus.ads.base.event.TPMessageUtils;
import com.tradplus.ads.base.event.push.EventBasePushUtil;
import com.tradplus.ads.base.event.timer.TPEventTimer;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.Json;
import com.tradplus.ads.common.util.LogUtil;
import com.tradplus.ads.pushcenter.event.request.SimplifyEvent;
import com.tradplus.ads.pushcenter.http.Listener;
import com.tradplus.ads.pushcenter.http.PushCenterHttpUtils;
import com.tradplus.ads.pushcenter.response.BaseResponse;
import java.util.HashMap;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EventSimplifyPushUtil
extends EventBasePushUtil {
    @Override
    public Pair<String[], String[]> getEvents(int n) {
        return StoreManager.getSimplifyEvent(n);
    }

    @Override
    public String getPushUrl() {
        return EventSimplifyPushUtil.getEventUrl();
    }

    @Override
    public void removeEvent(String ... stringArray) {
        TPMessageUtils.removeSimplifyEvent(stringArray);
    }

    @Override
    public void saveEvent(Object object) {
        if (object instanceof SimplifyEvent) {
            TPMessageUtils.saveSimplifyEvent((SimplifyEvent)object);
        }
    }

    @Override
    public void setEventTime(Object object) {
    }

    @Override
    public String getLogType() {
        return "CACHETRADPLUSSIMPLIFYTYPE";
    }

    private static String getEventUrl() {
        return TPURLManager.getInstance().getTPSimplifyEventUrl();
    }

    @Override
    public void pushEvent(int n) {
        try {
            final Pair<String[], String[]> pair = this.getEvents(n);
            if (pair == null || pair.first == null || pair.second == null) {
                return;
            }
            JSONObject jSONObject = this.putHeaderData();
            if (jSONObject == null) {
                return;
            }
            JSONArray jSONArray = new JSONArray();
            for (String string : (String[])pair.second) {
                jSONArray.put((Object)new JSONObject(string));
            }
            try {
                jSONObject.putOpt("cb", (Object)jSONArray);
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            PushCenterHttpUtils.push(EventSimplifyPushUtil.getEventUrl(), jSONObject.toString(), new Listener(){

                @Override
                public void onSuccess(BaseResponse baseResponse) {
                    LogUtil.ownShow("push Simplify Event success", EventSimplifyPushUtil.this.getLogType());
                    EventSimplifyPushUtil.this.removeEvent((String[])pair.first);
                    TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
                    TPEventTimer.getInstance().initUploadEventFailedNum();
                }

                @Override
                public void oError(int n, String string) {
                    LogUtil.ownShow("push Simplify failed", EventSimplifyPushUtil.this.getLogType());
                    TPEventTimer.getInstance().setUploadEventFailedNum();
                    TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
                }
            });
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    @Override
    public void pushSingleEvent(final Object object) {
        JSONObject jSONObject = this.putHeaderData();
        if (jSONObject == null) {
            return;
        }
        JSONArray jSONArray = new JSONArray();
        try {
            jSONArray.put((Object)new JSONObject(JSON.toJSONString(object)));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        try {
            jSONObject.putOpt("cb", (Object)jSONArray);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        PushCenterHttpUtils.push(EventSimplifyPushUtil.getEventUrl(), jSONObject.toString(), new Listener(){

            @Override
            public void onSuccess(BaseResponse baseResponse) {
                LogUtil.ownShow("push Simplify Single Event success", EventSimplifyPushUtil.this.getLogType());
                TPEventTimer.getInstance().initUploadEventFailedNum();
                TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
            }

            @Override
            public void oError(int n, String string) {
                LogUtil.ownShow("push Simplify single failed", EventSimplifyPushUtil.this.getLogType());
                TPDiskManager.getInstance().checkDatabaseSizeWillDelete(true);
                EventSimplifyPushUtil.this.saveEvent(object);
            }
        });
    }

    public JSONObject putHeaderData() {
        TPDataManager tPDataManager = TPDataManager.getInstance();
        JSONObject jSONObject = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("suuid", UUID.randomUUID().toString());
        hashMap.put("did", tPDataManager.getUuId());
        hashMap.put("iso", tPDataManager.getIsoCountryCode());
        hashMap.put("app_id", TradPlus.getAppId());
        hashMap.put("package", tPDataManager.getAppPackageName());
        hashMap.put("sdk_ver", tPDataManager.getSdkVersion());
        hashMap.put("os", "1");
        hashMap.put("app_ver", tPDataManager.getAppVersion());
        hashMap.put("device_gaid", tPDataManager.getGaidValue());
        hashMap.put("device_oaid", tPDataManager.getOaidValue());
        hashMap.put("device_osv", tPDataManager.getDeviceOsVersion());
        try {
            jSONObject = new JSONObject(Json.mapToJsonString(hashMap));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return jSONObject;
    }
}

