/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.filter;

import android.text.TextUtils;
import com.tradplus.ads.base.db.StoreManager;
import com.tradplus.ads.base.network.response.ConfigResponse;
import com.tradplus.ads.common.util.DateAndTime;
import java.io.Serializable;

public class NetWorkFrequencyUtils {
    private static NetWorkFrequencyUtils instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetWorkFrequencyUtils getInstance() {
        if (instance != null) return instance;
        Class<NetWorkFrequencyUtils> clazz = NetWorkFrequencyUtils.class;
        synchronized (NetWorkFrequencyUtils.class) {
            instance = new NetWorkFrequencyUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean checkNetworkFrequency(ConfigResponse.WaterfallBean serializable) {
        if (serializable == null) {
            return true;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        NetworkFrequencyBean networkFrequencyBean = StoreManager.getNetworkFrequency(this.getFrequencyId((ConfigResponse.WaterfallBean)serializable), false);
        if (networkFrequencyBean == null) {
            networkFrequencyBean = new NetworkFrequencyBean();
        }
        if ((serializable = ((ConfigResponse.WaterfallBean)serializable).getFrequency()) == null) {
            return true;
        }
        if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_day() <= 0) {
            bl = true;
        } else if (!TextUtils.equals((CharSequence)networkFrequencyBean.getDayTime(), (CharSequence)DateAndTime.getDate(0))) {
            bl = true;
        } else if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_day() > networkFrequencyBean.getDayCount()) {
            bl = true;
        }
        if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_hour() <= 0) {
            bl2 = true;
        } else if (!TextUtils.equals((CharSequence)networkFrequencyBean.getHourTime(), (CharSequence)DateAndTime.getDate(1))) {
            bl2 = true;
        } else if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_hour() > networkFrequencyBean.getHourCount()) {
            bl2 = true;
        }
        if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getPacing_min() <= 0) {
            bl3 = true;
        } else {
            long l = System.currentTimeMillis();
            if (networkFrequencyBean.getShowTime() < l && l - networkFrequencyBean.getShowTime() >= (long)(((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getPacing_min() * 60000)) {
                bl3 = true;
            }
        }
        return bl && bl2 && bl3;
    }

    private String getFrequencyId(ConfigResponse.WaterfallBean waterfallBean) {
        if (waterfallBean.getConfig() == null) {
            return waterfallBean.getAdsource_placement_id();
        }
        return waterfallBean.getAdsource_placement_id() + waterfallBean.getConfigBean().getPlacementId();
    }

    public void saveNetworkFrequency(ConfigResponse.WaterfallBean serializable) {
        if (serializable == null) {
            return;
        }
        String string = this.getFrequencyId((ConfigResponse.WaterfallBean)serializable);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        NetworkFrequencyBean networkFrequencyBean = StoreManager.getNetworkFrequency(string, false);
        if (networkFrequencyBean == null) {
            networkFrequencyBean = new NetworkFrequencyBean();
        }
        if ((serializable = ((ConfigResponse.WaterfallBean)serializable).getFrequency()) == null) {
            return;
        }
        networkFrequencyBean.setCapping_day(((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_day());
        networkFrequencyBean.setCapping_hour(((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_hour());
        networkFrequencyBean.setPacing_min(((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getPacing_min());
        if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_day() > 0) {
            if (!TextUtils.equals((CharSequence)networkFrequencyBean.getDayTime(), (CharSequence)DateAndTime.getDate(0))) {
                networkFrequencyBean.setDayCount(1);
                networkFrequencyBean.setDayTime(DateAndTime.getDate(0));
            } else {
                NetworkFrequencyBean networkFrequencyBean2 = networkFrequencyBean;
                networkFrequencyBean2.setDayCount(networkFrequencyBean2.getDayCount() + 1);
            }
        }
        if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getCapping_hour() > 0) {
            if (!TextUtils.equals((CharSequence)networkFrequencyBean.getHourTime(), (CharSequence)DateAndTime.getDate(1))) {
                networkFrequencyBean.setHourCount(1);
                networkFrequencyBean.setHourTime(DateAndTime.getDate(1));
            } else {
                NetworkFrequencyBean networkFrequencyBean3 = networkFrequencyBean;
                networkFrequencyBean3.setHourCount(networkFrequencyBean3.getHourCount() + 1);
            }
        }
        if (((ConfigResponse.WaterfallBean.FrequencyBean)serializable).getPacing_min() > 0) {
            long l = System.currentTimeMillis();
            networkFrequencyBean.setShowTime(l);
        }
        StoreManager.saveNetworkFrequency(string, networkFrequencyBean);
    }

    public static class NetworkFrequencyBean
    implements Serializable {
        private String dayTime;
        private String hourTime;
        private long showTime;
        private int dayCount;
        private int hourCount;
        private int capping_hour;
        private int capping_day;
        private int pacing_min;

        public String getDayTime() {
            return this.dayTime;
        }

        public void setDayTime(String string) {
            this.dayTime = string;
        }

        public String getHourTime() {
            return this.hourTime;
        }

        public void setHourTime(String string) {
            this.hourTime = string;
        }

        public long getShowTime() {
            return this.showTime;
        }

        public void setShowTime(long l) {
            this.showTime = l;
        }

        public int getDayCount() {
            return this.dayCount;
        }

        public void setDayCount(int n) {
            this.dayCount = n;
        }

        public int getHourCount() {
            return this.hourCount;
        }

        public void setHourCount(int n) {
            this.hourCount = n;
        }

        public int getCapping_hour() {
            return this.capping_hour;
        }

        public void setCapping_hour(int n) {
            this.capping_hour = n;
        }

        public int getCapping_day() {
            return this.capping_day;
        }

        public void setCapping_day(int n) {
            this.capping_day = n;
        }

        public int getPacing_min() {
            return this.pacing_min;
        }

        public void setPacing_min(int n) {
            this.pacing_min = n;
        }
    }
}

