/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.network;

import com.tradplus.ads.base.common.TPTaskManager;
import com.tradplus.ads.common.util.LogUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.http.conn.ConnectTimeoutException;

public abstract class BaseHttpRequest {
    private static final String TAG = "BaseHttpLoader";
    public static final int POST = 1;
    public static final int GET = 2;
    public static final int CONNECT_TIMEOUT = 20000;
    public static final int READ_TIMEOUT = 20000;
    public static final int ERROR_CRASH = 48;
    public static final int ERROR_GENERATE_URL = 2;
    public static final int ERROR_TIMEOUT = 3;
    public static final int ERROR_NO_CONNECT = 7;
    public static final int ERROR_PARSE_RESULT = 10;
    protected int connectTimeout = 20000;
    protected OnHttpLoaderListener mListener;
    protected boolean mCanceled;

    public void request(OnHttpLoaderListener onHttpLoaderListener) {
        this.mCanceled = false;
        this.mListener = onHttpLoaderListener;
        this.load();
    }

    public void canceled() {
        this.mCanceled = true;
    }

    protected abstract int requestType();

    protected abstract String generateURL();

    protected abstract Map<String, String> addHeaders();

    protected abstract byte[] postContent();

    protected abstract Object parseResult(String var1);

    private void load() {
        Runnable runnable = () -> {
            try {
                String string = this.generateURL();
                this.requestWithUrl(string);
                return;
            }
            catch (Throwable throwable) {
                String string = throwable.getMessage();
                if (this.mListener != null) {
                    this.mListener.loadError(2, string);
                }
                return;
            }
        };
        TPTaskManager.getInstance().runHttpPool(runnable);
    }

    /*
     * WARNING - void declaration
     */
    private void requestWithUrl(String object) {
        block38: {
            HttpURLConnection httpURLConnection = null;
            try {
                int n;
                httpURLConnection = (HttpURLConnection)new URL((String)object).openConnection();
                int n2 = this.requestType();
                if (n2 == 1) {
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setDoOutput(true);
                    httpURLConnection.setRequestMethod("POST");
                    httpURLConnection.setUseCaches(false);
                } else {
                    httpURLConnection.setInstanceFollowRedirects(false);
                }
                Object object3 = this.addHeaders();
                if (object3 != null && object3.size() > 0) {
                    for (String object22 : object3.keySet()) {
                        httpURLConnection.addRequestProperty(object22, object3.get(object22));
                    }
                }
                if (this.mCanceled) {
                    this.onCancelCallback();
                    return;
                }
                httpURLConnection.setConnectTimeout(this.connectTimeout);
                httpURLConnection.setReadTimeout(20000);
                httpURLConnection.connect();
                if (n2 == 1) {
                    byte[] byArray = this.postContent();
                    Object object4 = byArray;
                    if (byArray != null) {
                        OutputStream outputStream = httpURLConnection.getOutputStream();
                        outputStream.write((byte[])object4);
                        outputStream.flush();
                        outputStream.close();
                    }
                }
                if ((n = httpURLConnection.getResponseCode()) != 200) {
                    void var6_20;
                    if (n != 302) {
                        this.onErrorCallback(n, "http failed!");
                        return;
                    }
                    if (this.mCanceled) {
                        this.onCancelCallback();
                        return;
                    }
                    String string = httpURLConnection.getHeaderField("Location");
                    if (string == null) {
                        this.onErrorCallback(n, "302 but Location is null");
                        return;
                    }
                    if (!string.startsWith("http")) {
                        String string2 = (String)object + string;
                    }
                    this.requestWithUrl((String)var6_20);
                    return;
                }
                if (this.mCanceled) {
                    this.onCancelCallback();
                    return;
                }
                InputStream inputStream = this.getGzipInputStream(httpURLConnection);
                object = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader((Reader)object);
                StringBuilder stringBuilder = new StringBuilder();
                while ((object3 = bufferedReader.readLine()) != null) {
                    stringBuilder.append((String)object3);
                }
                bufferedReader.close();
                ((InputStreamReader)object).close();
                if (inputStream != null) {
                    inputStream.close();
                }
                if ((object = this.parseResult(stringBuilder.toString())) == null) {
                    this.onErrorCallback(10, "result parse error! resultStr=" + stringBuilder.toString());
                    return;
                }
                if (this.mListener != null) {
                    this.mListener.loadSuccess(object);
                }
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                    return;
                }
            }
            catch (ConnectTimeoutException connectTimeoutException) {
                this.onErrorCallback(3, connectTimeoutException.getMessage());
                return;
            }
            catch (UnknownHostException unknownHostException) {
                this.onErrorCallback(7, unknownHostException.getMessage());
                return;
            }
            catch (ConnectException connectException) {
                this.onErrorCallback(7, connectException.getMessage());
                return;
            }
            catch (SocketTimeoutException socketTimeoutException) {
                this.onErrorCallback(7, socketTimeoutException.getMessage());
                return;
            }
            catch (Throwable throwable) {
                Object object5 = throwable;
                throwable.printStackTrace();
                object5 = ((Throwable)object5).getMessage();
                this.onErrorCallback(48, (String)object5);
                return;
            }
            finally {
                if (httpURLConnection == null) break block38;
                httpURLConnection.disconnect();
            }
        }
    }

    private void onErrorCallback(int n, String string) {
        LogUtil.ownShow("base http request error msg : ".concat(String.valueOf(string)));
        if (this.mListener != null) {
            this.mListener.loadError(n, string);
        }
    }

    private void onCancelCallback() {
        if (this.mListener != null) {
            this.mListener.loadCanceled();
        }
    }

    public InputStream getGzipInputStream(HttpURLConnection object) {
        if (object == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = ((URLConnection)object).getInputStream();
        }
        catch (Exception exception) {}
        object = ((URLConnection)object).getHeaderField("Content-Encoding");
        if ("gzip".equalsIgnoreCase((String)object)) {
            try {
                byte[] byArray = new byte[2];
                object = new BufferedInputStream(inputStream);
                ((BufferedInputStream)object).mark(2);
                int n = ((FilterInputStream)object).read(byArray);
                ((BufferedInputStream)object).reset();
                int n2 = byArray[0] & 0xFF | (byArray[1] & 0xFF) << 8;
                if (n != -1 && n2 == 35615) {
                    object = new GZIPInputStream((InputStream)object);
                }
            }
            catch (Exception exception) {
                object = inputStream;
            }
            return object;
        }
        return inputStream;
    }

    protected byte[] compress(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gZIPOutputStream.write(string.getBytes("utf-8"));
            gZIPOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static interface OnHttpLoaderListener<T> {
        public void loadSuccess(T var1);

        public void loadError(int var1, String var2);

        public void loadCanceled();
    }
}

