/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.network;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.os.Build;
import com.tradplus.ads.base.GlobalTradPlus;
import com.tradplus.ads.base.network.NetStateChangeObserver;
import com.tradplus.ads.base.network.NetworkChangeReceiver;

public class NetworkChangeManager {
    private static NetworkChangeManager instance;
    private NetStateChangeObserver netStateChangeObserver;
    private boolean isStart;

    public static synchronized NetworkChangeManager getInstance() {
        if (instance == null) {
            instance = new NetworkChangeManager();
        }
        return instance;
    }

    public NetworkChangeManager() {
        if (!this.checkHasChangeNetworkPermission()) {
            this.isStart = true;
        }
    }

    public boolean checkHasChangeNetworkPermission() {
        boolean bl;
        try {
            Context context = GlobalTradPlus.getInstance().getContext();
            if (context == null) {
                return false;
            }
            PackageManager packageManager = context.getPackageManager();
            bl = 0 == packageManager.checkPermission("android.permission.CHANGE_NETWORK_STATE", context.getPackageName());
        }
        catch (Exception exception) {
            return false;
        }
        return bl;
    }

    public void setCloseNetworkChangeReceiver(boolean bl) {
        this.isStart = bl;
    }

    public void startConnectivityNetwork(Context context) {
        try {
            if (!this.isStart) {
                this.isStart = true;
                if (Build.VERSION.SDK_INT >= 21) {
                    ((ConnectivityManager)context.getSystemService("connectivity")).requestNetwork(new NetworkRequest.Builder().build(), new ConnectivityManager.NetworkCallback(){

                        public void onAvailable(Network network) {
                            super.onAvailable(network);
                            if (NetworkChangeManager.this.netStateChangeObserver != null) {
                                NetworkChangeManager.this.netStateChangeObserver.onConnect();
                            }
                        }

                        public void onLost(Network network) {
                            super.onLost(network);
                            if (NetworkChangeManager.this.netStateChangeObserver != null) {
                                NetworkChangeManager.this.netStateChangeObserver.onDisconnect();
                            }
                        }
                    });
                    return;
                }
                NetworkChangeReceiver.registerReceiver(context);
                NetworkChangeReceiver.registerObserver(this.netStateChangeObserver);
            }
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void stopConnectivityNetwork(Context context) {
        if (Build.VERSION.SDK_INT < 21) {
            NetworkChangeReceiver.unRegisterReceiver(context);
            NetworkChangeReceiver.unRegisterObserver(this.netStateChangeObserver);
        }
        this.setNetStateChangeObserver(null);
    }

    public void setNetStateChangeObserver(NetStateChangeObserver netStateChangeObserver) {
        this.netStateChangeObserver = netStateChangeObserver;
    }
}

