/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.tradplus.ads.base.network.NetStateChangeObserver;
import com.tradplus.ads.base.network.NetworkChangeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class NetworkChangeReceiver
extends BroadcastReceiver {
    private List<NetStateChangeObserver> mObservers = new ArrayList<NetStateChangeObserver>();
    private boolean mType;
    private static boolean isRegister = false;

    public void onReceive(Context context, Intent intent) {
        if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
            int n = NetworkChangeUtil.getConnectivityStatus(context);
            this.notifyObservers(n);
        }
    }

    public static void registerReceiver(Context context) {
        IntentFilter intentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)InstanceHolder.INSTANCE, intentFilter);
        isRegister = true;
    }

    public static void unRegisterReceiver(Context context) {
        if (isRegister) {
            isRegister = false;
            context.unregisterReceiver((BroadcastReceiver)InstanceHolder.INSTANCE);
        }
    }

    public static void registerObserver(NetStateChangeObserver netStateChangeObserver) {
        if (netStateChangeObserver == null) {
            return;
        }
        if (!InstanceHolder.INSTANCE.mObservers.contains(netStateChangeObserver)) {
            InstanceHolder.INSTANCE.mObservers.add(netStateChangeObserver);
        }
    }

    public static void unRegisterObserver(NetStateChangeObserver netStateChangeObserver) {
        if (netStateChangeObserver == null) {
            return;
        }
        if (InstanceHolder.INSTANCE.mObservers == null) {
            return;
        }
        InstanceHolder.INSTANCE.mObservers.remove(netStateChangeObserver);
    }

    private void notifyObservers(int n) {
        if (n == 2 || n == 1) {
            if (!this.mType) {
                Iterator<NetStateChangeObserver> iterator = this.mObservers.iterator();
                while (iterator.hasNext()) {
                    iterator.next().onConnect();
                    this.mType = true;
                }
                return;
            }
        } else {
            this.mType = false;
            Iterator<NetStateChangeObserver> iterator = this.mObservers.iterator();
            while (iterator.hasNext()) {
                iterator.next().onDisconnect();
            }
        }
    }

    static class InstanceHolder {
        private static final NetworkChangeReceiver INSTANCE = new NetworkChangeReceiver();

        private InstanceHolder() {
        }
    }
}

