/*
 * Decompiled with CFR 0.152.
 */
package com.tradplus.ads.base.network;

import android.text.TextUtils;
import com.tradplus.ads.base.common.TPDataManager;
import com.tradplus.ads.base.network.AESUtils;
import com.tradplus.ads.base.network.BaseHttpRequest;
import com.tradplus.ads.base.network.TPSettingManager;
import com.tradplus.ads.common.serialization.JSON;
import com.tradplus.ads.common.util.LogUtil;
import java.util.HashMap;
import java.util.Map;

public abstract class TPHttpBuilder
extends BaseHttpRequest {
    protected static final String TPHTTPTAG = "TPHttp";
    protected String body;
    protected String url;
    protected boolean isEncrypt;
    protected String userUUId = TPDataManager.getInstance().getUuId().replace("-", "").substring(3);
    protected Class parseClass;
    protected Map<String, String> headerMap;

    public TPHttpBuilder(String string, String string2, String string3) {
        this(string, string2, string3, false);
    }

    public TPHttpBuilder(String string, String string2, boolean bl) {
        this(string, "", string2, bl);
    }

    public TPHttpBuilder(String string, String string2) {
        this(string, "", string2, false);
    }

    public TPHttpBuilder(String string, String string2, String string3, boolean bl) {
        this.url = string;
        this.isEncrypt = bl;
        this.connectTimeout = TPSettingManager.getInstance().getHttpSettingData(string3);
        this.headerMap = new HashMap<String, String>();
        this.headerMap.put("s", this.userUUId);
        this.headerMap.put("content-type", "text/plain");
        this.body = bl ? new AESUtils(this.userUUId).encrypt(string2) : string2;
        LogUtil.ownShow("TPHttp url = " + string + " isEncrypt = " + bl + " body = " + string2 + "\n this body = \n" + this.body + " \nuserUUId = " + this.userUUId);
    }

    public void setParseClass(Class clazz) {
        this.parseClass = clazz;
    }

    protected Object parse(String string) {
        try {
            LogUtil.ownShow("response data: ".concat(String.valueOf(string)));
            if (this.parseClass != null) {
                if (!TextUtils.isEmpty((CharSequence)string) && this.isEncrypt) {
                    return JSON.parseObject(new AESUtils(this.userUUId).decrypt(string), this.parseClass);
                }
                return JSON.parseObject(string, this.parseClass);
            }
            if (!TextUtils.isEmpty((CharSequence)string) && this.isEncrypt) {
                return new AESUtils(this.userUUId).decrypt(string);
            }
            return string;
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public void setConnectTimeout(int n) {
        this.connectTimeout = n;
    }
}

